<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Groups;
use App\Models\GroupUser;
use Illuminate\Http\Request;

class GroupController extends Controller
{
    public function index(Request $request){
        return view('group.index');

    }

    public function create_group(Request $request){
        $request->validate([
            'name' => 'required|string|max:100|unique:groups,name', 
            'description' => 'nullable|string|max:500',
            'lecturer_ids' => 'required|array'
        ]);

        $group = new Groups();        
        $group->name = $request->name;
        $group->description = $request->description;
        $group->save();

        $lecturer_ids = $request->input('lecturer_ids');
        
        foreach($lecturer_ids as $id) {
            $group_user = new GroupUser();
            $group_user->group_id = $group->id;
            $group_user->user_id = $id;
            $group_user->save();
        }

        return redirect()->back()->with('success', 'Group created successfully.');
    }

    public function update_group_by_id(Request $request, $id){
        $request->validate([
            'name' => 'required|string|max:100', 
            'description' => 'nullable|string|max:500',
            'lecturer_ids' => 'required|array'
        ]);
        $group = Groups::findOrFail($id); 
        $group->name = $request->name;
        $group->description = $request->description;
        $group->save();

        $new_lecturer_ids = $request->input('lecturer_ids');
        $existing_group_users = GroupUser::where('group_id', $group->id)->pluck('user_id')->toArray();

        foreach ($new_lecturer_ids as $lecturer_id) {
            $user = User::find($lecturer_id);
            if ($user && $user->type === 'Lecturer') {
                // Only add if the lecturer is not already in the group
                if (!in_array($lecturer_id, $existing_group_users)) {
                    $group_user = new GroupUser();
                    $group_user->group_id = $group->id;
                    $group_user->user_id = $lecturer_id;
                    $group_user->save();
                }
            }
        }

        // Remove lecturers that are no longer in the new list
        foreach ($existing_group_users as $existing_id) {
            // Check if the existing user is a lecturer
            $user = User::find($existing_id);
            if ($user && $user->type === 'Lecturer') {
                if (!in_array($existing_id, $new_lecturer_ids)) {
                    GroupUser::where('group_id', $group->id)
                            ->where('user_id', $existing_id)
                            ->delete();
                }
            }
        }

        return redirect()->back()->with('success', 'Group updated successfully.')->with('updated_group_id', $id);
    }

    public function recreate_group_by_id(Request $request){
        $request->validate([
            'name' => 'required|string|max:100', 
            'description' => 'nullable|string|max:500',
            'lecturer_ids' => 'required|array',
            'student_ids' => 'nullable|array'
        ]);

        $group = new Groups();
        $group->name = $request->name;
        $group->description = $request->description;
        $group->save();

        $lecturer_ids = $request->input('lecturer_ids');
        $student_ids = $request->input('student_ids');
        
        foreach($lecturer_ids as $id) {
            $group_user = new GroupUser();
            $group_user->group_id = $group->id;
            $group_user->user_id = $id;
            $group_user->save();
        }

        if ($request->$student_ids){
            foreach($student_ids as $id) {
                $group_user = new GroupUser();
                $group_user->group_id = $group->id;
                $group_user->user_id = $id;
                $group_user->save();
            }
        }

        return redirect()->back()->with('success', 'Group recreated successfully.');
    }

    public function delete_group_by_id($id){
        $group = Groups::find($id);
        if ($group){
            $group->delete();
            return redirect()->back()->with('success', 'Group deleted successfully.');
        } else {
            return redirect()->back()->withErrors(['error' => 'Group not found!']);
        }
    }

    public function add_students_group_by_id(Request $request, $id){
        $request->validate([
            'student_ids' => 'required|array'
        ]);
        $new_student_ids = $request->input('student_ids');
        $existing_group_users = GroupUser::where('group_id', $id)->pluck('user_id')->toArray();

        foreach ($new_student_ids as $student_id) {
            $user = User::find($student_id);
            if ($user && ($user->type === 'Student' || $user->type === 'Student Lead')) {
                // Only add if the student is not already in the group
                if (!in_array($student_id, $existing_group_users)) {
                    $group_user = new GroupUser();
                    $group_user->group_id = $id;
                    $group_user->user_id = $student_id;
                    $group_user->save();
                }
            }
        }

        // Remove student that are no longer in the new list
        foreach ($existing_group_users as $existing_id) {
            // Check if the existing user is a student
            $user = User::find($existing_id);
            if ($user && ($user->type === 'Student' || $user->type === 'Student Lead')) {
                if (!in_array($existing_id, $new_student_ids)) {
                    GroupUser::where('group_id', $id)
                            ->where('user_id', $existing_id)
                            ->delete();
                }
            }
        }

        return redirect()->back()->with('success', 'Student updated successfully.')->with('updated_group_id', $id);
    }

}
