<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;

class HCPController extends Controller
{
    private function get_options($body, $uri) {
        $appKey = env('HIKCENTRAL_APP_KEY');
        $appSecret = env('HIKCENTRAL_APP_SECRET');
        $date = Carbon::now('GMT')->format('D, d M Y H:i:s \G\M\T');
        $method = 'POST';
        $contentType = 'application/json';

        // Generate Content-MD5
        $contentMd5 = base64_encode(md5($body, true));

        // Create the string to sign
        $stringToSign = "{$method}\n" .
                        "*/*\n" .
                        "{$contentMd5}\n" .
                        "{$contentType}\n" .
                        "{$date}\n" .
                        "x-ca-key:{$appKey}\n" .
                        "x-ca-timestamp:" . now()->timestamp * 1000 . "\n" .
                        $uri;

        // Generate the HmacSHA256 signature
        $signature = base64_encode(hash_hmac('sha256', $stringToSign, $appSecret, true));

        $options = [
            'headers' => [
                'Accept' => '*/*',
                'Content-MD5' => $contentMd5,
                'Content-Type' => $contentType,
                'Date' => $date,
                'X-Ca-Key' => $appKey,
                'X-Ca-Signature' => $signature,
                'X-Ca-Timestamp' => now()->timestamp * 1000,
                'X-Ca-Signature-Headers' => 'x-ca-key,x-ca-timestamp',
            ],
            'body' => $body,
        ];

        return $options;

    }

    function get_person_list(Request $request) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        
        $uri = '/artemis/api/resource/v1/person/personList';
        $body = json_encode([
            'pageNo' => 1,
            'pageSize' => 100
        ]);

        $options = $this->get_options($body, $uri);
        
        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, $options);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    }

    function get_door_event (Request $request) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $uri = '/artemis/api/acs/v1/door/events';
        $body = json_encode([
            "startTime"=> $request->input('startTime'),
            "endTime"=> $request->input('endTime'),
            "eventType"=> $request->input('eventType'),
            "personName"=> $request->input('personName'),
            "doorIndexCodes"=> $request->input('doorIndexCodes'),
            "pageNo"=> 1,
            "pageSize"=> 10,
            "temperatureStatus"=> -1,
            "maskStatus"=> -1
        ]);

        $options = $this->get_options($body, $uri);

        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, $options);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    }

    function add_person (Request $request) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $uri = '/artemis/api/resource/v1/person/single/add';
        $body = json_encode(array_filter([
            "personCode"=> $request->input('personCode'),
            "personGivenName"=> $request->input('personGivenName'),
            "personFamilyName"=> $request->input('personFamilyName'),
            "gender"=> $request->input('gender'),
            "orgIndexCode"=> $request->input('orgIndexCode'),
            "phoneNo"=> $request->input('phoneNo'),
            "email"=> $request->input('email'),
            // "faces"=> [
            //     [
            //         "faceData" => $request->input('face')
            //     ]
            // ],
            "remark"=> $request->input('remark'),
        ], function($value) {
            return !is_null($value);
        }));

        $options = $this->get_options($body, $uri);

        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, $options);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    }
}
