<?php

namespace App\Http\Controllers;

use App\Models\Rooms;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class RoomController extends Controller
{
    public function index(Request $request){
        return view('room.index');

    }
    
    public function create_room (Request $request){
        $request->validate([
            'name' => 'required|string|max:100', 
            'description' => 'nullable|string|max:500', 
            // 'access_level' => 'nullable|integer',
            'faculty_id' => 'required|string', 
            'building_id' => 'required|string|max:100', 
            'level_id' => 'required|string', 
            'type_id' => 'nullable|string', 
        ]);
        $room = new Rooms();
        $room->name = $request->name;
        $room->description = $request->description;
        // $room->access_level = $request->access_level;
        $room->faculty_id = $request->faculty_id;
        $room->building_id = $request->building_id;
        $room->level_id = $request->level_id;
        $room->type_id = $request->type_id;
        
        $room->save();

        return redirect()->back()->with('success', 'Room created successfully.');
    }

    public function update_room_by_id (Request $request, $id){
        // dd($request);
        $request->validate([
            'name' => 'required|string|max:100', 
            'description' => 'nullable|string|max:500', 
            // 'access_level' => 'nullable|integer',
            'faculty_id' => 'required|string', 
            'building_id' => 'required|string|max:100', 
            'level_id' => 'required|string', 
            'type_id' => 'nullable|string',
            'status' => 'nullable',
            'reason' => 'nullable', 
        ]);
        $room = Rooms::findOrFail($id);
        $room->name = $request->name;
        $room->description = $request->description;
        // $room->access_level = $request->access_level;
        $room->faculty_id = $request->faculty_id;
        $room->building_id = $request->building_id;
        $room->level_id = $request->level_id;
        $room->type_id = $request->type_id;
        $room->status = $request->status;
        $room->reason = $request->reason;
        
        $room->save();

        return redirect()->back()->with('success', 'Room updated successfully.')->with('updated_room_id', $id);
    }

    public function delete_room_by_id ($id){
        $room = Rooms::findOrFail($id);
        $room->delete();
        return redirect()->back()->with('success', 'Room deleted successfully.');
    }

    public function upload_room_image_by_id (Request $request){

    }

    public function update_room_image_by_id (Request $request, $id){
        // Validation rules for each image, with a max file size of 2MB (2048 KB)
        $request->validate([
            'room_image1' => 'nullable|image|max:2048',
            'room_image2' => 'nullable|image|max:2048',
            'room_image3' => 'nullable|image|max:2048',
            'room_image4' => 'nullable|image|max:2048',
        ]);

        $room = Rooms::findOrFail($id);

        // Process each image upload, replace if a new file is provided
        foreach (range(1, 4) as $i) {
            $field = 'room_image' . $i;
            $imagePathField = 'image_path' . $i;

            if ($request->file($field)) {
                $image_file = $request->file($field);
                $filename = $field . time() . '.jpg';
                $image_file_path = '/' . $image_file->storeAs('/room/' . strtoupper($room->id) . '/room_picture', $filename, 'public');

                // Delete the old image if it exists
                if ($room->$imagePathField && Storage::disk('public')->exists($room->$imagePathField)) {
                    Storage::disk('public')->delete($room->$imagePathField);
                }

                // Update the new path in the database
                $room->$imagePathField = $image_file_path;
            }
        }

        // Check for images to be deleted and update accordingly
        foreach (range(1, 4) as $i) {
            $removeField = 'remove_room_image' . $i;
            $imagePathField = 'image_path' . $i;

            if ($request->has($removeField) && $request->input($removeField) == '1') {
                if ($room->$imagePathField && Storage::disk('public')->exists($room->$imagePathField)) {
                    Storage::disk('public')->delete($room->$imagePathField);
                }
                $room->$imagePathField = null;
            }
        }

        $room->save();

        return redirect()->back()->with('success', 'Room image updated successfully.');
    }
}
