<?php

namespace App\Http\Controllers;

use App\Models\Levels;
use App\Models\Devices;
use App\Models\Holidays;
use App\Models\Settings;
use App\Models\Buildings;
use App\Models\Faculties;
use Illuminate\Http\Request;
use App\Models\Announcements;

class SettingController extends Controller
{
    public function index(Request $request){

        $announcements = Announcements::query();
        $announcements = $announcements->orderBy('id', 'desc')->paginate(4);
        $holidays = Holidays::query();
        $holidays = $holidays->orderBy('id', 'desc')->paginate(10);
       


        return view('setting.index', compact('announcements','holidays'));
    }

    public function update_general(Request $request){
        $request->validate([ 
            'system_version' => 'required|string|max:50', 
            'system_updated' => 'required|date_format:Y-m-d',
            'company_name' => 'required|string|max:255',
            'short_name' => 'required|string|max:50',
            'system_name' => 'required|string|max:255',
            'custom_range' => 'nullable|string|max:10',
            'start_time' => 'required|string|max:50', 
            'end_time' => 'required|string|max:50',
            'attendance_type' => 'required|string|max:500',
            'send_email' => 'nullable|string|max:10',
            'security_team' => 'nullable|string|max:500',
        ]);
        // $setting = Settings::all();
        $keys = [
            'system_version' => $request->system_version,
            'system_updated' => $request->system_updated,
            'company_name' => $request->company_name,
            'short_name' => $request->short_name,
            'system_name' => $request->system_name,
            'custom_range' => $request->has('custom_range') ? 1 : 0,
            'start_time' => $request->start_time,
            'end_time' => $request->end_time,
            'attendance_type' => $request->attendance_type,
            'send_email' => $request->has('send_email') ? 1 : 0,
            'security_team' => $request->security_team,

            // 'company_name' => $request->company_name,
            // 'short_name' => $request->short_name,
            // 'system_name' => $request->system_name,
            // 'start_time' => $request->has('online_clock_in') ? 1 : 0,
            // 'end_time' => $request->has('auto_clock_out') ? 1 : 0,
            // 'fixed_start_time' => $request->has('fixed_start_time') ? 1 : 0,
            // 'fixed_end_time' => $request->has('fixed_end_time') ? 1 : 0,
            // 'start_time' => $request->start_time,
            // 'end_time' => $request->end_time,
            // 'total_minutes_late' => $request->total_minutes_late,
            // 'total_working_hours' => $request->total_working_hours,
            // 'total_days_backdate_allowed' => $request->total_days_backdate_allowed,
            // 'hours_start_working' => $request->hours_start_working,
            // 'distance' => $request->distance,
            // 'personal_report' => $request->has('personal_report') ? 1 : 0,
        ];
        
        // $settings = $setting->whereIn('setting_key', array_keys($keys))->get();
        $settings = Settings::whereIn('setting_key', array_keys($keys))->get();
        
        foreach ($settings as $setting) {
            $setting->setting_value = $keys[$setting->setting_key];
            $setting->save();
        }        
        return redirect()->back()->with('success', 'Setting updated successfully.');
    }

    public function create_announcement(Request $request){
        $request->validate([
            'title' => 'required|string|max:255',
            'message' => 'required|string|max:500',
            'date_publish' => 'required|date|after_or_equal:today',
            'date_expiry' => 'required|date|after:date_publish',
        ]);
        $announcement = new Announcements();
        $announcement->title = $request->title;
        $announcement->message = $request->message;
        $announcement->date_publish = $request->date_publish;
        $announcement->date_expiry = $request->date_expiry;
        $announcement->save();
        return redirect()->back()->with('success', 'Announcement created successfully.');
    }

    public function update_announcement_by_id(Request $request, $id){
        $request->validate([
            'title' => 'required|string|max:255',
            'message' => 'required|string|max:500',
            'date_publish' => 'required|date|after_or_equal:today',
            'date_expiry' => 'required|date|after:date_publish',
        ]);
        $announcement = Announcements::findOrFail($id);
        $announcement->title = $request->title;
        $announcement->message = $request->message;
        $announcement->date_publish = $request->date_publish;
        $announcement->date_expiry = $request->date_expiry;
        $announcement->save();
        return redirect()->back()->with('success', 'Announcement updated successfully.');
    }

    public function delete_announcement_by_id($id){
        $announcement = Announcements::find($id);
        if ($announcement){
            $announcement->delete();
            return redirect()->back()->with('success', 'Announcement deleted successfully.');
        } else {
            return redirect()->back()->withErrors('error', 'Announcement not found!');
        }
    }

    public function create_faculty(Request $request){
        $request->validate([ 'name' => 'required|string|max:255', ]);
        $faculty = new Faculties();
        $faculty->name = $request->name;
        $faculty->save();
        return redirect()->back()->with('success', 'Faculty created successfully.');
    }

    public function update_faculty_by_id(Request $request, $id){
        $request->validate([ 'name' => 'required|string|max:255', ]);
        $faculty = Faculties::findOrFail($id);
        $faculty->name = $request->name;
        $faculty->save();
        return redirect()->back()->with('success', 'Faculty updated successfully.');
    }

    public function delete_faculty_by_id($id){
        $faculty = Faculties::find($id);
        if ($faculty){
            $faculty->delete();
            return redirect()->back()->with('success', 'Faculty deleted successfully.');
        } else {
            return redirect()->back()->withErrors(['error' => 'Faculty not found!']);
        }
    }

    public function create_building(Request $request){
        $request->validate([ 
            'name' => 'required|string|max:255',
            'faculty_id' => 'required|integer|exists:faculties,id',   
        ]);
        $building = new Buildings();
        $building->name = $request->name;
        $building->faculty_id = $request->faculty_id;
        $building->save();
        return redirect()->back()->with('success', 'Building created successfully.');
    }

    public function update_building_by_id(Request $request, $id){
        $request->validate([ 
            'name' => 'required|string|max:255',
            'faculty_id' => 'required|integer|exists:faculties,id',  
        ]);
        $building = Buildings::findOrFail($id);
        $building->name = $request->name;
        $building->faculty_id = $request->faculty_id;
        $building->save();
        return redirect()->back()->with('success', 'Building updated successfully.');
    }

    public function delete_building_by_id($id){
        $building = Buildings::find($id);
        if ($building){
            $building->delete();
            return redirect()->back()->with('success', 'Building deleted successfully.');
        } else {
            return redirect()->back()->withErrors(['error' => 'Building not found!']);
        }
    }

    public function create_level(Request $request){
        $request->validate([ 
            'name' => 'required|string|max:255', 
            'building_id' => 'required|integer|exists:buildings,id', // buildings is the name of db, id is the PK of buildings Table
            'faculty_id' => 'required|integer|exists:faculties,id', 
        ]);
        $level = new Levels();
        $level->name = $request->name;
        $level->building_id = $request->building_id;
        $level->faculty_id = $request->faculty_id;
        $level->save();
        return redirect()->back()->with('success', 'level created successfully.');
    }

    public function update_level_by_id(Request $request, $id){
        $request->validate([ 
            'name' => 'required|string|max:255', 
            'building_id' => 'required|integer|exists:buildings,id', // buildings is the name of db, id is the PK of buildings Table
            'faculty_id' => 'required|integer|exists:faculties,id', 
        ]);
        $level = Levels::findOrFail($id);
        $level->name = $request->name;
        $level->building_id = $request->building_id;
        $level->faculty_id = $request->faculty_id;
        $level->save();
        return redirect()->back()->with('success', 'Level updated successfully.');
    }

    public function delete_level_by_id($id){
        $level = Levels::find($id);
        if ($level){
            $level->delete();
            return redirect()->back()->with('success', 'Level deleted successfully.');
        } else {
            return redirect()->back()->withErrors('error', 'Level not found!');
        }
    }

    public function create_holiday(Request $request){
        $request->validate([ 
            'description' => 'required|string|max:500', 
            'date' => 'required|date_format:Y-m-d',
        ]);
        $holiday = new Holidays();
        $holiday->description = $request->description;
        $holiday->date = $request->date;
        $holiday->save();
        return redirect()->back()->with('success', 'Holiday created successfully.');
    }

    public function update_holiday_by_id(Request $request, $id){
        $request->validate([ 
            'description' => 'required|string|max:500', 
            'date' => 'required|date_format:Y-m-d',
        ]);
        $holiday = Holidays::findOrFail($id);
        $holiday->description = $request->description;
        $holiday->date = $request->date;
        $holiday->save();
        return redirect()->back()->with('success', 'Holiday updated successfully.');
    }

    public function delete_holiday_by_id($id){
        $holiday = Holidays::find($id);
        if ($holiday){
            $holiday->delete();
            return redirect()->back()->with('success', 'Holiday deleted successfully.');
        } else {
            return redirect()->back()->withErrors('error', 'Holiday not found!');
        }
    }

    public function update_smtp(Request $request){
        $request->validate([ 
            'smtp_server' => 'nullable|string|max:500', 
            'smtp_sender_name' => 'nullable|string|max:255',
            'smtp_username' => 'nullable|string|max:255',
            'smtp_password' => 'nullable|string|max:500',
            'smtp_port' => 'nullable|string|max:255',
            'enable_ssl' => 'nullable|string|max:10',
        ]);
        $keys = [
            'smtp_server' => $request->smtp_server,
            'smtp_sender_name' => $request->smtp_sender_name,
            'smtp_username' => $request->smtp_username,
            'smtp_password' => $request->smtp_password,
            'smtp_port' => $request->smtp_port,
            'enable_ssl' => $request->has('enable_ssl') ? 1 : 0,

            // 'company_name' => $request->company_name,
            // 'short_name' => $request->short_name,
            // 'system_name' => $request->system_name,
            // 'start_time' => $request->has('online_clock_in') ? 1 : 0,
            // 'end_time' => $request->has('auto_clock_out') ? 1 : 0,
            // 'fixed_start_time' => $request->has('fixed_start_time') ? 1 : 0,
            // 'fixed_end_time' => $request->has('fixed_end_time') ? 1 : 0,
            // 'start_time' => $request->start_time,
            // 'end_time' => $request->end_time,
            // 'total_minutes_late' => $request->total_minutes_late,
            // 'total_working_hours' => $request->total_working_hours,
            // 'total_days_backdate_allowed' => $request->total_days_backdate_allowed,
            // 'hours_start_working' => $request->hours_start_working,
            // 'distance' => $request->distance,
            // 'personal_report' => $request->has('personal_report') ? 1 : 0,
        ];
        $settings = Settings::whereIn('setting_key', array_keys($keys))->get();
        foreach ($settings as $setting) {
            $setting->setting_value = $keys[$setting->setting_key];
            $setting->save();
        }        
        return redirect()->back()->with('success', 'Setting updated successfully.');
    }

    public function create_device(Request $request){
        $request->validate([ 
            'name' => 'required|string|max:500', 
            'privilege_group_id' => 'required|integer',
            'room_id' => 'required|integer|exists:rooms,id',
        ]);
        $device = new Devices();
        $device->name = $request->name;
        $device->privilege_group_id = $request->privilege_group_id;
        $device->room_id = $request->room_id;
        $device->save();
        return redirect()->back()->with('success', 'Device created successfully.');
    }

    public function update_device_by_id(Request $request, $id){
        $request->validate([ 
            'name' => 'required|string|max:500', 
            'privilege_group_id' => 'required|integer',
            'room_id' => 'required|integer|exists:rooms,id',
        ]);
        $device = Devices::findOrFail($id);
        $device->name = $request->name;
        // $device->index_code = $request->index_code;
        $device->room_id = $request->room_id;
        $device->save();
        return redirect()->back()->with('success', 'Device updated successfully.');
    }

    public function delete_device_by_id($id){
        $device = Devices::find($id);
        if ($device){
            $device->delete();
            return redirect()->back()->with('success', 'Device deleted successfully.');
        } else {
            return redirect()->back()->withErrors('error', 'Device not found!');
        }
    }

    public function update_hcp(Request $request){
        $url = $request->url;
        $app_key = $request->app_key;
        $app_secret = $request->app_secret;

        $path = base_path('.env');
        $test = file_get_contents($path);
        if (file_exists($path)) {
            $newContent = str_replace('HIKCENTRAL_API_BASE_URL=' . env('HIKCENTRAL_API_BASE_URL'),'HIKCENTRAL_API_BASE_URL=' . $url, $test);
            $newContent = str_replace('HIKCENTRAL_APP_KEY=' . env('HIKCENTRAL_APP_KEY'),'HIKCENTRAL_APP_KEY=' . $app_key, $newContent);
            $newContent = str_replace('HIKCENTRAL_APP_SECRET=' . env('HIKCENTRAL_APP_SECRET'), 'HIKCENTRAL_APP_SECRET=' . $app_secret, $newContent);
        
            file_put_contents($path, $newContent);
        }
        return redirect()->back()->with('success', 'HikCentral updated successfully.');
    }

    public function update_db(Request $request){

    }
}
