<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class StudentMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if(Auth::check() && Auth::user()->type != 'Student'){
                return back()->with('message','Access Denied! you are not Student');
        }
        return $next($request);
    }
}


// <?php

// namespace App\Http\Middleware;

// use Closure;
// use Illuminate\Http\Request;
// use Illuminate\Support\Facades\Auth;
// use Symfony\Component\HttpFoundation\Response;

// class StaffMiddleware
// {
//     /**
//      * Handle an incoming request.
//      *
//      * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
//      */
//     public function handle(Request $request, Closure $next): Response
//     {
//         if(Auth::check() && Auth::user()->roleAs != 0){//!Auth::user()->roleAs==0
//             if(Auth::user()->roleAs==3){
//                 return redirect('/boss/dashboard')->with('message','Access Denied! you are not boss');
//             }
//             else if(Auth::user()->roleAs==2){
//                 return redirect('/admin/dashboard')->with('message','Access Denied! you are not admin');
//             }
//             else{
//                 return redirect('/ppm/dashboard')->with('message','Access Denied! you are not PPM');
//             }
//         }
//         return $next($request);
//     }
// }

