<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Buildings extends Model
{
    use HasFactory;

    protected $table = 'buildings';

    protected $fillable = [
        'name',
        'created_at',
        'updated_at'
    ];

    public function faculty()
    {
        return $this->belongsTo(Faculties::class, 'faculty_id');
    }

    public function levels()
    {
        return $this->hasMany(Levels::class, 'building_id');
    }

    public function rooms()
    {
        return $this->hasMany(Rooms::class, 'building_id');
    }
}
