<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Classes extends Model
{
    use HasFactory;

    protected $table = 'classes';

    protected $fillable = [
        'title',
        'description',
        'room_id',
        'start_date_time',
        'end_date_time',
        'group_id',
        'repeat_type',
        'approved_by_id',
        'approval_date_time',
        'approval_remark',
        'created_at',
        'updated_at'
    ];

    public function room()
    {
        return $this->belongsTo(Rooms::class, 'room_id');
    }
    public function group()
    {
        return $this->belongsTo(Groups::class, 'group_id');
    }
    public function approval_user()
    {
        return $this->belongsTo(User::class, 'approved_by_id');
    }
    public function request_user()
    {
        return $this->belongsTo(User::class, 'requested_by_id');
    }

    public function attendances()
    {
        return $this->hasMany(Attendances::class, 'class_id');
    }
}
