<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Devices extends Model
{
    use HasFactory;

    protected $table = 'devices';

    protected $fillable = [
        'name',
        'index_code',
        'room_id',
        'created_at',
        'updated_at'
    ];

    public function room()
    {
        return $this->belongsTo(Rooms::class, 'room_id');
    }
}
