<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Faculties extends Model
{
    use HasFactory;

    protected $table = 'faculties';

    protected $fillable = [
        'name'
    ];

    public function user()
    {
        return $this->hasMany(User::class, 'faculty_id');
    }

    public function building()
    {
        return $this->hasMany(Buildings::class, 'faculty_id');
    }

    public function level()
    {
        return $this->hasMany(Levels::class, 'faculty_id');
    }

    public function room()
    {
        return $this->hasMany(Rooms::class, 'faculty_id');
    }
}
