<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Groups extends Model
{
    use HasFactory;

    protected $table = 'groups';

    protected $fillable = [
        'name',
        'description',
        'status',
        'created_at',
        'updated_at'
    ];

    public function classes()
    {
        return $this->hasMany(Classes::class, 'group_id');
    }
    public function group_user()
    {
        return $this->hasMany(GroupUser::class, 'group_id');
    }
}
