<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Levels extends Model
{
    use HasFactory;

    protected $table = 'levels';

    protected $fillable = [
        'name',
        'building_id',
        'created_at',
        'updated_at'
    ];

    public function building()
    {
        return $this->belongsTo(Buildings::class, 'building_id');
    }

    public function faculty()
    {
        return $this->belongsTo(Faculties::class, 'faculty_id');
    }

    public function rooms()
    {
        return $this->hasMany(Rooms::class, 'level_id');
    }
}
