<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RoomType extends Model
{
    use HasFactory;

    protected $table = 'room_type';

    protected $fillable = [
        'name',
        'created_at',
        'updated_at'
    ];

    public function rooms()
    {
        return $this->hasMany(Rooms::class, 'type_id');
    }
}
