<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Rooms extends Model
{
    use HasFactory;

    protected $table = 'rooms';

    protected $fillable = [
        'name',
        'description',
        'access_level',
        'building_id',
        'level_id',
        'type_id',
        'status',
        'image_path',
        'created_at',
        'updated_at',
    ];

    public function faculty()
    {
        return $this->belongsTo(Faculties::class, 'faculty_id');
    }

    public function building()
    {
        return $this->belongsTo(Buildings::class, 'building_id');
    }
    public function level()
    {
        return $this->belongsTo(Levels::class, 'level_id');
    }
    public function room_type()
    {
        return $this->belongsTo(RoomType::class, 'type_id');
    }

    public function classes()
    {
        return $this->hasMany(Classes::class, 'room_id');
    }
    public function devices()
    {
        return $this->hasMany(Devices::class, 'room_id');
    }
}
