<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'email',
        'email_verified_at',
        'password',
        'type',
        'faculty_id',
        'staff_id',
        'first_name',
        'last_name',
        'full_name',
        'phone_no',
        'address',
        'nric',
        'remark',
        'gender',
        'remember_token',
        'password_reset_token',
        'last_login',
        'language',
        'image_path',
        'status',
        'created_at',
        'updated_at',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function approval_user_classes()
    {
        return $this->hasMany(Classes::class, 'approved_by_id');
    }
    public function group_user()
    {
        return $this->hasMany(GroupUser::class, 'user_id');
    }
    public function request_class()
    {
        return $this->hasMany(Classes::class, 'requested_by_id');
    }
    public function attendances()
    {
        return $this->hasMany(Attendances::class, 'user_id');
    }

    public function faculties()
    {
        return $this->belongsTo(Faculties::class, 'faculty_id');
    }
}
