<?php

use App\Console\Commands\ManageAccess;
use Illuminate\Foundation\Application;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'isAdministrator' => AdministratorMiddleware::class
        ]);
        $middleware->alias([
            'isLecturer' => LecturerMiddleware::class
        ]);
        $middleware->alias([
            'isManagement' => ManagementMiddleware::class
        ]);
        $middleware->alias([
            'isStudentLead' => StudentLeadMiddleware::class
        ]);
        $middleware->alias([
            'isStudent' => StudentMiddleware::class
        ]);

        // $middleware->append(AdministratorMiddleware::class);
        // $middleware->append(LecturerMiddleware::class);
        // $middleware->append(ManagementMiddleware::class);
        // $middleware->append(StudentLeadMiddleware::class);
        // $middleware->append(StudentMiddleware::class);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })
    ->withSchedule(function (Schedule $schedule) {
        $schedule->command('app:manage-access')->everyMinute();
    })->create();
