<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->integer('hcp_id')->nullable();
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->enum('type', ['Administrator', 'Faculty Administrator', 'Management', 'Lecturer', 'Student Lead', 'Student'])->nullable();
            $table->foreignId('faculty_id')->nullable()->constrained('faculties', 'id')->onDelete('cascade');
            $table->string('staff_id')->unique();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('full_name');
            $table->string('intake_year')->nullable();
            $table->string('phone_no')->nullable();
            $table->text('address')->nullable();
            $table->string('nric')->nullable();
            $table->text('remark')->nullable();
            $table->integer('gender');
            $table->rememberToken()->nullable();
            $table->string('password_reset_token')->nullable();
            $table->datetime('last_login')->nullable();
            $table->string('language')->nullable();
            $table->string('image_path')->nullable();
            $table->enum('status', ['Active', 'Not Active'])->default('Active');
            $table->timestamps();
        });

        // for the user of migrate fresh, no need to enter again
        DB::table('users')->insert([
            [
                'type' => 'Student',
                'hcp_id' => 62,
                'staff_id' => 'bi20110195',
                'first_name' => 'user1',
                'last_name' => 'user1',
                'full_name' => 'user1_full_name',
                'gender' => 1,
                'email' => 'user1@gmail.com',
                'password' => bcrypt('password'),
            ],
            [
                'type' => 'Lecturer',
                'hcp_id' => 61,
                'staff_id' => 'bs20110347',
                'first_name' => 'lecturer2',
                'last_name' => 'lecturer2',
                'full_name' => 'lecturer2_full_name',
                'gender' => 1,
                'email' => 'lecturer2@gmail.com',
                'password' => bcrypt('password'),
            ],
            [
                'type' => 'Lecturer',
                'hcp_id' => null,
                'staff_id' => 'LT02',
                'first_name' => 'lecturer3',
                'last_name' => 'lecturer3',
                'full_name' => 'lecturer3_full_name',
                'gender' => 1,
                'email' => 'lecturer3@gmail.com',
                'password' => bcrypt('password'),
            ],
            [
                'type' => 'Lecturer',
                'hcp_id' => null,
                'staff_id' => 'LT03',
                'first_name' => 'lecturer4',
                'last_name' => 'lecturer4',
                'full_name' => 'lecturer4_full_name',
                'gender' => 0,
                'email' => 'lecturer4@gmail.com',
                'password' => bcrypt('password'),
            ],
            [
                'type' => 'Lecturer',
                'hcp_id' => null,
                'staff_id' => 'LT04',
                'first_name' => 'lecturer5',
                'last_name' => 'lecturer5',
                'full_name' => 'lecturer5_full_name',
                'gender' => 1,
                'email' => 'lecturer5@gmail.com',
                'password' => bcrypt('password'),
            ],
            [
                'type' => 'Lecturer',
                'hcp_id' => null,
                'staff_id' => 'LT05',
                'first_name' => 'lecturer6',
                'last_name' => 'lecturer6',
                'full_name' => 'lecturer6_full_name',
                'gender' => 0,
                'email' => 'lecturer6@gmail.com',
                'password' => bcrypt('password'),
            ],
            [
                'type' => 'Student',
                'hcp_id' => null,
                'staff_id' => 'ST02',
                'first_name' => 'user7',
                'last_name' => 'user7',
                'full_name' => 'user7_full_name',
                'gender' => 0,
                'email' => 'user7@gmail.com',
                'password' => bcrypt('password'),
            ],
            [
                'type' => 'Student Lead',
                'hcp_id' => null,
                'staff_id' => 'ST03',
                'first_name' => 'user8',
                'last_name' => 'user8',
                'full_name' => 'user8_full_name',
                'gender' => 1,
                'email' => 'user8@gmail.com',
                'password' => bcrypt('password'),
            ],
            [
                'type' => 'Student Lead',
                'hcp_id' => null,
                'staff_id' => 'ST04',
                'first_name' => 'user9',
                'last_name' => 'user9',
                'full_name' => 'user9_full_name',
                'gender' => 0,
                'email' => 'user9@gmail.com',
                'password' => bcrypt('password'),
            ],
            [
                'type' => 'Management',
                'hcp_id' => null,
                'staff_id' => 'MG01',
                'first_name' => 'manager1',
                'last_name' => 'manager1',
                'full_name' => 'manager1_full_name',
                'gender' => 0,
                'email' => 'manager1@gmail.com',
                'password' => bcrypt('password'),
            ],
            [
                'type' => 'Administrator',
                'hcp_id' => null,
                'staff_id' => 'Admin',
                'first_name' => 'admin',
                'last_name' => 'admin',
                'full_name' => 'Administrator',
                'gender' => 0,
                'email' => 'admin@gmail.com',
                'password' => bcrypt('password'),
            ],
            [
                'type' => 'Faculty Administrator',
                'hcp_id' => null,
                'staff_id' => 'FA',
                'first_name' => 'Faculty Admin',
                'last_name' => 'Faculty Admin',
                'full_name' => 'Faculty Administrator',
                'gender' => 1,
                'email' => 'fadmin@gmail.com',
                'password' => bcrypt('password'),
            ],
        ]);
        

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
