<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('buildings', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->foreignId('faculty_id')->constrained('faculties','id')->onDelete('cascade');
            $table->timestamps();
        });

        DB::table('buildings')->insert([
            [
                'name'=>'Building 1',
                'faculty_id'=> 1,
            ],
            [
                'name'=>'Building 2',
                'faculty_id'=> 2,
            ],
            [
                'name'=>'Building 3',
                'faculty_id'=> 1,
            ],
            [
                'name'=>'Building 4',
                'faculty_id'=> 1,
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('buildings');
    }
};
