<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('levels', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->foreignId('building_id')->constrained('buildings','id')->onDelete('cascade');
            $table->foreignId('faculty_id')->constrained('faculties','id')->onDelete('cascade');
            $table->timestamps();
        });

        DB::table('levels')->insert([
            [
                'name'=>'Ground Floor',
                'building_id'=> 1,
                'faculty_id'=> 1,
            ],
            [
                'name'=>'1',
                'building_id'=> 2,
                'faculty_id'=> 2,
            ],
            [
                'name'=>'2',
                'building_id'=> 3,
                'faculty_id'=> 1,
            ],
            [
                'name'=>'3',
                'building_id'=> 4,
                'faculty_id'=> 1,
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('levels');
    }
};
