<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rooms', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->string('access_level_name')->nullable();
            $table->integer('access_level_id')->nullable();
            $table->foreignId('faculty_id')->constrained('faculties','id')->onDelete('cascade')->nullable();
            $table->foreignId('building_id')->constrained('buildings','id')->onDelete('cascade')->nullable();
            $table->foreignId('level_id')->constrained('levels','id')->onDelete('cascade')->nullable();
            $table->foreignId('type_id')->constrained('room_type','id')->onDelete('cascade');
            $table->enum('status', ['Available', 'Unavailable'])->default('Available');
            $table->enum('reason', ['Closed', 'Maintenance'])->nullable();
            $table->string('image_path1')->nullable();
            $table->string('image_path2')->nullable();
            $table->string('image_path3')->nullable();
            $table->string('image_path4')->nullable();
            $table->timestamps();
        });

        DB::table('rooms')->insert([
            [
                'name' => 'room 1',
                'faculty_id' => '1',
                'building_id' => '1',
                'level_id' => '1',
                'type_id' => '1',
            ],
            [
                'name' => 'room 2',
                'faculty_id' => '2',
                'building_id' => '2',
                'level_id' => '2',
                'type_id' => '2',
            ],
        ]);
    }

    
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rooms');
    }
};
