<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('classes', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description')->nullable();
            $table->foreignId('room_id')->constrained('rooms','id')->onDelete('cascade');
            $table->dateTime('start_date_time');
            $table->dateTime('end_date_time');
            $table->foreignId('group_id')->constrained('groups','id')->onDelete('cascade');
            $table->enum('repeat_type', ['Once', 'Weekly', 'Monthly'])->default('Once');
            $table->enum('status', ['Pending', 'Approved', 'Cancelled'])->default('Pending');
            $table->foreignId('requested_by_id')->nullable()->constrained('users','id')->onDelete('cascade');
            $table->foreignId('approved_by_id')->nullable()->constrained('users','id')->onDelete('cascade');
            $table->dateTime('approval_date_time')->nullable();
            $table->text('approval_remark')->nullable();
            $table->timestamps();
        });

        DB::table('classes')->insert(([
            [
                'title' => 'Class 1',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-08 07:00:00',
                'end_date_time' => '2024-11-08 09:00:00',
                'group_id' => '1',
            ],
            [
                'title' => 'Class 2',
                'description' => 'testing',
                'room_id' => '2',
                'start_date_time' => '2024-11-08 10:00:00',
                'end_date_time' => '2024-11-08 12:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 3',
                'description' => 'testing',
                'room_id' => '2',
                'start_date_time' => '2024-11-23 07:00:00',
                'end_date_time' => '2024-11-23 09:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 4',
                'description' => 'testing',
                'room_id' => '2',
                'start_date_time' => '2024-11-23 10:00:00',
                'end_date_time' => '2024-11-23 12:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 5',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 07:00:00',
                'end_date_time' => '2024-11-12 07:30:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 6',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 7:30:00',
                'end_date_time' => '2024-11-12 08:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 7',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 08:00:00',
                'end_date_time' => '2024-11-12 08:30:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 8',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 08:30:00',
                'end_date_time' => '2024-11-12 09:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 9',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 09:00:00',
                'end_date_time' => '2024-11-12 09:30:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 10',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 09:30:00',
                'end_date_time' => '2024-11-12 10:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 11',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 10:00:00',
                'end_date_time' => '2024-11-12 10:30:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 12',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 10:30:00',
                'end_date_time' => '2024-11-12 11:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 13',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 11:00:00',
                'end_date_time' => '2024-11-12 11:30:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 14',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 11:30:00',
                'end_date_time' => '2024-11-12 12:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 15',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 12:00:00',
                'end_date_time' => '2024-11-12 12:30:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 16',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 12:30:00',
                'end_date_time' => '2024-11-12 13:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 17',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 13:00:00',
                'end_date_time' => '2024-11-12 13:30:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 18',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 13:30:00',
                'end_date_time' => '2024-11-12 14:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 19',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 14:00:00',
                'end_date_time' => '2024-11-12 14:30:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 20',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 14:30:00',
                'end_date_time' => '2024-11-12 15:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 21',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 15:00:00',
                'end_date_time' => '2024-11-12 15:30:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 22',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 15:30:00',
                'end_date_time' => '2024-11-12 16:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 23',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 16:00:00',
                'end_date_time' => '2024-11-12 16:30:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 24',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-12 16:30:00',
                'end_date_time' => '2024-11-12 17:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 25',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-13 17:00:00',
                'end_date_time' => '2024-11-13 17:30:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 26',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-13 17:30:00',
                'end_date_time' => '2024-11-13 18:00:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 27',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-13 18:00:00',
                'end_date_time' => '2024-11-13 18:30:00',
                'group_id' => '2',
            ],
            [
                'title' => 'Class 28',
                'description' => 'testing',
                'room_id' => '1',
                'start_date_time' => '2024-11-13 18:30:00',
                'end_date_time' => '2024-11-13 19:00:00',
                'group_id' => '2',
            ],
        ]));

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('classes');
    }
};
