<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('group_user', function (Blueprint $table) {
            $table->id();
            $table->foreignId('group_id')->constrained('groups','id')->onDelete('cascade');
            $table->foreignId('user_id')->constrained('users','id')->onDelete('cascade');
            $table->timestamps();
        });

        DB::table('group_user')->insert([
            [
                'group_id' => 1,
                'user_id' => 2,
            ],
            [
                'group_id' => 1,
                'user_id' => 3,
            ],
            [
                'group_id' => 1,
                'user_id' => 4,
            ],
            [
                'group_id' => 1,
                'user_id' => 5,
            ],
            [
                'group_id' => 1,
                'user_id' => 6,
            ],
            [
                'group_id' => 2,
                'user_id' => 5,
            ],
            [
                'group_id' => 2,
                'user_id' => 3,
            ],
            [
                'group_id' => 2,
                'user_id' => 6,
            ],
            [
                'group_id' => 2,
                'user_id' => 2,
            ],
            [
                'group_id' => 2,
                'user_id' => 4,
            ],
            [
                'group_id' => 1,
                'user_id' => 1,
            ],
            [
                'group_id' => 1,
                'user_id' => 8,
            ],
            [
                'group_id' => 2,
                'user_id' => 7,
            ],
            [
                'group_id' => 2,
                'user_id' => 9,
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('group_user');
    }
};
