<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->string('setting_key');
            $table->string('setting_value')->nullable();
        });

        DB::table('settings')->insert([
            [
                'setting_key' => 'system_version',
                'setting_value' => '1.0.0',
            ],
            [
                'setting_key' => 'system_updated',
                'setting_value' => '2024-10-30',
            ],
            [
                'setting_key' => 'company_name',
                'setting_value' => 'Universiti Tun Hussein Onn Malaysia',
            ],
            [
                'setting_key' => 'short_name',
                'setting_value' => 'UTHM',
            ],
            [
                'setting_key' => 'system_name',
                'setting_value' => 'Classroom Management',
            ],
            [
                'setting_key' => 'custom_range',
                'setting_value' => '1',
            ],
            [
                'setting_key' => 'start_time',
                'setting_value' => '07:00:00',
            ],
            [
                'setting_key' => 'end_time',
                'setting_value' => '22:00:00',
            ],
            [
                'setting_key' => 'attendance_type',
                'setting_value' => 'Check in and check out',
            ],
            [
                'setting_key' => 'send_email',
                'setting_value' => '0',
            ],
            [
                'setting_key' => 'security_team',
                'setting_value' => '',
            ],
            [
                'setting_key' => 'smtp_server',
                'setting_value' => '',
            ],
            [
                'setting_key' => 'smtp_sender_name',
                'setting_value' => '',
            ],
            [
                'setting_key' => 'smtp_username',
                'setting_value' => '',
            ],
            [
                'setting_key' => 'smtp_password',
                'setting_value' => '',
            ],
            [
                'setting_key' => 'smtp_port',
                'setting_value' => '',
            ],
            [
                'setting_key' => 'enable_ssl',
                'setting_value' => '',
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
