<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
    <h1>Approve Class by Id</h1>
    {{-- to display error if wrong user --}}
    @if (session('success'))
    <div class="alert alert-danger" role="alert">
        {{ session('success') }}
    </div>
    @endif

    @php
        $class_id = 1;
    @endphp
    
    <form action="{{route('class.approve-class-by-id', ['id' => $class_id])}}" method="POST">
        @csrf
        @method('PATCH')

        <div>Approve Class : {{App\Models\Classes::findOrFail($class_id)->title}} </div>

        <div>Remark</div>
        <textarea type="text" name="approval_remark"></textarea>

        <button type="submit">Approve</button>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
            
    </form>

    <script>

        function building_option_click(levels, building_name) {
            dropdown = document.getElementById('level-dropdown');
            dropdown.innerHTML = ''; 
            levels.forEach(l => {
                level_option = document.createElement('div');
                level_option.style = 'cursor:pointer';
                level_option.onclick = function (){document.getElementById('level-button').textContent = l.name; document.getElementById('level_id').value = l.id; }
                level_option.textContent = l.name;

                dropdown.appendChild(level_option);
            });

            document.getElementById('building-button').value = building_name; //for building id
        }

    </script>
    
</body>
</html>