<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
    <h1>Update Class by Id</h1>
    {{-- to display error if wrong user --}}
    @if (session('success'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('success') }}
    </div>
    @endif

    @php 
    $class_id = 1;
    $class = App\Models\Classes::findOrFail($class_id);
    @endphp
    
    <form action="{{route('class.update-class-by-id', ['id' => $class_id])}}" method="POST">
        @csrf
        @method('PATCH')

        <div>Title*</div>
        <input type="text" name="title" value="{{$class->title}}">

        <div>Description</div>
        <textarea type="text" name="description">{{$class->description}}</textarea>

        <div>Room</div>
        <input type="hidden" name="room_id" id="room_id" value="{{$class->room_id}}">
        <div id="room-dropdown-button">{{$class->room->name}}</div>
        <div style="width:150px; height:80px; overflow:auto">
            @php $rooms = App\Models\Rooms::all(); @endphp
            @foreach ($rooms as $rm)
                <div style="cursor:pointer" onclick="document.getElementById('room-dropdown-button').textContent='{{$rm->name}}'; document.getElementById('room_id').value = {{$rm->id}}">{{$rm->name}}</div>
            @endforeach
        </div>

        <div>Start Date*</div>
        <input type="text" name="start_date" value="{{(new DateTime($class->start_date_time))->format('Y-m-d')}}">

        <div>Start Time*</div>
        <input type="hidden" name="start_time" id="start_time" value="{{(new DateTime($class->start_date_time))->format('H:i:s')}}">
        <div style="display:flex;">
            <div style="width:100px">
                <div id="start-hour-dropdown-button" style="text-align:center">{{(new DateTime($class->start_date_time))->format('h')}}</div>
                <div style="height:150px; overflow:auto;">
                    @for ($i = 1; $i <= 12; $i++)
                        <div style="cursor:pointer" onclick="document.getElementById('start-hour-dropdown-button').textContent = '{{ sprintf('%02d', $i) }}'; time_click('hour', {{$i}}, 'start_time')">{{ sprintf('%02d', $i) }}</div>
                    @endfor
                </div>
            </div>
            <div style="width:100px">
                <div id="start-minute-dropdown-button" style="text-align:center">{{(new DateTime($class->start_date_time))->format('i')}}</div>
                <div style="height:150px; overflow:auto;">
                    @for ($i = 0; $i <= 59; $i++)
                        <div style="cursor:pointer" onclick="document.getElementById('start-minute-dropdown-button').textContent = '{{ sprintf('%02d', $i) }}'; time_click('minute', {{$i}}, 'start_time')">{{ sprintf('%02d', $i) }}</div>
                    @endfor
                </div>
            </div>
            <div style="width:100px">
                <div id="start-phase-dropdown-button" style="text-align:center">{{(new DateTime($class->start_date_time))->format('A')}}</div>
                <div style="height:150px; overflow:auto;">
                    <div style="cursor:pointer" onclick="document.getElementById('start-phase-dropdown-button').textContent = 'AM'; time_click('phase', 'AM', 'start_time')">AM</div>
                    <div style="cursor:pointer" onclick="document.getElementById('start-phase-dropdown-button').textContent = 'PM'; time_click('phase', 'PM', 'start_time')">PM</div>
                </div>
            </div>
        </div>

        <div style="height:20px"></div>

        <div>End Date*</div>
        <input type="text" name="end_date" value="{{(new DateTime($class->end_date_time))->format('Y-m-d')}}">

        <div>End Time*</div>
        <input type="hidden" name="end_time" id="end_time" value="{{(new DateTime($class->end_date_time))->format('H:i:s')}}">
        <div style="display:flex;">
            <div style="width:100px">
                <div id="end-hour-dropdown-button" style="text-align:center">{{(new DateTime($class->end_date_time))->format('h')}}</div>
                <div style="height:150px; overflow:auto;">
                    @for ($i = 1; $i <= 12; $i++)
                        <div style="cursor:pointer" onclick="document.getElementById('end-hour-dropdown-button').textContent = '{{ sprintf('%02d', $i) }}'; time_click('hour', {{$i}}, 'end_time')">{{ sprintf('%02d', $i) }}</div>
                    @endfor
                </div>
            </div>
            <div style="width:100px">
                <div id="end-minute-dropdown-button" style="text-align:center">{{(new DateTime($class->end_date_time))->format('i')}}</div>
                <div style="height:150px; overflow:auto;">
                    @for ($i = 0; $i <= 59; $i++)
                        <div style="cursor:pointer" onclick="document.getElementById('end-minute-dropdown-button').textContent = '{{ sprintf('%02d', $i) }}'; time_click('minute', {{$i}}, 'end_time')">{{ sprintf('%02d', $i) }}</div>
                    @endfor
                </div>
            </div>
            <div style="width:100px">
                <div id="end-phase-dropdown-button" style="text-align:center">{{(new DateTime($class->end_date_time))->format('A')}}</div>
                <div style="height:150px; overflow:auto;">
                    <div style="cursor:pointer" onclick="document.getElementById('end-phase-dropdown-button').textContent = 'AM'; time_click('phase', 'AM', 'end_time')">AM</div>
                    <div style="cursor:pointer" onclick="document.getElementById('end-phase-dropdown-button').textContent = 'PM'; time_click('phase', 'PM', 'end_time')">PM</div>
                </div>
            </div>
        </div>

        <div style="height:20px"></div>

        <div>Group*</div>
        <input type="hidden" name="group_id" id="group_id" value="{{$class->group_id}}">
        <div id="group-dropdown-button">{{$class->group->name}}</div>
        <div style="width:150px; height:80px; overflow:auto">
            @php $groups = App\Models\Groups::all(); @endphp
            @foreach ($groups as $gr)
                <div style="cursor:pointer" onclick="document.getElementById('group-dropdown-button').textContent='{{$gr->name}}'; document.getElementById('group_id').value = {{$gr->id}}">{{$gr->name}}</div>
            @endforeach
        </div>

        <button type="submit">Save Changes</button>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
            
    </form>

    <script>
        function time_click(time_type, value, input_id) {
            input = document.getElementById(input_id);
            let current_time = input.value;

            let time_parts = current_time.split(':');
            let hour = parseInt(time_parts[0]);
            let minute = parseInt(time_parts[1]);
            let phase = hour >= 12 ? 'PM' : 'AM';
            switch (time_type) {
                case 'hour': 
                    if (phase === 'PM') { hour = (value < 12) ? value + 12 : value;
                    } else { hour = (value === 12) ? 0 : value; }
                    break;
                case 'minute': 
                    minute = value;
                    break;
                case 'phase': 
                    if (value === 'AM' && hour >= 12) { hour -= 12;
                    } else if (value === 'PM' && hour < 12) {hour += 12;}
                    break;
            }
            let new_time = `${hour.toString().padStart(2, '0')}:${minute.toString().padStart(2, '0')}:00`; // Seconds are fixed to "00"
            input.value = new_time;
        }
    </script>
</body>
</html>