@extends('layouts.app')

@push('style')
    <style>
        #group-option-dropdown-button { transition: 0.3s }
        #group-option-dropdown-button.active { background-color: #00000088; }
        .group-header { border-bottom: 3px solid #00000000; transition:0.3s; cursor:pointer }
        .group-header.active { color:var(--plt2); border-bottom: 3px solid var(--plt2); }
        .group-header:hover { color:var(--plt2) }
        .group-tab { display:none }
        .group-tab.active { display:block }
    </style>
@endpush

@section('groups-button', 'active')

@section('header')
    @php $visible = 'visibility:hidden;' @endphp
    @if (Auth::user()->type == 'Administrator' || Auth::user()->type == 'Management' || Auth::user()->type == 'Lecturer')
        @php $visible = 'visibility:visible;' @endphp
    @endif

    <div class="d-flex h-100p" id="nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs1 fw-bold cursor-default">Groups</div>
        <div class="d-flex-center" style="{{$visible}}">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" onclick="open_popup_click('add-group-popup')">
                <span class="material-symbols-outlined fs-20 mg-r-5">add</span>
                <div>Add</div>
            </div>
        </div>
    </div>

    <div class="d-none" id="group-nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold clr-blue clr-blue-hv txt-u-hv cursor-pointer" onclick="back_click()">Back</div>
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold cursor-default" id="group-name-header"></div>
        <div class="h-100p" style="position:relative">
            <div class="d-flex-center h-100p" style="{{$visible}}">
                <div id="group-option-dropdown-button" class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;">
                    <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">list</span>
                    <div>Option</div>
                </div>
            </div>
            <div class="dropdown w-180 cursor-pointer" id="group-option-dropdown" style="position:absolute; {{$visible}}">
                <div class="option" id="edit-group-button">
                    <div class="fs3 clr-black-2 fw-bold">Edit Group</div>
                    <div class="fs4 clr-grey-2 fw-bold">Update group details</div>
                </div>
                <div class="option" id="recreate-group-button">
                    <div class="fs3 clr-black-2 fw-bold">Recreate Group</div>
                    <div class="fs4 clr-grey-2 fw-bold">Recreate same group</div>
                </div>
                <div class="option pd-b-10" id="delete-group-button">
                    <div class="fs3 clr-black-2 fw-bold">Delete Group</div>
                    <div class="fs4 clr-grey-2 fw-bold">Remove this group from the system</div>
                </div>
            </div>
        </div>
        <div class="d-flex-center" style="{{$visible}}">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" id="add-student-group-button">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">add</span>
                <div>Add</div>
            </div>
        </div>
    </div>
    
@endsection

@section('main-body')
    @php
        $groups = App\Models\Groups::all();
    @endphp 
    <div id="main">
        <table class="table w-100p">
            <tr>
                <th></th>
                <th><div class="cursor-pointer clr-blue-hv">Group name</div></th>
                <th>Lecturer</th>
                <th><div class="cursor-pointer clr-blue-hv">Total</div></th>
                <th>Status</th>
            </tr>

            @php $count = 1; @endphp
            @foreach ($groups as $group)
                @if (Auth::user()->type == 'Lecturer' || Auth::user()->type == 'Student Lead' || Auth::user()->type == 'Student')
                    @php 
                    @endphp
                    @if ($group->group_user->where('user_id', Auth::user()->id) == '[]')
                        @break
                    @endif
                @endif
                <tr>
                    <td style="width:0px">
                        <div class="d-flex-center">
                            <div class="bg-plt1-tr2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4">{{$count}}</div>
                        </div>
                    </td>
                    <td>
                        <div class="cursor-pointer clr-blue-hv txt-u-hv tw-nowrap fs-12 clr-grey-1" onclick="group_click({{$group->id}}, `{{$group->name}}`)">
                            {{$group->name}}</div>
                    </td>
                    <td>
                        @foreach ($group->group_user as $group_user)
                            @if($group_user->user->type == 'Lecturer')
                                @php $lecturer = $group_user->user; @endphp
                                <div class="tw-nowrap fs-12 clr-grey-1">{{$lecturer->full_name}}</div>
                            @endif
                        @endforeach
                    </td>
                    <td>
                        @php $totalStudent = 0;  @endphp
                        @forEach ($group->group_user as $group_user)
                            @if($group_user->user->type == 'Student' || $group_user->user->type == 'Student Lead')
                                @php $totalStudent += 1; @endphp
                            @endif
                        @endforeach
                        <div class="tw-nowrap fs-12 clr-grey-1">{{$totalStudent}} student</div>
                    </td>
                    <td>
                        @if($group->status == 'Active')
                            <div class="tw-nowrap fs-12 clr-green fw-bold br-5 bg-green-2 w-mc pd-5">{{$group->status}}</div>
                        @else
                            <div class="tw-nowrap fs-12 clr-yellow fw-bold br-5 bg-gold-2 w-mc pd-5">{{$group->status}}</div>
                        @endif
                    </td>
                </tr>
                @php $count += 1; @endphp
            @endforeach
        </table>
    </div>

    @foreach ($groups as $group)
        <form id="delete-group-{{$group->id}}-form" class="d-none" action="{{route('group.delete-group-by-id',['id' => $group->id])}}" method="POST">
            @csrf
            @method('DELETE')
        </form>

        <div class="w-100p h-100p pd-t-20 d-none" id="group-{{$group->id}}">
            @php $group_users = App\Models\GroupUser::where('group_id', $group->id)->get(); @endphp
            <div class="w-100p h-100p d-flex cursor-default">
                <div class="w-250 h-500 f-shrink-0">
                    <div class="d-flex pd-b-10 fw-wrap">
                    @foreach ($group_users as $group_user)
                    @php 
                        $user = $group_user->user; 
                        if ($user->type != 'Lecturer') { break; }
                        $lecturer = $user;
                    @endphp
                        <div class="d-flex pd-tb-5 pd-r-10">
                            <div class="">
                                @if ($lecturer['image_path'])
                                    <img src="{{asset('storage' . $lecturer->image_path)}}" alt="" class="w-40 h-40 br-50p">
                                @else
                                    <img src="{{asset('storage/system/avatar.png')}}" alt="" class="w-40 h-40 br-50p">
                                @endif
                            </div>
                            <div class="mg-l-10">
                                <div class="clr-black-2 fw-bold fs3">{{$lecturer->full_name}}</div>
                                <div class="fs3 clr-grey-2 fw-bold">{{$lecturer->email}}</div>
                            </div>
                        </div>
                    @endforeach
                    </div>
                    
                    <div class="mg-b-20">
                        <div class="clr-black-2 fw-bold fs3">Group Name</div>
                        <div class="fs3 clr-grey-2 fw-bold">{{$group->name}}</div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-black-2 fw-bold fs3">Description</div>
                        <div class="fs3 clr-grey-2 fw-bold">{{$group->description}}</div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-black-2 fw-bold fs3">Total Student</div>
                        @php $totalStudent = 0;  @endphp
                        @foreach ($group->group_user as $group_user)
                            @if($group_user->user->type == 'Student' || $group_user->user->type == 'Student Lead')
                                @php $totalStudent += 1; @endphp
                            @endif
                        @endforeach
                        <div class="fs3 clr-grey-2 fw-bold">{{$totalStudent}}</div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-black-2 fw-bold fs3">Group Status</div>
                        <div class="fs3 clr-grey-2 fw-bold">{{$group->status}}</div>
                    </div>
                </div>
                <div class="w-1 h-100p mg-lr-30" style="background-color:#00000022"></div>
                <div class="w-100p d-flex fd-column">
                    <div class="d-flex f-shrink-0 pd-tb-10 fw-bold fs3 clr-grey-2">
                        <div id="group-{{$group->id}}-header-1" class="group-header active d-flex-center pd-10" onclick="group_header_click(1, {{$group->id}})"><span class="material-symbols-outlined fs-20 mg-r-5">groups</span>Student</div>
                        <div id="group-{{$group->id}}-header-2" class="group-header d-flex-center pd-10" onclick="group_header_click(2, {{$group->id}})"><span class="material-symbols-outlined fs-20 mg-r-5">event_available</span>Classes</div>
                        <div id="group-{{$group->id}}-header-3" class="group-header d-flex-center pd-10" onclick="group_header_click(3, {{$group->id}})"><span class="material-symbols-outlined fs-20 mg-r-5">history</span>Previous</div>
                    </div>
                    <div class="h-100p">
                        <div id="group-{{$group->id}}-tab-1" class="group-tab active of-auto w-100p bs-bb h-100p pd-10">
                            @if ($totalStudent == 0)
                                <div class="d-flex fd-column ai-center">
                                    <span class="material-symbols-outlined clr-grey-2 fs-200">group</span>
                                    <div class="clr-grey-2 fs2">Currently you have no student to show</div>
                                </div>
                            @else
                                @php $count = 1; @endphp              
                                @foreach ($group->group_user as $group_user)
                                    @if($group_user->user->type == 'Student' || $group_user->user->type == 'Student Lead')
                                        <div class="d-flex pd-tb-10 pd-lr-10 bg-blue-hv" style="border-bottom: 1px solid #bec3d055;">
                                            <div class="d-flex-center">
                                                <div class="bg-plt1-tr2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4 mg-r-20">{{$count}}</div>
                                            </div>
                                            <div class="d-flex-center mg-l-20 mg-r-30">
                                                <div class="checkbox">
                                                    <input type="checkbox" id="" name="group_student_ids[]" value={{$group_user->user->id}}>
                                                    <svg viewBox="0 0 35.6 35.6">
                                                        <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                                        <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                                        <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                                                    </svg>
                                                </div>
                                            </div>
                                            <div class="d-flex option ai-center" id="student-{{$group_user->id}}-{{$group->id}}">
                                                <div class="d-flex w-100p ai-center cursor-default">
                                                    <div>
                                                        @if ($group_user['image_path'])
                                                            <img src="{{asset('storage' . $group_user->user->image_path)}}" alt="" class="w-35 h-35 br-50p">
                                                        @else
                                                            <img src="{{asset('storage/system/avatar.png')}}" alt="" class="w-35 h-35 br-50p">
                                                        @endif
                                                    </div>
                                                    <div class="mg-l-10">
                                                        <div class="lecturer-name fw-bold fs3">{{$group_user->user->full_name}}</div>
                                                        <div class="fs4 clr-grey-2 fw-bold">{{$group_user->user->email}}</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @php $count += 1; @endphp
                                    @endif
                                @endforeach
                            @endif
                        </div>
                        <div id="group-{{$group->id}}-tab-2" class="group-tab">
                            @foreach (Carbon\CarbonPeriod::create(Carbon\Carbon::today(), Carbon\Carbon::today()->addWeeks(2)) as $date)
                                <div class="d-flex pd-tb-10 pd-lr-10 bg-blue-hv"  style="border-bottom: 1px solid #bec3d055;">
                                    <div class="w-mc f-shrink-0 d-flex fd-column mg-r-20" style="gap:5px;">
                                        <div class="fs4 clr-grey-1">{{$date->format('D')}}</div>
                                        <div class="fs1 fw-bold">{{$date->format('d')}}</div>
                                    </div>
                                    <div class="w-100p">
                                        <!-- Check if there's a holiday on this date -->
                                        @php
                                            $holidays = App\Models\Holidays::all();
                                            $holidayDescription = null;
                                            foreach ($holidays as $holiday) {
                                                if (Carbon\Carbon::parse($holiday->date)->isSameDay($date)) {
                                                    $holidayDescription = $holiday->description;
                                                    break;
                                                }
                                            }
                                        @endphp
                                        <!-- Display holiday description if available -->
                                        @if ($holidayDescription)
                                            <div class="w-100p d-flex bg-plt5 clr-blue pd-5 mg-b-5">
                                                <span class="material-symbols-outlined us-none">today</span>
                                                <div class="fs3 fw-bold txt-nowrap d-flex-center">
                                                    {{ $holidayDescription }}
                                                </div>
                                            </div>
                                        @endif
                                        @foreach($group->classes as $class)
                                            @if (Carbon\Carbon::parse($class->start_date_time)->isSameDay($date))
                                                <div class="w-100p d-flex fs4">
                                                    <div class="w-150 f-shrink-0 clr-grey-1">{{Carbon\Carbon::parse($class->start_date_time)->format('h:i A')}} - {{Carbon\Carbon::parse($class->end_date_time)->format('h:i A')}}</div>
                                                    <div class="w-100p clr-blue fw-bold txt-nowrap">{{$class->title}}</div>
                                                    <div class="w-150 f-shrink-0 clr-grey-1 d-flex ai-center">
                                                        <span class="material-symbols-outlined fs-15 mg-r-5">location_on</span>
                                                        <div class="txt-nowrap">{{$class->room->name}}</div>
                                                    </div>
                                                    <div class="f-shrink-0 clr-grey-1 d-flex ai-center">
                                                        <span class="material-symbols-outlined fs-15 mg-r-5">schedule</span>
                                                        @php
                                                            $diff = Carbon\Carbon::parse($class->start_date_time)->diff(Carbon\Carbon::parse($class->end_date_time));
                                                            $hours = $diff->h;
                                                            $minutes = $diff->i;
                                                            if ($hours > 0 && $minutes > 0) { $result = "{$hours} hours {$minutes} minutes";
                                                            } elseif ($hours > 0) { $result = "{$hours} hours";
                                                            } else { $result = "{$minutes} minutes"; } 
                                                        @endphp
                                                        <div class="txt-nowrap">{{$result}}</div>
                                                    </div>
                                                    
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div id="group-{{$group->id}}-tab-3" class="group-tab of-auto w-100p bs-bb h-100p pd-10">
                            @if ($group->classes->count() == 0)
                                <div class="d-flex fd-column ai-center">
                                    <span class="material-symbols-outlined clr-grey-2 fs-200">history</span>
                                    <div class="clr-grey-2 fs2">Currently you have no previous class to show</div>
                                </div>
                            @else
                                @php $count = 1; @endphp              
                                @foreach ($group->classes as $class)
                                    @if (Carbon\Carbon::parse($class->start_date_time)->isPast())
                                        <div class="d-flex pd-tb-10 pd-lr-10 bg-blue-hv"  style="border-bottom: 1px solid #bec3d055;">
                                            <div class="d-flex-center">
                                                <div class="bg-plt1-tr2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4 mg-r-20">{{$count}}</div>
                                            </div>
                                            <div class="cursor-pointer w-250 f-shrink-0 clr-blue clr-blue-hv fw-bold txt-u-hv tw-nowrap fs-12 clr-grey-1" style="text-overflow:ellipsis; overflow:hidden; white-space:nowrap;" onclick="class_click({{$class->id}}, `{{$class->title}}`)">
                                                {{$class->title}}
                                            </div>
                                            <div class="d-flex ai-center w-150 f-shrink-0 tw-nowrap fs-10 clr-grey-1" style="text-overflow:ellipsis; overflow:hidden; white-space:nowrap;" onclick="class_click({{$class->id}}, `{{$class->title}}`)">
                                                <span class="material-symbols-outlined fs-15 mg-r-5">location_on</span>
                                                <div>{{$class->room->name}}</div>
                                            </div>
                                            <div class="d-flex ai-center w-250 f-shrink-0 tw-nowrap fs-10 clr-grey-1">
                                                <span class="material-symbols-outlined fs-15 mg-r-5">schedule</span>
                                                <div>{{Carbon\Carbon::parse($class->start_date_time)->format('d M Y h:i A')}} - {{Carbon\Carbon::parse($class->end_date_time)->format('h:i A')}}</div>
                                            </div>
                                            <div class="d-flex ai-center w-100p tw-nowrap fs-10 clr-grey-1">
                                                <span class="material-symbols-outlined fs-15 mg-r-5">groups</span>
                                                <div>Attendance 15/12</div>
                                            </div>
                                        </div>
                                        @php $count += 1; @endphp
                                    @endif
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>  
    @endforeach
@endsection

@section('body-box')
    <div id="add-group-popup" class="right-popup bg-white w-600 h-100p">
        <form action="{{route('group.create-group')}}" method="POST" class="h-100p w-100p">
            @csrf
            @method('POST')
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb cursor-default">
                    <div class="fs-18 clr-grey-2 fw-bold">New Group</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-30">Lecturer <span style="color:red;">*</span></div>
                    <div id="lecturer-dropdown-button" class="button-primary d-flex-center mg-tb-10 w-100">Add Lecturer</div>
                    <div id="lecturer-dropdown" class="dropdown w-300">
                        <div class="d-flex">
                            <input type="text" name="" id="lecturer-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                        @php $user_lecturer = App\Models\User::where('type', 'Lecturer')->get(); @endphp
                        @foreach ($user_lecturer as $ul)
                            <div class="d-flex option ai-center" id="lecturer-{{$ul->id}}">
                                <div class="d-flex w-100p ai-center cursor-default">
                                    <div>
                                        @if ($ul['image_path'])
                                            <img src="{{asset('storage' . $user->image_path)}}" alt="" class="w-40 h-40 br-50p">
                                        @else
                                            <img src="{{asset('storage/system/avatar.png')}}" alt="" class="w-40 h-40 br-50p">
                                        @endif
                                    </div>
                                    <div class="mg-l-10">
                                        <div class="lecturer-name fw-bold fs3">{{$ul->full_name}}</div>
                                        <div class="fs4 clr-grey-2 fw-bold">{{$ul->email}}</div>
                                    </div>
                                </div>
                                <button type="button" class="button-primary d-flex-center w-30 h-30 f-shrink-0 mg-r-10" onclick="add_lecturer_click({{$ul->id}}, '{{$ul->email}}', '{{$ul->full_name}}', '{{$ul->image_path}}')">
                                    <span class="material-symbols-outlined">add</span></button>
                            </div>
                        @endforeach
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20 mg-b-10">Added Lecturer(s)</div>
                    <div id="added-lecturer" class="w-300"></div>
                    {{-- <input type="text" name="lecturer_name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text"> --}}

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Group Name <span style="color:red;">*</span></div>
                    <input type="text" name="name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Description </div>
                    <textarea class="textarea w-300 clr-grey-1 mg-t-5 pd-5 bs-bb cursor-text" style="font-family:Arial, Helvetica, sans-serif; max-width:300px; min-width:300px;" name="description" rows="5"></textarea>

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                    <button type="button" onclick="close_popup_click('add-group-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>
    
    {{-- for add student --}}
    @foreach ($groups as $group)
        <div id="add-student-group-{{$group->id}}-popup" class="right-popup bg-white w-600 h-100p">
            <form action="{{route('group.add-students-group-by-id', ['id' => $group->id])}}" method="POST" enctype="multipart/form-data" class="h-100p w-100p">
            @csrf
            @method('PATCH')
            
                <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                    <div class="h-100p pd-30 bs-bb cursor-default">
                        <div class="fs-18 clr-grey-2 fw-bold">Add Student</div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-30">Student <span style="color:red;">*</span></div>
                        <div id="student-dropdown-button-group-{{$group->id}}" class="button-primary d-flex-center mg-tb-10 w-100">Add Student</div>
                        <div id="student-dropdown-group-{{$group->id}}" class="dropdown w-300">
                            <div class="d-flex">
                                <input type="text" name="" id="student-search-group-{{$group->id}}" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                            </div>
                            @php $user_student = App\Models\User::whereIn('type', ['Student','Student Lead'])->get(); @endphp
                            @foreach ($user_student as $us)
                                <div class="d-flex option ai-center" id="student-{{$us->id}}-{{$group->id}}">
                                    <div class="d-flex w-100p ai-center cursor-default">
                                        <div>
                                            @if ($us['image_path'])
                                                <img src="{{asset('storage' . $us->image_path)}}" alt="" class="w-40 h-40 br-50p">
                                            @else
                                                <img src="{{asset('storage/system/avatar.png')}}" alt="" class="w-40 h-40 br-50p">
                                            @endif
                                        </div>
                                        <div class="mg-l-10">
                                            <div class="lecturer-name fw-bold fs3">{{$us->full_name}}</div>
                                            <div class="fs4 clr-grey-2 fw-bold">{{$us->email}}</div>
                                        </div>
                                    </div>
                                    <button type="button" class="button-primary d-flex-center w-30 h-30 f-shrink-0 mg-r-10" onclick="edit_group_add_student_click({{$us->id}}, '{{$us->email}}', '{{$us->full_name}}', '{{$us->image_path}}', {{$group->id}})">
                                        <span class="material-symbols-outlined">add</span></button>
                                </div>
                            @endforeach
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20 mg-b-10">Added Student(s)</div>
                        <div id="added-student-group-{{$group->id}}" class="w-300"></div>
                        {{-- <input type="text" name="lecturer_name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text"> --}}
                    </div>
                </div>

                <div class="submit-section h-80 w-100p">
                    <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                        <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Add</button>
                        <button type="button" onclick="close_popup_click('add-student-group-{{$group->id}}-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    @endforeach

    {{-- for edit group --}}
    @foreach ($groups as $group)
        <div id="edit-group-{{$group->id}}-popup" class="right-popup bg-white w-600 h-100p">
            <form action="{{route('group.update-group-by-id', ['id' => $group->id])}}" method="POST" enctype="multipart/form-data" class="h-100p w-100p">
            @csrf
            @method('PATCH')
            
                <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                    <div class="h-100p pd-30 bs-bb cursor-default">
                        <div class="fs-18 clr-grey-2 fw-bold">Edit Group</div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-30">Lecturer <span style="color:red;">*</span></div>
                        <div id="lecturer-dropdown-button-group-{{$group->id}}" class="button-primary d-flex-center mg-tb-10 w-100">Add Lecturer</div>
                        <div id="lecturer-dropdown-group-{{$group->id}}" class="dropdown w-300">
                            <div class="d-flex">
                                <input type="text" name="" id="lecturer-search-group-{{$group->id}}" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                            </div>
                            @php $user_lecturer = App\Models\User::where('type', 'Lecturer')->get(); @endphp
                            @foreach ($user_lecturer as $ul)
                                <div class="d-flex option ai-center" id="lecturer-{{$ul->id}}-{{$group->id}}">
                                    <div class="d-flex w-100p ai-center cursor-default">
                                        <div>
                                            @if ($ul['image_path'])
                                                <img src="{{asset('storage' . $ul->image_path)}}" alt="" class="w-40 h-40 br-50p">
                                            @else
                                                <img src="{{asset('storage/system/avatar.png')}}" alt="" class="w-40 h-40 br-50p">
                                            @endif
                                        </div>
                                        <div class="mg-l-10">
                                            <div class="lecturer-name fw-bold fs3">{{$ul->full_name}}</div>
                                            <div class="fs4 clr-grey-2 fw-bold">{{$ul->email}}</div>
                                        </div>
                                    </div>
                                    <button type="button" class="button-primary d-flex-center w-30 h-30 f-shrink-0 mg-r-10" onclick="edit_group_add_lecturer_click({{$ul->id}}, '{{$ul->email}}', '{{$ul->full_name}}', '{{$ul->image_path}}', {{$group->id}})">
                                        <span class="material-symbols-outlined">add</span></button>
                                </div>
                            @endforeach
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20 mg-b-10">Added Lecturer(s)</div>
                        <div id="added-lecturer-group-{{$group->id}}" class="w-300"></div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Group Name <span style="color:red;">*</span></div>
                        <input type="text" name="name" value="{{$group->name}}" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                                                
                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Description </div>
                        <textarea class="textarea w-300 clr-grey-1 mg-t-5 pd-5 bs-bb cursor-text" style="font-family:Arial, Helvetica, sans-serif; max-width:300px; min-width:300px;" name="description" rows="5">{{$group->description}}</textarea>

                        <div class="h-150"></div>
                        
                    </div>
                </div>

                <div class="submit-section h-80 w-100p">
                    <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                        <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Update</button>
                        <button type="button" onclick="close_popup_click('edit-group-{{$group->id}}-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    @endforeach

    {{-- for recreate group --}}
    @foreach ($groups as $group)
        <div id="recreate-group-{{$group->id}}-popup" class="right-popup bg-white w-600 h-100p">
            <form action="{{route('group.recreate-group-by-id', ['id' => $group->id])}}" method="POST" enctype="multipart/form-data" class="h-100p w-100p">
            @csrf
            @method('POST')
            
                <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                    <div class="h-100p pd-30 bs-bb cursor-default">
                        <div class="fs-18 clr-grey-2 fw-bold">Recreate Group</div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-30">Lecturer <span style="color:red;">*</span></div>
                        <div id="lecturer-dropdown-button-recreate-group-{{$group->id}}" class="button-primary d-flex-center mg-tb-10 w-100">Add Lecturer</div>
                        <div id="lecturer-dropdown-recreate-group-{{$group->id}}" class="dropdown w-300">
                            <div class="d-flex">
                                <input type="text" name="" id="lecturer-search-recreate-group-{{$group->id}}" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                            </div>
                            @php $user_lecturer = App\Models\User::where('type', 'Lecturer')->get(); @endphp
                            @foreach ($user_lecturer as $ul)
                                <div class="d-flex option ai-center" id="lecturer-{{$ul->id}}-recreate-{{$group->id}}">
                                    <div class="d-flex w-100p ai-center cursor-default">
                                        <div>
                                            @if ($ul['image_path'])
                                                <img src="{{asset('storage' . $ul->image_path)}}" alt="" class="w-40 h-40 br-50p">
                                            @else
                                                <img src="{{asset('storage/system/avatar.png')}}" alt="" class="w-40 h-40 br-50p">
                                            @endif
                                        </div>
                                        <div class="mg-l-10">
                                            <div class="lecturer-name fw-bold fs3">{{$ul->full_name}}</div>
                                            <div class="fs4 clr-grey-2 fw-bold">{{$ul->email}}</div>
                                        </div>
                                    </div>
                                    <button type="button" class="button-primary d-flex-center w-30 h-30 f-shrink-0 mg-r-10" onclick="recreate_group_add_lecturer_click({{$ul->id}}, '{{$ul->email}}', '{{$ul->full_name}}', '{{$ul->image_path}}', {{$group->id}})">
                                        <span class="material-symbols-outlined">add</span></button>
                                </div>
                            @endforeach
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20 mg-b-10">Added Lecturer(s)</div>
                        <div id="added-lecturer-recreate-group-{{$group->id}}" class="w-300"></div>

                        <div id="added-student-recreate-group-{{$group->id}}" class="d-none">
                            @php $group_user = $group->group_user; @endphp
                            @foreach ($group_user as $gu)
                                @if ($gu->user->type == 'Student' || $gu->user->type == 'Student Lead')
                                    <input type="hidden" name="student_ids[{{$gu->user->id}}]" id="" value="{{$gu->user->id}}">
                                @endif
                            @endforeach
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Group Name <span style="color:red;">*</span></div>
                        <input type="text" name="name" value="{{$group->name}}" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                                                
                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Description </div>
                        <textarea class="textarea w-300 clr-grey-1 mg-t-5 pd-5 bs-bb cursor-text" style="font-family:Arial, Helvetica, sans-serif; max-width:300px; min-width:300px;" name="description" rows="5">{{$group->description}}</textarea>

                        <div class="h-150"></div>
                    </div>
                </div>

                <div class="submit-section h-80 w-100p">
                    <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                        <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                        <button type="button" onclick="close_popup_click('recreate-group-{{$group->id}}-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    @endforeach
@endsection

@push('script')
    <script>
        let group_id_opened;
        @if (session('updated_group_id'))
            group_click({{ session('updated_group_id') }}, `{{App\Models\Groups::findOrFail(session('updated_group_id'))->name}}`);
        @endif

        // group_click(2, "Dondee Jahatttt");

        let lecturer_index = 0;
        const all_lecturers = @json($user_lecturer);
        const all_students = @json($user_student);
        
        //add group related function
        function add_lecturer_click(lecturer_id, lecturer_email, lecturer_name, lecturer_image) {
            const added_lecturer = document.getElementById('added-lecturer');
            
            added_lecturer.innerHTML += `
            <div id="added-lecturer-${lecturer_id}" class="mg-t-10 ai-center" style="display:flex">
                <div class="d-flex w-100p ai-center cursor-default">
                    <div>
                        @if ($ul['image_path'])
                            <img src="storage/${lecturer_image}" alt="" class="w-40 h-40 br-50p">
                        @else
                            <img src="storage/system/avatar.png" alt="" class="w-40 h-40 br-50p">
                        @endif
                    </div>
                    <div class="mg-l-10">
                        <div class="lecturer-name fw-bold fs3">${lecturer_name}</div>
                        <div class="fs4 clr-grey-2 fw-bold">${lecturer_email}</div>
                    </div>
                </div>               
                <button type="button" class="d-flex-center w-30 h-30 f-shrink-0 bg-red bg-red-hv clr-white border-none br-5 f-shrink-0 cursor-pointer" onclick="remove_lecturer_click(${lecturer_id}, '${lecturer_email}', '${lecturer_name}', '${lecturer_image}')">
                    <span class="material-symbols-outlined">remove</span></button>
            </div>`;
            added_lecturer.innerHTML += `<input type="hidden" id="hidden-lecturer-${lecturer_id}" value="${lecturer_id}" name="lecturer_ids[${lecturer_index}]">`;
            lecturer_index++;

            update_lecturer_dropdown(lecturer_id, 'remove', lecturer_email, lecturer_name, lecturer_image);
        }

        function remove_lecturer_click(lecturer_id, lecturer_email, lecturer_name, lecturer_image) {
            const added_lecturer_div = document.getElementById('added-lecturer-' + lecturer_id);
            const hidden_input = document.getElementById('hidden-lecturer-' + lecturer_id);
            added_lecturer_div.remove();
            hidden_input.remove();

            update_lecturer_dropdown(lecturer_id, 'add', lecturer_email, lecturer_name, lecturer_image);
        }

        function update_lecturer_dropdown(lecturer_id, action, lecturer_email, lecturer_name, lecturer_image) {
            const lecturer_dropdown = document.getElementById('lecturer-dropdown');
            if (action === 'remove') {
                const lecturer_div = document.getElementById('lecturer-' + lecturer_id);
                lecturer_dropdown.removeChild(lecturer_div);
            } else if (action === 'add') {
                const index = all_lecturers.findIndex(lec => lec.id === lecturer_id);
                const lecturer_div = document.createElement('div');
                lecturer_div.setAttribute('id', 'lecturer-' + lecturer_id);
                lecturer_div.className = 'd-flex option ai-center';
                lecturer_div.innerHTML = `
                    <div class="d-flex w-100p ai-center cursor-default">
                        <div>
                            @if ($ul['image_path'])
                                <img src="${lecturer_image}" alt="" class="w-40 h-40 br-50p">
                            @else
                                <img src="{{asset('storage/system/avatar.png')}}" alt="" class="w-40 h-40 br-50p">
                            @endif
                        </div>
                        <div class="mg-l-10">
                            <div class="lecturer-name fw-bold fs3">${lecturer_name}</div>
                            <div class="fs4 clr-grey-2 fw-bold">${lecturer_email}</div>
                        </div>
                    </div>
                    <button type="button" class="button-primary d-flex-center w-30 h-30 f-shrink-0 mg-r-10" onclick="add_lecturer_click(${lecturer_id}, '${lecturer_email}', '${lecturer_name}', '${lecturer_image}')">
                        <span class="material-symbols-outlined">add</span></button>
                `;

                let inserted = false;
                for (let i = 0; i < lecturer_dropdown.children.length; i++) {
                    const dropdown_child = lecturer_dropdown.children[i];
                    const dropdown_lecturer_id = parseInt(dropdown_child.id.split('-')[1]);
                    const current_lecturer_index = all_lecturers.findIndex(lec => lec.id === dropdown_lecturer_id);
                    if (index < current_lecturer_index) {
                        lecturer_dropdown.insertBefore(lecturer_div, dropdown_child);
                        inserted = true;
                        break;
                    }
                }
                
                if (!inserted) {
                    lecturer_dropdown.appendChild(lecturer_div); // Append at the end if no position found
                }
            }
        }


        //  Edit Group Related Function (Lecturer)
        function edit_group_add_lecturer_click(lecturer_id, lecturer_email, lecturer_name, lecturer_image, group_id) {
            const added_lecturer = document.getElementById(`added-lecturer-group-${group_id}`);
            
            added_lecturer.innerHTML += `
            <div id="added-lecturer-${lecturer_id}-${group_id}" class="mg-t-10 ai-center" style="display:flex">
                <div class="d-flex w-100p ai-center cursor-default">
                    <div>
                        @if ($ul['image_path'])
                            <img src="storage/${lecturer_image}" alt="" class="w-40 h-40 br-50p">
                        @else
                            <img src="storage/system/avatar.png" alt="" class="w-40 h-40 br-50p">
                        @endif
                    </div>
                    <div class="mg-l-10">
                        <div class="lecturer-name fw-bold fs3">${lecturer_name}</div>
                        <div class="fs4 clr-grey-2 fw-bold">${lecturer_email}</div>
                    </div>
                </div>               
                <button type="button" class="d-flex-center w-30 h-30 f-shrink-0 bg-red bg-red-hv clr-white border-none br-5 f-shrink-0 cursor-pointer" onclick="edit_group_remove_lecturer_click(${lecturer_id}, '${lecturer_email}', '${lecturer_name}', '${lecturer_image}', ${group_id})">
                    <span class="material-symbols-outlined">remove</span></button>
            </div>`;
            added_lecturer.innerHTML += `<input type="hidden" id="hidden-lecturer-${lecturer_id}-${group_id}" value="${lecturer_id}" name="lecturer_ids[${lecturer_index}]">`;
            lecturer_index++;

            edit_group_update_lecturer_dropdown(lecturer_id, 'remove', lecturer_email, lecturer_name, lecturer_image, group_id);
        }

        function edit_group_remove_lecturer_click(lecturer_id, lecturer_email, lecturer_name, lecturer_image, group_id) {
            const added_lecturer_div = document.getElementById('added-lecturer-' + lecturer_id + '-' + group_id);
            const hidden_input = document.getElementById('hidden-lecturer-' + lecturer_id + '-' + group_id);
            added_lecturer_div.remove();
            hidden_input.remove();

            edit_group_update_lecturer_dropdown(lecturer_id, 'add', lecturer_email, lecturer_name, lecturer_image, group_id);
        }

        function edit_group_update_lecturer_dropdown(lecturer_id, action, lecturer_email, lecturer_name, lecturer_image, group_id) {
            const lecturer_dropdown = document.getElementById(`lecturer-dropdown-group-${group_id}`);
            if (action === 'remove') {
                const lecturer_div = document.getElementById(`lecturer-${lecturer_id}-${group_id}`);
                lecturer_dropdown.removeChild(lecturer_div);
            } else if (action === 'add') {
                const index = all_lecturers.findIndex(lec => lec.id === lecturer_id);
                const lecturer_div = document.createElement('div');
                lecturer_div.setAttribute('id', `lecturer-${lecturer_id}-${group_id}`);
                lecturer_div.className = 'd-flex option ai-center';
                lecturer_div.innerHTML = `
                    <div class="d-flex w-100p ai-center cursor-default">
                        <div>
                            @if ($ul['image_path'])
                                <img src="${lecturer_image}" alt="" class="w-40 h-40 br-50p">
                            @else
                                <img src="{{asset('storage/system/avatar.png')}}" alt="" class="w-40 h-40 br-50p">
                            @endif
                        </div>
                        <div class="mg-l-10">
                            <div class="lecturer-name fw-bold fs3">${lecturer_name}</div>
                            <div class="fs4 clr-grey-2 fw-bold">${lecturer_email}</div>
                        </div>
                    </div>
                    <button type="button" class="button-primary d-flex-center w-30 h-30 f-shrink-0 mg-r-10" onclick="edit_group_add_lecturer_click(${lecturer_id}, '${lecturer_email}', '${lecturer_name}', '${lecturer_image}', ${group_id})">
                        <span class="material-symbols-outlined">add</span></button>
                `;

                let inserted = false;
                for (let i = 0; i < lecturer_dropdown.children.length; i++) {
                    const dropdown_child = lecturer_dropdown.children[i];
                    const dropdown_lecturer_id = parseInt(dropdown_child.id.split('-')[1]);
                    const current_lecturer_index = all_lecturers.findIndex(lec => lec.id === dropdown_lecturer_id);
                    if (index < current_lecturer_index) {
                        lecturer_dropdown.insertBefore(lecturer_div, dropdown_child);
                        inserted = true;
                        break;
                    }
                }
                
                if (!inserted) {
                    lecturer_dropdown.appendChild(lecturer_div); // Append at the end if no position found
                }
            }
        }


        //  Edit Group Related Function (Student)
        function edit_group_add_student_click(student_id, student_email, student_name, student_image, group_id) {
            const added_student = document.getElementById(`added-student-group-${group_id}`);
            
            added_student.innerHTML += `
            <div id="added-student-${student_id}-${group_id}" class="mg-t-10 ai-center" style="display:flex">
                <div class="d-flex w-100p ai-center cursor-default">
                    <div>
                        @if ($ul['image_path'])
                            <img src="storage/${student_image}" alt="" class="w-40 h-40 br-50p">
                        @else
                            <img src="storage/system/avatar.png" alt="" class="w-40 h-40 br-50p">
                        @endif
                    </div>
                    <div class="mg-l-10">
                        <div class="student-name fw-bold fs3">${student_name}</div>
                        <div class="fs4 clr-grey-2 fw-bold">${student_email}</div>
                    </div>
                </div>               
                <button type="button" class="d-flex-center w-30 h-30 f-shrink-0 bg-red bg-red-hv clr-white border-none br-5 f-shrink-0 cursor-pointer" onclick="edit_group_remove_student_click(${student_id}, '${student_email}', '${student_name}', '${student_image}', ${group_id})">
                    <span class="material-symbols-outlined">remove</span></button>
            </div>`;
            added_student.innerHTML += `<input type="hidden" id="hidden-student-${student_id}-${group_id}" value="${student_id}" name="student_ids[${lecturer_index}]">`;
            lecturer_index++;

            edit_group_update_student_dropdown(student_id, 'remove', student_email, student_name, student_image, group_id);
        }

        function edit_group_remove_student_click(student_id, student_email, student_name, student_image, group_id) {
            const added_student_div = document.getElementById('added-student-' + student_id + '-' + group_id);
            const hidden_input = document.getElementById('hidden-student-' + student_id + '-' + group_id);
            added_student_div.remove();
            hidden_input.remove();

            edit_group_update_student_dropdown(student_id, 'add', student_email, student_name, student_image, group_id);
        }

        function edit_group_update_student_dropdown(student_id, action, student_email, student_name, student_image, group_id) {
            const student_dropdown = document.getElementById(`student-dropdown-group-${group_id}`);
            if (action === 'remove') {
                const student_div = document.getElementById(`student-${student_id}-${group_id}`);
                student_dropdown.removeChild(student_div);
            } else if (action === 'add') {
                const index = all_students.findIndex(lec => lec.id === student_id);
                const student_div = document.createElement('div');
                student_div.setAttribute('id', `student-${student_id}-${group_id}`);
                student_div.className = 'd-flex option ai-center';
                student_div.innerHTML = `
                    <div class="d-flex w-100p ai-center cursor-default">
                        <div>
                            @if ($ul['image_path'])
                                <img src="${student_image}" alt="" class="w-40 h-40 br-50p">
                            @else
                                <img src="{{asset('storage/system/avatar.png')}}" alt="" class="w-40 h-40 br-50p">
                            @endif
                        </div>
                        <div class="mg-l-10">
                            <div class="student-name fw-bold fs3">${student_name}</div>
                            <div class="fs4 clr-grey-2 fw-bold">${student_email}</div>
                        </div>
                    </div>
                    <button type="button" class="button-primary d-flex-center w-30 h-30 f-shrink-0 mg-r-10" onclick="edit_group_add_student_click(${student_id}, '${student_email}', '${student_name}', '${student_image}', ${group_id})">
                        <span class="material-symbols-outlined">add</span></button>
                `;

                let inserted = false;
                for (let i = 0; i < student_dropdown.children.length; i++) {
                    const dropdown_child = student_dropdown.children[i];
                    const dropdown_student_id = parseInt(dropdown_child.id.split('-')[1]);
                    const current_student_index = all_students.findIndex(lec => lec.id === dropdown_student_id);
                    if (index < current_student_index) {
                        student_dropdown.insertBefore(student_div, dropdown_child);
                        inserted = true;
                        break;
                    }
                }
                
                if (!inserted) {
                    student_dropdown.appendChild(student_div); // Append at the end if no position found
                }
            }
        }


        // Recreate Group Related Funtion (Lecturer)
        function recreate_group_add_lecturer_click(lecturer_id, lecturer_email, lecturer_name, lecturer_image, group_id) {
            const added_lecturer = document.getElementById(`added-lecturer-recreate-group-${group_id}`);
            
            added_lecturer.innerHTML += `
            <div id="added-lecturer-${lecturer_id}-recreate-${group_id}" class="mg-t-10 ai-center" style="display:flex">
                <div class="d-flex w-100p ai-center cursor-default">
                    <div>
                        @if ($ul['image_path'])
                            <img src="storage/${lecturer_image}" alt="" class="w-40 h-40 br-50p">
                        @else
                            <img src="storage/system/avatar.png" alt="" class="w-40 h-40 br-50p">
                        @endif
                    </div>
                    <div class="mg-l-10">
                        <div class="lecturer-name fw-bold fs3">${lecturer_name}</div>
                        <div class="fs4 clr-grey-2 fw-bold">${lecturer_email}</div>
                    </div>
                </div>               
                <button type="button" class="d-flex-center w-30 h-30 f-shrink-0 bg-red bg-red-hv clr-white border-none br-5 f-shrink-0 cursor-pointer" onclick="recreate_group_remove_lecturer_click(${lecturer_id}, '${lecturer_email}', '${lecturer_name}', '${lecturer_image}', ${group_id})">
                    <span class="material-symbols-outlined">remove</span></button>
            </div>`;
            added_lecturer.innerHTML += `<input type="hidden" id="hidden-lecturer-${lecturer_id}-recreate-${group_id}" value="${lecturer_id}" name="lecturer_ids[${lecturer_index}]">`;
            lecturer_index++;

            recreate_group_update_lecturer_dropdown(lecturer_id, 'remove', lecturer_email, lecturer_name, lecturer_image, group_id);
        }

        function recreate_group_remove_lecturer_click(lecturer_id, lecturer_email, lecturer_name, lecturer_image, group_id) {
            const added_lecturer_div = document.getElementById('added-lecturer-' + lecturer_id + '-recreate-' + group_id);
            const hidden_input = document.getElementById('hidden-lecturer-' + lecturer_id + '-recreate-' + group_id);
            added_lecturer_div.remove();
            hidden_input.remove();

            recreate_group_update_lecturer_dropdown(lecturer_id, 'add', lecturer_email, lecturer_name, lecturer_image, group_id);
        }

        function recreate_group_update_lecturer_dropdown(lecturer_id, action, lecturer_email, lecturer_name, lecturer_image, group_id) {
            const lecturer_dropdown = document.getElementById(`lecturer-dropdown-recreate-group-${group_id}`);
            if (action === 'remove') {
                const lecturer_div = document.getElementById(`lecturer-${lecturer_id}-recreate-${group_id}`);
                lecturer_dropdown.removeChild(lecturer_div);
            } else if (action === 'add') {
                const index = all_lecturers.findIndex(lec => lec.id === lecturer_id);
                const lecturer_div = document.createElement('div');
                lecturer_div.setAttribute('id', `lecturer-${lecturer_id}-recreate-${group_id}`);
                lecturer_div.className = 'd-flex option ai-center';
                lecturer_div.innerHTML = `
                    <div class="d-flex w-100p ai-center cursor-default">
                        <div>
                            @if ($ul['image_path'])
                                <img src="${lecturer_image}" alt="" class="w-40 h-40 br-50p">
                            @else
                                <img src="{{asset('storage/system/avatar.png')}}" alt="" class="w-40 h-40 br-50p">
                            @endif
                        </div>
                        <div class="mg-l-10">
                            <div class="lecturer-name fw-bold fs3">${lecturer_name}</div>
                            <div class="fs4 clr-grey-2 fw-bold">${lecturer_email}</div>
                        </div>
                    </div>
                    <button type="button" class="button-primary d-flex-center w-30 h-30 f-shrink-0 mg-r-10" onclick="recreate_group_add_lecturer_click(${lecturer_id}, '${lecturer_email}', '${lecturer_name}', '${lecturer_image}', ${group_id})">
                        <span class="material-symbols-outlined">add</span></button>
                `;

                let inserted = false;
                for (let i = 0; i < lecturer_dropdown.children.length; i++) {
                    const dropdown_child = lecturer_dropdown.children[i];
                    const dropdown_lecturer_id = parseInt(dropdown_child.id.split('-')[1]);
                    const current_lecturer_index = all_lecturers.findIndex(lec => lec.id === dropdown_lecturer_id);
                    if (index < current_lecturer_index) {
                        lecturer_dropdown.insertBefore(lecturer_div, dropdown_child);
                        inserted = true;
                        break;
                    }
                }
                
                if (!inserted) {
                    lecturer_dropdown.appendChild(lecturer_div); // Append at the end if no position found
                }
            }
        }

        @foreach ($groups as $group)
            @php $group_users = App\Models\GroupUser::where('group_id', $group->id)->get(); @endphp
            @foreach ($group_users as $group_user)
                @php $user = $group_user->user; @endphp
                @if ($user->type != 'Lecturer') 
                    @php break; @endphp
                @else
                    edit_group_add_lecturer_click(`{{$user->id}}`, `{{$user->email}}`, `{{$user->full_name}}`, `{{$user->image_path}}`, `{{$group->id}}`);
                    recreate_group_add_lecturer_click(`{{$user->id}}`, `{{$user->email}}`, `{{$user->full_name}}`, `{{$user->image_path}}`, `{{$group->id}}`);
                @endif
            @endforeach
        @endforeach

        function add_search_group(input_id, dropdown_id){
            document.getElementById(input_id).addEventListener('input', function() {
                const input = this.value.toLowerCase();
                const options = document.querySelectorAll('#' + dropdown_id + ' .option');
                options.forEach(function(option) {
                    if (option.querySelector('.lecturer-name').textContent.toLowerCase().includes(input)) {
                        option.style.display = '';
                    } else {
                        option.style.display = 'none';
                    }
                });
            });
        }

        // Register dropdown related event from main.css
        add_dropdown_event('lecturer-dropdown-button', 'lecturer-dropdown');
        add_search_group('lecturer-search', 'lecturer-dropdown');
        add_dropdown_event('group-option-dropdown-button', 'group-option-dropdown');
        @foreach($groups as $group)
            add_dropdown_event('lecturer-dropdown-button-group-{{$group->id}}', 'lecturer-dropdown-group-{{$group->id}}');
            add_search_group('lecturer-search-group-{{$group->id}}', 'lecturer-dropdown-group-{{$group->id}}');
            add_dropdown_event('lecturer-dropdown-button-recreate-group-{{$group->id}}', 'lecturer-dropdown-recreate-group-{{$group->id}}');
            add_search_group('lecturer-search-recreate-group-{{$group->id}}', 'lecturer-dropdown-recreate-group-{{$group->id}}');
            add_dropdown_event('student-dropdown-button-group-{{$group->id}}', 'student-dropdown-group-{{$group->id}}');
            add_search_group('student-search-group-{{$group->id}}', 'student-dropdown-group-{{$group->id}}');
        @endforeach

        function group_click(group_id, group_name) {
            document.getElementById(`group-${group_id}`).style.display = 'flex';
            document.getElementById('main').style.display = 'none';
            document.getElementById('nav-button').style.display = 'none';
            document.getElementById('group-nav-button').style.display = 'flex';
            
            document.getElementById('group-name-header').textContent = group_name;
            group_id_opened = group_id;

            document.getElementById('add-student-group-button').onclick = function () { open_popup_click(`add-student-group-${group_id}-popup`) }
            document.getElementById('edit-group-button').onclick = function () { 
                open_popup_click(`edit-group-${group_id}-popup`);
                document.getElementById('group-option-dropdown-button').classList.remove('active');
                document.getElementById('group-option-dropdown').classList.remove('active');
            }
            document.getElementById('delete-group-button').onclick = function () {
                if (confirm('Are you sure you want to delete this group?')) {
                    document.getElementById(`delete-group-${group_id}-form`).submit();
                }
            }
            document.getElementById('recreate-group-button').onclick = function () { 
                open_popup_click(`recreate-group-${group_id}-popup`);
                document.getElementById('group-option-dropdown-button').classList.remove('active');
                document.getElementById('group-option-dropdown').classList.remove('active');
            }
        }

        function back_click() {
            document.getElementById(`group-${group_id_opened}`).style.display = 'none';
            document.getElementById('main').style.display = 'block';
            document.getElementById('nav-button').style.display = 'flex';
            document.getElementById('group-nav-button').style.display = 'none';

        }

        function group_header_click(tab_number, group_id){
            document.getElementById(`group-${group_id}-header-1`).classList.remove('active');
            document.getElementById(`group-${group_id}-header-2`).classList.remove('active');
            document.getElementById(`group-${group_id}-header-3`).classList.remove('active');
            document.getElementById(`group-${group_id}-header-${tab_number}`).classList.add('active');

            document.getElementById(`group-${group_id}-tab-1`).classList.remove('active');
            document.getElementById(`group-${group_id}-tab-2`).classList.remove('active');
            document.getElementById(`group-${group_id}-tab-3`).classList.remove('active');
            document.getElementById(`group-${group_id}-tab-${tab_number}`).classList.add('active');
        }

        // to remove session on the last session page
        localStorage.removeItem('classroom-management-session');
    </script>
@endpush