<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
    <h1>Update Group by Id</h1>
    {{-- to display error if wrong user --}}
    @if (session('success'))
    <div class="alert alert-danger" role="alert">
        {{ session('success') }}
    </div>
    @endif

    @php
    $group_id = 8;
    $group_users = App\Models\GroupUser::where('group_id', $group_id)->get();
    $group = App\Models\Groups::findOrFail($group_id);
    @endphp
    
    <form action="{{route('group.add-students-group-by-id', ['id'=> $group_id])}}" method="POST">
        @csrf
        @method('PATCH')
        
        <div>student Name*</div>
        <div id="student-name-dropdown-button">---</div>
        <div style="width:150px; height:80px; overflow:auto" id="student-name-dropdown">
            @php $user_student = App\Models\User::where('type', 'Student')->get(); @endphp
            @foreach ($user_student as $ul)
            <div style="display:flex" id="student-{{$ul->id}}">
                <div>{{$ul->full_name}}</div>
                <button type="button" onclick="add_student_click({{$ul}})">Add</button>
            </div>
            @endforeach
        </div>

        <div style="height:20px"></div>

        <div>Added Student(s)</div>
        <div id="added-student"></div>

        <div style="height:20px"></div>

        <div>Group Name*</div>
        <input type="text" name="name" value="{{$group->name}}">

        <div>Description</div>
        <textarea name="description" rows="4">{{$group->description}}</textarea>

        <button type="submit">Save</button>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
            
    </form>

    <script>

        let student_index = 0;
        const all_students = @json($user_student);

        @php
            foreach($group_users as $gu) {
                $user = App\Models\User::findOrFail($gu->user_id);
                if ($user->type == 'Student') {
                    echo("add_student_click({$user});");
                }
            }
        @endphp

        function add_student_click(user_student) {
            const added_student = document.getElementById('added-student');
            
            added_student.innerHTML += `
            <div id="added-student-${user_student.id}" style="display:flex">
                <div>${user_student.full_name}</div>
                <button type="button" onclick="remove_student_click(${user_student.id}, '${user_student.full_name}')">Remove</button>
            </div>`;
            added_student.innerHTML += `<input type="hidden" id="hidden-student-${user_student.id}" value="${user_student.id}" name="student_ids[${student_index}]">`;
            student_index++;

            update_student_dropdown(user_student.id, 'remove');
        }

        function remove_student_click(student_id, student_name) {
            const added_student_div = document.getElementById('added-student-' + student_id);
            const hidden_input = document.getElementById('hidden-student-' + student_id);
            added_student_div.remove();
            hidden_input.remove();

            update_student_dropdown(student_id, 'add', student_name);
        }

        function update_student_dropdown(student_id, action, student_name = '') {
            const student_dropdown = document.getElementById('student-name-dropdown');
            if (action === 'remove') {
                const student_div = document.getElementById('student-' + student_id);
                student_dropdown.removeChild(student_div);
            } else if (action === 'add') {
                const index = all_students.findIndex(student => student.id === student_id);
                const student_div = document.createElement('div');
                student_div.setAttribute('id', 'student-' + student_id);
                student_div.setAttribute('style', 'display:flex');
                student_div.innerHTML = `
                    <div>${student_name}</div>
                    <button type="button" onclick="add_student_click({id: ${student_id}, full_name: '${student_name}'})">Add</button>
                `;

                let inserted = false;
                for (let i = 0; i < student_dropdown.children.length; i++) {
                    const dropdown_child = student_dropdown.children[i];
                    const dropdown_student_id = parseInt(dropdown_child.id.split('-')[1]);
                    const current_student_index = all_students.findIndex(student => student.id === dropdown_student_id);
                    if (index < current_student_index) {
                        student_dropdown.insertBefore(student_div, dropdown_child);
                        inserted = true;
                        break;
                    }
                }
                
                if (!inserted) {
                    student_dropdown.appendChild(student_div); // Append at the end if no position found
                }
            }
        }

    </script>
</body>
</html>