<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
    <h1>Create Group</h1>
    {{-- to display error if wrong user --}}
    @if (session('success'))
    <div class="alert alert-danger" role="alert">
        {{ session('success') }}
    </div>
    @endif
    
    <form action="{{route('group.create-group')}}" method="POST">
        @csrf
        @method('POST')
        
        <div>Lecturer Name*</div>
        <div id="lecturer-name-dropdown-button">---</div>
        <div style="width:150px; height:80px; overflow:auto" id="lecturer-name-dropdown">
            @php $user_lecturer = App\Models\User::where('type', 'Lecturer')->get(); @endphp
            @foreach ($user_lecturer as $ul)
            <div style="display:flex" id="lecturer-{{$ul->id}}">
                <div>{{$ul->full_name}}</div>
                <button type="button" onclick="add_lecturer_click({{$ul}})">Add</button>
            </div>
            @endforeach
        </div>

        <div style="height:20px"></div>

        <div>Added Lecturer(s)</div>
        <div id="added-lecturer"></div>

        <div style="height:20px"></div>

        <div>Group Name*</div>
        <input type="text" name="name">

        <div>Description</div>
        <textarea name="description" rows="4"></textarea>

        <button type="submit">Create</button>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
            
    </form>

    <script>

        let lecturer_index = 0;
        const all_lecturers = @json($user_lecturer);

        function add_lecturer_click(user_lecturer) {
            const added_lecturer = document.getElementById('added-lecturer');
            
            added_lecturer.innerHTML += `
            <div id="added-lecturer-${user_lecturer.id}" style="display:flex">
                <div>${user_lecturer.full_name}</div>
                <button type="button" onclick="remove_lecturer_click(${user_lecturer.id}, '${user_lecturer.full_name}')">Remove</button>
            </div>`;
            added_lecturer.innerHTML += `<input type="hidden" id="hidden-lecturer-${user_lecturer.id}" value="${user_lecturer.id}" name="lecturer_ids[${lecturer_index}]">`;
            lecturer_index++;

            update_lecturer_dropdown(user_lecturer.id, 'remove');
        }

        function remove_lecturer_click(lecturer_id, lecturer_name) {
            const added_lecturer_div = document.getElementById('added-lecturer-' + lecturer_id);
            const hidden_input = document.getElementById('hidden-lecturer-' + lecturer_id);
            added_lecturer_div.remove();
            hidden_input.remove();

            update_lecturer_dropdown(lecturer_id, 'add', lecturer_name);
        }

        function update_lecturer_dropdown(lecturer_id, action, lecturer_name = '') {
            const lecturer_dropdown = document.getElementById('lecturer-name-dropdown');
            if (action === 'remove') {
                const lecturer_div = document.getElementById('lecturer-' + lecturer_id);
                lecturer_dropdown.removeChild(lecturer_div);
            } else if (action === 'add') {
                const index = all_lecturers.findIndex(lecturer => lecturer.id === lecturer_id);
                const lecturer_div = document.createElement('div');
                lecturer_div.setAttribute('id', 'lecturer-' + lecturer_id);
                lecturer_div.setAttribute('style', 'display:flex');
                lecturer_div.innerHTML = `
                    <div>${lecturer_name}</div>
                    <button type="button" onclick="add_lecturer_click({id: ${lecturer_id}, full_name: '${lecturer_name}'})">Add</button>
                `;

                let inserted = false;
                for (let i = 0; i < lecturer_dropdown.children.length; i++) {
                    const dropdown_child = lecturer_dropdown.children[i];
                    const dropdown_lecturer_id = parseInt(dropdown_child.id.split('-')[1]);
                    const current_lecturer_index = all_lecturers.findIndex(lecturer => lecturer.id === dropdown_lecturer_id);
                    if (index < current_lecturer_index) {
                        lecturer_dropdown.insertBefore(lecturer_div, dropdown_child);
                        inserted = true;
                        break;
                    }
                }
                
                if (!inserted) {
                    lecturer_dropdown.appendChild(lecturer_div); // Append at the end if no position found
                }
            }
        }

    </script>
</body>
</html>