@extends('layouts.app')

@push('style')
    <style>
        
    </style>
@endpush

@section('profile-button', 'active')

@section('header')
<div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs1 fw-bold cursor-default">Profile</div>
@endsection

@section('main-body')
<div class="w-100p h-500 pd-t-20 d-flex" style="position:fixed;">
    @php
        $user = Auth::user();
    @endphp
    <div class="w-300 d-flex jc-center">
        <div class="h-100p w-100p d-flex-center ai-start">
            <div class="w-150 h-150" style="position: relative;">
                @if (Auth::user()->image_path)
                    <img src="{{asset('storage' . Auth::user()->image_path)}}" alt="" class="w-150 h-150 br-50p" style="object-fit:cover;border:none;">
                @else
                    <img src="{{asset('storage/system/avatar.png')}}" alt="" class="w-150 h-150 br-50p" style="object-fit:cover;border:none;">
                @endif
                <div class="cursor-pointer" style="position:absolute; bottom:0px; right:15px;" onclick="open_popup_click('change-img-profile-popup')"><span class="material-symbols-outlined fs-25 w-35 h-35 clr-white bg-gold-1-hv fw-bold bg-plt2 br-50p d-flex-center">photo_camera</span></div>
            </div>
        </div>
    </div>

    <div class="w-450 d-flex jc-center">
        <div class="w-400 h-100p">
            <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                <div class="w-150 h-100p clr-grey-2">User-ID</div>
                <div class="">{{$user->staff_id ? $user->staff_id : '-'}}</div>
            </div>
            <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                <div class="w-150 h-100p clr-grey-2 ">Name</div>
                <div class="">{{$user->full_name ? $user->full_name : '-'}}</div>
            </div>
            <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                <div class="w-150 h-100p clr-grey-2 ">Email</div>
                <div class="">{{$user->email ? $user->email : '-'}}</div>
            </div>
            @if ($user->type == 'Student' || $user->type == 'Student Lead')
                <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                    <div class="w-150 h-100p clr-grey-2 ">Intake Year</div>
                    <div class="">{{$user->intake_year ? $user->intake_year : '-'}}</div>
                </div>
            @endif
            <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                <div class="w-150 h-100p clr-grey-2 ">Phone Number</div>
                <div class="">{{$user->phone_no ? $user->phone_no : '-'}}</div>
            </div>
            <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                <div class="w-150 h-100p clr-grey-2 ">Gender</div>
                <div class="">{{$user->gender == 1 ? 'Male' : 'Female'}}</div>
            </div>
            <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                <div class="w-150 h-100p clr-grey-2 ">Address</div>
                <div class="">{{$user->address ? $user->address : '-'}}</div>
            </div>
            <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                <div class="w-150 h-100p clr-grey-2 ">NRIC</div>
                <div class="">{{$user->nric ? $user->nric : '-'}}</div>
            </div>
            <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                <div class="w-150 h-100p clr-grey-2 ">Type</div>
                <div class="">{{$user->type ? $user->type : '-'}}</div>
            </div>
            <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                <div class="w-150 h-100p clr-grey-2 ">Last Login</div>
                <div class="">{{Carbon\Carbon::parse($user->last_login, 'Asia/Kuala_Lumpur')->format('d F Y h:i A')}}</div>
            </div>
            <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                <div class="w-150 h-100p clr-grey-2 ">Language</div>
                <div class="">{{$user->language ? $user->language : '-'}}</div>
            </div>
            <!-- <button class="button-primary cursor-pointer" onclick="assignFR()">Assigned</button>
            <button class="button-primary cursor-pointer" onclick="unassignFR()">Unassigned</button> 
            <button class="button-primary cursor-pointer" onclick="add_person_to_hcp()">Add Person to HCP</button>  -->

        </div>
    </div>

    <div class="w-300">
        <div class="w-180 h-100p mg-b-10  ">
            <div class="h-60 fw-bold">
                <div class="cursor-pointer fs3 clr-blue txt-u-hv clr-blue-hv" onclick="open_popup_click('edit-detail-profile-popup')">Edit Details</div>
                <div class="cursor-default fs4 clr-grey-2">You are only allow to update your phone number and address.</div>
            </div>
            <div class="h-60 fw-bold">
                <div class="cursor-pointer fs3 clr-blue txt-u-hv clr-blue-hv" onclick="open_popup_click('edit-password-profile-popup')">Edit Password</div>
                <div class="cursor-default fs4 clr-grey-2">We highly recommand you to update your password frequently and ensure nobody know about your password.</div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('body-box')
    <div id="edit-detail-profile-popup" class="right-popup bg-white w-600 h-100p">
        <form  action="{{route('user.update-user')}}" method="POST" class="h-100p w-100p">
            @csrf
            @method('PATCH')

            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Edit Details</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-30">Phone Number</div>
                    <input type="text" name="phone_no" value="{{Auth::user()->phone_no}}" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Address</div>
                    <input type="text" name="address" value="{{Auth::user()->address}}" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                </div>
            </div>
        
            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Save Changes</button>
                    <button type="button" onclick="close_popup_click('edit-detail-profile-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>

    {{-- for change image room --}}
    <div id="change-img-profile-popup" class="right-popup bg-white w-600 h-100p">
        <form action="{{route('user.update-user-image-by-id', ['id' => Auth::user()->id])}}" method="POST" enctype="multipart/form-data" class="h-100p w-100p">
        @csrf
        @method('PATCH')
        
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb cursor-default">
                    <div class="fs-18 clr-grey-2 fw-bold">Upload Profile Image</div>

                    <input type="file" id="profile-image-input" name="image_path" accept="image/*" class="w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 d-none" style="cursor:text;">
                    <div id="profile-drop-image" class="cursor-pointer w-170 h-200 mg-10 mg-tb-20" style="border: 3px dashed #bec3d0;" onclick="document.getElementById('profile-image-input').click()"> 
                        <div class="d-flex-center fd-column w-100p h-100p bg-grey-2-hv clr-grey-2 clr-black-2-hv">
                            <span class="material-symbols-outlined fs-100">upload_file</span>
                            <div class="fs3">Click to select image</div>
                        </div>
                    </div>
                    <div id="profile-image-preview" class="w-170 h-200 mg-t-10 d-none">
                        <div class="w-100p h-100p d-flex-center of-hidden">
                            <img id="profile-image" class="h-100p" style="object-fit:cover; border:none;" src="" alt="">
                        </div>
                    </div>
                    <div class="d-flex-center w-170">
                        <input type="hidden" class="remove_profile_image" name="remove_profile_image" id="remove-profile-image" value="0">
                        <div id="profile-file-delete" class="button-primary w-100 mg-tb-10 d-none txt-c fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none; background-color:#bc3333;" onmouseover="this.style.backgroundColor = '#bc3333aa';" onmouseout="this.style.backgroundColor = '#bc3333';" onclick="removeImage()">Remove</div>
                    </div>
                    
                    <div class="w-200 mg-tb-20">
                        <div class="d-flex fs3 clr-grey-2 fw-bold">You only allow to upload maximum 2MB file size. Subsequence uploaded image will overwrite previous image.</div>
                    </div>           

                    <div class="h-150"></div>
                    
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Save Changes</button>
                    <button type="button" onclick="close_popup_click('change-img-profile-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>


    <div id="edit-password-profile-popup" class="right-popup bg-white w-600 h-100p">
        <form action="{{route('user.update-password')}}" method="POST">
            @csrf
            @method('PATCH')

            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Edit Password</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-30">Current Password <span style="color:red;">*</span></div>
                    <input type="password" name="current_password" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                    
                    <div class="fs-13 clr-black-1 fw-bold mg-t-30">New Password <span style="color:red;">*</span></div>
                    <input type="password" name="new_password" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                    
                    <div class="fs-13 clr-black-1 fw-bold mg-t-30">Confirm Password <span style="color:red;">*</span></div>
                    <input type="password" name="new_password_confirmation" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                </div>
            </div>
        
            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Save Changes</button>
                    <button type="button" onclick="close_popup_click('edit-password-profile-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>
@endsection

@push('script')
    <script>
        // document.getElementById('profile-image-input').addEventListener('change', (e) => {
        //     const file = e.target.files[0];

        //     let files = e.target.files;
        //     if (files.length > 0) {
        //         preview_image(files[0], document.getElementById('profile-image'));
        //         document.getElementById('profile-image-preview').style.display = 'flex';
        //         document.getElementById('profile-drop-image').style.display = 'none';
        //         document.getElementById('profile-file-delete').style.display = 'block';
        //         document.getElementById('remove-profile-image').value = '0';
        //     }
        // })
        document.addEventListener('DOMContentLoaded', () => {
            const imagePath = "{{ $user->image_path ?? '' }}";
            const imagePreview = document.getElementById('profile-image-preview');
            const dropImageContainer = document.getElementById('profile-drop-image');
            const deleteImageContainer = document.getElementById('profile-file-delete');
            const profileImage = document.getElementById('profile-image');

            // Display the existing image if imagePath is set
            if (imagePath) {
                profileImage.src = imagePath;
                imagePreview.style.display = 'flex';
                dropImageContainer.style.display = 'none';
                deleteImageContainer.style.display = 'block';
            }

            document.getElementById('profile-image-input').addEventListener('change', (e) => {
                const file = e.target.files[0];
                if (file) {
                    preview_image(file, profileImage);
                    imagePreview.style.display = 'flex';
                    dropImageContainer.style.display = 'none';
                    deleteImageContainer.style.display = 'block';
                    document.getElementById('remove-profile-image').value = '0';
                }
            });
        });

        function preview_image(file, img_box) {
            let reader = new FileReader();
            reader.onload = function(e) {
                img_box.src = e.target.result;
            }
            reader.readAsDataURL(file);
        }

        function removeImage(){
            imageInput = document.getElementById('profile-image-input');
            imagePreviewContainer = document.getElementById('profile-image-preview');
            imageElement = document.getElementById('profile-image');
            dropImageContainer = document.getElementById('profile-drop-image');
            deleteImageContainer = document.getElementById('profile-file-delete');
            removeProfileImg = document.getElementById('remove-profile-image');

            // Clear the file input value
            imageInput.value = '';

            // Reset the image source and hide the preview container
            imageElement.src = '';
            imagePreviewContainer.style.display = 'none';

            // Show the initial "Click to select image" container
            dropImageContainer.style.display = 'block';
            deleteImageContainer.style.display = 'none';

            removeProfileImg.value = '1';
        }


        function assignFR(){
            Promise.all([fetch_data(api='/artemis/api/acs/v1/privilege/group/single/addPersons', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({})),])
            .then(([data]) => {
                console.log(data);
            });
        }
        function unassignFR(){
            Promise.all([fetch_data(api='/artemis/api/acs/v1/privilege/group/single/deletePersons', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({})),])
            .then(([data]) => {
                console.log(data);
            });
        }

        function add_person_to_hcp() {
            Promise.all([fetch_data(api=`{{route('hcp.add_person')}}`, method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, 
                            body=JSON.stringify({
                                'personCode': 'ST01',
                                'personGivenName': 'Dando',
                                'personFamilyName': 'Santos',
                                'gender': '1',
                                'orgIndexCode': '1',
                                'phoneNo': '01131950817',
                                'email': 'dandosantos@gmail.com',
                                'remark': 'Helloo'
                            }))
                        ])
            .then(([data]) => {
                console.log(data);
            });
        }

        // function assignFR() {
        //     const personListPromise = fetch_data(api='/get-person-list', method='POST', headers={
        //         'Content-Type': 'application/json',
        //         'X-CSRF-TOKEN': csrfToken,
        //     }, body=JSON.stringify({}));

        //     const addPersonsPromise = fetch_data(api='/artemis/api/acs/v1/privilege/group/single/addPersons', method='POST', headers={
        //         'Content-Type': 'application/json',
        //         'X-CSRF-TOKEN': csrfToken,
        //     }, body=JSON.stringify({'privilegeGroupId': '1'}));

        //     Promise.all([personListPromise, addPersonsPromise])
        //         .then(([personListData, addPersonsData]) => {
        //             console.log('Person List Data:', personListData);
        //             console.log('Add Persons Data:', addPersonsData);
        //         })
        //         .catch(error => {
        //             console.error('Error occurred:', error);
        //         });
        // }
                
        // to remove session on the last session page
        localStorage.removeItem('classroom-management-session');
    </script>
@endpush