@extends('layouts.app')

@push('style')
    <style>
        .report-button {
            box-shadow: 0px 0px 10px 0px #00000022;
            transition: box-shadow 0.3s;
        }

        .report-button:hover {
            box-shadow: 0px 0px 15px 10px #00000022;
        }

        .hidden {
            display: none;
        }
        .d-none {
            display: none;
        }
    </style>
@endpush

@section('reports-button', 'active')

@section('header')
    <div class="d-flex h-100p" id="nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs1 fw-bold cursor-default">Reports</div>
    </div>
@endsection

@section('main-body')
    @php
        $rooms = App\Models\Rooms::all();
        $groups = App\Models\Groups::all();
    @endphp

    <div class="d-flex pd-30 fw-wrap">
        <div onclick="open_popup_click('attendance-popup')" style="background-color:#00000009" class="report-button d-flex w-350 h-130 mg-10 br-5 of-hidden cursor-pointer f-shrink-0">
            <div class="h-100p w-150 of-hidden d-flex-center" style="flex-shrink:0;">
                <img class="w-100p h-100p" style="object-fit: cover;" src="{{asset('storage/system/bg-report.jpg')}}" alt="">
            </div>
            <div class="h-100p w-160 pd-20">
                <div class="fs-16 fw-bold clr-blue">Attendance<br>(Under Maintenance)</div>
                <div class="fs-12 clr-grey-2">Class attendance for student group</div>
            </div>
        </div>
        <div onclick="open_popup_click('report-booking-popup')" style="background-color:#00000009" class="report-button d-flex w-350 h-130 mg-10 br-5 of-hidden cursor-pointer f-shrink-0">
            <div class="h-100p w-150" style="flex-shrink:0;">
                <img class="w-100p h-100p" style="object-fit: cover;" src="{{asset('storage/system/bg-statistics.jpg')}}" alt="">
            </div>
            <div class="h-100p w-160 pd-20">
                <div class="fs-16 fw-bold clr-blue">Booking</div>
                <div class="fs-12 clr-grey-2">Class booking statistics for lecturer</div>
            </div>
        </div>
        <div onclick="open_popup_click('usage-popup')" style="background-color:#00000009" class="report-button d-flex w-350 h-130 mg-10 br-5 of-hidden cursor-pointer f-shrink-0">
            <div class="h-100p w-150" style="flex-shrink:0;">
                <img class="w-100p h-100p" style="object-fit: cover;" src="{{asset('storage/system/bg-outstation.jpg')}}" alt="">
            </div>
            <div class="h-100p w-160 pd-20">
                <div class="fs-16 fw-bold clr-blue">Usage</div>
                <div class="fs-12 clr-grey-2">Room usage statistics</div>
            </div>
        </div>
    </div>
        
    <div class="clr-grey-1 fw-bold fs-18 mg-b-20">Preview</div>
    <div class="">

    </div>
    <div id="pdfPreviewSection" class="d-none w-100p h-100p">
        <iframe id="preview-pdf" class="w-100p h-100p"></iframe>
    </div>

    <div id="excelPreviewAttendanceSection" class="d-none w-100p h-100p pd-20 bs-bb of-auto" style="border: 1px solid #000;">
        <button class="button-primary mg-b-20" onclick="downloadExcel('attendance')">Download Excel</button>
        <div class="" style="height: calc(100% - 50px)">
            <div id="excelPreviewTableAttendance" class="us-none"></div>
        </div>
    </div>

    <div id="excelPreviewBookingSection" class="d-none w-100p h-100p pd-20 bs-bb of-auto" style="border: 1px solid #000;">
        <button class="button-primary mg-b-20" onclick="downloadExcel('booking')">Download Excel</button>
        <div class="" style="height: calc(100% - 50px)">
            <div id="excelPreviewTableBooking" class="us-none"></div>
        </div>
    </div>

    <div id="excelPreviewUsageSection" class="d-none w-100p h-100p pd-20 bs-bb of-auto" style="border: 1px solid #000;">
        <button class="button-primary mg-b-20" onclick="downloadExcel('usage')">Download Excel</button>
        <div class="" style="height: calc(100% - 50px)">
            <div id="excelPreviewTableUsage" class="us-none"></div>
        </div>
    </div>
    
    <img id="logo" src="{{asset('storage/system/logo-uthm.png')}}" class="d-none" alt="">

@endsection

@section('body-box')
    <div id="attendance-popup" class="right-popup bg-white w-600 h-100p">
        <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
            <div class="h-100p pd-30 bs-bb cursor-default" style="position: relative">
                <div class="fs-18 clr-grey-2 fw-bold">Attendance Report</div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Student Group <span style="color:red;">*</span></div>
                <input id="report-attendance-group-dropdown-input" value="{{$groups->first()->id}}" type="hidden" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                <div id="report-attendance-group-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">{{$groups->first()->name}}</div>
                <div id="report-attendance-group-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                    <div class="d-flex">
                        <input type="text" id="report-attendance-group-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                        <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                    </div>
                    @foreach ($groups as $group)
                        <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'report-attendance-group-dropdown-button', 'report-attendance-group-dropdown-input', {{$group->id}}, 'report-attendance-group-dropdown')" style="border:none;">{{$group->name}}</div>
                    @endforeach
                </div>
                
                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Date <span style="color:red;">*</span></div>
                <input type="date" id="report-attendance-start-date" value="{{ now()->subMonth()->format('Y-m-d') }}" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">End Date <span style="color:red;">*</span></div>
                <input type="date" id="report-attendance-end-date" value="{{ now()->format('Y-m-d') }}" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                <div class="h-150"></div>
            </div>
        </div>

        <div class="submit-section h-80 w-100p">
            <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                <button type="submit" id="download-attendance-button" onclick="showPreview('pdf');" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Preview PDF</button>
                <button type="submit" id="download-attendance-excel-button" onclick="showPreview('attendance');" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Preview Excel</button>
                <button type="button" onclick="close_popup_click('attendance-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
            </div>
        </div>
    </div>

    <div id="report-booking-popup" class="right-popup bg-white w-600 h-100p">
        <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
            <div class="h-100p pd-30 bs-bb cursor-default">
                <div class="fs-18 clr-grey-2 fw-bold">Class Booking Report</div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Room <span style="color:red;">*</span></div>
                <input id="report-booking-room-dropdown-input" value="{{$rooms->first()->id}}" type="hidden" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">
                <div id="report-booking-room-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">{{$rooms->first()->name}}</div>
                <div id="report-booking-room-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                    <div class="d-flex">
                        <input type="text" id="report-booking-room-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                        <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                    </div>
                    @foreach ($rooms as $room)
                        <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'report-booking-room-dropdown-button', 'report-booking-room-dropdown-input', {{$room->id}}, 'report-booking-room-dropdown')" style="border:none;">{{$room->name}}</div>
                    @endforeach
                </div>
                
                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Date <span style="color:red;">*</span></div>
                <input type="date" id="report-booking-start-date" value="{{ now()->subMonth()->format('Y-m-d') }}" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">End Date <span style="color:red;">*</span></div>
                <input type="date" id="report-booking-end-date" value="{{ now()->format('Y-m-d') }}" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                <div class="h-150"></div>
            </div>
        </div>

        <div class="submit-section h-80 w-100p">
            <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                <button type="submit" id="download-booking-button" onclick="showPreview('pdf');" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Preview PDF</button>
                <button type="submit" id="download-booking-excel-button" onclick="showPreview('booking');" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Preview Excel</button>
                <button type="button" onclick="close_popup_click('report-booking-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
            </div>
        </div>
    </div>

    <div id="usage-popup" class="right-popup bg-white w-600 h-100p">
        <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
            <div class="h-100p pd-30 bs-bb cursor-default">
                <div class="fs-18 clr-grey-2 fw-bold">Room Usage Report</div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Specific Room </div>
                <input id="report-usage-room-dropdown-input" type="hidden" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                <div id="report-usage-room-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"></div>
                <div id="report-usage-room-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                    <div class="d-flex">
                        <input type="text" id="report-usage-room-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                        <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                    </div>
                    @foreach ($rooms as $room)
                        <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'report-usage-room-dropdown-button', 'report-usage-room-dropdown-input', {{$room->id}}, 'report-usage-room-dropdown')" style="border:none;">{{$room->name}}</div>
                    @endforeach
                </div>

                <div class="fs-13 clr-black-1 fw-bold mg-t-20">Date <span style="color:red;">*</span></div>
                <input type="date" id="report-usage-date" value="{{ now()->format('Y-m-d') }}" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                <div class="h-150"></div>
            </div>
        </div>

        <div class="submit-section h-80 w-100p">
            <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                <button type="submit" id="download-usage-button" onclick="showPreview('pdf');" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Preview PDF</button>
                <button type="submit" id="download-usage-excel-button" onclick="showPreview('usage');" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Preview Excel</button>
                <button type="button" onclick="close_popup_click('usage-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
            </div>
        </div>
    </div>
@endsection

@push('script')
    {{-- pdf plugin link --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.13/jspdf.plugin.autotable.min.js"></script>
    {{-- pdf reviewer --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf-lib/1.17.1/pdf-lib.min.js"></script>

    {{-- Excel reviewer --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/handsontable@10.0.0/dist/handsontable.full.min.css" />
    <script src="https://cdn.jsdelivr.net/npm/handsontable@10.0.0/dist/handsontable.full.min.js"></script>
    {{-- Excel plugin link --}}
    {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script> --}}
    {{-- excel download advance style --}}
    <script src="https://cdn.jsdelivr.net/npm/xlsx-js-style@1.2.0/dist/xlsx.min.js"></script>
    {{-- excel add image --}}
    <script src="https://cdn.jsdelivr.net/npm/exceljs@4.3.0/dist/exceljs.min.js"></script>

    
    <script>
        // to remove session on the last session page
        localStorage.removeItem('classroom-management-session');

        // attendance group dropdown
        add_dropdown_event('report-attendance-group-dropdown-button','report-attendance-group-dropdown');
        add_search('report-attendance-group-search','report-attendance-group-dropdown');
        // booking room dropdown
        add_dropdown_event('report-booking-room-dropdown-button','report-booking-room-dropdown');
        add_search('report-booking-room-search','report-booking-room-dropdown');
        // usage room dropdown
        add_dropdown_event('report-usage-room-dropdown-button','report-usage-room-dropdown');
        add_search('report-usage-room-search','report-usage-room-dropdown');

        // report attendance pdf
        document.getElementById('download-attendance-button').addEventListener('click', async function (e) {
            group_id = document.getElementById('report-attendance-group-dropdown-input').value;
            group_users = @json(App\Models\GroupUser::all());
            users = @json(App\Models\User::all());
            classes = @json(App\Models\Classes::all());
            

            start_date = document.getElementById('report-attendance-start-date').value;
            end_date = document.getElementById('report-attendance-end-date').value;

            filtered_group_users = group_users.filter(group_user => group_user.group_id == group_id);
            filtered_users = users.filter(user => filtered_group_users.some(group_user => group_user.user_id === user.id))

            filtered_classes_by_group = classes.filter(clss => clss.group_id == group_id);
            filtered_classes_by_date = filtered_classes_by_group.filter(clss => (new Date(clss.start_date_time)) >= (new Date(start_date)) && (new Date(clss.start_date_time)) <= (new Date(end_date)));

            console.log(filtered_classes_by_date)

            const { jsPDF } = window.jspdf;
            const doc = new jsPDF({ orientation: 'l', unit: 'mm', format: 'a4' }); // size a4 210 x 297 mm

            doc.addImage(document.getElementById('logo'), 'PNG', 15, 8, 42, 12); //x, y, width, height
            doc.setFontSize(10); doc.setFont('helvetica', "bold");
            doc.text('Attendance Report', 15, 28);
            doc.setFontSize(6); 
            doc.text('Student Group', 15, 30); doc.text(' : ', 45,30); doc.setFont('helvetica', "normal"); 
            doc.text(document.getElementById('report-attendance-group-dropdown-button').textContent, 50, 30);
            doc.setFont('helvetica', "bold"); doc.text('Lecturer', 15, 35); doc.text(' : ', 45,35); doc.setFont('helvetica', "normal"); 
            yPosition = 35;
            filtered_users.forEach(user => {
                    if (user.type == 'Lecturer') {
                        let lecturerFullName = user.full_name;
                        doc.text(lecturerFullName, 50, yPosition);
                        yPosition += 5;
                    }
            });
            let count = 0;
            users.forEach(user => {
                    if (user.type == 'Student' || user.type == 'Student Lead') {
                        count += 1;
                    }
            });
            doc.setFont('helvetica', "bold"); doc.text('Total Students', 15, yPosition); doc.text(' : ', 45, yPosition); doc.setFont('helvetica', "normal");
            doc.text(count.toString(), 50, yPosition);

            const columns = [ 
                {content: ''},
                {content: 'Student Name'},
            ]

            filtered_classes_by_date.forEach(clss => {
                columns.push(`(${clss.start_date_time} - ${clss.end_date_time}) ${clss.title}`)
            })

            let data = 
            [ ['1', 'Aiman', 'Attended'], ]
            
            row = []
            // `${count}` - to turn to string
            count = 1;
            filtered_users.forEach(user => {
                if (user.type == 'Student Lead' && user.type == 'Student') {
                    // row.push(`${count}`)
                    // row.push(user.name)
                    count += 1;
                } 
            });

            doc.autoTable({
                head: [columns],
                body: data, 
                startY: yPosition + 5,
                headStyles: {
                    fillColor: [180, 180, 180],
                    textColor: [0, 0, 0],
                    fontStyle: 'bold',
                    fontSize: 6,
                    valign: 'middle',
                    halign: 'center',
                },
                bodyStyles: {
                    fillColor: [150, 150, 150],
                    textColor: [0, 0, 0],
                    fontStyle: 'normal',
                    fontSize: 6,
                    valign: 'middle',
                    halign: 'left',
                },
                styles: {
                    lineWidth: 0.2,
                    lineColor: [200, 200, 200],
                },
            })

            const generatedPdfBytes = doc.output("arraybuffer");
            
            const pdfDoc = await PDFLib.PDFDocument.create();
            const pdf = await PDFLib.PDFDocument.load(generatedPdfBytes);

            const pdf1Pages = await pdfDoc.copyPages(pdf, pdf.getPageIndices());
            pdf1Pages.forEach((page) => pdfDoc.addPage(page));

            const combinedPdfBytes = await pdfDoc.save();

            const blob = new Blob([combinedPdfBytes], { type: "application/pdf" });
            const url = URL.createObjectURL(blob);

            // doc.save("attendance_report.pdf");
            document.getElementById('preview-pdf').src = url;
        });
      
        // report booking pdf
        document.getElementById('download-booking-button').addEventListener('click', async function (e) {
            start_date = document.getElementById('report-booking-start-date').value;
            end_date = document.getElementById('report-booking-end-date').value;

            room_id = document.getElementById('report-booking-room-dropdown-input').value;
            rooms = @json(App\Models\Rooms::all());
            groups = @json(App\Models\Groups::all());
            classes = @json(App\Models\Classes::all());
            buildings = @json(App\Models\Buildings::all());
            levels = @json(App\Models\Levels::all());

            // filter() - always return array, that is why filtered_rooms[0]
            filtered_classes_by_date = classes.filter(clss => (new Date(clss.start_date_time)) >= (new Date(start_date)) && (new Date(clss.start_date_time)) <= (new Date(end_date)));
            // filtered_classes_by_date = classes.filter(clss => (new Date(clss.start_date_time).getTime() >= new Date(start_date).getTime()) && (new Date(clss.start_date_time).getTime() <= new Date(end_date).getTime()));
            filtered_rooms = rooms.filter(rm => rm.id == room_id)
            filtered_classes = filtered_classes_by_date.filter(clss => clss.room_id == room_id)
            filtered_buildings = buildings.filter(building => building.id == filtered_rooms[0].building_id)
            filtered_levels = levels.filter(level => level.id == filtered_rooms[0].level_id)

            const { jsPDF } = window.jspdf;
            const doc = new jsPDF({ orientation: 'l', unit: 'mm', format: 'a4' }); // size a4 210 x 297 mm

            doc.addImage(document.getElementById('logo'), 'PNG', 15, 10, 42, 12); //x, y, width, height
            doc.setFontSize(9); doc.setFont('helvetica', "bold"); 
            doc.text('Class Booking Report', 15, 28);
            doc.setFontSize(8); 
            doc.text('Room', 15, 34); doc.text(' : ', 45,34); doc.setFont('helvetica', "normal"); 
            doc.text(document.getElementById('report-booking-room-dropdown-button').textContent, 50, 34);
            doc.setFont('helvetica', "bold"); doc.text('Building', 15, 38); doc.text(' : ', 45,38); doc.setFont('helvetica', "normal"); 
            doc.text(filtered_buildings[0].name, 50, 38);
            doc.setFont('helvetica', "bold"); doc.text('Level', 15, 42); doc.text(' : ', 45, 42); doc.setFont('helvetica', "normal");
            doc.text(filtered_levels[0].name, 50, 42);


            const columns = [ 
                {content: ''},
                {content: 'Title'},
                {content: 'Description'},
                {content: 'Group'},
                {content: 'Start'},
                {content: 'End'},
            ]

            let data = []

            count = 1;
            filtered_classes.forEach(clss => {
                filtered_group = groups.filter(group => clss.group_id == group.id)[0];
                // console.log(filtered_group) - to debug
                formatted_start = `${new Date(clss.start_date_time).toLocaleDateString('en-GB', { day: '2-digit', month: 'short', year: 'numeric' })} ${new Date(clss.start_date_time).toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', hour12: true })}`;
                formatted_end = `${new Date(clss.end_date_time).toLocaleDateString('en-GB', { day: '2-digit', month: 'short', year: 'numeric' })} ${new Date(clss.end_date_time).toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', hour12: true })}`;
                data.push([count, clss.title, clss.description, filtered_group.name, formatted_start, formatted_end]);
                count += 1;
            });

            doc.autoTable({
                head: [columns],
                body: data, 
                startY: 50,
                headStyles: {
                    fillColor: [49, 39, 131],
                    textColor: [220, 220, 220],
                    fontStyle: 'bold',
                    fontSize: 6,
                    valign: 'middle',
                    halign: 'center',
                },
                bodyStyles: {
                    fillColor: [208, 203, 242],
                    textColor: [0, 0, 0],
                    fontStyle: 'normal',
                    fontSize: 6,
                    valign: 'middle',
                    halign: 'center',
                },
                styles: {
                    lineWidth: 0.2,
                    lineColor: [200, 200, 200],
                },
            })

            const generatedPdfBytes = doc.output("arraybuffer");
            
            const pdfDoc = await PDFLib.PDFDocument.create();
            const pdf = await PDFLib.PDFDocument.load(generatedPdfBytes);

            const pdf1Pages = await pdfDoc.copyPages(pdf, pdf.getPageIndices());
            pdf1Pages.forEach((page) => pdfDoc.addPage(page));

            const combinedPdfBytes = await pdfDoc.save();

            const blob = new Blob([combinedPdfBytes], { type: "application/pdf" });
            const url = URL.createObjectURL(blob);

            // doc.save("attendance_report.pdf");
            document.getElementById('preview-pdf').src = url;
        });
        
        // report usage pdf
        document.getElementById('download-usage-button').addEventListener('click', async function (e) {
            users = @json(App\Models\User::all());
            group_user = @json(App\Models\GroupUser::all());
            buildings = @json(App\Models\Buildings::all());
            levels = @json(App\Models\Levels::all());
            rooms = @json(App\Models\Rooms::all());            
            classes = @json(App\Models\Classes::all());
            settings = @json(App\Models\Settings::all());

            customRange = settings.filter(setting => setting.setting_key == 'custom_range')[0].setting_value;
            startTime = new Date(`1970-01-01T${settings.filter(setting => setting.setting_key == 'start_time')[0].setting_value}Z`);
            endTime = new Date(`1970-01-01T${settings.filter(setting => setting.setting_key == 'end_time')[0].setting_value}Z`);

            totalAvailableTimeForOneRoom = endTime - startTime;
            input_start = document.getElementById('report-usage-date').value;

            currentUser = @json(Auth::user());
            room_id = document.getElementById('report-usage-room-dropdown-input').value;

            // If room_id is empty, use all rooms; otherwise, filter for the specific room
            filtered_rooms = room_id ? rooms.filter(rm => rm.id == room_id) : rooms;

            function round(value, decimals) {
                return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals);
            }

            const { jsPDF } = window.jspdf;
            const doc = new jsPDF({ orientation: 'l', unit: 'mm', format: 'a4' }); // size a4 210 x 297 mm

            doc.addImage(document.getElementById('logo'), 'PNG', 15, 10, 42, 12); //x, y, width, height
            doc.setFontSize(9); doc.setFont('helvetica', "bold"); 
            doc.text('Room Usage Report', 15, 28);
            doc.setFontSize(8); 
            doc.text('Date', 15, 34); doc.text(' : ', 45,34); doc.setFont('helvetica', "normal"); 
            doc.text(new Date(document.getElementById('report-usage-date').value).toLocaleDateString('en-GB', { day: '2-digit', month: 'long', year: 'numeric' }), 50, 34);
            doc.setFont('helvetica', "bold"); doc.text('Generated By', 15, 38); doc.text(' : ', 45,38); doc.setFont('helvetica', "normal"); 
            doc.text(currentUser.type, 50, 38);

            const columns = [ 
                {content: ''},
                {content: 'Room Name'},
                {content: 'Description'},
                {content: 'Building'},
                {content: 'Level'},
                {content: 'Today Usage (%)'},
                {content: 'Weekly Usage (%)'},
                {content: 'Monthly Usage (%)'},
            ]

            let data = []
            count = 1;
            filtered_rooms.forEach(rm => {

                filtered_buildings = buildings.filter(building => rm.building_id == building.id)[0];
                filtered_levels = levels.filter(level => rm.level_id == level.id)[0];
                console.log(filtered_buildings.name);

                // today usage %
                filtered_classes_by_date_and_room = classes.filter(clss => {
                    const class_start = new Date(clss.start_date_time);
                    const input_start_date = new Date(input_start)
                    return (class_start.getDate() == input_start_date.getDate() &&
                            class_start.getMonth() == input_start_date.getMonth() &&
                            class_start.getFullYear() == input_start_date.getFullYear() &&
                            clss.room_id == rm.id);
                })
                totalAvailableTimeAllRoomsDaily = totalAvailableTimeForOneRoom;
                totalBookedTimeAllRoomsDaily = 0
                filtered_classes_by_date_and_room.forEach(clss => {
                    const class_start = new Date(clss.start_date_time);
                    const class_end = new Date(clss.end_date_time);
                    const duration = class_end - class_start;
                    totalBookedTimeAllRoomsDaily += duration;
                })
                todayUsagePercentage = (totalBookedTimeAllRoomsDaily / totalAvailableTimeAllRoomsDaily) * 100;

                // weekly usage %
                filtered_classes_by_week_and_room = classes.filter(clss => {
                    //condition
                    const class_start_week = new Date(clss.start_date_time);

                    //start of the week
                    const startOfWeek = new Date(input_start);
                    startOfWeek.setDate(startOfWeek.getDate() - startOfWeek.getDay()); // Move to the previous Sunday
                    startOfWeek.setHours(0, 0, 0, 0);
                    
                    //end of the week
                    const endOfWeek = new Date(input_start);
                    endOfWeek.setDate(endOfWeek.getDate() + (6 - endOfWeek.getDay())); // Move to the next Saturday
                    endOfWeek.setHours(23, 59, 59, 999);
                    return (class_start_week >= startOfWeek && 
                            class_start_week <= endOfWeek &&
                            clss.room_id == rm.id);
                })
                totalAvailableTimeAllRoomsWeekly = totalAvailableTimeForOneRoom * 7;
                totalBookedTimeAllRoomsWeekly = 0
                filtered_classes_by_week_and_room.forEach(clss => {
                    const class_start = new Date(clss.start_date_time);
                    const class_end = new Date(clss.end_date_time);
                    const duration = class_end - class_start;
                    totalBookedTimeAllRoomsWeekly += duration;
                })
                weeklyUsagePercentage = (totalBookedTimeAllRoomsWeekly / totalAvailableTimeAllRoomsWeekly) * 100;

                // Monthly usage %
                filtered_classes_by_month_and_room = classes.filter(clss => {
                    //start of the month
                    const startOfMonth = new Date(input_start);
                    startOfMonth.setDate(1); // Move to the first day of the month
                    startOfMonth.setHours(0, 0, 0, 0);
                    
                    //end of the month
                    const endOfMonth  = new Date(input_start);
                    endOfMonth.setMonth(endOfMonth.getMonth() + 1, 0); // Move to the last day of the month
                    endOfMonth.setHours(23, 59, 59, 999);

                    //condition
                    const class_start_month = new Date(clss.start_date_time);

                    return (class_start_month >= startOfMonth && 
                            class_start_month <= endOfMonth &&
                            clss.room_id == rm.id);
                })

                input_date_month = new Date(input_start);
                year = input_date_month.getFullYear();
                month = input_date_month.getMonth();
                console.log()
                
                totalAvailableTimeAllRoomsMonthly = totalAvailableTimeForOneRoom * (new Date(year, month + 1, 0).getDate());
                totalBookedTimeAllRoomsMonthly = 0
                filtered_classes_by_month_and_room.forEach(clss => {
                    const class_start = new Date(clss.start_date_time);
                    const class_end = new Date(clss.end_date_time);
                    const duration = class_end - class_start;
                    totalBookedTimeAllRoomsMonthly += duration;
                })
                monthlyUsagePercentage = (totalBookedTimeAllRoomsMonthly / totalAvailableTimeAllRoomsMonthly) * 100;


                data.push([count, rm.name, rm.description, filtered_buildings.name, filtered_levels.name, round(todayUsagePercentage, 2), round(weeklyUsagePercentage, 2) , round(monthlyUsagePercentage, 2)]);
                count += 1;
            });
            

            doc.autoTable({
                head: [columns],
                body: data, 
                startY: 45,
                headStyles: {
                    fillColor: [49, 39, 131],
                    textColor: [220, 220, 220],
                    fontStyle: 'bold',
                    fontSize: 6,
                    valign: 'middle',
                    halign: 'center',
                },
                bodyStyles: {
                    fillColor: [208, 203, 242],
                    textColor: [0, 0, 0],
                    fontStyle: 'normal',
                    fontSize: 6,
                    valign: 'middle',
                    halign: 'center',
                },
                styles: {
                    lineWidth: 0.2,
                    lineColor: [200, 200, 200],
                },
            })

            const generatedPdfBytes = doc.output("arraybuffer");
            
            const pdfDoc = await PDFLib.PDFDocument.create();
            const pdf = await PDFLib.PDFDocument.load(generatedPdfBytes);

            const pdf1Pages = await pdfDoc.copyPages(pdf, pdf.getPageIndices());
            pdf1Pages.forEach((page) => pdfDoc.addPage(page));

            const combinedPdfBytes = await pdfDoc.save();

            const blob = new Blob([combinedPdfBytes], { type: "application/pdf" });
            const url = URL.createObjectURL(blob);

            // doc.save("attendance_report.pdf");
            document.getElementById('preview-pdf').src = url;
        });


        // Excel
        // Store current Handsontable instance
        let currentHot;

        function showPreview(type) {
            if (type == 'attendance') {
                document.getElementById("excelPreviewAttendanceSection").style.display = 'block';
                document.getElementById('pdfPreviewSection').style.display = 'none'; // Hide PDF preview section if switching back to Excel
                document.getElementById("excelPreviewBookingSection").style.display = 'none';
                document.getElementById("excelPreviewUsageSection").style.display = 'none';
            } else if (type == 'booking') {
                document.getElementById("excelPreviewAttendanceSection").style.display = 'none';
                document.getElementById('pdfPreviewSection').style.display = 'none'; 
                document.getElementById("excelPreviewBookingSection").style.display = 'block';
                document.getElementById("excelPreviewUsageSection").style.display = 'none';
            } else if (type == 'usage') {
                document.getElementById("excelPreviewAttendanceSection").style.display = 'none';
                document.getElementById('pdfPreviewSection').style.display = 'none'; 
                document.getElementById("excelPreviewBookingSection").style.display = 'none';
                document.getElementById("excelPreviewUsageSection").style.display = 'block';
            } else if ((type == 'pdf')){
                document.getElementById("excelPreviewAttendanceSection").style.display = 'none'; // Hide Excel section
                document.getElementById('pdfPreviewSection').style.display = 'block'; 
                document.getElementById("excelPreviewBookingSection").style.display = 'none';
                document.getElementById("excelPreviewUsageSection").style.display = 'none';
                if (currentHot) {
                    currentHot.destroy();
                    currentHot = null; 
                }
                return;
            }

            // Hide all tables
            document.getElementById("excelPreviewTableAttendance").classList.add("hidden");
            document.getElementById("excelPreviewTableBooking").classList.add("hidden");
            document.getElementById("excelPreviewTableUsage").classList.add("hidden");

        
            // Destroy previous Handsontable instance if it exists
            if (currentHot) {
                currentHot.destroy();
                currentHot = null; 
            }

            // Initialize Handsontable for the selected table and update currentHot
            let container;
            if (type === 'attendance') {
                // Define datasets for each table
                const excelData = [
                    ["Alice"],
                    ["Bob"],
                    ["Charlie"]
                ];

                container = document.getElementById("excelPreviewTableAttendance");
                container.classList.remove("hidden");
                currentHot = new Handsontable(container, {
                    data: excelData,
                    rowHeaders: true,
                    colHeaders: ["Student Name"],
                    stretchH: 'all',
                    width: '100%',
                    height: '100%',
                    licenseKey: 'non-commercial-and-evaluation'
                });
            } else if (type === 'booking') {
                try {
                    rooms = @json(App\Models\Rooms::all());
                    groups = @json(App\Models\Groups::all());
                    classes = @json(App\Models\Classes::all());
                    buildings = @json(App\Models\Buildings::all());
                    levels = @json(App\Models\Levels::all());

                    start_date = document.getElementById('report-booking-start-date').value;
                    end_date = document.getElementById('report-booking-end-date').value;
                    room_id = document.getElementById('report-booking-room-dropdown-input').value;
                    room_name = document.getElementById('report-booking-room-dropdown-button').textContent;

                    filtered_classes_by_date = classes.filter(clss => (new Date(clss.start_date_time)) >= (new Date(start_date)) && (new Date(clss.start_date_time)) <= (new Date(end_date)));
                    filtered_rooms = rooms.filter(rm => rm.id == room_id);
                    filtered_classes = filtered_classes_by_date.filter(clss => clss.room_id == room_id);
                    filtered_buildings = buildings.filter(building => building.id == filtered_rooms[0].building_id);
                    filtered_levels = levels.filter(level => level.id == filtered_rooms[0].level_id);

                    data = [
                        [`storage/system/logo-uthm.png`, "", "", "", ""],
                        ["Class Booking Report", "", "", "", ""],
                        ["Room : "+room_name, "", "", "", ""],
                        ["Building : "+filtered_buildings[0].name, "", "", "", ""],
                        ["Level : "+filtered_levels[0].name, "", "", "", ""],
                        ["", "", "", "", ""],
                        ["Title", "Description", "Group", "Start", "End"],
                    ];

                    for (clss of filtered_classes) {
                        filtered_group = groups.filter(group => clss.group_id == group.id)[0];
                        formatted_start = `${new Date(clss.start_date_time).toLocaleDateString('en-GB', { day: '2-digit', month: 'short', year: 'numeric' })} ${new Date(clss.start_date_time).toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', hour12: true })}`;
                        formatted_end = `${new Date(clss.end_date_time).toLocaleDateString('en-GB', { day: '2-digit', month: 'short', year: 'numeric' })} ${new Date(clss.end_date_time).toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', hour12: true })}`;
                        data.push([clss.title, clss.description, filtered_group.name, formatted_start, formatted_end]);
                    }

                    container = document.getElementById("excelPreviewTableBooking");
                    container.classList.remove("hidden");
                    currentHot = new Handsontable(container, {
                        data: data,
                        rowHeaders: true,
                        colHeaders: ["A", "B", "C", "D", "E"],
                        colWidths: [100, 80, 100, 70, 70],
                        mergeCells: [
                            { row: 0, col: 0, rowspan: 1, colspan: 5 },  
                            { row: 1, col: 0, rowspan: 1, colspan: 5 },  
                            { row: 2, col: 0, rowspan: 1, colspan: 5 },  
                            { row: 3, col: 0, rowspan: 1, colspan: 5 },
                            { row: 4, col: 0, rowspan: 1, colspan: 5 },  
                        ],
                        stretchH: 'all',
                        width: '100%',
                        height: '100%',
                        licenseKey: 'non-commercial-and-evaluation',

                        // Define the custom image renderer for the first column
                        cells: function(row, col) {
                            const cellProperties = {};
                            
                            if (col === 0 && row === 0) { // Apply image renderer to specific cell
                                cellProperties.renderer = function (instance, td, row, col, prop, value, cellProperties){
                                    Handsontable.dom.empty(td); // Clear the cell
                                    // Check if the value is a valid image URL or base64 image
                                    if (value) {
                                        const img = document.createElement('img');
                                        img.src = value;
                                        img.style.width = '150px';  // Set the width of the image
                                        img.style.height = 'auto';  // Set the height of the image
                                        td.appendChild(img); // Add the image to the cell
                                    } else {
                                        td.innerText = 'No Image'; // Fallback text if there's no image
                                    }
                                    return td;
                                };
                            }
                            if (col === 0 && row === 1) { 
                                cellProperties.renderer = function (instance, td, row, col, prop, value, cellProperties){
                                    Handsontable.dom.empty(td); // Clear the cell
                                    // Set the text content
                                    td.innerText = value;
                                    // Apply styles for bold text and font size
                                    td.style.fontWeight = 'bold'; // Makes the text bold
                                    td.style.fontSize = '16px'; // Change the font size (adjust as needed)
                                    return td;
                                };
                            }
                            if ((col === 0 && row === 6) || 
                                (col === 1 && row === 6) || 
                                (col === 2 && row === 6) || 
                                (col === 3 && row === 6) || 
                                (col === 4 && row === 6) ) { 
                                cellProperties.renderer = function (instance, td, row, col, prop, value, cellProperties){
                                    Handsontable.dom.empty(td);
                                    td.innerText = value;
                                    td.style.fontWeight = 'bold';
                                    td.style.backgroundColor = '#f0f0f0';
                                    return td;
                                };
                            }

                            return cellProperties;
                        }

                    });
                } catch (error) {
                    console.error('Error fetching usage data:', error);
                }
            } else if (type === 'usage') {
                try {
                    users = @json(App\Models\User::all());
                    group_user = @json(App\Models\GroupUser::all());
                    buildings = @json(App\Models\Buildings::all());
                    levels = @json(App\Models\Levels::all());
                    rooms = @json(App\Models\Rooms::all());            
                    classes = @json(App\Models\Classes::all());
                    settings = @json(App\Models\Settings::all());

                    customRange = settings.find(setting => setting.setting_key === 'custom_range').setting_value;
                    startTime = new Date(`1970-01-01T${settings.find(setting => setting.setting_key === 'start_time').setting_value}Z`);
                    endTime = new Date(`1970-01-01T${settings.find(setting => setting.setting_key === 'end_time').setting_value}Z`);
                    totalAvailableTimeForOneRoom = endTime - startTime;

                    input_start = document.getElementById('report-usage-date').value;
                    room_id = document.getElementById('report-usage-room-dropdown-input').value;
                    currentUser = @json(Auth::user());

                    filtered_rooms = room_id ? rooms.filter(room => room.id == room_id) : rooms;
                    

                    // Helper functions
                    function calculateUsagePercentage(classes, totalAvailableTime) {
                        let totalBookedTime = 0;
                        classes.forEach(cl => {
                            start = new Date(cl.start_date_time);
                            end = new Date(cl.end_date_time);
                            totalBookedTime += end - start;
                        });
                        return ((totalBookedTime / totalAvailableTime) * 100).toFixed(2);
                    }

                    function getClassesForWeek(input_start, classes, room_id) {
                        startOfWeek = new Date(input_start);
                        startOfWeek.setDate(startOfWeek.getDate() - startOfWeek.getDay());
                        startOfWeek.setHours(0, 0, 0, 0);

                        endOfWeek = new Date(startOfWeek);
                        endOfWeek.setDate(startOfWeek.getDate() + 6);
                        endOfWeek.setHours(23, 59, 59, 999);

                        return classes.filter(cl => {
                            classDate = new Date(cl.start_date_time);
                            return classDate >= startOfWeek && classDate <= endOfWeek && cl.room_id === room_id;
                        });
                    }

                    function getClassesForMonth(input_start, classes, room_id) {
                        startOfMonth = new Date(input_start);
                        startOfMonth.setDate(1);
                        endOfMonth = new Date(startOfMonth);
                        endOfMonth.setMonth(startOfMonth.getMonth() + 1, 0);

                        return classes.filter(cl => {
                            classDate = new Date(cl.start_date_time);
                            return classDate >= startOfMonth && classDate <= endOfMonth && cl.room_id === room_id;
                        });
                    }

                    input_start = new Date(document.getElementById('report-usage-date').value).toLocaleDateString('en-GB', { day: '2-digit', month: 'long', year: 'numeric' })

                    data = [
                        [`storage/system/logo-uthm.png`, "", "", "", "", "", ""],
                        ["Room Usage Report", "", "", "", "", "", ""],
                        ["Date : "+input_start, "", "", "", "", "", ""],
                        ["Generated By : "+currentUser.type, "", "", "", "", "", ""],
                        ["", "", "", "", "", "", ""],
                        ["Room Name", "Description", "Building", "Level", "Today Usage (%)", "Weekly Usage (%)", "Monthly Usage (%)"],
                    ];
                    for (room of filtered_rooms) {
                        building = buildings.find(b => b.id === room.building_id);
                        level = levels.find(l => l.id === room.level_id);

                        // Calculate Today Usage
                        todayClasses = classes.filter(cl => new Date(cl.start_date_time).toDateString() === new Date(input_start).toDateString() && cl.room_id === room.id);
                        todayUsage = calculateUsagePercentage(todayClasses, totalAvailableTimeForOneRoom);

                        // Calculate Weekly Usage
                        weekClasses = getClassesForWeek(input_start, classes, room.id);
                        weeklyUsage = calculateUsagePercentage(weekClasses, totalAvailableTimeForOneRoom * 7);

                        // Calculate Monthly Usage
                        monthClasses = getClassesForMonth(input_start, classes, room.id);
                        daysInMonth = new Date(new Date(input_start).getFullYear(), new Date(input_start).getMonth() + 1, 0).getDate();
                        monthlyUsage = calculateUsagePercentage(monthClasses, totalAvailableTimeForOneRoom * daysInMonth);

                        data.push([room.name, room.description, building.name, level.name, todayUsage, weeklyUsage, monthlyUsage]);
                    }

                    container = document.getElementById("excelPreviewTableUsage");
                    container.classList.remove("hidden");
                    currentHot = new Handsontable(container, {
                        data: data,
                        rowHeaders: true,
                        colHeaders: ["A", "B", "C", "D", "E", "F", "G"],
                        colWidths: [100, 200, 100, 75, 100, 100, 100],
                        mergeCells: [
                            { row: 0, col: 0, rowspan: 1, colspan: 7 },  
                            { row: 1, col: 0, rowspan: 1, colspan: 7 },  
                            { row: 2, col: 0, rowspan: 1, colspan: 7 },  
                            { row: 3, col: 0, rowspan: 1, colspan: 7 },
                        ],
                        stretchH: 'all',
                        width: '100%',
                        height: '100%',
                        licenseKey: 'non-commercial-and-evaluation',

                        // Define the custom image renderer for the first column
                        cells: function(row, col) {
                            const cellProperties = {};
                            
                            if (col === 0 && row === 0) { // Apply image renderer to specific cell
                                cellProperties.renderer = function (instance, td, row, col, prop, value, cellProperties){
                                    Handsontable.dom.empty(td); // Clear the cell
                                    // Check if the value is a valid image URL or base64 image
                                    if (value) {
                                        const img = document.createElement('img');
                                        img.src = value;
                                        img.style.width = '150px';  // Set the width of the image
                                        img.style.height = 'auto';  // Set the height of the image
                                        td.appendChild(img); // Add the image to the cell
                                    } else {
                                        td.innerText = 'No Image'; // Fallback text if there's no image
                                    }
                                    return td;
                                };
                            }
                            if (col === 0 && row === 1) { 
                                cellProperties.renderer = function (instance, td, row, col, prop, value, cellProperties){
                                    Handsontable.dom.empty(td); // Clear the cell
                                    // Set the text content
                                    td.innerText = value;
                                    // Apply styles for bold text and font size
                                    td.style.fontWeight = 'bold'; // Makes the text bold
                                    td.style.fontSize = '16px'; // Change the font size (adjust as needed)
                                    return td;
                                };
                            }
                            if ((col === 0 && row === 5) || 
                                (col === 1 && row === 5) || 
                                (col === 2 && row === 5) || 
                                (col === 3 && row === 5) || 
                                (col === 4 && row === 5) || 
                                (col === 5 && row === 5) || 
                                (col === 6 && row === 5) ) { 
                                cellProperties.renderer = function (instance, td, row, col, prop, value, cellProperties){
                                    Handsontable.dom.empty(td);
                                    td.innerText = value;
                                    td.style.fontWeight = 'bold';
                                    td.style.backgroundColor = '#f0f0f0'; 
                                    return td;
                                };
                            }

                            return cellProperties;
                        }
                    });
                } catch (error) {
                    console.error('Error fetching usage data:', error);
                }
            }
        }
       
        
        // to dowload excel file, 
        function downloadExcel(type) {
            if (type === 'attendance') {
                // Retrieve data from the current Handsontable instance
                const data = currentHot.getData();

                // Create a new worksheet from the data array
                const ws = XLSX.utils.aoa_to_sheet(data);

                // Create a new workbook and add the worksheet
                const wb = XLSX.utils.book_new();
                XLSX.utils.book_append_sheet(wb, ws, "Sheet1");

                // Download the Excel file
                XLSX.writeFile(wb, "Handsontable_Data.xlsx");
            } 
            else if (type === 'booking') {
                const workbook = new ExcelJS.Workbook();
                const worksheet = workbook.addWorksheet("Class Booking Report");

                // Retrieve data from Handsontable
                const data = currentHot.getData();

                const setCellStyleForContent = (cell, fontWeight = 'normal', fontSize = 10, bgColor = null, color = '000000', borderStyle = null, borderColor = '000000') => {
                    cell.font = { bold: fontWeight === 'bold', size: fontSize, color: { argb: color } };
                    if (bgColor) cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: bgColor } };
                    if (borderStyle) {
                        cell.border = {
                            top: { style: borderStyle, color: { argb: borderColor } },
                            bottom: { style: borderStyle, color: { argb: borderColor } },
                            left: { style: borderStyle, color: { argb: borderColor } },
                            right: { style: borderStyle, color: { argb: borderColor } }
                        };
                    }
                };
                
                // Add data to the worksheet
                data.forEach((row, rowIndex) => {
                    row.forEach((value, colIndex) => {
                        if (rowIndex === 0 && colIndex === 0) return;
                        worksheet.getRow(rowIndex + 1).getCell(colIndex + 1).value = value;

                        setCellStyleForContent(worksheet.getRow(rowIndex + 1).getCell(colIndex + 1), 'normal', 10, null, '000000', 'thin','B4B4B4');
                    });
                });

                // Define merged cells
                worksheet.mergeCells('A1:E1');  // Logo row merge
                worksheet.mergeCells('A2:E2');  // "Class Booking Report" title merge
                worksheet.mergeCells('A3:E3');  // "Room" info row merge
                worksheet.mergeCells('A4:E4');  // "Building" info row merge
                worksheet.mergeCells('A5:E5');  // "Level" info row merge

                // Set column widths
                worksheet.columns = [
                    { width: 40 },
                    { width: 30 },
                    { width: 40 },
                    { width: 20 },
                    { width: 20 }
                ];

                // Set row heights
                worksheet.getRow(1).height = 62;

                // Define a helper function for styling cells
                const setCellStyle = (cell, fontWeight = 'normal', fontSize = 10, bgColor = null, color = '000000', borderStyle = null, borderColor = '000000', alignment = 'left') => {
                    cell.font = { bold: fontWeight === 'bold', size: fontSize, color: { argb: color } };
                    if (bgColor) cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: bgColor } };
                    if (borderStyle) {
                        // exp "thin", "medium", "thick"
                        cell.border = {
                            top: { style: borderStyle, color: { argb: borderColor } },
                            bottom: { style: borderStyle, color: { argb: borderColor } },
                            left: { style: borderStyle, color: { argb: borderColor } },
                            right: { style: borderStyle, color: { argb: borderColor } }
                        };
                    }
                    cell.alignment = { horizontal: alignment, vertical: 'middle' };
                };

                // Apply custom styles
                setCellStyle(worksheet.getCell("A1"), 'normal', 10);         // Logo placeholder cell
                setCellStyle(worksheet.getCell("A2"), 'bold', 14);           // Title "Class Booking Report"
                setCellStyle(worksheet.getCell("A3"), 'normal', 10);         // "Room" info
                setCellStyle(worksheet.getCell("A4"), 'normal', 10);         // "Building" info
                setCellStyle(worksheet.getCell("A5"), 'normal', 10);         // "Level" info

                // Style headers
                ["A7", "B7", "C7", "D7", "E7"].forEach(cell => setCellStyle(worksheet.getCell(cell), 'bold', 12, "F0F0F0", '000000', 'thin','B4B4B4'));
                setCellStyle(worksheet.getCell('D7'), 'bold', 12, 'F0F0F0', '000000', 'thin', 'B4B4B4', 'center');
                setCellStyle(worksheet.getCell('E7'), 'bold', 12, 'F0F0F0', '000000', 'thin', 'B4B4B4', 'center');

                // Load and add the logo image
                const logoUrl = "storage/system/logo-uthm.png"; // Your image URL or path

                // Fetch the image, process it, and add it to the worksheet using .then()
                fetch(logoUrl)
                    .then(imageResponse => imageResponse.arrayBuffer())
                    .then(imageBuffer => {
                        const imageId = workbook.addImage({
                            buffer: imageBuffer,
                            extension: 'png'
                        });

                        // Add the image to the worksheet in the desired position
                        worksheet.addImage(imageId, {
                            tl: { col: 0, row: 0 }, // Top-left position
                            ext: { width: 200, height: 60 } // Set width and height
                        });

                        // Generate the workbook and trigger download
                        return workbook.xlsx.writeBuffer();
                    })
                    .then(buffer => {
                        const blob = new Blob([buffer], { type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" });
                        const url = URL.createObjectURL(blob);
                        const a = document.createElement("a");
                        a.href = url;
                        a.download = "Class_Booking_Report.xlsx";
                        a.click();
                    })
                .catch(error => {
                    console.error("Error processing the workbook:", error);
                });
            } 
            else if (type === 'usage') {
                const workbook = new ExcelJS.Workbook();
                const worksheet = workbook.addWorksheet("Room Usage Report");

                // Retrieve data from Handsontable
                const data = currentHot.getData();

                const setCellStyleForContent = (cell, fontWeight = 'normal', fontSize = 10, bgColor = null, color = '000000', borderStyle = null, borderColor = '000000') => {
                    cell.font = { bold: fontWeight === 'bold', size: fontSize, color: { argb: color } };
                    if (bgColor) cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: bgColor } };
                    if (borderStyle) {
                        cell.border = {
                            top: { style: borderStyle, color: { argb: borderColor } },
                            bottom: { style: borderStyle, color: { argb: borderColor } },
                            left: { style: borderStyle, color: { argb: borderColor } },
                            right: { style: borderStyle, color: { argb: borderColor } }
                        };
                    }
                };
                
                // Add data to the worksheet
                data.forEach((row, rowIndex) => {
                    row.forEach((value, colIndex) => {
                        if (rowIndex === 0 && colIndex === 0) return;
                        worksheet.getRow(rowIndex + 1).getCell(colIndex + 1).value = value;

                        setCellStyleForContent(worksheet.getRow(rowIndex + 1).getCell(colIndex + 1), 'normal', 10, null, '000000', 'thin','B4B4B4');
                    });
                });

                // Define merged cells
                worksheet.mergeCells('A1:G1'); 
                worksheet.mergeCells('A2:G2');  
                worksheet.mergeCells('A3:G3');  
                worksheet.mergeCells('A4:G4');  

                // Set column widths
                worksheet.columns = [
                    { width: 20 },
                    { width: 50 },
                    { width: 30 },
                    { width: 20 },
                    { width: 30 },
                    { width: 30 },
                    { width: 30 }
                ];

                // Set row heights
                worksheet.getRow(1).height = 62;

                // Define a helper function for styling cells
                const setCellStyle = (cell, fontWeight = 'normal', fontSize = 10, bgColor = null, color = '000000', borderStyle = null, borderColor = '000000', alignment = 'left') => {
                    cell.font = { bold: fontWeight === 'bold', size: fontSize, color: { argb: color } };
                    if (bgColor) cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: bgColor } };
                    if (borderStyle) {
                        // exp "thin", "medium", "thick"
                        cell.border = {
                            top: { style: borderStyle, color: { argb: borderColor } },
                            bottom: { style: borderStyle, color: { argb: borderColor } },
                            left: { style: borderStyle, color: { argb: borderColor } },
                            right: { style: borderStyle, color: { argb: borderColor } }
                        };
                    }
                    cell.alignment = { horizontal: alignment, vertical: 'middle' };
                };

                // Apply custom styles
                setCellStyle(worksheet.getCell("A1"), 'normal', 10);         
                setCellStyle(worksheet.getCell("A2"), 'bold', 14);           
                setCellStyle(worksheet.getCell("A3"), 'normal', 10);         
                setCellStyle(worksheet.getCell("A4"), 'normal', 10);         

                // Style headers
                ["A6", "B6", "C6", "D6", "E6", "F6", "G6"].forEach(cell => setCellStyle(worksheet.getCell(cell), 'bold', 12, "F0F0F0", '000000', 'thin', 'B4B4B4', 'center'));

                // Load and add the logo image
                const logoUrl = "storage/system/logo-uthm.png"; // Your image URL or path

                // Fetch the image, process it, and add it to the worksheet using .then()
                fetch(logoUrl)
                    .then(imageResponse => imageResponse.arrayBuffer())
                    .then(imageBuffer => {
                        const imageId = workbook.addImage({
                            buffer: imageBuffer,
                            extension: 'png'
                        });

                        // Add the image to the worksheet in the desired position
                        worksheet.addImage(imageId, {
                            tl: { col: 0, row: 0 }, // Top-left position
                            ext: { width: 200, height: 60 } // Set width and height
                        });

                        // Generate the workbook and trigger download
                        return workbook.xlsx.writeBuffer();
                    })
                    .then(buffer => {
                        const blob = new Blob([buffer], { type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" });
                        const url = URL.createObjectURL(blob);
                        const a = document.createElement("a");
                        a.href = url;
                        a.download = "Class_Usage_Report.xlsx";
                        a.click();
                    })
                .catch(error => {
                    console.error("Error processing the workbook:", error);
                });
            } 
            else {
                alert("No data available to download.");
            }
        }
    </script>
@endpush