<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
    <h1>Create Room</h1>
    {{-- to display error if wrong user --}}
    @if (session('success'))
    <div class="alert alert-danger" role="alert">
        {{ session('success') }}
    </div>
    @endif
    
    <form action="{{route('room.create-room')}}" method="POST">
        @csrf
        @method('POST')

        <input type="hidden" id="building_id" name="building_id">
        <input type="hidden" id="level_id" name="level_id">
        <input type="hidden" id="type_id" name="type_id">
        
        <div>Room Name*</div>
        <input type="text" name="name" class="form-control" value="">

        <div>Description</div>
        <textarea name="description" class="form-control" value=""></textarea>

        <div>Index Code*</div>

        <div style="height:20px;"></div>

        <div>Building*</div>
        <input type="text" id="building-button" class="form-control" value="">
        <div style="width:150px; height:50px; overflow:auto;">
            @php $building = App\Models\Buildings::all(); @endphp
            @foreach ($building as $b)
                <div style="cursor:pointer" onclick="building_option_click({{App\Models\Buildings::findOrFail($b->id)->levels}}, '{{$b->name}}'); document.getElementById('building_id').value = {{$b->id}};">{{$b->name}}</div>
            @endforeach
        </div>

        <div style="height:20px;"></div>

        <div>Level*</div>
        <div type="text" id="level-button" class="form-control" value=""></div>
        <div id="level-dropdown" style="width:150px; height:50px; overflow:auto;">
        </div>

        <div style="height:20px;"></div>
        
        <div>Room Type</div>
        <input type="text" id="room-type-input" class="form-control" value="">
        <div style="width:150px; height:80px; overflow:auto">
            @php $room_types = App\Models\RoomType::all(); @endphp
            @foreach ($room_types as $rt)
                <div style="cursor:pointer" onclick="document.getElementById('room-type-input').value='{{$rt->name}}'; document.getElementById('type_id').value = {{$rt->id}}">{{$rt->name}}</div>
            @endforeach
        </div>

        <div style="height:20px;"></div>

        <button type="submit">Create</button>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
    </form>

    <script>
        function building_option_click(levels, building_name) {
            dropdown = document.getElementById('level-dropdown');
            dropdown.innerHTML = ''; 
            levels.forEach(l => {
                level_option = document.createElement('div');
                level_option.style = 'cursor:pointer';
                level_option.onclick = function (){document.getElementById('level-button').textContent = l.name; document.getElementById('level_id').value = l.id; }
                level_option.textContent = l.name;

                dropdown.appendChild(level_option);
            });

            document.getElementById('building-button').value = building_name; //for building id
        }
    </script>
</body>
</html>