<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
    <h1>Delete Room</h1>
    {{-- to display error if wrong user --}}
    @if (session('success'))
    <div class="alert alert-danger" role="alert">
        {{ session('success') }}
    </div>
    @endif

    @php
        $room_id = 1;
    @endphp
    
    <form action="{{route('room.delete-room-by-id', ['id' => $room_id])}}" method="POST">
        @csrf
        @method('DELETE')

        <div>Delete Room : {{App\Models\Rooms::findOrFail($room_id)->name}} </div>
        <button type="submit">Delete</button>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
            
    </form>

    <script>

        function building_option_click(levels, building_name) {
            dropdown = document.getElementById('level-dropdown');
            dropdown.innerHTML = ''; 
            levels.forEach(l => {
                level_option = document.createElement('div');
                level_option.style = 'cursor:pointer';
                level_option.onclick = function (){document.getElementById('level-button').textContent = l.name; document.getElementById('level_id').value = l.id; }
                level_option.textContent = l.name;

                dropdown.appendChild(level_option);
            });

            document.getElementById('building-button').value = building_name; //for building id
        }

    </script>
    
</body>
</html>