<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
    <h1>Disable User</h1>
    {{-- to display error if wrong user --}}
    @if (session('success'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    @php
        $user_id = 1;
    @endphp
    
    <form action="{{route('user.disable-user-by-id', ['id' => $user_id])}}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PATCH')
        
        <div>Status User: {{App\Models\User::findOrFail($user_id)->status}}</div>
        <div>Disable Button</div>
        <button type="submit">Disable</button>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
            
    </form>

    <script>
    </script>
</body>
</html>