<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
    <h1>Update User</h1>
    {{-- to display error if wrong user --}}
    @if (session('success'))
    <div class="" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif
    
    <form action="{{route('user.update-user')}}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PATCH')
        
        <div>Phone</div>
        <input type="text" name="phone_no" class="form-control" value="{{Auth::user()->phone_no}}">

        <div>Address</div>
        <input type="text" name="address" class="form-control" value="{{Auth::user()->address}}">

        <button type="submit">Create</button>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
    </form>

    <script>

        document.querySelectorAll('input[name="type"]').forEach((checkbox) => {
            checkbox.addEventListener('click', function () {
            if (this.checked) {
                document.querySelectorAll('input[name="type"]').forEach((cb) => {
                    if (cb !== this) {
                        cb.checked = false
                    }
                })
            } else {
                this.checked = true;
            }
            });
        });

        document.querySelectorAll('input[name="gender"]').forEach((checkbox) => {
            checkbox.addEventListener('click', function () {
            if (this.checked) {
                document.querySelectorAll('input[name="gender"]').forEach((cb) => {
                    if (cb !== this) {
                        cb.checked = false
                    }
                })
            } else {
                this.checked = true;
            }
            });
        });

    </script>
</body>
</html>