<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
    <h1>Update User by ID</h1>
    {{-- to display error if wrong user --}}
    @if (session('success'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    @php
        $user_id = 4;
    @endphp
    
    <form action="{{route('user.update-user-by-id', ['id' => $user_id])}}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PATCH')

        <div>Image</div>
        <input type="file" name="image" class="form-control" accept="image/*">

        <div>Staff id</div>
        <input type="text" name="staff_id" class="form-control" value="{{App\Models\User::findOrFail($user_id)->staff_id}}">

        <div>Email</div>
        <input type="email" name="email" class="form-control" value="{{App\Models\User::findOrFail($user_id)->email}}">

        <div>First Name</div>
        <input type="text" name="first_name" class="form-control" value="{{App\Models\User::findOrFail($user_id)->first_name}}">

        <div>Last Name</div>
        <input type="text" name="last_name" class="form-control" value="{{App\Models\User::findOrFail($user_id)->last_name}}">

        <div>Full Name</div>
        <input type="text" name="full_name" class="form-control" value="{{App\Models\User::findOrFail($user_id)->full_name}}">

        <div>Phone</div>
        <input type="text" name="phone_no" class="form-control" value="{{App\Models\User::findOrFail($user_id)->phone_no}}">

        <div>Address</div>
        <input type="text" name="address" class="form-control" value="{{App\Models\User::findOrFail($user_id)->address}}">

        <div>NRIC</div>
        <input type="text" name="nric" class="form-control" value="{{App\Models\User::findOrFail($user_id)->nric}}">

        <div>Remark</div>
        <input type="text" name="remark" class="form-control" value="{{App\Models\User::findOrFail($user_id)->remark}}">

        <div>Gender</div>
        
        <div style="display:flex">
            <input type="checkbox" id="male-cb" name="gender" class="form-control" value="0">
            <div>Male</div>
        </div>
        <div style="display:flex">
            <input type="checkbox" id="female-cb" name="gender" class="form-control" value="1">
            <div>Female</div>
        </div>

        <div>User Type</div>
        <div style="display:flex">
            <input type="checkbox" id="administrator-cb" name="type" class="form-control" value="Administrator">
            <div>Administrator</div>
        </div>
        <div style="display:flex">
            <input type="checkbox" id="management-cb" name="type" class="form-control" value="Management">
            <div>Management</div>
        </div>
        <div style="display:flex">
            <input type="checkbox" id="lecturer-cb" name="type" class="form-control" value="Lecturer">
            <div>Lecturer</div>
        </div>
        <div style="display:flex">
            <input type="checkbox" id="student-lead-cb" name="type" class="form-control" value="Student Lead">
            <div>Student Lead</div>
        </div>
        <div style="display:flex">
            <input type="checkbox" id="student-cb" name="type" class="form-control" value="Student">
            <div>Student</div>
        </div>

        <button type="submit">Update</button>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
    </form>

    <script>
        document.querySelectorAll('input[name="type"]').forEach((checkbox) => {
            checkbox.addEventListener('click', function () {
            if (this.checked) {
                document.querySelectorAll('input[name="type"]').forEach((cb) => {
                    if (cb !== this) {
                        cb.checked = false
                    }
                })
            } else {
                this.checked = true;
            }
            });
        });

        document.querySelectorAll('input[name="gender"]').forEach((checkbox) => {
            checkbox.addEventListener('click', function () {
            if (this.checked) {
                document.querySelectorAll('input[name="gender"]').forEach((cb) => {
                    if (cb !== this) {
                        cb.checked = false
                    }
                })
            } else {
                this.checked = true;
            }
            });
        });

        // checkbox update function for gender
        var user = @json(App\Models\User::findOrFail($user_id));
        if (user.gender == 0) { checkbox = document.getElementById("male-cb").checked = true; }
        else { checkbox = document.getElementById("female-cb").checked = true; }

        // checkbox update function for type
        if (user.type == "Student") { checkbox = document.getElementById("student-cb").checked = true; }
        else if (user.type == "Student Lead") { checkbox = document.getElementById("student-lead-cb").checked = true; }
        else if (user.type == "Lecturer") { checkbox = document.getElementById("lecturer-cb").checked = true; }
        else if (user.type == "Management") { checkbox = document.getElementById("management-cb").checked = true; }
        else { checkbox = document.getElementById("administrator-cb").checked = true; }

    </script>
</body>
</html>