<!-- <link rel="stylesheet" href="/css/bootstrap-custom.css"> -->
<!-- <link rel="stylesheet" href="/css/layout.css"> -->
<style>
    #nav-pagination {
        position:fixed; bottom:30px; box-shadow:0px 0px 15px 5px #00000022; border-radius: 10px
    }

    @media only screen and (max-width: 425px) {
        #nav-pagination {
            position:fixed; bottom:65px; left:50%; transform:translateX(-50%); box-shadow:0px 0px 15px 5px #00000022
        }
    }

    /* Tablets (480px to 768px) */ 
    @media only screen and (min-width: 425px) and (max-width: 768px) {
        #nav-pagination {
            right:30px;
        }
    }

    /* Desktops (768px to 1024px) */
    @media only screen and (min-width: 768px) and (max-width: 1024px) {
        #nav-pagination {
            right:30px;
        }
    }

    /* Large Screens (more than 1024px) */
    @media only screen and (min-width: 1024px) {
        #nav-pagination {
            right:30px;
        }
    }
</style>

@if ($paginator->hasPages())
    <nav role="navigation" id="nav-pagination" aria-label="{{ __('Pagination Navigation') }}" class="d-flex ai-center pd-lr-15 pd-tb-10 bg-primary">

        <!-- Go to Page Form -->
        <div class="d-flex ai-center">
            <form action="{{ request()->url() }}" method="GET" class="d-flex ai-center">
                <label for="page" class="fs-13 fw-bold">Page:</label>
                @if(isset($pageName))
                    <input type="number" name="{{$pageName}}" id="page" value="{{$paginator->currentPage()}}" min="1" max="{{ $paginator->lastPage() }}" class="form-control dropdown-button w-70 clr-grey-1 pd-tb-8 pd-lr-8 mg-l-10 pd-lr-0 cursor-text txt-c" style="">
                @else
                    <input type="number" name="page" id="page" value="{{$paginator->currentPage()}}" min="1" max="{{ $paginator->lastPage() }}" class="form-control dropdown-button w-70 clr-grey-1 pd-tb-8 pd-lr-8 mg-l-10 pd-lr-0 cursor-text txt-c" style="">
                @endif
                
            </form>
            <label for="" class="fs-13 clr-grey-1 tw-nowrap">of {{$paginator->lastPage()}}</label>
        </div>

        <div class="d-flex mg-l-15 flex-1 sm:hidden fw-bold">
            @if ($paginator->onFirstPage())
                <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-5"><span class="material-symbols-outlined clr-white fs-20 fw-bold">first_page</span></div>
                <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-5"><span class="material-symbols-outlined clr-white fs-20 fw-bold">chevron_left</span></div>
            @else
                <a href="{{ $paginator->url(1) }}" class="txt-none">
                    <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-5"><span class="material-symbols-outlined clr-white fs-20 fw-bold">first_page</span></div>
                </a>
                <a href="{{ $paginator->previousPageUrl() }}" class="txt-none">
                    <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-5"><span class="material-symbols-outlined clr-white fs-20 fw-bold">chevron_left</span></div>
                </a>
            @endif

            @if ($paginator->hasMorePages())
                <a href="{{ $paginator->nextPageUrl() }}" class="txt-none">
                    <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-15"><span class="material-symbols-outlined clr-white fs-20 fw-bold">chevron_right</span></div>
                </a>
                <a href="{{ $paginator->url($paginator->lastPage()) }}" class="txt-none">
                    <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-5"><span class="material-symbols-outlined clr-white fs-20 fw-bold">last_page</span></div>
                </a>
            @else
                <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-15"><span class="material-symbols-outlined clr-white fs-20 fw-bold">chevron_right</span></div>
                <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-5"><span class="material-symbols-outlined clr-white fs-20 fw-bold">last_page</span></div>
            @endif
        </div>
    </nav>
@endif
