<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HCPController;
use App\Http\Controllers\RoomController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ClassController;
use App\Http\Controllers\GroupController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\SettingController;

Route::get('/', function () {
    return view('welcome');
});

// Route::get('/dashboard', function () {
//     return view('dashboard');
// })->middleware(['auth', 'verified'])->name('dashboard');




Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::get('/dashboard', function (): mixed{return view('dashboard');})->name('dashboard.index');
    Route::get('/profile', function (): mixed{return view('profile.index');})->name('profile.index');
    Route::get('/report', function (): mixed{return view('report.index');})->name('report.index');
    Route::get('/report-attendance', function (): mixed{return view('report.attendance');})->name('report.attendance');
    Route::get('/report-booking', function (): mixed{return view('report.booking');})->name('report.booking');
    Route::get('/report-usage', function (): mixed{return view('report.usage');})->name('report.usage');




    // User
    // Route::get('/user-create', function (): mixed{return view('user.ref_create_user');})->name('user.create');
    // Route::get('/user-index', function (): mixed{return view('user.ref_update_password');})->name('user.index');
    // Route::get('/user-index2', function (): mixed{return view('user.ref_update_user_image_by_id');})->name('user.index2');
    // Route::get('/user-disable', function (): mixed{return view('user.ref_disable_user_by_id');})->name('user.disable');
    // Route::get('/user-enable', function (): mixed{return view('user.ref_enable_user_by_id');})->name('user.enable');

    // Room
    // Route::get('/room-create', function (): mixed{return view('room.ref_create_room');});
    // Route::get('/room-update', function (): mixed{return view('room.ref_update_room_by_id');});
    // Route::get('/room-delete', function (): mixed{return view('room.ref_delete_user_by_id');});
    // Route::get('/room-upload-room-image', function (): mixed{return view('room.ref_upload_room_image_by_id');});

    // Class
    // Route::get('/class-create', function (): mixed{return view('class.ref_create_class');});
    // Route::get('/class-update', function (): mixed{return view('class.ref_update_class_by_id');});
    // Route::get('/class-delete', function (): mixed{return view('class.ref_delete_class_by_id');});
    // Route::get('/class-recreate', function (): mixed{return view('class.ref_recreate_class_by_id');});
    // Route::get('/class-approve', function (): mixed{return view('class.ref_approve_class_by_id');});

    // Group
    // Route::get('/group-create', function (): mixed{return view('group.ref_create_group');});
    // Route::get('/group-update', function (): mixed{return view('group.ref_update_group_by_id');});
    // Route::get('/group-recreate', function (): mixed{return view('group.ref_recreate_group_by_id');});
    // Route::get('/group-delete', function (): mixed{return view('group.ref_delete_group_by_id');});
    // Route::get('/group-add-students', function (): mixed{return view('group.ref_add_students_group_by_id');});

    // Setting - general, announcement, building, level, holiday, smtp, device, hcp, db
    // Route::get('/general-update', function (): mixed{return view('setting.ref_update_general');});
    // Route::get('/announcement-create', function (): mixed{return view('setting.ref_create_announcement');});
    // Route::get('/announcement-update', function (): mixed{return view('setting.ref_update_announcement_by_id');});
    // Route::get('/announcement-delete', function (): mixed{return view('setting.ref_delete_announcement_by_id');});
    // Route::get('/building-create', function (): mixed{return view('setting.ref_create_building');});
    // Route::get('/building-update', function (): mixed{return view('setting.ref_update_building_by_id');});
    // Route::get('/building-delete', function (): mixed{return view('setting.ref_delete_building_by_id');});
    // Route::get('/level-create', function (): mixed{return view('setting.ref_create_level');});
    // Route::get('/level-update', function (): mixed{return view('setting.ref_update_level_by_id');});
    // Route::get('/level-delete', function (): mixed{return view('setting.ref_delete_level_by_id');});
    // Route::get('/holiday-create', function (): mixed{return view('setting.ref_create_holiday');});
    // Route::get('/holiday-update', function (): mixed{return view('setting.ref_update_holiday_by_id');});
    // Route::get('/holiday-delete', function (): mixed{return view('setting.ref_delete_holiday_by_id');});
    // Route::get('/smtp-update', function (): mixed{return view('setting.ref_update_smtp');});
    // Route::get('/device-create', function (): mixed{return view('setting.ref_create_device');});
    // Route::get('/device-update', function (): mixed{return view('setting.ref_update_device_by_id');});
    // Route::get('/device-delete', function (): mixed{return view('setting.ref_delete_device_by_id');});
    // Route::get('/hcp-update', function (): mixed{return view('setting.ref_update_hcp');});
    // Route::get('/db-update', function (): mixed{return view('setting.ref_update_db');});


    Route::get('/user', [UserController::class, 'index'])->name('user.index');
    Route::prefix('/user')->group(function(){
        Route::post('/create-user', [UserController::class, 'create_user'])->name('user.create-user');
        Route::post('/create-user-excel', [UserController::class, 'create_user_excel'])->name('user.create-user-excel');
        Route::patch('/update-user/{id}', [UserController::class, 'update_user_by_id'])->name('user.update-user-by-id');
        Route::patch('/update-user', [UserController::class, 'update_user'])->name('user.update-user');
        Route::patch('/update-password/{id}', [UserController::class, 'update_password_by_id'])->name('user.update-password-by-id');
        Route::patch('/update-password', [UserController::class, 'update_password'])->name('user.update-password');
        Route::patch('/disable-user/{id}', [UserController::class, 'disable_user_by_id'])->name('user.disable-user-by-id');
        Route::patch('/enable-user/{id}', [UserController::class, 'enable_user_by_id'])->name('user.enable-user-by-id');
        Route::delete('/delete-user/{id}', [UserController::class, 'delete_user_by_id'])->name('user.delete-user-by-id');
        Route::patch('/update-user-image/{id}', [UserController::class, 'update_user_image_by_id'])->name('user.update-user-image-by-id');
    });

    Route::get('/room', [RoomController::class, 'index'])->name('room.index');
    Route::prefix('/room')->group(function(){
        Route::post('/create-room', [RoomController::class, 'create_room'])->name('room.create-room');
        Route::patch('/update-room/{id}', [RoomController::class, 'update_room_by_id'])->name('room.update-room-by-id');
        Route::delete('/delete-room/{id}', [RoomController::class, 'delete_room_by_id'])->name('room.delete-room-by-id');
        Route::post('/upload-room-image/{id}', [RoomController::class, 'upload_room_image_by_id'])->name('room.upload-room-image-by-id');
        Route::patch('/update-room-image/{id}', [RoomController::class, 'update_room_image_by_id'])->name('room.update-room-image-by-id');
    });

    Route::get('/class', [ClassController::class, 'index'])->name('class.index');
    Route::prefix('/class')->group(function(){
        Route::post('/create-class', [ClassController::class, 'create_class'])->name('class.create-class');
        Route::patch('/update-class/{id}', [ClassController::class, 'update_class_by_id'])->name('class.update-class-by-id');
        Route::post('/recreate-class/{id}', [ClassController::class, 'recreate_class_by_id'])->name('class.recreate-class-by-id');
        Route::delete('/delete-class/{id}', [ClassController::class, 'delete_class_by_id'])->name('class.delete-class-by-id');
        Route::patch('/approve-class/{id}', [ClassController::class, 'approve_class_by_id'])->name('class.approve-class-by-id');
    });

    Route::get('/group', [GroupController::class, 'index'])->name('group.index');
    Route::prefix('/group')->group(function(){
        Route::post('/create-group', [GroupController::class, 'create_group'])->name('group.create-group');
        Route::patch('/update-group/{id}', [GroupController::class, 'update_group_by_id'])->name('group.update-group-by-id');
        Route::post('/recreate-group/{id}', [GroupController::class, 'recreate_group_by_id'])->name('group.recreate-group-by-id');
        Route::delete('/delete-group/{id}', [GroupController::class, 'delete_group_by_id'])->name('group.delete-group-by-id');
        Route::patch('/add-students-group/{id}}', [GroupController::class, 'add_students_group_by_id'])->name('group.add-students-group-by-id');
    });

    Route::get('/setting', [SettingController::class, 'index'])->name('setting.index');
    Route::prefix('/setting')->group(function(){
        Route::patch('/update-general', [SettingController::class, 'update_general'])->name('setting.update-general');
        
        Route::prefix('/announcement')->group(function(){
            Route::post('/create-announcement', [SettingController::class, 'create_announcement'])->name('setting.create-announcement');
            Route::patch('/update-announcement/{id}', [SettingController::class, 'update_announcement_by_id'])->name('setting.update-announcement-by-id');
            Route::delete('/delete-announcement/{id}', [SettingController::class, 'delete_announcement_by_id'])->name('setting.delete-announcement-by-id');
        });

        Route::prefix('/faculty')->group(function(){
            Route::post('/create-faculty', [SettingController::class, 'create_faculty'])->name('setting.create-faculty');
            Route::patch('/update-faculty/{id}', [SettingController::class, 'update_faculty_by_id'])->name('setting.update-faculty-by-id');
            Route::delete('/delete-faculty/{id}', [SettingController::class, 'delete_faculty_by_id'])->name('setting.delete-faculty-by-id');
        });

        Route::prefix('/building')->group(function(){
            Route::post('/create-building', [SettingController::class, 'create_building'])->name('setting.create-building');
            Route::patch('/update-building/{id}', [SettingController::class, 'update_building_by_id'])->name('setting.update-building-by-id');
            Route::delete('/delete-building/{id}', [SettingController::class, 'delete_building_by_id'])->name('setting.delete-building-by-id');
        });
        
        Route::prefix('/level')->group(function(){
            Route::post('/create-level', [SettingController::class, 'create_level'])->name('setting.create-level');
            Route::patch('/update-level/{id}', [SettingController::class, 'update_level_by_id'])->name('setting.update-level-by-id');
            Route::delete('/delete-level/{id}', [SettingController::class, 'delete_level_by_id'])->name('setting.delete-level-by-id');
        });

        Route::prefix('/holiday')->group(function(){
            Route::post('/create-holiday', [SettingController::class, 'create_holiday'])->name('setting.create-holiday');
            Route::patch('/update-holiday/{id}', [SettingController::class, 'update_holiday_by_id'])->name('setting.update-holiday-by-id');
            Route::delete('/delete-holiday/{id}', [SettingController::class, 'delete_holiday_by_id'])->name('setting.delete-holiday-by-id');
        });

        Route::patch('/update-smtp', [SettingController::class, 'update_smtp'])->name('setting.update-smtp');

        Route::prefix('/device')->group(function(){
            Route::post('/create-device', [SettingController::class, 'create_device'])->name('setting.create-device');
            Route::patch('/update-device/{id}', [SettingController::class, 'update_device_by_id'])->name('setting.update-device-by-id');
            Route::delete('/delete-device/{id}', [SettingController::class, 'delete_device_by_id'])->name('setting.delete-device-by-id');
        });

        Route::patch('/update-hcp', [SettingController::class, 'update_hcp'])->name('setting.update-hcp');
        Route::patch('/update-db', [SettingController::class, 'update_db'])->name('setting.update-db');
    });



    Route::post('/get-person-list', [HCPController::class, 'get_person_list'])->name('hcp.get_person_list');
    Route::post('/get-door-event', [HCPController::class, 'get_door_event'])->name('hcp.get_door_event');
    Route::post('/add-person', [HCPController::class, 'add_person'])->name('hcp.add_person');

    Route::post('/artemis/api/resource/v1/acsDoor/acsDoorList', function (Request $request) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $appKey = env('HIKCENTRAL_APP_KEY');
        $appSecret = env('HIKCENTRAL_APP_SECRET');
        $method = 'POST';
        $contentType = 'application/json';
        $date = Carbon::now('GMT')->format('D, d M Y H:i:s \G\M\T');
        $uri = '/artemis/api/resource/v1/acsDoor/acsDoorList';
        $body = json_encode([
            "pageNo" => 1,
            "pageSize" => 2
        ]);

        // Generate Content-MD5
        $contentMd5 = base64_encode(md5($body, true));

        // Create the string to sign
        $stringToSign = "{$method}\n" .
                        "*/*\n" .
                        "{$contentMd5}\n" .
                        "{$contentType}\n" .
                        "{$date}\n" .
                        "x-ca-key:{$appKey}\n" .
                        "x-ca-timestamp:" . now()->timestamp * 1000 . "\n" .
                        $uri;

        // Generate the HmacSHA256 signature
        $signature = base64_encode(hash_hmac('sha256', $stringToSign, $appSecret, true));
        
        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, [
                'headers' => [
                    'Accept' => '*/*',
                    'Content-MD5' => $contentMd5,
                    'Content-Type' => $contentType,
                    'Date' => $date,
                    'X-Ca-Key' => $appKey,
                    'X-Ca-Signature' => $signature,
                    'X-Ca-Timestamp' => now()->timestamp * 1000,
                    'X-Ca-Signature-Headers' => 'x-ca-key,x-ca-timestamp',
                ],
                'body' => $body,
            ]);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    });

    Route::post('/artemis/api/acs/v1/privilege/group/single/addPersons', function (Request $request) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $appKey = env('HIKCENTRAL_APP_KEY');
        $appSecret = env('HIKCENTRAL_APP_SECRET');
        $method = 'POST';
        $contentType = 'application/json';
        $date = Carbon::now('GMT')->format('D, d M Y H:i:s \G\M\T');
        $uri = '/artemis/api/acs/v1/privilege/group/single/addPersons';
        
        $body = json_encode([
            "privilegeGroupId" => '1',
            "type" => 1,
            "list" => [
                [
                    "id" => '57'
                ]
            ],
        ]);

        // Generate Content-MD5
        $contentMd5 = base64_encode(md5($body, true));

        // Create the string to sign
        $stringToSign = "{$method}\n" .
                        "*/*\n" .
                        "{$contentMd5}\n" .
                        "{$contentType}\n" .
                        "{$date}\n" .
                        "x-ca-key:{$appKey}\n" .
                        "x-ca-timestamp:" . now()->timestamp * 1000 . "\n" .
                        $uri;

        // Generate the HmacSHA256 signature
        $signature = base64_encode(hash_hmac('sha256', $stringToSign, $appSecret, true));
        
        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, [
                'headers' => [
                    'Accept' => '*/*',
                    'Content-MD5' => $contentMd5,
                    'Content-Type' => $contentType,
                    'Date' => $date,
                    'X-Ca-Key' => $appKey,
                    'X-Ca-Signature' => $signature,
                    'X-Ca-Timestamp' => now()->timestamp * 1000,
                    'X-Ca-Signature-Headers' => 'x-ca-key,x-ca-timestamp',
                ],
                'body' => $body,
            ]);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    });

    Route::post('/artemis/api/acs/v1/privilege/group/single/deletePersons', function (Request $request) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $appKey = env('HIKCENTRAL_APP_KEY');
        $appSecret = env('HIKCENTRAL_APP_SECRET');
        $method = 'POST';
        $contentType = 'application/json';
        $date = Carbon::now('GMT')->format('D, d M Y H:i:s \G\M\T');
        $uri = '/artemis/api/acs/v1/privilege/group/single/deletePersons';
        
        $body = json_encode([
            "privilegeGroupId" => '1',
            "type" => 1,
            "list" => [
                [
                    "id" => '57'
                ]
            ],
        ]);

        // Generate Content-MD5
        $contentMd5 = base64_encode(md5($body, true));

        // Create the string to sign
        $stringToSign = "{$method}\n" .
                        "*/*\n" .
                        "{$contentMd5}\n" .
                        "{$contentType}\n" .
                        "{$date}\n" .
                        "x-ca-key:{$appKey}\n" .
                        "x-ca-timestamp:" . now()->timestamp * 1000 . "\n" .
                        $uri;

        // Generate the HmacSHA256 signature
        $signature = base64_encode(hash_hmac('sha256', $stringToSign, $appSecret, true));
        
        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, [
                'headers' => [
                    'Accept' => '*/*',
                    'Content-MD5' => $contentMd5,
                    'Content-Type' => $contentType,
                    'Date' => $date,
                    'X-Ca-Key' => $appKey,
                    'X-Ca-Signature' => $signature,
                    'X-Ca-Timestamp' => now()->timestamp * 1000,
                    'X-Ca-Signature-Headers' => 'x-ca-key,x-ca-timestamp',
                ],
                'body' => $body,
            ]);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    });

    Route::post('/artemis/api/acs/v1/privilege/group', function (Request $request) {
        $client = new \GuzzleHttp\Client([
            'verify' => false, // Disable SSL verification
        ]);
        $appKey = env('HIKCENTRAL_APP_KEY');
        $appSecret = env('HIKCENTRAL_APP_SECRET');
        $method = 'POST';
        $contentType = 'application/json';
        $date = Carbon::now('GMT')->format('D, d M Y H:i:s \G\M\T');
        $uri = '/artemis/api/acs/v1/privilege/group';
        $body = json_encode([
            'pageNo' => 1,
            'pageSize' => 100,
            'type' => 1
        ]);

        // Generate Content-MD5
        $contentMd5 = base64_encode(md5($body, true));

        // Create the string to sign
        $stringToSign = "{$method}\n" .
                        "*/*\n" .
                        "{$contentMd5}\n" .
                        "{$contentType}\n" .
                        "{$date}\n" .
                        "x-ca-key:{$appKey}\n" .
                        "x-ca-timestamp:" . now()->timestamp * 1000 . "\n" .
                        $uri;

        // Generate the HmacSHA256 signature
        $signature = base64_encode(hash_hmac('sha256', $stringToSign, $appSecret, true));
        
        try {
            $response = $client->post(env('HIKCENTRAL_API_BASE_URL') . $uri, [
                'headers' => [
                    'Accept' => '*/*',
                    'Content-MD5' => $contentMd5,
                    'Content-Type' => $contentType,
                    'Date' => $date,
                    'X-Ca-Key' => $appKey,
                    'X-Ca-Signature' => $signature,
                    'X-Ca-Timestamp' => now()->timestamp * 1000,
                    'X-Ca-Signature-Headers' => 'x-ca-key,x-ca-timestamp',
                ],
                'body' => $body,
            ]);
    
            $data = json_decode($response->getBody(), true);
            return response()->json($data);
    
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return response()->json(['error' => 'Request failed'], 500);
        }
    });
});

// Route::prefix('boss')->middleware(['auth','isBoss'])->group(function(){
// });

require __DIR__.'/auth.php';
