

<?php $__env->startPush('style'); ?>
    <style>
        #class-option-dropdown-button { transition: 0.3s }
        #class-option-dropdown-button.active { background-color: #00000088; }
        .class-header { border-bottom: 3px solid #00000000; transition:0.3s; cursor:pointer }
        .class-header.active { color:var(--plt2); border-bottom: 3px solid var(--plt2); }
        .class-header:hover { color:var(--plt2) }
        .class-tab { display:none }
        .class-tab.active { display:block }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('classes-button', 'active'); ?>

<?php $__env->startSection('header'); ?>
    <?php $visible = 'visibility:hidden;' ?>
    <?php if(Auth::user()->type == 'Administrator' || Auth::user()->type == 'Management' || Auth::user()->type == 'Lecturer' || Auth::user()->type == 'Student Lead'): ?>
        <?php $visible = 'visibility:visible;' ?>
    <?php endif; ?>

    <div class="d-flex h-100p" id="nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs1 fw-bold cursor-default">Classes</div>
        <div class="d-flex-center">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;">
                <span class="material-symbols-outlined b fs-20 mg-r-5">filter_alt</span>
                <div>Filter</div>
            </div>
        </div>
        <div class="d-flex-center" style="<?php echo e($visible); ?>">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" onclick="open_popup_click('add-class-popup')">
                <span class="material-symbols-outlined b fs-20 mg-r-5">add</span>
                <div>Add</div>
            </div>
        </div>
    </div>

    <?php $visible = 'visibility:hidden;' ?>
    <?php if(Auth::user()->type == 'Administrator' || Auth::user()->type == 'Management' || Auth::user()->type == 'Lecturer'): ?>
        <?php $visible = 'visibility:visible;' ?>
    <?php endif; ?>

    <div class="d-none" id="class-nav-button" >
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold clr-blue clr-blue-hv txt-u-hv cursor-pointer" onclick="back_click()">Back</div>
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold cursor-default" id="class-name-header"></div>
        <div class="d-flex-center" style="<?php echo e($visible); ?>">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" id="edit-class-button">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">edit</span>
                <div>Edit</div>
            </div>
        </div>
        <div class="h-100p" style="position:relative; <?php echo e($visible); ?>">
            <div class="d-flex-center h-100p">
                <div id="class-option-dropdown-button" class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;">
                    <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">list</span>
                    <div>Option</div>
                </div>
            </div>
            <div class="dropdown w-180 cursor-pointer" id="class-option-dropdown" style="position:absolute;">
                <div class="option" id="recreate-class-button">
                    <div class="fs3 clr-black-2 fw-bold">Recreate Class</div>
                    <div class="fs4 clr-grey-2 fw-bold">Recreate same class</div>
                </div>
                <div class="option pd-b-10" id="delete-class-button">
                    <div class="fs3 clr-black-2 fw-bold">Delete Class</div>
                    <div class="fs4 clr-grey-2 fw-bold">Remove this class from the system</div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main-body'); ?>
    <div id="main">
        <?php
            $classes = App\Models\Classes::all();
            $groups = App\Models\Groups::all();
            $rooms = App\Models\Rooms::all();
        ?> 
        <table class="table w-100p">
            <tr>
                <th></th>
                <th>Title</th>
                <th>Lecturer</th>
                <th>Room</th>
                <th>Start</th>
                <th>End</th>
                <th>Group</th>
                <th>Status</th>
            </tr>

            <?php $count = 1; ?>
            <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(Auth::user()->type == 'Lecturer' || Auth::user()->type == 'Student Lead' || Auth::user()->type == 'Student'): ?>
                    <?php 
                    ?>
                    <?php if($class->group->group_user->where('user_id', Auth::user()->id) == '[]'): ?>
                        <?php break; ?>
                    <?php endif; ?>
                <?php endif; ?>
                <tr>
                    <td style="width:0px">
                        <div class="d-flex-center">
                            <div class="bg-plt1-tr2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4"><?php echo e($count); ?></div>
                        </div>
                    </td>
                    <td>
                        <div class="cursor-pointer clr-blue-hv txt-u-hv tw-nowrap fs-12 clr-grey-1" onclick="class_click(<?php echo e($class->id); ?>, `<?php echo e($class->title); ?>`)">
                            <?php echo e($class->title); ?>

                        </div>
                    </td>
                    <td>
                        <div class="tw-nowrap fs-12 clr-grey-1">
                            <?php $__currentLoopData = $class->group->group_user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class_user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($class_user->user->type == 'Lecturer'): ?>
                                    <?php $lecturer = $class_user->user; ?>
                                    <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($lecturer->full_name); ?></div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                    <td>
                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($class->room->name); ?></div>
                    </td>
                    <td>
                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e(Carbon\Carbon::parse($class->start_date_time, 'Asia/Kuala_Lumpur')->format('d M Y h:i A')); ?></div>
                    </td>
                    <td>
                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e(Carbon\Carbon::parse($class->end_date_time, 'Asia/Kuala_Lumpur')->format('d M Y h:i A')); ?></div>
                    </td>
                    <td>
                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($class->group->name); ?></div>
                    </td>
                    <td>
                        <?php if($class->approval_by_id == ''): ?>
                            <div class="tw-nowrap fs-12 clr-yellow fw-bold br-5 bg-gold-2 w-mc pd-5">Pending</div>
                        <?php else: ?>
                            <div class="tw-nowrap fs-12 clr-green fw-bold br-5 bg-green-2 w-mc pd-5"><?php echo e($class->approval_by_id); ?></div>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php $count += 1; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>
    </div>

    <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <form id="delete-class-<?php echo e($class->id); ?>-form" class="d-none" action="<?php echo e(route('class.delete-class-by-id',['id' => $class->id])); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
        </form>

        <div class="w-100p h-100p pd-t-20 d-none" id="class-<?php echo e($class->id); ?>">
            <?php 
                $group_users = App\Models\GroupUser::where('group_id', $class->group->id)->get();
            ?>
            <div class="w-100p h-100p d-flex cursor-default">
                <div class="w-400 h-500 f-shrink-0">
                    <div class="d-flex pd-b-10 fw-wrap">
                    <?php $__currentLoopData = $group_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group_user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php 
                            $user = $group_user->user; 
                            if ($user->type != 'Lecturer') { break; }
                            $lecturer = $user;
                        ?>
                        <div class="d-flex pd-tb-5 pd-r-10">
                            <div class="">
                                <?php if($lecturer['image_path']): ?>
                                    <img src="<?php echo e(asset('storage' . $lecturer->image_path)); ?>" alt="" class="w-40 h-40 br-50p">
                                <?php else: ?>
                                    <img src="<?php echo e(asset('storage/system/avatar.png')); ?>" alt="" class="w-40 h-40 br-50p">
                                <?php endif; ?>
                            </div>
                            <div class="mg-l-10">
                                <div class="clr-black-2 fw-bold fs3"><?php echo e($lecturer->full_name); ?></div>
                                <div class="fs3 clr-grey-2 fw-bold"><?php echo e($lecturer->email); ?></div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    
                    <div class="mg-b-20">
                        <div class="clr-black-2 fw-bold fs3">Title</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e($class->title); ?></div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-black-2 fw-bold fs3">Description</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e($class->description); ?></div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-black-2 fw-bold fs3">Room</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e($class->room->name); ?></div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-black-2 fw-bold fs3">Start</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e(Carbon\Carbon::parse($class->start_date_time)->format('d M Y H:i A')); ?></div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-black-2 fw-bold fs3">End</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e(Carbon\Carbon::parse($class->end_date_time)->format('d M Y H:i A')); ?></div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-black-2 fw-bold fs3">Group</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e($class->group->name); ?></div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-black-2 fw-bold fs3 mg-b-5">Status</div>
                        <?php if($class->status == 'Approved'): ?>
                            <div class="tw-nowrap fs3 clr-green fw-bold br-5 bg-green-2 w-mc pd-5"><?php echo e($class->status); ?></div>
                        <?php else: ?>
                            <div class="tw-nowrap fs3 clr-yellow fw-bold br-5 bg-gold-2 w-mc pd-5"><?php echo e($class->status); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mg-b-20 mg-t-60">
                        <div class="clr-black-2 fw-bold fs3">Approved By</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e($class->approval_user); ?>null</div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-black-2 fw-bold fs3">Date Time</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e($class->approval_date_time); ?>null</div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-black-2 fw-bold fs3">Remark</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e($class->approval_remark); ?>null</div>
                    </div>
                </div>
                <div class="w-1 h-100p mg-lr-30" style="background-color:#00000022"></div>
                <div class="w-100p d-flex fd-column">
                    <div class="d-flex f-shrink-0 pd-tb-10">
                        <div class="fw-bold fs2 clr-grey-2">Attendance</div>
                    </div>
                    <div class="h-100p">
                        <div class="of-auto w-100p bs-bb h-100p pd-10">
                            
                                <?php $count = 1; ?>              
                                <?php $__currentLoopData = $class->group->group_user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group_user_class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($group_user_class->user->type == 'Student' || $group_user_class->user->type == 'Student Lead'): ?>
                                        <div class="d-flex pd-tb-10 pd-lr-10 bg-blue-hv" style="border-bottom: 1px solid #bec3d055;">
                                            <div class="d-flex-center">
                                                <div class="bg-plt1-tr2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4 mg-r-40"><?php echo e($count); ?></div>
                                            </div>
                                            <div class="d-flex option ai-center" id="student-<?php echo e($group_user_class->id); ?>-<?php echo e($class->id); ?>">
                                                <div class="d-flex w-100p ai-center cursor-default">
                                                    <div>
                                                        <?php if($group_user_class->user['image_path']): ?>
                                                            <img src="<?php echo e(asset('storage' . $group_user_class->user->image_path)); ?>" alt="" class="w-35 h-35 br-50p">
                                                        <?php else: ?>
                                                            <img src="<?php echo e(asset('storage/system/avatar.png')); ?>" alt="" class="w-35 h-35 br-50p">
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="mg-l-10">
                                                        <div class="lecturer-name fw-bold fs3"><?php echo e($group_user_class->user->full_name); ?></div>
                                                        <div class="fs4 clr-grey-2 fw-bold"><?php echo e($group_user_class->user->email); ?></div>
                                                    </div>
                                                </div>
                                            </div>

                                            <?php
                                                $attendance = $group_user_class->user->attendances->where('class_id', $class->id);
                                            ?>
                                            <?php if(!$attendance->isEmpty()): ?>
                                                <div class="d-flex-center fs-12 mg-l-20 clr-grey-1">
                                                    <div><?php echo e(Carbon\Carbon::parse($attendance->first()->check_date_time)->format('d M Y g:ia')); ?></div>
                                                </div>
                                                <div class="d-flex-center mg-l-20">
                                                    <div class="clr-green bg-green-2 pd-5 fs-12 fw-bold br-5">Attend</div>
                                                </div>
                                            <?php else: ?>
                                                <div class="d-flex-center fs-12 mg-l-20 clr-grey-1">
                                                    <div>No record found</div>
                                                </div>
                                                <div class="d-flex-center mg-l-20">
                                                    <div class="clr-white bg-red pd-5 fs-12 fw-bold br-5">Absent</div>
                                                </div>
                                                
                                            <?php endif; ?>
                                            
                                        </div>
                                    <?php $count += 1; ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div> 
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-box'); ?>
    <div id="add-class-popup" class="right-popup bg-white w-600 h-100p">
        <form action="<?php echo e(route('class.create-class')); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('POST'); ?>
            <div class="content w-100p of-auto cursor-default" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">New Class</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-30">Title <span style="color:red;">*</span></div>
                    <input type="text" name="title" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Description</div>
                    <textarea class="textarea w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text" style="font-family:Arial, Helvetica, sans-serif; max-width:300px; min-width:300px;" name="description" rows="4"></textarea>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Room <span style="color:red;">*</span></div>
                    <input id="class-room-dropdown-input" type="hidden" name="room_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                    <div id="class-room-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"></div>
                    <div id="class-room-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                        <div class="d-flex">
                            <input type="text" name="" id="class-room-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                        <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'class-room-dropdown-button', 'class-room-dropdown-input', <?php echo e($room->id); ?>, 'class-room-dropdown')" style="border:none;"><?php echo e($room->name); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Date <span style="color:red;">*</span></div>
                    <input type="date" id="class_start_date" name="start_date" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Time <span style="color:red;">*</span></div>
                    <input id="start_time" type="hidden" name="start_time" value="08:00:00" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                    <div class="d-flex h-30 mg-t-5">
                        <div class="w-96 mg-r-5 cursor-pointer">
                            <div id="start-hour-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb clr-black-2">08</div>
                            <div id="start-hour-dropdown" class="dropdown w-96 h-145 of-auto">
                                <?php for($i = 1; $i <= 12; $i++): ?>
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-hour-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('hour', <?php echo e($i); ?>, 'start_time')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                <?php endfor; ?>
                            </div>
                        </div>
                        <div class="w-96 mg-r-5 cursor-pointer">
                            <div id="start-minute-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2">00</div>
                            <div id="start-minute-dropdown" class="dropdown w-96 h-145 of-auto">
                                <?php for($i = 0; $i <= 59; $i++): ?>
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-minute-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('minute', <?php echo e($i); ?>, 'start_time')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                <?php endfor; ?>
                            </div>
                        </div>
                        <div class="w-96 mg-r-5 cursor-pointer">
                            <div id="start-phase-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2">AM</div>
                            <div id="start-phase-dropdown" class="dropdown w-96 h-50 of-auto">
                                <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-phase-dropdown-button').textContent = 'AM'; time_click('phase', 'AM', 'start_time')">AM</div>
                                <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-phase-dropdown-button').textContent = 'PM'; time_click('phase', 'PM', 'start_time')">PM</div>
                            </div>
                        </div>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">End Date <span style="color:red;">*</span></div>
                    <input type="date" id="class_end_date" name="end_date" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">End Time <span style="color:red;">*</span></div>
                    <input id="end_time" type="hidden" name="end_time" value="08:30:00" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                    <div class="d-flex h-30 mg-t-5">
                        <div class="w-96 mg-r-5 cursor-pointer">
                            <div id="end-hour-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2">08</div>
                            <div id="end-hour-dropdown" class="dropdown w-96 h-145 of-auto">
                                <?php for($i = 1; $i <= 12; $i++): ?>
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-hour-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('hour', <?php echo e($i); ?>, 'end_time')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                <?php endfor; ?>
                            </div>
                        </div>
                        <div class="w-96 mg-r-5 cursor-pointer">
                            <div id="end-minute-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2">30</div>
                            <div id="end-minute-dropdown" class="dropdown w-96 h-145 of-auto">
                                <?php for($i = 0; $i <= 59; $i++): ?>
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-minute-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('minute', <?php echo e($i); ?>, 'end_time')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                <?php endfor; ?>
                            </div>
                        </div>
                        <div class="w-96 mg-r-5 cursor-pointer">
                            <div id="end-phase-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2">AM</div>
                            <div id="end-phase-dropdown" class="dropdown w-96 h-50 of-auto">
                                <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-phase-dropdown-button').textContent = 'AM'; time_click('phase', 'AM', 'end_time')">AM</div>
                                <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-phase-dropdown-button').textContent = 'PM'; time_click('phase', 'PM', 'end_time')">PM</div>
                            </div>
                        </div>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Group <span style="color:red;">*</span></div>
                    <input id="class-group-dropdown-input" type="hidden" name="group_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">
                    <div id="class-group-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"></div>
                    <div id="class-group-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                        <div class="d-flex">
                            <input type="text" name="" id="class-group-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                        <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'class-group-dropdown-button', 'class-group-dropdown-input', <?php echo e($group->id); ?>, 'class-group-dropdown')" style="border:none;"><?php echo e($group->name); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Repeat Type <span style="color:red;">*</span></div>
                    <input id="class-type-dropdown-input" type="hidden" name="repeat_type" value="Once" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">
                    <div id="class-type-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">Once</div>
                    <div class="dropdown w-300 cursor-pointer" id="class-type-option-dropdown" style="position:absolute;">
                        <div class="option" id="once-option">
                            <div class="fs3 clr-grey-1" onclick="dropdown_option_input_click(this, 'class-type-dropdown-button', 'class-type-dropdown-input', 'Once', 'class-type-option-dropdown'); hideRepeatUntil()">Once</div>
                        </div>
                        <div class="option pd-b-10" id="weekly-option">
                            <div class="fs3 clr-grey-1" onclick="dropdown_option_input_click(this, 'class-type-dropdown-button', 'class-type-dropdown-input', 'Weekly', 'class-type-option-dropdown'); showRepeatUntil(); setRepeatUntil(2, 0);">Weekly</div>
                        </div>
                        <div class="option pd-b-10" id="monthly-option">
                            <div class="fs3 clr-grey-1" onclick="dropdown_option_input_click(this, 'class-type-dropdown-button', 'class-type-dropdown-input', 'Monthly', 'class-type-option-dropdown'); showRepeatUntil(); setRepeatUntil(0, 2);">Monthly</div>
                        </div>
                    </div>

                    <div id="repeat-until-section" class="d-none">
                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Repeat until <span style="color:red;">*</span></div>
                        <input id="repeat-until-input" type="date" name="repeat_until" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                    </div>
                    
                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                    <button type="button" onclick="close_popup_click('add-class-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>

    
    <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div id="edit-class-<?php echo e($class->id); ?>-popup" class="right-popup bg-white w-600 h-100p">
            <form action="<?php echo e(route('class.update-class-by-id', ['id' => $class->id])); ?>" method="POST" enctype="multipart/form-data" class="h-100p w-100p">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            
                <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                    <div class="h-100p pd-30 bs-bb cursor-default">
                        <div class="fs-18 clr-grey-2 fw-bold">Edit Class</div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Title <span style="color:red;">*</span></div>
                        <input type="text" name="title" value="<?php echo e($class->title); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                                                
                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Description </div>
                        <textarea class="textarea w-300 clr-grey-1 mg-t-5 pd-5 bs-bb cursor-text" style="font-family:Arial, Helvetica, sans-serif; max-width:300px; min-width:300px;" name="description" rows="5"><?php echo e($class->description); ?></textarea>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Room <span style="color:red;">*</span></div>
                        <input id="class-room-<?php echo e($class->id); ?>-dropdown-input" type="hidden" name="room_id" value="<?php echo e($class->room->id); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                        <div id="class-room-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"><?php echo e($class->room->name); ?></div>
                        <div id="class-room-<?php echo e($class->id); ?>-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                            <div class="d-flex">
                                <input type="text" name="" id="class-room-<?php echo e($class->id); ?>-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                            </div>
                            <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'class-room-<?php echo e($class->id); ?>-dropdown-button', 'class-room-<?php echo e($class->id); ?>-dropdown-input', <?php echo e($room->id); ?>, 'class-room-<?php echo e($class->id); ?>-dropdown')" style="border:none;"><?php echo e($room->name); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Date <span style="color:red;">*</span></div>
                        <input id="edit_class_start_date" type="date" name="start_date" value="<?php echo e(\Carbon\Carbon::parse($class->start_date_time)->format('Y-m-d')); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Time <span style="color:red;">*</span></div>
                        <input id="start_time-<?php echo e($class->id); ?>" type="hidden" name="start_time" value="<?php echo e(\Carbon\Carbon::parse($class->start_date_time)->format('H:i:s')); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                        <div class="d-flex h-30 mg-t-5">
                            <div class="w-96 mg-r-5 cursor-pointer">
                                <div id="start-hour-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb clr-black-2"><?php echo e(\Carbon\Carbon::parse($class->start_date_time)->format('H')); ?></div>
                                <div id="start-hour-<?php echo e($class->id); ?>-dropdown" class="dropdown w-96 h-145 of-auto">
                                    <?php for($i = 1; $i <= 12; $i++): ?>
                                        <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-hour-<?php echo e($class->id); ?>-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('hour', <?php echo e($i); ?>, 'start_time-<?php echo e($class->id); ?>')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                            <div class="w-96 mg-r-5 cursor-pointer">
                                <div id="start-minute-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2"><?php echo e(\Carbon\Carbon::parse($class->start_date_time)->format('i')); ?></div>
                                <div id="start-minute-<?php echo e($class->id); ?>-dropdown" class="dropdown w-96 h-145 of-auto">
                                    <?php for($i = 0; $i <= 59; $i++): ?>
                                        <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-minute-<?php echo e($class->id); ?>-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('minute', <?php echo e($i); ?>, 'start_time-<?php echo e($class->id); ?>')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                            <div class="w-96 mg-r-5 cursor-pointer">
                                <div id="start-phase-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2"><?php echo e(\Carbon\Carbon::parse($class->start_date_time)->format('A')); ?></div>
                                <div id="start-phase-<?php echo e($class->id); ?>-dropdown" class="dropdown w-96 h-50 of-auto">
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-phase-<?php echo e($class->id); ?>-dropdown-button').textContent = 'AM'; time_click('phase', 'AM', 'start_time-<?php echo e($class->id); ?>')">AM</div>
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-phase-<?php echo e($class->id); ?>-dropdown-button').textContent = 'PM'; time_click('phase', 'PM', 'start_time-<?php echo e($class->id); ?>')">PM</div>
                                </div>
                            </div>
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">End Date <span style="color:red;">*</span></div>
                        <input id="edit_class_end_date" type="date" name="end_date" value="<?php echo e(\Carbon\Carbon::parse($class->end_date_time)->format('Y-m-d')); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">End Time <span style="color:red;">*</span></div>
                        <input id="end_time-<?php echo e($class->id); ?>" type="hidden" name="end_time" value="<?php echo e(\Carbon\Carbon::parse($class->end_date_time)->format('H:i:s')); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                        <div class="d-flex h-30 mg-t-5">
                            <div class="w-96 mg-r-5 cursor-pointer">
                                <div id="end-hour-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2"><?php echo e(\Carbon\Carbon::parse($class->end_date_time)->format('H')); ?></div>
                                <div id="end-hour-<?php echo e($class->id); ?>-dropdown" class="dropdown w-96 h-145 of-auto">
                                    <?php for($i = 1; $i <= 12; $i++): ?>
                                        <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-hour-<?php echo e($class->id); ?>-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('hour', <?php echo e($i); ?>, 'end_time-<?php echo e($class->id); ?>')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                            <div class="w-96 mg-r-5 cursor-pointer">
                                <div id="end-minute-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2"><?php echo e(\Carbon\Carbon::parse($class->end_date_time)->format('i')); ?></div>
                                <div id="end-minute-<?php echo e($class->id); ?>-dropdown" class="dropdown w-96 h-145 of-auto">
                                    <?php for($i = 0; $i <= 59; $i++): ?>
                                        <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-minute-<?php echo e($class->id); ?>-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('minute', <?php echo e($i); ?>, 'end_time-<?php echo e($class->id); ?>')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                            <div class="w-96 mg-r-5 cursor-pointer">
                                <div id="end-phase-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2"><?php echo e(\Carbon\Carbon::parse($class->end_date_time)->format('A')); ?></div>
                                <div id="end-phase-<?php echo e($class->id); ?>-dropdown" class="dropdown w-96 h-50 of-auto">
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-phase-<?php echo e($class->id); ?>-dropdown-button').textContent = 'AM'; time_click('phase', 'AM', 'end_time-<?php echo e($class->id); ?>')">AM</div>
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-phase-<?php echo e($class->id); ?>-dropdown-button').textContent = 'PM'; time_click('phase', 'PM', 'end_time-<?php echo e($class->id); ?>')">PM</div>
                                </div>
                            </div>
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Group <span style="color:red;">*</span></div>
                        <input id="class-group-<?php echo e($class->id); ?>-dropdown-input" type="hidden" name="group_id" value="<?php echo e($class->group->id); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">
                        <div id="class-group-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"><?php echo e($class->group->name); ?></div>
                        <div id="class-group-<?php echo e($class->id); ?>-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                            <div class="d-flex">
                                <input type="text" name="" id="class-group-<?php echo e($class->id); ?>-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                            </div>
                            <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'class-group-<?php echo e($class->id); ?>-dropdown-button', 'class-group-<?php echo e($class->id); ?>-dropdown-input', <?php echo e($group->id); ?>, 'class-group-<?php echo e($class->id); ?>-dropdown')" style="border:none;"><?php echo e($group->name); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div class="h-150"></div>
                        
                    </div>
                </div>

                <div class="submit-section h-80 w-100p">
                    <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                        <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Update</button>
                        <button type="button" onclick="close_popup_click('edit-class-<?php echo e($class->id); ?>-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        let class_id_opened;
        //to make sure the update/edit and recreate will stay on the page after submit the button, make sure to update your controller
        <?php if(session('updated_class_id')): ?>
            class_click(<?php echo e(session('updated_class_id')); ?>, `<?php echo e(App\Models\Classes::findOrFail(session('updated_class_id'))->name); ?>`);
        <?php endif; ?>

        add_dropdown_event('class-option-dropdown-button', 'class-option-dropdown');

        // add classes, room dropdown
        add_dropdown_event('class-room-dropdown-button','class-room-dropdown');
        add_search('class-room-search', 'class-room-dropdown');
        // add classes, group dropdown
        add_dropdown_event('class-group-dropdown-button','class-group-dropdown');
        add_search('class-group-search', 'class-group-dropdown');
        // add classes, repeat type dropdown
        add_dropdown_event('class-type-dropdown-button','class-type-option-dropdown');
        // add classes, start & end time dropdown
        add_dropdown_event('start-hour-dropdown-button','start-hour-dropdown');
        add_dropdown_event('start-minute-dropdown-button','start-minute-dropdown');
        add_dropdown_event('start-phase-dropdown-button','start-phase-dropdown');
        add_dropdown_event('end-hour-dropdown-button','end-hour-dropdown');
        add_dropdown_event('end-minute-dropdown-button','end-minute-dropdown');
        add_dropdown_event('end-phase-dropdown-button','end-phase-dropdown');

        <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            // edit classes, room dropdown
            add_dropdown_event('class-room-<?php echo e($class->id); ?>-dropdown-button','class-room-<?php echo e($class->id); ?>-dropdown');
            add_search('class-room-<?php echo e($class->id); ?>-search', 'class-room-<?php echo e($class->id); ?>-dropdown');
            // edit classes, group dropdown
            add_dropdown_event('class-group-<?php echo e($class->id); ?>-dropdown-button','class-group-<?php echo e($class->id); ?>-dropdown');
            add_search('class-group-<?php echo e($class->id); ?>-search', 'class-group-<?php echo e($class->id); ?>-dropdown');
            // edit classes, start & end time dropdown
            add_dropdown_event('start-hour-<?php echo e($class->id); ?>-dropdown-button','start-hour-<?php echo e($class->id); ?>-dropdown');
            add_dropdown_event('start-minute-<?php echo e($class->id); ?>-dropdown-button','start-minute-<?php echo e($class->id); ?>-dropdown');
            add_dropdown_event('start-phase-<?php echo e($class->id); ?>-dropdown-button','start-phase-<?php echo e($class->id); ?>-dropdown');
            add_dropdown_event('end-hour-<?php echo e($class->id); ?>-dropdown-button','end-hour-<?php echo e($class->id); ?>-dropdown');
            add_dropdown_event('end-minute-<?php echo e($class->id); ?>-dropdown-button','end-minute-<?php echo e($class->id); ?>-dropdown');
            add_dropdown_event('end-phase-<?php echo e($class->id); ?>-dropdown-button','end-phase-<?php echo e($class->id); ?>-dropdown');
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        function class_click(class_id, class_name) {
            document.getElementById(`class-${class_id}`).style.display = 'flex';
            document.getElementById('main').style.display = 'none';
            document.getElementById('nav-button').style.display = 'none';
            document.getElementById('class-nav-button').style.display = 'flex';
            
            document.getElementById('class-name-header').textContent = class_name;
            class_id_opened = class_id;

            document.getElementById('edit-class-button').onclick = function () { open_popup_click(`edit-class-${class_id}-popup`) }
            // document.getElementById('edit-class-button').onclick = function () { 
            //     open_popup_click(`edit-class-${class_id}-popup`);
            //     document.getElementById('class-option-dropdown-button').classList.remove('active');
            //     document.getElementById('class-option-dropdown').classList.remove('active');
            // }
            document.getElementById('delete-class-button').onclick = function () {
                if (confirm('Are you sure you want to delete this class?')) {
                    document.getElementById(`delete-class-${class_id}-form`).submit();
                }
            }
            document.getElementById('recreate-class-button').onclick = function () { 
                open_popup_click(`recreate-class-${class_id}-popup`);
                document.getElementById('class-option-dropdown-button').classList.remove('active');
                document.getElementById('class-option-dropdown').classList.remove('active');
            }
        }
        
        let startDateInput = document.getElementById('class_start_date');
        let endDateInput = document.getElementById('class_end_date');
        let repeatUntilInput = document.getElementById('repeat-until-input');

        // When start date changes, adjust end date if needed
        startDateInput.addEventListener('change', function() {
            let startDateValue = new Date(startDateInput.value);
            let endDateValue = new Date(endDateInput.value);
            repeatUntilInput.value = startDateInput.value;

            // If end date is earlier than start date, adjust end date
            if (startDateValue && (!endDateInput.value || startDateValue > endDateValue)) {
                endDateInput.value = startDateInput.value;
            }
        });

        // When end date changes, adjust start date if needed
        endDateInput.addEventListener('change', function() {
            let startDateValue = new Date(startDateInput.value);
            let endDateValue = new Date(endDateInput.value);

            // If start date is later than end date, adjust start date
            if (endDateValue && (!startDateInput.value || endDateValue < startDateValue)) {
                startDateInput.value = endDateInput.value;
            }
        });

        let startDateInputEdit = document.getElementById('edit_class_start_date');
        let endDateInputEdit = document.getElementById('edit_class_end_date');

        // When start date changes, adjust end date if needed
        startDateInputEdit.addEventListener('change', function() {
            let startDateValueEdit = new Date(startDateInputEdit.value);
            let endDateValueEdit = new Date(endDateInputEdit.value);

            // If end date is earlier than start date, adjust end date
            if (startDateValueEdit && (!endDateInputEdit.value || startDateValueEdit > endDateValueEdit)) {
                endDateInputEdit.value = startDateInputEdit.value;
            }
        });

        // When end date changes, adjust start date if needed
        endDateInputEdit.addEventListener('change', function() {
            let startDateValueEdit = new Date(startDateInputEdit.value);
            let endDateValueEdit = new Date(endDateInputEdit.value);

            // If start date is later than end date, adjust start date
            if (endDateValueEdit && (!startDateInputEdit.value || endDateValueEdit < startDateValueEdit)) {
                startDateInputEdit.value = endDateInputEdit.value;
            }
        });

        function back_click() {
            document.getElementById(`class-${class_id_opened}`).style.display = 'none';
            document.getElementById('main').style.display = 'block';
            document.getElementById('nav-button').style.display = 'flex';
            document.getElementById('class-nav-button').style.display = 'none';

        }

        function class_header_click(tab_number, class_id){
            document.getElementById(`class-${class_id}-header-1`).classList.remove('active');
            document.getElementById(`class-${class_id}-header-2`).classList.remove('active');
            document.getElementById(`class-${class_id}-header-3`).classList.remove('active');
            document.getElementById(`class-${class_id}-header-${tab_number}`).classList.add('active');

            document.getElementById(`class-${class_id}-tab-1`).classList.remove('active');
            document.getElementById(`class-${class_id}-tab-2`).classList.remove('active');
            document.getElementById(`class-${class_id}-tab-3`).classList.remove('active');
            document.getElementById(`class-${class_id}-tab-${tab_number}`).classList.add('active');
        }

        // to remove session on the last session page
        localStorage.removeItem('classroom-management-session');
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Predator\OneDrive - ums.edu.my\Documents\Work\Khaleef Net Sdn Bhd\uthm_classroom_management_system\resources\views/class/index.blade.php ENDPATH**/ ?>