
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <title>Dashboard</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,200,0,-25" />
    <link href="<?php echo e(asset('css/bootstrap-custom.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/main.css')); ?>" rel="stylesheet">

    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.13/jspdf.plugin.autotable.min.js"></script>


    <style>
        .leftbar-nav-button {
            display: flex;
            align-items: center;
            width: 180px;
            margin-top: 5px;
            padding: 8px;
            border-radius: 5px;
            font-weight: bold;
            font-size: 12px;
            cursor: pointer;
            transition: 0.5s;
            text-decoration: none;
        }

        .leftbar-nav-button:hover {
            background-color: #00000011;
            color: #000000;
        }

        .leftbar-nav-button.active {
            background-color: var(--plt2);
            color: #eee;
        }

        #profile-dropdown { display: none}
        #profile-dropdown.active { display: block }

        .message {
            visibility: hidden;
            position:fixed; 
            left:50%; 
            top: -500px;
            transform:translateX(-50%);
            z-index: 99;
            border-radius: 10px;
            transition: 1s;
            box-shadow: 0px 10px 20px 5px #00000033;
        }

        .message.success { background-color: #91cd91}
        .message.error { background-color: #fc6d6d }


        .message.active {
            visibility: visible;
            top: 10px;
        }
    </style>

    <?php echo $__env->yieldPushContent('style'); ?>

</head>
<body>
    <div class="message w-500 pd-20 bs-bb" style="position:fixed">
        <div style="position:relative;">
            <div class="d-flex jc-end clr-white" style="position:absolute; right:0px;"><span class="material-symbols-outlined fs-15 cursor-pointer" onclick="document.querySelector('.message').classList.remove('active');">close</span></div>
        </div>
        <?php if($errors->any()): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="fs-12 clr-white mg-b-5" style="width:calc(100% - 20px)"><?php echo e($error); ?></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <?php if(session('success')): ?>
            <div class="fs-12 clr-white mg-b-5" style="width:calc(100% - 20px)"><?php echo e(session('success')); ?></div>
        <?php endif; ?>
    </div>

    <div class="h-100p w-220 bg-plt5 f-shrink-0" style="position:fixed;">
        <a class="w-100p mg-b-20 d-flex cursor-pointer" style="height:60px; text-decoration:none;">
            <div class="pd-10 mg-l-10"><img class="h-100p" src="storage/system/logo.png" alt="" style="object-fit:cover"></div>
            <div class="d-flex fd-column jc-center">
                <div class="fs-13 fw-bold"><?php echo e(App\Models\Settings::where('setting_key', 'short_name')->get()->first()->setting_value); ?></div>
                <div class="fs-9 fw-bold clr-grey-1"><?php echo e(App\Models\Settings::where('setting_key', 'system_name')->get()->first()->setting_value); ?></div>
            </div>
        </a>
        <div class="w-100p h-80p d-flex fd-column ai-center" style="height:calc(100% - 60px)">

            <div class="cursor-default fs-15 fw-bold mg-t-20 clr-grey-1" style="width:180px">Class</div>

            <a href="<?php echo e(route('dashboard.index')); ?>" class="leftbar-nav-button clr-grey-2 <?php echo $__env->yieldContent('dashboard-button'); ?>">
                <span class="material-symbols-outlined mg-r-10">dashboard</span>
                Dashboard
            </a>

            <?php if(Auth::user()->type == 'Administrator' || Auth::user()->type == 'Management' || Auth::user()->type == 'Lecturer' || Auth::user()->type == 'Student Lead'): ?>
                <a href="<?php echo e(route('room.index')); ?>" class="leftbar-nav-button clr-grey-2 <?php echo $__env->yieldContent('rooms-button'); ?>">
                    <span class="material-symbols-outlined mg-r-10">door_front</span>
                    Rooms
                </a>
            <?php endif; ?>

            <?php if(Auth::user()->type == 'Administrator' || Auth::user()->type == 'Management' || Auth::user()->type == 'Lecturer' || Auth::user()->type == 'Student Lead'): ?>
                <a href="<?php echo e(route('class.index')); ?>" class="leftbar-nav-button clr-grey-2 <?php echo $__env->yieldContent('classes-button'); ?>">
                    <span class="material-symbols-outlined mg-r-10">event_available</span>
                    Classes
                </a>
            <?php endif; ?>

            <a href="<?php echo e(route('group.index')); ?>" class="leftbar-nav-button clr-grey-2 <?php echo $__env->yieldContent('groups-button'); ?>">
                <span class="material-symbols-outlined mg-r-10">groups</span>
                Groups
            </a>

            <!-- <a href="" class="leftbar-nav-button clr-grey-2 <?php echo $__env->yieldContent('request-button'); ?>">
                <span class="material-symbols-outlined mg-r-10">videocam</span>
                Videos
            </a> -->

            <div class="cursor-default fs-15 fw-bold mg-t-20 clr-grey-1" style="width:180px">System</div>

            <?php if(Auth::user()->type == 'Administrator' || Auth::user()->type == 'Management'): ?>
                <a href="<?php echo e(route('report.index')); ?>" class="leftbar-nav-button clr-grey-2 <?php echo $__env->yieldContent('reports-button'); ?>">
                    <span class="material-symbols-outlined mg-r-10">description</span>
                    Reports
                </a>
            <?php endif; ?>

            <?php if(Auth::user()->type == 'Administrator' || Auth::user()->type == 'Management'): ?>
                <a href="<?php echo e(route('user.index')); ?>" class="leftbar-nav-button clr-grey-2 <?php echo $__env->yieldContent('users-button'); ?>">
                    <span class="material-symbols-outlined mg-r-10">group</span>
                    Users
                </a>
            <?php endif; ?>
            
            <?php if(Auth::user()->type == 'Administrator'): ?>
                <a href="<?php echo e(route('setting.index')); ?>" class="leftbar-nav-button clr-grey-2 <?php echo $__env->yieldContent('settings-button'); ?>">
                    <span class="material-symbols-outlined mg-r-10">settings</span>
                    Settings
                </a>
            <?php endif; ?>

            <a href="<?php echo e(route('profile.index')); ?>" class="leftbar-nav-button clr-grey-2 <?php echo $__env->yieldContent('profile-button'); ?>">
                <span class="material-symbols-outlined mg-r-10">assignment_ind</span>
                Profile
            </a>

            
        </div>
    </div>

    <div class="h-100p d-flex-center" style="position:fixed; width:calc(100% - 220px); left:220px;">
        <img src="<?php echo e(asset('storage/system/logo-circle.png')); ?>" style="height:80%; position:absolute; object-fit:cover; opacity:0.05;" alt="">
    </div>

    <div class="pd-20 bs-bb of-auto" style="height:calc(100% - 50px); width:calc(100% - 220px); position:fixed; right:0; bottom:0;">
        <?php echo $__env->yieldContent('main-body'); ?>
    </div>

    <div class="header h-50 bg-white" style="position:fixed; left:220px; width:calc(100% - 220px);">
        <div class="h-100p d-flex">
            <?php echo $__env->yieldContent('header'); ?>
        </div>
        <div id="profile-button" class="h-50 cursor-pointer mg-r-20" style="position:fixed; right:10px; top:0px;">
            
            <div class="d-flex">
                <div id="profile-button-picture" class="h-50 w-50 d-flex-center">
                    <?php if(Auth::user()->image_path): ?>
                        <img src="<?php echo e(asset('storage' . Auth::user()->image_path)); ?>" alt="" class="w-35 h-35 br-50p" style="object-fit:cover;border:none;">
                    <?php else: ?>
                        <img src="<?php echo e(asset('storage/system/avatar.png')); ?>" alt="" class="w-35 h-35 br-50p" style="object-fit:cover;border:none;">
                    <?php endif; ?>
                </div>
                <div id="profile-button-detail" class="fd-column">
                    <div class="name tw-nowrap mg-t-10 mg-l-5 fs-11 fw-bold clr-black-1"><?php echo e(Auth::user()->full_name); ?></div>
                    <div class="tw-nowrap mg-l-5 fs-11 fw-bold clr-grey-2"><?php echo e(Auth::user()->type); ?></div>
                    
                </div>
            </div>
            
            <div id="profile-dropdown" class="dropdown w-150 pd-b-10 bg-plt" style="z-index:99">
                <form id="profile-button-form" method="GET" action="">
                <?php echo csrf_field(); ?>
                <?php echo method_field('GET'); ?>
                    <button type="submit" class="option w-100p txt-l fs-12 clr-grey-1 cursor-pointer" onclick="" style="border:none;">Profile</button>
                </form>
                
                <form method="POST" action="<?php echo e(route('logout')); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('POST'); ?>
                    <button type="submit" class="option w-100p txt-l fs-12 clr-grey-1 cursor-pointer" onclick="" style="border:none;">Logout</button>
                </form>
            </div>
        </div>
    </div>

    <div id="transparent" class="transparent"></div>

    <?php echo $__env->yieldContent('body-box'); ?>

    <script>
        <?php if($errors->any()): ?>
            document.querySelector('.message').classList.add('error');
            document.querySelector('.message').classList.add('active');
        <?php elseif(session('success')): ?>
            document.querySelector('.message').classList.add('success');
            document.querySelector('.message').classList.add('active');
        <?php endif; ?>


        function open_popup_click(popup_id) {
            document.getElementById(popup_id).classList.add('active');
            document.getElementById('transparent').classList.add('active');
        }

        function close_popup_click(popup_id) {
            document.getElementById(popup_id).classList.remove('active');
            document.getElementById('transparent').classList.remove('active');
        }

        function add_dropdown_event(button_id, dropdown_id){
            let button_element = document.getElementById(button_id);
            let dropdown_element = document.getElementById(dropdown_id);
            button_element.addEventListener('click', (e) => {
                dropdown_element.classList.toggle('active');
                button_element.classList.toggle('active');
            });
            window.addEventListener('blur', (e) => {
                dropdown_element.classList.remove('active');
                button_element.classList.remove('active');
            });
            dropdown_element.addEventListener('click', (event) => {
                event.stopPropagation();
            });
            document.addEventListener('click', (event) => {
                if (!button_element.contains(event.target)) {
                    dropdown_element.classList.remove('active');
                    button_element.classList.remove('active');
                }
            });
        }

        function dropdown_option_input_click(option, button_id, input_id, input_value, dropdown_id=null) {
            document.getElementById(button_id).textContent = option.textContent;
            document.getElementById(input_id).value = input_value;
            if (dropdown_id) {
                document.getElementById(dropdown_id).classList.remove('active');
                document.getElementById(button_id).classList.remove('active');
            }
        }

        function add_search(input_id, dropdown_id){
            document.getElementById(input_id).addEventListener('input', function() {
                const input = this.value.toLowerCase();
                const options = document.querySelectorAll('#' + dropdown_id + ' .option');
                options.forEach(function(option) {
                    if (option.textContent.toLowerCase().includes(input)) {
                        option.style.display = '';
                    } else {
                        option.style.display = 'none';
                    }
                });
            });
        }

        function submit_form(form_id) {
            document.getElementById(form_id).submit();
        }

        function time_click(time_type, value, input_id) {
            input = document.getElementById(input_id);
            let current_time = input.value;

            let time_parts = current_time.split(':');
            let hour = parseInt(time_parts[0]);
            let minute = parseInt(time_parts[1]);
            let phase = hour >= 12 ? 'PM' : 'AM';
            switch (time_type) {
                case 'hour': 
                    if (phase === 'PM') { hour = (value < 12) ? value + 12 : value;
                    } else { hour = (value === 12) ? 0 : value; }
                    break;
                case 'minute': 
                    minute = value;
                    break;
                case 'phase': 
                    if (value === 'AM' && hour >= 12) { hour -= 12;
                    } else if (value === 'PM' && hour < 12) {hour += 12;}
                    break;
            }
            let new_time = `${hour.toString().padStart(2, '0')}:${minute.toString().padStart(2, '0')}:00`; // Seconds are fixed to "00"
            input.value = new_time;
        }

        
        function showRepeatUntil() {
            let repeatUntilSection = document.getElementById('repeat-until-section');
            repeatUntilSection.style.display = 'block';
        }

        function hideRepeatUntil() {
            let repeatUntilSection = document.getElementById('repeat-until-section');
            repeatUntilSection.style.display = 'none';
        }

        function setRepeatUntil(weeksAhead = 0, monthsAhead = 0) {
            let repeatUntilInput = document.getElementById('repeat-until-input');
            let startDateInput = document.getElementById('class_start_date');
            let startDateFollow = new Date(startDateInput.value);
            let currentDate = new Date();
            let targetDate;
            let formattedDate;

            // Calculate future date
            if (startDateInput.value){
                targetDate = startDateFollow;

                if (weeksAhead > 0) {
                    startDateFollow.setDate(startDateFollow.getDate() + (weeksAhead * 7));
                } else if (monthsAhead > 0) {
                    startDateFollow.setMonth(startDateFollow.getMonth() + monthsAhead);
                }

            } else{
                targetDate = currentDate;

                if (weeksAhead > 0) {
                    currentDate.setDate(currentDate.getDate() + (weeksAhead * 7));
                } else if (monthsAhead > 0) {
                    currentDate.setMonth(currentDate.getMonth() + monthsAhead);
                }
            }

            // Format the date as yyyy-mm-dd
            let year = targetDate.getFullYear();
            let month = String(targetDate.getMonth() + 1).padStart(2, '0');
            let day = String(targetDate.getDate()).padStart(2, '0');
            formattedDate = `${year}-${month}-${day}`;

            // Set the calculated date into the input field
            repeatUntilInput.value = formattedDate;
        }
        
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        function fetch_data(api='', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({})) {
;            return fetch(api,{
                    method: method,
                    headers: headers,
                    body: body,
                })
                .then(response => response.json())
                .catch(error => console.error('Error:', error));
        }

        add_dropdown_event('profile-button', 'profile-dropdown');


        // function getDoorEvent() {
        //     Promise.all([fetch_data(api='get-door-event', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({'startTime':'2024-11-07T00:00:00+08:00', 'endTime':'2024-11-20T00:00:00+08:00', 'eventType':196893, 'personName':'', 'doorIndexCodes':['3'] })),
        //                 fetch_data(api='get-door-event', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({'startTime':'2024-11-07T00:00:00+08:00', 'endTime':'2024-11-20T00:00:00+08:00', 'eventType':198914, 'personName':'', 'doorIndexCodes':['3'] })),
        //                 fetch_data(api='get-door-event', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({'startTime':'2024-11-07T00:00:00+08:00', 'endTime':'2024-11-20T00:00:00+08:00', 'eventType':197127, 'personName':'', 'doorIndexCodes':['3'] })),
        //                 fetch_data(api='/artemis/api/resource/v1/acsDoor/acsDoorList', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({}))])
        //     .then(([data_face, data_card, data_fingerprint, door_list]) => {
        //         // all_data = [..data_face.data.list, ...data_card.data.list, ...data_fingerprint.data.list]
        //             console.log(door_list.data.list);


        //     });
        // }

        // getDoorEvent()
        // setInterval(getDoorEvent, 10000);
        
    </script>
    <?php echo $__env->yieldPushContent('script'); ?>
</body>
</html><?php /**PATH C:\Users\Predator\OneDrive - ums.edu.my\Documents\Work\Khaleef Net Sdn Bhd\uthm_classroom_management_system\resources\views/layouts/app.blade.php ENDPATH**/ ?>