<!-- <link rel="stylesheet" href="/css/bootstrap-custom.css"> -->
<!-- <link rel="stylesheet" href="/css/layout.css"> -->
<style>
    #nav-pagination {
        position:fixed; bottom:30px; box-shadow:0px 0px 15px 5px #00000022; border-radius: 10px
    }

    @media only screen and (max-width: 425px) {
        #nav-pagination {
            position:fixed; bottom:65px; left:50%; transform:translateX(-50%); box-shadow:0px 0px 15px 5px #00000022
        }
    }

    /* Tablets (480px to 768px) */ 
    @media only screen and (min-width: 425px) and (max-width: 768px) {
        #nav-pagination {
            right:30px;
        }
    }

    /* Desktops (768px to 1024px) */
    @media only screen and (min-width: 768px) and (max-width: 1024px) {
        #nav-pagination {
            right:30px;
        }
    }

    /* Large Screens (more than 1024px) */
    @media only screen and (min-width: 1024px) {
        #nav-pagination {
            right:30px;
        }
    }
</style>

<?php if($paginator->hasPages()): ?>
    <nav role="navigation" id="nav-pagination" aria-label="<?php echo e(__('Pagination Navigation')); ?>" class="d-flex ai-center pd-lr-15 pd-tb-10 bg-primary">

        <!-- Go to Page Form -->
        <div class="d-flex ai-center">
            <form action="<?php echo e(request()->url()); ?>" method="GET" class="d-flex ai-center">
                <label for="page" class="fs-13 fw-bold">Page:</label>
                <?php if(isset($pageName)): ?>
                    <input type="number" name="<?php echo e($pageName); ?>" id="page" value="<?php echo e($paginator->currentPage()); ?>" min="1" max="<?php echo e($paginator->lastPage()); ?>" class="form-control dropdown-button w-70 clr-grey-1 pd-tb-8 pd-lr-8 mg-l-10 pd-lr-0 cursor-text txt-c" style="">
                <?php else: ?>
                    <input type="number" name="page" id="page" value="<?php echo e($paginator->currentPage()); ?>" min="1" max="<?php echo e($paginator->lastPage()); ?>" class="form-control dropdown-button w-70 clr-grey-1 pd-tb-8 pd-lr-8 mg-l-10 pd-lr-0 cursor-text txt-c" style="">
                <?php endif; ?>
                
            </form>
            <label for="" class="fs-13 clr-grey-1 tw-nowrap">of <?php echo e($paginator->lastPage()); ?></label>
        </div>

        <div class="d-flex mg-l-15 flex-1 sm:hidden fw-bold">
            <?php if($paginator->onFirstPage()): ?>
                <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-5"><span class="material-symbols-outlined clr-white fs-20 fw-bold">first_page</span></div>
                <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-5"><span class="material-symbols-outlined clr-white fs-20 fw-bold">chevron_left</span></div>
            <?php else: ?>
                <a href="<?php echo e($paginator->url(1)); ?>" class="txt-none">
                    <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-5"><span class="material-symbols-outlined clr-white fs-20 fw-bold">first_page</span></div>
                </a>
                <a href="<?php echo e($paginator->previousPageUrl()); ?>" class="txt-none">
                    <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-5"><span class="material-symbols-outlined clr-white fs-20 fw-bold">chevron_left</span></div>
                </a>
            <?php endif; ?>

            <?php if($paginator->hasMorePages()): ?>
                <a href="<?php echo e($paginator->nextPageUrl()); ?>" class="txt-none">
                    <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-15"><span class="material-symbols-outlined clr-white fs-20 fw-bold">chevron_right</span></div>
                </a>
                <a href="<?php echo e($paginator->url($paginator->lastPage())); ?>" class="txt-none">
                    <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-5"><span class="material-symbols-outlined clr-white fs-20 fw-bold">last_page</span></div>
                </a>
            <?php else: ?>
                <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-15"><span class="material-symbols-outlined clr-white fs-20 fw-bold">chevron_right</span></div>
                <div class="d-flex-center button-primary br-50p cursor-pointer us-none w-25 h-25 mg-l-5"><span class="material-symbols-outlined clr-white fs-20 fw-bold">last_page</span></div>
            <?php endif; ?>
        </div>
    </nav>
<?php endif; ?>
<?php /**PATH C:\Users\Predator\OneDrive - ums.edu.my\Documents\Work\Khaleef Net Sdn Bhd\uthm_classroom_management_system\resources\views/vendor/pagination/tailwind.blade.php ENDPATH**/ ?>