

<?php $__env->startPush('style'); ?>
    <style>
        #room-option-dropdown-button { transition: 0.3s }
        #room-option-dropdown-button.active { background-color: #00000088; }
        .room-header { border: 3px solid #00000000; transition:0.3s; cursor:pointer }
        .room-header.active { background-color: var(--plt2); color: #ffffff; }
        .room-header:hover { color: #ffffff; }
        .room-tab { display:none }
        .room-tab.active { display:block }

        .time-slot-hv:hover { background: var(--plt1-tr1) }
        .holiday-calender .holiday-calender-mark {
            color: red;
            font-weight: bold;
            margin-top: 5px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('rooms-button', 'active'); ?>

<?php $__env->startSection('header'); ?>
    <div class="d-flex h-100p" id="nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs1 fw-bold cursor-default">Rooms</div>
        <div class="d-flex-center">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;">
                <span class="material-symbols-outlined fs-20">filter_alt</span>
                <div class="mg-l-5 d-none laptop-view">Filter</div>
            </div>
        </div>

        <?php if(Auth::user()->type == 'Administrator'): ?>
            <div class="d-flex-center">
                <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" onclick="open_popup_click('add-room-popup')">
                    <span class="material-symbols-outlined b fs-20 mg-r-5">add</span>
                    <div>Add</div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <?php $visible = 'visibility:hidden;' ?>
    <?php if(Auth::user()->type == 'Administrator'): ?>
        <?php $visible = 'visibility:visible;' ?>
    <?php endif; ?>
    
    <div class="d-none" id="room-nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold clr-blue clr-blue-hv txt-u-hv cursor-pointer" onclick="back_click()">Back</div>
        <!-- <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold cursor-default" id="room-name-header"></div> -->
        <div class="d-flex-center"  style="<?php echo e($visible); ?>">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" id="edit-room-button">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">edit</span>
                <div>Edit</div>
            </div>
        </div>
        <div class="h-100p" style="position:relative; <?php echo e($visible); ?>">
            <div class="d-flex-center h-100p">
                <div id="room-option-dropdown-button" class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;">
                    <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">list</span>
                    <div>Option</div>
                </div>
            </div>
            <div class="dropdown w-180 cursor-pointer" id="room-option-dropdown" style="position:absolute;">
                <div class="option pd-b-10" id="delete-room-button">
                    <div class="fs3 clr-black-2 fw-bold">Delete Room</div>
                    <div class="fs4 clr-grey-2 fw-bold">Remove this room from the system</div>
                </div>
            </div>
        </div>
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main-body'); ?>
    <div id="main">
        <?php
            $rooms = App\Models\Rooms::all();
            $classes = App\Models\Classes::all();
            $groups = App\Models\Groups::all();
            $faculties = App\Models\Faculties::all();
            $buildings = App\Models\Buildings::all();
            $levels = App\Models\Levels::all();
            $roomTypes = App\Models\RoomType::all();
            $holidays = App\Models\Holidays::all();
        ?> 
        <table class="table w-100p">
            <tr>
                <th></th>
                <th>Name</th>
                <th>Faculty</th>
                <th>Building</th>
                <th>Level</th>
                <th>Room Type</th>
                <th>Status</th>
                <th>Availability (Today)</th>
            </tr>

            <?php $count = 1; ?>
            <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td style="width:0px">
                        <div class="d-flex-center">
                            <div class="bg-plt1-tr2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4"><?php echo e($count); ?></div>
                        </div>
                    </td>
                    <td>
                        <div class="d-flex ai-center">
                            <div class="w-150 mg-r-20">
                                <div class="w-100p h-40 d-flex mg-b-5" style="gap:5px">
                                    <div class="w-100p h-100p of-hidden bg-grey-2" style="border-radius: 5px 0px 0px 0px;"><img src="<?php echo e(asset('storage/' . $room->image_path1)); ?>" class="w-100p" style="object-fit:cover;" alt=""></div>
                                    <div class="w-100p h-100p of-hidden bg-grey-2" style="border-radius: 0px 5px 0px 0px;"><img src="<?php echo e(asset('storage/' . $room->image_path2)); ?>" class="w-100p" style="object-fit:cover;" alt=""></div>
                                </div>
                                <div class="w-100p h-40 d-flex" style="gap:5px; position:relative;">
                                    <div class="w-100p h-100p of-hidden bg-grey-2" style="border-radius: 0px 0px 0px 5px;"><img src="<?php echo e(asset('storage/' . $room->image_path3)); ?>" class="w-100p" style="object-fit:cover;" alt=""></div>
                                    <div class="w-100p h-100p of-hidden bg-grey-2" style="border-radius: 0px 0px 5px 0px;"><img src="<?php echo e(asset('storage/' . $room->image_path4)); ?>" class="w-100p" style="object-fit:cover;" alt=""></div>
                                </div>
                            </div>
                            <div>
                                <div class="cursor-pointer clr-blue-hv txt-u-hv tw-nowrap fs-13 fw-bold clr-blue" onclick="room_click(<?php echo e($room->id); ?>, `<?php echo e($room->name); ?>`)">
                                    <?php echo e($room->name); ?>

                                </div>
                                <div class="cursor-pointer tw-nowrap fs-12 clr-grey-1">
                                    <?php echo e($room->description); ?>

                                </div>
                                <div class="cursor-pointer tw-nowrap fs-12 clr-grey-1">
                                    <?php echo e($room->faculty->name); ?>

                                </div>
                                <div class="cursor-pointer tw-nowrap fs-12 clr-grey-1">
                                    <?php echo e($room->building->name); ?>

                                </div>
                                <div class="cursor-pointer tw-nowrap fs-12 clr-grey-1">
                                    <?php echo e($room->level->name); ?>

                                </div>
                            </div>
                        </div>
                        
                    </td>
                    <td>
                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($room->faculty->name); ?></div>
                    </td>
                    <td>
                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($room->building->name); ?></div>
                    </td>
                    <td>
                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($room->level->name); ?></div>
                    </td>
                    <td>
                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($room->room_type->name); ?></div>
                    </td>
                    <td>
                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($room->status); ?></div>
                    </td>
                    <td>
                        <?php
                            $scheduleStart = \Carbon\Carbon::parse('07:00:00');
                            $scheduleEnd = \Carbon\Carbon::parse('22:00:00');
                            $totalMinutes = $scheduleEnd->diffInMinutes($scheduleStart);

                            $timeX = \Carbon\Carbon::parse('10:00:00');
                            $minutesFromStart = $timeX->diffInMinutes($scheduleStart);

                            $percentagePosition = ($minutesFromStart / $totalMinutes) * 100;
                        ?>
                        <div class="tw-nowrap fs-12 clr-grey-1 w-150 h-20" style="position:relative; background-color:#00000011">
                            <?php $__currentLoopData = $room->classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $startTimeSetting = \Carbon\Carbon::parse(App\Models\Settings::where('setting_key', 'start_time')->get()->first()->setting_value);
                                    $endTimeSetting = \Carbon\Carbon::parse(App\Models\Settings::where('setting_key', 'end_time')->get()->first()->setting_value);
                                    $startTime = \Carbon\Carbon::parse($class->start_date_time);
                                    $endTime = \Carbon\Carbon::parse($class->end_date_time);
                                    
                                    if ($startTime->isToday()) {
                                        $totalDuration = $startTimeSetting->diffInMinutes($endTimeSetting);
                                        $usageDuration = $startTime->diffInMinutes($endTime);
                                        $usagePercentage = ($usageDuration / $totalDuration) * 100;
                                        $startPositionPercentage = ($startTimeSetting->diffInMinutes($startTime) / $totalDuration) * 100;
                                    }
                                ?>
                                <?php if($startTime->isToday()): ?>
                                    <div class="h-100p bg-plt2 tooltip" onmouseover="this.style.backgroundColor='var(--plt1)'" onmouseout="this.style.backgroundColor='var(--plt2)'" style="position:absolute; left:<?php echo e($startPositionPercentage); ?>%; width:<?php echo e($usagePercentage); ?>%; border-right:1px solid #ffffff; border-left:1px solid #ffffff; box-sizing:border-box">
                                        <span class="top-tooltiptext"><?php echo e($class->title); ?><br><?php echo e($startTime->format('g:i A')); ?> - <?php echo e($endTime->format('g:i A')); ?></span>
                                    </div>                                
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="h-100p"></div>
                        </div>
                    </td>
                </tr>
                <?php $count += 1; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>
    </div>

    <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <form id="delete-room-<?php echo e($room->id); ?>-form" class="d-none" action="<?php echo e(route('room.delete-room-by-id',['id' => $room->id])); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
        </form>
        
        <div class="w-100p h-100p pd-t-20 d-none" id="room-<?php echo e($room->id); ?>">
            <div class="room-calendar w-100p h-100p d-flex cursor-default">
                <div class="w-250 f-shrink-0">
                    <div class="w-100p h-70 d-flex mg-b-5" style="gap:5px">
                        <div class="w-100p h-100p of-hidden bg-grey-2" style="border-radius: 5px 0px 0px 0px;"><img src="<?php echo e(asset('storage/' . $room->image_path1)); ?>" class="w-100p" style="object-fit:cover;" alt=""></div>
                        <div class="w-100p h-100p of-hidden bg-grey-2" style="border-radius: 0px 5px 0px 0px;"><img src="<?php echo e(asset('storage/' . $room->image_path2)); ?>" class="w-100p" style="object-fit:cover;" alt=""></div>
                    </div>
                    <div class="w-100p h-70 d-flex mg-b-20" style="gap:5px; position:relative;">
                        <div class="w-100p h-100p of-hidden bg-grey-2" style="border-radius: 0px 0px 0px 5px;"><img src="<?php echo e(asset('storage/' . $room->image_path3)); ?>" class="w-100p" style="object-fit:cover;" alt=""></div>
                        <div class="w-100p h-100p of-hidden bg-grey-2" style="border-radius: 0px 0px 5px 0px;"><img src="<?php echo e(asset('storage/' . $room->image_path4)); ?>" class="w-100p" style="object-fit:cover;" alt=""></div>
                        <div id="change-img-room-button-<?php echo e($room->id); ?>" class="cursor-pointer" style="position:absolute; bottom:0px; right:5px;"><span class="material-symbols-outlined fs-25 clr-white clr-blue-hv fw-bold">photo_camera</span></div>
                    </div>

                    <div class="mg-b-20">
                        <div class="clr-grey-2 fw-bold fs3">Room Name</div>
                        <div class="fs3 clr-black-2 fw-bold"><?php echo e($room->name); ?></div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-grey-2 fw-bold fs3">Description</div>
                        <div class="fs3 clr-black-2 fw-bold"><?php echo e($room->description); ?></div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-grey-2 fw-bold fs3">Faculty</div>
                        <div class="fs3 clr-black-2 fw-bold"><?php echo e($room->faculty->name); ?></div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-grey-2 fw-bold fs3">Building</div>
                        <div class="fs3 clr-black-2 fw-bold"><?php echo e($room->building->name); ?></div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-grey-2 fw-bold fs3">Level</div>
                        <div class="fs3 clr-black-2 fw-bold"><?php echo e($room->level->name); ?></div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-grey-2 fw-bold fs3">Room Type</div>
                        <div class="fs3 clr-black-2 fw-bold"><?php echo e($room->room_type->name); ?></div>
                    </div>
                    <div class="mg-b-20">
                        <div class="clr-grey-2 fw-bold fs3">Status</div>
                        <div class="fs3 clr-black-2 fw-bold"><?php echo e($room->status); ?></div>
                    </div>
                </div>
                <div class="w-1 h-100p mg-lr-30 d-none laptop-view" style="background-color:#00000022"></div>
                
                <div class="w-100p d-flex fd-column" style="max-width:800px;">
                    <div class="d-flex jc-end w-100p mg-b-10">
                        <div class="h-30 d-flex fd-row bg-plt3 br-5 us-none">
                            <div id="room-<?php echo e($room->id); ?>-header-1" class="room-header active clr-white-hv pd-2 br-5 cursor-pointer" onclick="toggleCalenderOrList(1, <?php echo e($room->id); ?>)">
                                <span class="material-symbols-outlined fs-20">calendar_month</span>
                            </div>
                            <div id="room-<?php echo e($room->id); ?>-header-2" class="room-header clr-white-hv pd-2 br-5 cursor-pointer" onclick="toggleCalenderOrList(2, <?php echo e($room->id); ?>)">
                                <span class="material-symbols-outlined fs-20">list</span>
                            </div>
                        </div>
                    </div>
                    <div class="">
                        <div id="room-<?php echo e($room->id); ?>-tab-1" class="room-tab active">
                            <div class="d-flex-center us-none">
                                <div class="bg-blue-1-hv pd-t-4 pd-r-5 pd-l-5 br-5 mg-r-5 clr-white-hv cursor-pointer bg-plt3" onclick="previousMonth(<?php echo e($room->id); ?>, <?php echo e($room->classes); ?>, '<?php echo e($room->name); ?>')">
                                    <span class="material-symbols-outlined fw-bold">keyboard_arrow_left</span>
                                </div>
                                <div id="monthYearDisplay-<?php echo e($room->id); ?>" class="w-150 txt-c fs3 fw-bold">Month Year</div>
                                <div class="bg-blue-1-hv pd-t-4 pd-l-5 pd-r-5 br-5 mg-l-5 clr-white-hv cursor-pointer bg-plt3" onclick="nextMonth(<?php echo e($room->id); ?>, <?php echo e($room->classes); ?>, '<?php echo e($room->name); ?>')">
                                    <span class="material-symbols-outlined fw-bold">keyboard_arrow_right</span>
                                </div>
                            </div>
                            
                            <?php
                                $month = now()->month; // or set it to any specific month
                                $year = now()->year; // or set it to any specific year
                                $holidayCalender = App\Models\Holidays::whereMonth('date', $month)
                                    ->whereYear('date', $year)
                                    ->pluck('date')
                                    ->toArray();
                            ?>
                            <div class="d-flex f-shrink-0 pd-tb-10 fw-bold fs3 clr-grey-2">
                                <div id="calendar-room-<?php echo e($room->id); ?>" class="calendar w-100p" style="aspect-ratio:1">
                                    <div class="calendar-day">SUN</div>
                                    <div class="calendar-day">MON</div>
                                    <div class="calendar-day">TUE</div>
                                    <div class="calendar-day">WED</div>
                                    <div class="calendar-day">THU</div>
                                    <div class="calendar-day">FRI</div>
                                    <div class="calendar-day">SAT</div>
        
                                    <div class="calendar-cell first sunday"></div>
                                    <div class="calendar-cell first monday"></div>
                                    <div class="calendar-cell first tuesday"></div>
                                    <div class="calendar-cell first wednesday"></div>
                                    <div class="calendar-cell first thursday"></div>
                                    <div class="calendar-cell first friday"></div>
                                    <div class="calendar-cell first saturday"></div>
        
                                    <div class="calendar-cell second sunday"></div>
                                    <div class="calendar-cell second monday"></div>
                                    <div class="calendar-cell second tuesday"></div>
                                    <div class="calendar-cell second wednesday"></div>
                                    <div class="calendar-cell second thursday"></div>
                                    <div class="calendar-cell second friday"></div>
                                    <div class="calendar-cell second saturday"></div>
        
                                    <div class="calendar-cell third sunday"></div>
                                    <div class="calendar-cell third monday"></div>
                                    <div class="calendar-cell third tuesday"></div>
                                    <div class="calendar-cell third wednesday"></div>
                                    <div class="calendar-cell third thursday"></div>
                                    <div class="calendar-cell third friday"></div>
                                    <div class="calendar-cell third saturday"></div>
        
                                    <div class="calendar-cell fourth sunday"></div>
                                    <div class="calendar-cell fourth monday"></div>
                                    <div class="calendar-cell fourth tuesday"></div>
                                    <div class="calendar-cell fourth wednesday"></div>
                                    <div class="calendar-cell fourth thursday"></div>
                                    <div class="calendar-cell fourth friday"></div>
                                    <div class="calendar-cell fourth saturday"></div>
                                    
                                    <div class="calendar-cell fifth sunday"></div>
                                    <div class="calendar-cell fifth monday"></div>
                                    <div class="calendar-cell fifth tuesday"></div>
                                    <div class="calendar-cell fifth wednesday"></div>
                                    <div class="calendar-cell fifth thursday"></div>
                                    <div class="calendar-cell fifth friday"></div>
                                    <div class="calendar-cell fifth saturday"></div>
        
                                    <div class="calendar-cell sixth sunday"></div>
                                    <div class="calendar-cell sixth monday"></div>
                                    <div class="calendar-cell sixth tuesday"></div>
                                    <div class="calendar-cell sixth wednesday"></div>
                                    <div class="calendar-cell sixth thursday"></div>
                                    <div class="calendar-cell sixth friday"></div>
                                    <div class="calendar-cell sixth saturday"></div>
                                </div>
                            </div>
                            <div id="holidayDisplay-<?php echo e($room->id); ?>" class="w-50p d-flex fd-column clr-black pd-5 mg-b-5 d-none">
                                <!-- Holiday info will be dynamically populated here by JavaScript -->
                            </div>
                        </div>
                        <div id="room-<?php echo e($room->id); ?>-tab-2" class="room-tab">
                            <div class="d-flex-center w-100p h-100p us-none">
                                <div class="h-50 d-flex-center">
                                        <?php
                                            $firstDay = Carbon\Carbon::today();
                                            $secondDay = Carbon\Carbon::today()->addDays(1);
                                            $thirdDay = Carbon\Carbon::today()->addDays(2);
                                        ?>

                                    <div class="d-flex-center bg-blue-1-hv pd-t-4 pd-r-5 pd-l-5 br-5 mg-r-5 clr-white-hv cursor-pointer bg-gold-2" onclick="previousDay(<?php echo e($room->id); ?>, <?php echo e($room->classes); ?>)">
                                        <span class="material-symbols-outlined fw-bold">keyboard_arrow_left</span>
                                    </div>
                                    <div id="" class="w-700 d-flex-center mg-lr-10">
                                        <div class="d-flex fd-column mg-lr-80">
                                            <div class="txt-c fs4 clr-grey-1 first-day-name"><?php echo e($firstDay->format('D')); ?></div>
                                            <div class="d-flex">
                                                <div class="fs1 fw-bold pd-r-10 first-day-date"><?php echo e($firstDay->format('d')); ?></div>
                                                <div class="fs1 fw-bold first-day-month"><?php echo e($firstDay->format('M')); ?></div>
                                            </div>
                                        </div>
                                        <div class="d-flex fd-column mg-lr-80">
                                            <div class="txt-c fs4 clr-grey-1 second-day-name"><?php echo e($secondDay->format('D')); ?></div>
                                            <div class="d-flex">
                                                <div class="fs1 fw-bold pd-r-10 second-day-date"><?php echo e($secondDay->format('d')); ?></div>
                                                <div class="fs1 fw-bold second-day-month"><?php echo e($secondDay->format('M')); ?></div>
                                            </div>
                                        </div>
                                        <div class="d-flex fd-column mg-lr-80">
                                            <div class="txt-c fs4 clr-grey-1 third-day-name"><?php echo e($thirdDay->format('D')); ?></div>
                                            <div class="d-flex">
                                                <div class="fs1 fw-bold pd-r-10 third-day-date"><?php echo e($thirdDay->format('d')); ?></div>
                                                <div class="fs1 fw-bold third-day-month"><?php echo e($thirdDay->format('M')); ?></div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="d-flex-center bg-blue-1-hv pd-t-4 pd-l-5 pd-r-5 br-5 mg-l-5 clr-white-hv cursor-pointer bg-gold-2 f-shrink-0" onclick="nextDay(<?php echo e($room->id); ?>, <?php echo e($room->classes); ?>)">
                                        <span class="material-symbols-outlined fw-bold">keyboard_arrow_right</span>
                                    </div>
                                </div>
                            </div>
                            <div class="w-100p h-100p" id="time-slot-date-list-<?php echo e($room->id); ?>">
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> 
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-box'); ?>
    <div id="add-room-popup" class="right-popup bg-white h-100p cursor-default">
        <form action="<?php echo e(route('room.create-room')); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('POST'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">New Room</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Room Name <span style="color:red;">*</span></div>
                    <input type="text" name="name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Description </div>
                    <textarea class="textarea w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text" style="font-family:Arial, Helvetica, sans-serif; max-width:300px; min-width:300px;" name="description" rows="4"></textarea>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-30">Faculty</div>
                    <input id="add-room-faculty-dropdown-input" type="hidden" name="faculty_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                    <div id="add-room-faculty-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"></div>
                    <div id="add-room-faculty-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                        <div class="d-flex">
                            <input type="text" name="" id="add-room-faculty-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                        <?php $__currentLoopData = $faculties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faculty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'add-room-faculty-dropdown-button', 'add-room-faculty-dropdown-input', <?php echo e($faculty->id); ?>, 'add-room-faculty-dropdown'); add_faculty_dropdown_click(<?php echo e($faculty->id); ?>);" style="border:none;"><?php echo e($faculty->name); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    
                    <div class="fs-13 clr-black-1 fw-bold mg-t-30">Building</div>
                    <input id="add-room-building-dropdown-input" type="hidden" name="building_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                    <div id="add-room-building-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"></div>
                    <div id="add-room-building-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                        <div class="d-flex">
                            <input type="text" name="" id="add-room-building-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                    </div>
                    
                    <div class="fs-13 clr-black-1 fw-bold mg-t-30">Level</div>
                    <input id="add-room-level-dropdown-input" type="hidden" name="level_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                    <div id="add-room-level-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"></div>
                    <div id="add-room-level-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                        <div class="d-flex">
                            <input type="text" name="" id="add-room-level-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                    </div>
                    
                    <div class="fs-13 clr-black-1 fw-bold mg-t-30">Room Type</div>
                    <input id="add-room-type-dropdown-input" type="hidden" name="type_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                    <div id="add-room-type-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"></div>
                    <div id="add-room-type-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                        <div class="d-flex">
                            <input type="text" name="" id="add-room-type-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                        <?php $__currentLoopData = $roomTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roomType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'add-room-type-dropdown-button', 'add-room-type-dropdown-input', <?php echo e($roomType->id); ?>, 'add-room-type-dropdown')" style="border:none;"><?php echo e($roomType->name); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
            
                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                    <button type="button" onclick="close_popup_click('add-room-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>

    
    <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div id="change-img-room-<?php echo e($room->id); ?>-popup" class="right-popup bg-white w-600 h-100p">
            <form action="<?php echo e(route('room.update-room-image-by-id', ['id' => $room->id])); ?>" method="POST" enctype="multipart/form-data" class="h-100p w-100p">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            
                <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                    <div class="h-100p pd-30 bs-bb cursor-default">
                        <div class="fs-18 clr-grey-2 fw-bold">Change Image</div>

                        <input type="file" name="room_image1" accept="image/*" class="room-image1-input w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 d-none" style="cursor:text;">
                        <div class="room-drop1-image <?php echo e($room->image_path1 ? 'd-none' : ''); ?> cursor-pointer txt-c w-300 h-130 mg-10" style="border: 3px dashed #bec3d0;" onclick="document.querySelector('#change-img-room-<?php echo e($room->id); ?>-popup .room-image1-input').click()"> 
                            <div class="w-100p h-100p bg-grey-2-hv clr-grey-2 clr-black-2-hv">
                                <span class="material-symbols-outlined fs-100">upload_file</span>
                                <div class="fs3">Click to select image</div>
                            </div>
                        </div>
                        <div class="room-image1-preview <?php echo e($room->image_path1 ? '' : 'd-none'); ?> w-300 h-200 mg-t-10">
                            <div class="w-100p h-100p d-flex-center of-hidden">
                                <img class="room-image1 h-100p" style="object-fit:cover; border:none;" src="<?php echo e($room->image_path1 ? asset('storage/' . $room->image_path1) : ''); ?>" alt="">
                            </div>
                        </div>
                        <div class="d-flex-center w-300">
                            <input type="hidden" class="remove_room_image1" name="remove_room_image1" id="remove-room-image1" value="0">
                            <div class="button-primary room-file1-delete <?php echo e($room->image_path1 ? '' : 'd-none'); ?> w-100 mg-tb-10 txt-c fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none; background-color:#bc3333;" onmouseover="this.style.backgroundColor = '#bc3333aa';" onmouseout="this.style.backgroundColor = '#bc3333';" onclick="removeImage( <?php echo e($room->id); ?>, '.room-image1-input', '.room-image1-preview', '.room-image1', '.room-drop1-image', '.room-file1-delete', '#remove-room-image1')">Remove</div>
                        </div>


                        <input type="file" name="room_image2" accept="image/*" class="room-image2-input w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 d-none" style="cursor:text;">
                        <div class="room-drop2-image <?php echo e($room->image_path2 ? 'd-none' : ''); ?> cursor-pointer txt-c w-300 h-130 mg-10" style="border: 3px dashed #bec3d0;" onclick="document.querySelector('#change-img-room-<?php echo e($room->id); ?>-popup .room-image2-input').click()">
                            <div class="w-100p h-100p bg-grey-2-hv clr-grey-2 clr-black-2-hv">
                                <span class="material-symbols-outlined fs-100">upload_file</span>
                                <div class="fs3">Click to select image</div>
                            </div>
                        </div>
                        <div class="room-image2-preview <?php echo e($room->image_path2 ? '' : 'd-none'); ?> w-300 h-200 mg-t-10">
                            <div class="w-100p h-100p d-flex-center of-hidden">
                                <img class="room-image2 h-100p" style="object-fit:cover; border:none;" src="<?php echo e($room->image_path2 ? asset('storage/' . $room->image_path2) : ''); ?>" alt="">
                            </div>
                        </div>
                        <div class="d-flex-center w-300">
                            <input type="hidden" class="remove_room_image2" name="remove_room_image2" id="remove-room-image2" value="0">
                            <div class="button-primary room-file2-delete <?php echo e($room->image_path2 ? '' : 'd-none'); ?> w-100 mg-tb-10 txt-c fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none; background-color:#bc3333;" onmouseover="this.style.backgroundColor = '#bc3333aa';" onmouseout="this.style.backgroundColor = '#bc3333';" onclick="removeImage( <?php echo e($room->id); ?>, '.room-image2-input', '.room-image2-preview', '.room-image2', '.room-drop2-image', '.room-file2-delete', '#remove-room-image2')">Remove</div>
                        </div>

                        <input type="file" name="room_image3" accept="image/*" class="room-image3-input w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 d-none" style="cursor:text;">
                        <div class="room-drop3-image <?php echo e($room->image_path3 ? 'd-none' : ''); ?> cursor-pointer txt-c w-300 h-130 mg-10" style="border: 3px dashed #bec3d0;" onclick="document.querySelector('#change-img-room-<?php echo e($room->id); ?>-popup .room-image3-input').click()">
                            <div class="w-100p h-100p bg-grey-2-hv clr-grey-2 clr-black-2-hv">
                                <span class="material-symbols-outlined fs-100">upload_file</span>
                                <div class="fs3">Click to select image</div>
                            </div>
                        </div>
                        <div class="room-image3-preview <?php echo e($room->image_path3 ? '' : 'd-none'); ?> w-300 h-200 mg-t-10">
                            <div class="w-100p h-100p d-flex-center of-hidden">
                                <img class="room-image3 h-100p" style="object-fit:cover; border:none;" src="<?php echo e($room->image_path3 ? asset('storage/' . $room->image_path3) : ''); ?>" alt="">
                            </div>
                        </div>
                        <div class="d-flex-center w-300">
                            <input type="hidden" class="remove_room_image3" name="remove_room_image3" id="remove-room-image3" value="0">
                            <div class="button-primary room-file3-delete <?php echo e($room->image_path3 ? '' : 'd-none'); ?> w-100 mg-tb-10 txt-c fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none; background-color:#bc3333;" onmouseover="this.style.backgroundColor = '#bc3333aa';" onmouseout="this.style.backgroundColor = '#bc3333';" onclick="removeImage( <?php echo e($room->id); ?>, '.room-image3-input', '.room-image3-preview', '.room-image3', '.room-drop3-image', '.room-file3-delete', '#remove-room-image3')">Remove</div>
                        </div>

                        <input type="file" name="room_image4" accept="image/*" class="room-image4-input w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 d-none" style="cursor:text;">
                        <div class="room-drop4-image <?php echo e($room->image_path4 ? 'd-none' : ''); ?> cursor-pointer txt-c w-300 h-130 mg-10" style="border: 3px dashed #bec3d0;" onclick="document.querySelector('#change-img-room-<?php echo e($room->id); ?>-popup .room-image4-input').click()">
                            <div class="w-100p h-100p bg-grey-2-hv clr-grey-2 clr-black-2-hv">
                                <span class="material-symbols-outlined fs-100">upload_file</span>
                                <div class="fs3">Click to select image</div>
                            </div>
                        </div>
                        <div class="room-image4-preview <?php echo e($room->image_path4 ? '' : 'd-none'); ?> w-300 h-200 mg-t-10">
                            <div class="w-100p h-100p d-flex-center of-hidden">
                                <img class="room-image4 h-100p" style="object-fit:cover; border:none;" src="<?php echo e($room->image_path4 ? asset('storage/' . $room->image_path4) : ''); ?>" alt="">
                            </div>
                        </div>
                        <div class="d-flex-center w-300">
                            <input type="hidden" class="remove_room_image4" name="remove_room_image4" id="remove-room-image4" value="0">
                            <div class="button-primary room-file4-delete <?php echo e($room->image_path4 ? '' : 'd-none'); ?> w-100 mg-tb-10 txt-c fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none; background-color:#bc3333;" onmouseover="this.style.backgroundColor = '#bc3333aa';" onmouseout="this.style.backgroundColor = '#bc3333';" onclick="removeImage( <?php echo e($room->id); ?>, '.room-image4-input', '.room-image4-preview', '.room-image4', '.room-drop4-image', '.room-file4-delete', '#remove-room-image4')">Remove</div>
                        </div>

                        
                        <div class="w-300">
                            <div class="d-flex fs3 clr-grey-2 fw-bold">You only allow to upload maximum 10MB file size.</div>
                        </div>
                        <div class="h-150"></div>
                        
                    </div>
                </div>

                <div class="submit-section h-80 w-100p">
                    <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                        <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Save Changes</button>
                        <button type="button" onclick="close_popup_click('change-img-room-<?php echo e($room->id); ?>-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    
    <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div id="edit-room-<?php echo e($room->id); ?>-popup" class="right-popup bg-white w-600 h-100p">
            <form action="<?php echo e(route('room.update-room-by-id', ['id' => $room->id])); ?>" method="POST" enctype="multipart/form-data" class="h-100p w-100p">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            
                <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                    <div class="h-100p pd-30 bs-bb cursor-default">
                        <div class="fs-18 clr-grey-2 fw-bold">Edit Room</div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Room Name <span style="color:red;">*</span></div>
                        <input type="text" name="name" value="<?php echo e($room->name); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                                                
                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Description </div>
                        <textarea class="textarea w-300 clr-grey-1 mg-t-5 pd-5 bs-bb cursor-text" style="font-family:Arial, Helvetica, sans-serif; max-width:300px; min-width:300px;" name="description" rows="5"><?php echo e($room->description); ?></textarea>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Access Level <span style="color:red;">*</span></div>
                        <input type="text" name="access_level" value="<?php echo e($room->access_level); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;" disabled>

                        <div class="w-300">
                            <div class="fs-13 clr-black-1 fw-bold mg-t-20">Index Code<span style="color:red;">*</span></div>
                            <div class="w-300 bg-plt5 mg-t-5 bs-bb">
                                <input type="text" disabled name="id" value="<?php echo e($room->id); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:default;">
                            </div>
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Faculty <span style="color:red;">*</span></div>
                        <input id="edit-room-faculty-<?php echo e($room->id); ?>-dropdown-input" type="hidden" value="<?php echo e($room->faculty->id); ?>" name="faculty_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                        <div id="edit-room-faculty-<?php echo e($room->id); ?>-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"><?php echo e($room->faculty->name); ?></div>
                        <div id="edit-room-faculty-<?php echo e($room->id); ?>-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                            <div class="d-flex">
                                <input type="text" name="" id="edit-room-faculty-<?php echo e($room->id); ?>-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                            </div>
                            <?php $__currentLoopData = $faculties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faculty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'edit-room-faculty-<?php echo e($room->id); ?>-dropdown-button', 'edit-room-faculty-<?php echo e($room->id); ?>-dropdown-input', <?php echo e($faculty->id); ?>, 'edit-room-faculty-<?php echo e($room->id); ?>-dropdown'); edit_faculty_dropdown_click(<?php echo e($room->id); ?>, <?php echo e($faculty->id); ?>);" style="border:none;"><?php echo e($faculty->name); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Building <span style="color:red;">*</span></div>
                        
                        <input id="edit-room-building-<?php echo e($room->id); ?>-dropdown-input" type="hidden" value="<?php echo e($room->building->id); ?>" name="building_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                        <div id="edit-room-building-<?php echo e($room->id); ?>-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"><?php echo e($room->building->name); ?></div>
                        <div id="edit-room-building-<?php echo e($room->id); ?>-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                            <div class="d-flex">
                                <input type="text" name="" id="edit-room-building-<?php echo e($room->id); ?>-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                            </div>
                            <?php $__currentLoopData = $buildings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $building): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'edit-room-building-<?php echo e($room->id); ?>-dropdown-button', 'edit-room-building-<?php echo e($room->id); ?>-dropdown-input', <?php echo e($building->id); ?>, 'edit-room-building-<?php echo e($room->id); ?>-dropdown'); edit_building_dropdown_click(<?php echo e($room->id); ?>, <?php echo e($building->id); ?>);" style="border:none;"><?php echo e($building->name); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        
                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Level <span style="color:red;">*</span></div>
                        
                        <input id="edit-room-level-<?php echo e($room->id); ?>-dropdown-input" value="<?php echo e($room->level->id); ?>" type="hidden" name="level_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                        <div id="edit-room-level-<?php echo e($room->id); ?>-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"><?php echo e($room->level->name); ?></div>
                        <div id="edit-room-level-<?php echo e($room->id); ?>-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                            <div class="d-flex">
                                <input type="text" name="" id="edit-room-level-<?php echo e($room->id); ?>-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                            </div>
                            <?php $__currentLoopData = $room->building->levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'edit-room-<?php echo e($room->id); ?>-dropdown-button', 'edit-room-<?php echo e($room->id); ?>-dropdown-input', <?php echo e($level->id); ?>, 'edit-room-<?php echo e($room->id); ?>-dropdown')" style="border:none;"><?php echo e($level->name); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Room Type <span style="color:red;">*</span></div>
                        
                        <input id="edit-room-type-<?php echo e($room->id); ?>-dropdown-input" type="hidden" value="<?php echo e($room->room_type->id); ?>" name="type_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                        <div id="edit-room-type-<?php echo e($room->id); ?>-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"><?php echo e($room->room_type->name); ?></div>
                        <div id="edit-room-type-<?php echo e($room->id); ?>-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                            <div class="d-flex">
                                <input type="text" name="" id="edit-room-type-<?php echo e($room->id); ?>-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                            </div>
                            <?php $__currentLoopData = $roomTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roomType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'edit-room-type-<?php echo e($room->id); ?>-dropdown-button', 'edit-room-type-<?php echo e($room->id); ?>-dropdown-input', <?php echo e($roomType->id); ?>, 'edit-room-type-<?php echo e($room->id); ?>-dropdown')" style="border:none;"><?php echo e($roomType->name); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div class="d-flex fd-row w-300 pd-5 mg-t-20 bs-bb fw-wrap bg-plt5">
                            <div class="bs-bb fw-shrink-0 w-200">
                                <div class="d-flex fs-13 clr-black-1 fw-bold mg-b-5">Inactive Room </div>
                                <div class="d-flex fs3 clr-grey-2 fw-bold">Set the room to inactive and you are no longer able to book the class with the room.</div>
                            </div>
                            <div class="switch d-flex ai-center mg-l-20">
                                <input type="checkbox" id="switchRoomStatus" name="status_toggle" 
                                    <?php echo e($room->status == 'Available' ? '' : 'checked'); ?> 
                                    onclick="toggleReason('reason-section-<?php echo e($room->id); ?>','switchRoomStatus','roomStatus','edit-reason-<?php echo e($room->id); ?>-dropdown-input')">
                                <label for="switchRoomStatus" class="toggle"><span></span></label>
                            </div>
                            <input type="hidden" id="roomStatus" value="<?php echo e($room->status); ?>" name="status">
                        </div>
                        <?php  
                            $reasonDisplay = 'd-none';
                            if ($room->status == 'Available'){
                                $reasonDisplay = 'd-none';
                            } else {
                                $reasonDisplay = '';
                            }
                        ?>

                        <div id="reason-section-<?php echo e($room->id); ?>" class="<?php echo e($reasonDisplay); ?>">
                            <div class="fs-13 clr-black-1 fw-bold mg-t-20">Reason <span style="color:red;">*</span></div>
                            <input id="edit-reason-<?php echo e($room->id); ?>-dropdown-input" type="hidden" value="<?php echo e($room->reason); ?>" name="reason" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">
                            <div id="edit-reason-<?php echo e($room->id); ?>-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"><?php echo e($room->reason); ?></div>
                            <div id="edit-reason-<?php echo e($room->id); ?>-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                                <div class="option" id="closed-option">
                                    <div class="fs3 pd-5 clr-grey-1 cursor-pointer" onclick="dropdown_option_input_click(this, 'edit-reason-<?php echo e($room->id); ?>-dropdown-button', 'edit-reason-<?php echo e($room->id); ?>-dropdown-input', this.textContent, 'edit-reason-<?php echo e($room->id); ?>-dropdown')">Closed</div>
                                </div>
                                <div class="option" id="maintenance-option">
                                    <div class="fs3 pd-5 clr-grey-1 cursor-pointer" onclick="dropdown_option_input_click(this, 'edit-reason-<?php echo e($room->id); ?>-dropdown-button', 'edit-reason-<?php echo e($room->id); ?>-dropdown-input', this.textContent, 'edit-reason-<?php echo e($room->id); ?>-dropdown')">Maintenance</div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="h-150"></div>
                        
                    </div>
                </div>

                <div class="submit-section h-80 w-100p">
                    <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                        <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Update</button>
                        <button type="button" onclick="close_popup_click('edit-room-<?php echo e($room->id); ?>-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    
    <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div id="calendar-day-<?php echo e($room->id); ?>-popup" class="right-popup bg-white w-600 h-100p">
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb cursor-default">
                    <div class="title fs2 clr-grey-2 fw-bold mg-b-30">Time Slot : <span class="fw-bold clr-blue"></span></div>
                    <div class="fs3 clr-grey-2 fw-bold mg-b-20">Please select your time slot</div>
                    <div class="time-slot">



                    </div>
                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="button" onclick="close_popup_click('calendar-day-<?php echo e($room->id); ?>-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    
    <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div id="view-class-<?php echo e($class->id); ?>-popup" class="right-popup bg-white w-600 h-100p">
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb cursor-default">
                    <div class="fs-18 clr-grey-2 fw-bold">View Class</div>
                    
                    <div class="d-flex mg-b-20 mg-t-50">
                        <div class="w-150 clr-black-2 fw-bold fs3">Title</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e($class->title); ?></div>
                    </div>
                    <div class="d-flex mg-b-20">
                        <div class="w-150 clr-black-2 fw-bold fs3">Description</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e($class->description); ?></div>
                    </div>
                    <div class="d-flex mg-b-20">
                        <div class="w-150 clr-black-2 fw-bold fs3">Room</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e($class->room->name); ?></div>
                    </div>
                    <div class="d-flex mg-b-20">
                        <div class="w-150 clr-black-2 fw-bold fs3">Start</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e(\Carbon\Carbon::parse($class->start_date_time)->format('d M Y H:i A')); ?></div>
                    </div>
                    <div class="d-flex mg-b-20">
                        <div class="w-150 clr-black-2 fw-bold fs3">End</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e(\Carbon\Carbon::parse($class->end_date_time)->format('d M Y H:i A')); ?></div>
                    </div>
                    <div class="d-flex mg-b-20">
                        <div class="w-150 clr-black-2 fw-bold fs3">Requested By</div>
                        <div class="fs3 clr-grey-2 fw-bold">null</div>
                    </div>
                    <div class="d-flex mg-b-20">
                        <div class="w-150 clr-black-2 fw-bold fs3">Group</div>
                        <div class="fs3 clr-grey-2 fw-bold"><?php echo e($class->group->name); ?></div>
                    </div>
                    <div class="d-flex mg-b-20">
                        <div class="w-150 clr-black-2 fw-bold fs3 mg-b-5">Status</div>
                        <?php if($class->approval_by_id == ''): ?>
                            <div class="tw-nowrap fs3 clr-yellow fw-bold br-5 bg-gold-2 w-mc pd-5">Pending</div>
                        <?php else: ?>
                            <div class="tw-nowrap fs3 clr-green fw-bold br-5 bg-green-2 w-mc pd-5"><?php echo e($class->approval_by_id); ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="h-150"></div>
                    
                </div>
            </div>

            <form id="delete-room-class-<?php echo e($class->id); ?>-form" class="d-none" action="<?php echo e(route('class.delete-class-by-id',['id' => $class->id])); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
            </form>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <?php if(Auth::user()->type == 'Administrator' || Auth::user()->type == 'Management'): ?>
                        <button type="button" onclick="open_popup_click('edit-class-<?php echo e($class->id); ?>-popup')" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Edit Class</button>
                    <?php endif; ?>
                    <button type="button" onclick="close_popup_click('view-class-<?php echo e($class->id); ?>-popup'); document.getElementById('transparent').classList.add('active');" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer cancel-class-button1" style="border:none">Cancel</button>
                    <button type="button" onclick="close_popup_click('view-class-<?php echo e($class->id); ?>-popup');" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer cancel-class-button2 d-none" style="border:none">Cancel</button>
                    <?php if(Auth::user()->type == 'Administrator' || Auth::user()->type == 'Management'): ?>
                        <button type="button" onclick="if(confirm('Are you sure you want to delete <?php echo e($class->title); ?>?')) {submit_form('delete-room-class-<?php echo e($class->id); ?>-form')}" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 mg-l-270 br-4 cursor-pointer" style="border:none; background-color:#bc3333;" onmouseover="this.style.backgroundColor = '#bc3333aa';" onmouseout="this.style.backgroundColor = '#bc3333';">Delete Class</button>
                    <?php else: ?>
                        <button type="button" onclick="if(confirm('Are you sure you want to delete <?php echo e($class->title); ?>?')) {submit_form('delete-room-class-<?php echo e($class->id); ?>-form')}" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 mg-l-270 br-4 cursor-pointer" style="border:none; background-color:#bc3333; visibility:hidden;" onmouseover="this.style.backgroundColor = '#bc3333aa';" onmouseout="this.style.backgroundColor = '#bc3333';">Delete Class</button>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        
        
        <div id="edit-class-<?php echo e($class->id); ?>-popup" class="right-popup bg-white w-600 h-100p">
            <form action="<?php echo e(route('class.update-class-by-id', ['id' => $class->id])); ?>" method="POST" enctype="multipart/form-data" class="h-100p w-100p">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            
                <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                    <div class="h-100p pd-30 bs-bb cursor-default">
                        <div class="fs-18 clr-grey-2 fw-bold">Edit Class</div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Title <span style="color:red;">*</span></div>
                        <input type="text" name="title" value="<?php echo e($class->title); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                                                
                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Description </div>
                        <textarea class="textarea w-300 clr-grey-1 mg-t-5 pd-5 bs-bb cursor-text" style="font-family:Arial, Helvetica, sans-serif; max-width:300px; min-width:300px;" name="description" rows="5"><?php echo e($class->description); ?></textarea>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Room <span style="color:red;">*</span></div>
                        <input id="class-room-<?php echo e($class->id); ?>-dropdown-input" type="hidden" name="room_id" value="<?php echo e($class->room->id); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                        <div id="class-room-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"><?php echo e($class->room->name); ?></div>
                        <div id="class-room-<?php echo e($class->id); ?>-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                            <div class="d-flex">
                                <input type="text" name="" id="class-room-<?php echo e($class->id); ?>-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                            </div>
                            <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'class-room-<?php echo e($class->id); ?>-dropdown-button', 'class-room-<?php echo e($class->id); ?>-dropdown-input', <?php echo e($room->id); ?>, 'class-room-<?php echo e($class->id); ?>-dropdown')" style="border:none;"><?php echo e($room->name); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Date <span style="color:red;">*</span></div>
                        <input id="edit-class-<?php echo e($class->id); ?>-start-date" type="date" name="start_date" value="<?php echo e(\Carbon\Carbon::parse($class->start_date_time)->format('Y-m-d')); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                        
                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Time <span style="color:red;">*</span></div>
                        <input id="start_time-<?php echo e($class->id); ?>" type="hidden" name="start_time" value="<?php echo e(\Carbon\Carbon::parse($class->start_date_time)->format('H:i:s')); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                        <div class="d-flex h-30 mg-t-5">
                            <div class="w-96 mg-r-5 cursor-pointer">
                                <div id="start-hour-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb clr-black-2"><?php echo e(\Carbon\Carbon::parse($class->start_date_time)->format('H')); ?></div>
                                <div id="start-hour-<?php echo e($class->id); ?>-dropdown" class="dropdown w-96 h-145 of-auto">
                                    <?php for($i = 1; $i <= 12; $i++): ?>
                                        <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-hour-<?php echo e($class->id); ?>-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('hour', <?php echo e($i); ?>, 'start_time-<?php echo e($class->id); ?>')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                            <div class="w-96 mg-r-5 cursor-pointer">
                                <div id="start-minute-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2"><?php echo e(\Carbon\Carbon::parse($class->start_date_time)->format('i')); ?></div>
                                <div id="start-minute-<?php echo e($class->id); ?>-dropdown" class="dropdown w-96 h-145 of-auto">
                                    <?php for($i = 0; $i <= 59; $i++): ?>
                                        <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-minute-<?php echo e($class->id); ?>-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('minute', <?php echo e($i); ?>, 'start_time-<?php echo e($class->id); ?>')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                            <div class="w-96 mg-r-5 cursor-pointer">
                                <div id="start-phase-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2"><?php echo e(\Carbon\Carbon::parse($class->start_date_time)->format('A')); ?></div>
                                <div id="start-phase-<?php echo e($class->id); ?>-dropdown" class="dropdown w-96 h-50 of-auto">
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-phase-<?php echo e($class->id); ?>-dropdown-button').textContent = 'AM'; time_click('phase', 'AM', 'start_time-<?php echo e($class->id); ?>')">AM</div>
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-phase-<?php echo e($class->id); ?>-dropdown-button').textContent = 'PM'; time_click('phase', 'PM', 'start_time-<?php echo e($class->id); ?>')">PM</div>
                                </div>
                            </div>
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">End Date <span style="color:red;">*</span></div>
                        <input id="edit-class-<?php echo e($class->id); ?>-end-date" type="date" name="end_date" value="<?php echo e(\Carbon\Carbon::parse($class->end_date_time)->format('Y-m-d')); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">End Time <span style="color:red;">*</span></div>
                        <input id="end_time-<?php echo e($class->id); ?>" type="hidden" name="end_time" value="<?php echo e(\Carbon\Carbon::parse($class->end_date_time)->format('H:i:s')); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                        <div class="d-flex h-30 mg-t-5">
                            <div class="w-96 mg-r-5 cursor-pointer">
                                <div id="end-hour-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2"><?php echo e(\Carbon\Carbon::parse($class->end_date_time)->format('H')); ?></div>
                                <div id="end-hour-<?php echo e($class->id); ?>-dropdown" class="dropdown w-96 h-145 of-auto">
                                    <?php for($i = 1; $i <= 12; $i++): ?>
                                        <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-hour-<?php echo e($class->id); ?>-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('hour', <?php echo e($i); ?>, 'end_time-<?php echo e($class->id); ?>')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                            <div class="w-96 mg-r-5 cursor-pointer">
                                <div id="end-minute-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2"><?php echo e(\Carbon\Carbon::parse($class->end_date_time)->format('i')); ?></div>
                                <div id="end-minute-<?php echo e($class->id); ?>-dropdown" class="dropdown w-96 h-145 of-auto">
                                    <?php for($i = 0; $i <= 59; $i++): ?>
                                        <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-minute-<?php echo e($class->id); ?>-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('minute', <?php echo e($i); ?>, 'end_time-<?php echo e($class->id); ?>')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                            <div class="w-96 mg-r-5 cursor-pointer">
                                <div id="end-phase-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2"><?php echo e(\Carbon\Carbon::parse($class->end_date_time)->format('A')); ?></div>
                                <div id="end-phase-<?php echo e($class->id); ?>-dropdown" class="dropdown w-96 h-50 of-auto">
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-phase-<?php echo e($class->id); ?>-dropdown-button').textContent = 'AM'; time_click('phase', 'AM', 'end_time-<?php echo e($class->id); ?>')">AM</div>
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-phase-<?php echo e($class->id); ?>-dropdown-button').textContent = 'PM'; time_click('phase', 'PM', 'end_time-<?php echo e($class->id); ?>')">PM</div>
                                </div>
                            </div>
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Group <span style="color:red;">*</span></div>
                        <input id="class-group-<?php echo e($class->id); ?>-dropdown-input" type="hidden" name="group_id" value="<?php echo e($class->group->id); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">
                        <div id="class-group-<?php echo e($class->id); ?>-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"><?php echo e($class->group->name); ?></div>
                        <div id="class-group-<?php echo e($class->id); ?>-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                            <div class="d-flex">
                                <input type="text" name="" id="class-group-<?php echo e($class->id); ?>-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                            </div>
                            <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'class-group-<?php echo e($class->id); ?>-dropdown-button', 'class-group-<?php echo e($class->id); ?>-dropdown-input', <?php echo e($group->id); ?>, 'class-group-<?php echo e($class->id); ?>-dropdown')" style="border:none;"><?php echo e($group->name); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div class="h-150"></div>
                        
                    </div>
                </div>

                <div class="submit-section h-80 w-100p">
                    <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                        <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Update</button>
                        <button type="button" onclick="close_popup_click('edit-class-<?php echo e($class->id); ?>-popup'); document.getElementById('transparent').classList.add('active');" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    
    <div id="add-class-popup" class="right-popup bg-white w-600 h-100p">
        <form action="<?php echo e(route('class.create-class')); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('POST'); ?>
            <div class="content w-100p of-auto cursor-default" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">New Class</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-30">Title <span style="color:red;">*</span></div>
                    <input type="text" name="title" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Description</div>
                    <textarea class="textarea w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text" style="font-family:Arial, Helvetica, sans-serif; max-width:300px; min-width:300px;" name="description" rows="4"></textarea>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Room <span style="color:red;">*</span></div>
                    <input id="class-room-dropdown-input" type="hidden" name="room_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:default;">
                    <div id="class-room-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:default;"></div>
                    

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Date <span style="color:red;">*</span></div>
                    <input type="hidden" id="class_start_date" name="start_date" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:default;">
                    <div id="class_add_start_date" name="start_date" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:default;"></div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Start Time <span style="color:red;">*</span></div>
                    <input id="start_time" type="hidden" name="start_time" value="08:00:00" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                    <div class="d-flex h-30 mg-t-5">
                        <div class="w-96 mg-r-5 cursor-pointer">
                            <div id="start-hour-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb clr-black-2">08</div>
                            <div id="start-hour-dropdown" class="dropdown w-96 h-145 of-auto">
                                <?php for($i = 1; $i <= 12; $i++): ?>
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-hour-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('hour', <?php echo e($i); ?>, 'start_time')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                <?php endfor; ?>
                            </div>
                        </div>
                        <div class="w-96 mg-r-5 cursor-pointer">
                            <div id="start-minute-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2">00</div>
                            <div id="start-minute-dropdown" class="dropdown w-96 h-145 of-auto">
                                <?php for($i = 0; $i <= 59; $i++): ?>
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-minute-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('minute', <?php echo e($i); ?>, 'start_time')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                <?php endfor; ?>
                            </div>
                        </div>
                        <div class="w-96 mg-r-5 cursor-pointer">
                            <div id="start-phase-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2">AM</div>
                            <div id="start-phase-dropdown" class="dropdown w-96 h-50 of-auto">
                                <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-phase-dropdown-button').textContent = 'AM'; time_click('phase', 'AM', 'start_time')">AM</div>
                                <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('start-phase-dropdown-button').textContent = 'PM'; time_click('phase', 'PM', 'start_time')">PM</div>
                            </div>
                        </div>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">End Date <span style="color:red;">*</span></div>
                    <input type="hidden" id="class_end_date" name="end_date" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:default;">
                    <div id="class_add_end_date" name="end_date" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:default;"></div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">End Time <span style="color:red;">*</span></div>
                    <input id="end_time" type="hidden" name="end_time" value="08:30:00" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                    <div class="d-flex h-30 mg-t-5">
                        <div class="w-96 mg-r-5 cursor-pointer">
                            <div id="end-hour-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2">08</div>
                            <div id="end-hour-dropdown" class="dropdown w-96 h-145 of-auto">
                                <?php for($i = 1; $i <= 12; $i++): ?>
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-hour-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('hour', <?php echo e($i); ?>, 'end_time')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                <?php endfor; ?>
                            </div>
                        </div>
                        <div class="w-96 mg-r-5 cursor-pointer">
                            <div id="end-minute-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2">30</div>
                            <div id="end-minute-dropdown" class="dropdown w-96 h-145 of-auto">
                                <?php for($i = 0; $i <= 59; $i++): ?>
                                    <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-minute-dropdown-button').textContent = '<?php echo e(sprintf('%02d', $i)); ?>'; time_click('minute', <?php echo e($i); ?>, 'end_time')"><?php echo e(sprintf('%02d', $i)); ?></div>
                                <?php endfor; ?>
                            </div>
                        </div>
                        <div class="w-96 mg-r-5 cursor-pointer">
                            <div id="end-phase-dropdown-button" class="dropdown-button txt-c h-30 pd-t-5 bs-bb  clr-black-2">AM</div>
                            <div id="end-phase-dropdown" class="dropdown w-96 h-50 of-auto">
                                <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-phase-dropdown-button').textContent = 'AM'; time_click('phase', 'AM', 'end_time')">AM</div>
                                <div class="cursor-pointer clr-grey-1 fs3 pd-5 bg-blue-1-hv clr-white-hv" onclick="document.getElementById('end-phase-dropdown-button').textContent = 'PM'; time_click('phase', 'PM', 'end_time')">PM</div>
                            </div>
                        </div>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Group <span style="color:red;">*</span></div>
                    <input id="class-group-dropdown-input" type="hidden" name="group_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">
                    <div id="class-group-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0"></div>
                    <div id="class-group-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                        <div class="d-flex">
                            <input type="text" name="" id="class-group-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                        <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'class-group-dropdown-button', 'class-group-dropdown-input', <?php echo e($group->id); ?>, 'class-group-dropdown')" style="border:none;"><?php echo e($group->name); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Repeat Type <span style="color:red;">*</span></div>
                    <input id="class-type-dropdown-input" type="hidden" name="repeat_type" value="Once" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">
                    <div id="class-type-dropdown-button" class="dropdown-button w-300 h-15 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">Once</div>
                    <div class="dropdown w-300 cursor-pointer" id="class-type-option-dropdown" style="position:absolute;">
                        <div class="option" id="once-option">
                            <div class="fs3 clr-grey-1" onclick="dropdown_option_input_click(this, 'class-type-dropdown-button', 'class-type-dropdown-input', 'Once', 'class-type-option-dropdown'); hideRepeatUntil()">Once</div>
                        </div>
                        <div class="option pd-b-10" id="weekly-option">
                            <div class="fs3 clr-grey-1" onclick="dropdown_option_input_click(this, 'class-type-dropdown-button', 'class-type-dropdown-input', 'Weekly', 'class-type-option-dropdown'); showRepeatUntil(); setRepeatUntil(2, 0);">Weekly</div>
                        </div>
                        <div class="option pd-b-10" id="monthly-option">
                            <div class="fs3 clr-grey-1" onclick="dropdown_option_input_click(this, 'class-type-dropdown-button', 'class-type-dropdown-input', 'Monthly', 'class-type-option-dropdown'); showRepeatUntil(); setRepeatUntil(0, 2);">Monthly</div>
                        </div>
                    </div>

                    <div id="repeat-until-section" class="d-none">
                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Repeat until <span style="color:red;">*</span></div>
                        <input id="repeat-until-input" type="date" name="repeat_until" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                    </div>
                    
                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                    <button type="button" onclick="close_popup_click('add-class-popup'); document.getElementById('transparent').classList.add('active');" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>

    

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        let room_id_opened;
        //to make sure the update/edit and recreate will stay on the page after submit the button, make sure to update your controller
        <?php if(session('updated_room_id')): ?>
            room_click(<?php echo e(session('updated_room_id')); ?>, `<?php echo e(App\Models\Rooms::findOrFail(session('updated_room_id'))->name); ?>`);
        <?php endif; ?>

        // to remove session on the last session page
        localStorage.removeItem('classroom-management-session');

        function room_click(room_id, room_name) {
            document.getElementById(`room-${room_id}`).style.display = 'flex';
            document.getElementById('main').style.display = 'none';
            document.getElementById('nav-button').style.display = 'none';
            document.getElementById('room-nav-button').style.display = 'flex';
            
            // document.getElementById('room-name-header').textContent = room_name;
            room_id_opened = room_id;

            document.getElementById('edit-room-button').onclick = function () { open_popup_click(`edit-room-${room_id}-popup`) }
            document.getElementById(`change-img-room-button-${room_id}`).onclick = function () { open_popup_click(`change-img-room-${room_id}-popup`) }
            document.getElementById('delete-room-button').onclick = function () {
                if (confirm('Are you sure you want to delete this room? All related classes set to this room will be deleted!')) {
                    document.getElementById(`delete-room-${room_id}-form`).submit();
                }
            }
        }

        rooms = <?php echo json_encode($rooms, 15, 512) ?>;
        rooms.forEach(room => {
            const room_id = room.id;
            document.querySelector(`#change-img-room-${room_id}-popup .room-image1-input`).addEventListener('change', (e) => {
                const file = e.target.files[0];
                let files = e.target.files;
                // console.log(room)
                if (files.length > 0) {
                    preview_image(files[0], document.querySelector(`#change-img-room-${room_id}-popup .room-image1`));
                    document.querySelector(`#change-img-room-${room_id}-popup .room-image1-preview`).style.display = 'flex';
                    document.querySelector(`#change-img-room-${room_id}-popup .room-drop1-image`).style.display = 'none';
                    document.querySelector(`#change-img-room-${room_id}-popup .room-file1-delete`).style.display = 'block';

                    // set the remove-room-image-1 value to '0'
                    document.querySelector(`#change-img-room-${room_id}-popup #remove-room-image1`).value = '0';
                }
            })

            document.querySelector(`#change-img-room-${room_id}-popup .room-image2-input`).addEventListener('change', (e) => {
                const file = e.target.files[0];
                let files = e.target.files;
                console.log(room)
                if (files.length > 0) {
                    preview_image(files[0], document.querySelector(`#change-img-room-${room_id}-popup .room-image2`));
                    document.querySelector(`#change-img-room-${room_id}-popup .room-image2-preview`).style.display = 'flex';
                    document.querySelector(`#change-img-room-${room_id}-popup .room-drop2-image`).style.display = 'none';
                    document.querySelector(`#change-img-room-${room_id}-popup .room-file2-delete`).style.display = 'block';
                    document.querySelector(`#change-img-room-${room_id}-popup #remove-room-image2`).value = '0';
                }
            })

            document.querySelector(`#change-img-room-${room_id}-popup .room-image3-input`).addEventListener('change', (e) => {
                const file = e.target.files[0];
                let files = e.target.files;
                console.log(room)
                if (files.length > 0) {
                    preview_image(files[0], document.querySelector(`#change-img-room-${room_id}-popup .room-image3`));
                    document.querySelector(`#change-img-room-${room_id}-popup .room-image3-preview`).style.display = 'flex';
                    document.querySelector(`#change-img-room-${room_id}-popup .room-drop3-image`).style.display = 'none';
                    document.querySelector(`#change-img-room-${room_id}-popup .room-file3-delete`).style.display = 'block';
                    document.querySelector(`#change-img-room-${room_id}-popup #remove-room-image3`).value = '0';
                }
            })

            document.querySelector(`#change-img-room-${room_id}-popup .room-image4-input`).addEventListener('change', (e) => {
                const file = e.target.files[0];
                let files = e.target.files;
                console.log(room)
                if (files.length > 0) {
                    preview_image(files[0], document.querySelector(`#change-img-room-${room_id}-popup .room-image4`));
                    document.querySelector(`#change-img-room-${room_id}-popup .room-image4-preview`).style.display = 'flex';
                    document.querySelector(`#change-img-room-${room_id}-popup .room-drop4-image`).style.display = 'none';
                    document.querySelector(`#change-img-room-${room_id}-popup .room-file4-delete`).style.display = 'block';
                    document.querySelector(`#change-img-room-${room_id}-popup #remove-room-image4`).value = '0';
                }
            })
        })

        function preview_image(file, img_box) {
            let reader = new FileReader();
            reader.onload = function(e) {
                img_box.src = e.target.result;
            }
            reader.readAsDataURL(file);
        }

        function removeImage(room_id, roomImageInput, roomImagePreview, roomImage, roomDropImage, roomFileDelete, removeRoomImgInput){
            // Reference the elements
            imageInput = document.querySelector(`#change-img-room-${room_id}-popup `+roomImageInput);
            imagePreviewContainer = document.querySelector(`#change-img-room-${room_id}-popup `+roomImagePreview);
            imageElement = document.querySelector(`#change-img-room-${room_id}-popup `+roomImage);
            dropImageContainer = document.querySelector(`#change-img-room-${room_id}-popup `+roomDropImage);
            deleteImageContainer = document.querySelector(`#change-img-room-${room_id}-popup `+roomFileDelete);
            removeRoomImg = document.querySelector(`#change-img-room-${room_id}-popup `+removeRoomImgInput);

            // Clear the file input value
            imageInput.value = '';

            // Reset the image source and hide the preview container
            imageElement.src = '';
            imagePreviewContainer.style.display = 'none';

            // Show the initial "Click to select image" container
            dropImageContainer.style.display = 'block';
            deleteImageContainer.style.display = 'none';

            // Set the hidden input value to 1 to mark for deletion
            removeRoomImg.value = '1';
        }

        function back_click() {
            document.getElementById(`room-${room_id_opened}`).style.display = 'none';
            document.getElementById('main').style.display = 'block';
            document.getElementById('nav-button').style.display = 'flex';
            document.getElementById('room-nav-button').style.display = 'none';

        }

        function toggleCalenderOrList(tab_number, room_id){
            document.getElementById(`room-${room_id}-header-1`).classList.remove('active');
            document.getElementById(`room-${room_id}-header-2`).classList.remove('active');
            document.getElementById(`room-${room_id}-header-${tab_number}`).classList.add('active');

            document.getElementById(`room-${room_id}-tab-1`).classList.remove('active');
            document.getElementById(`room-${room_id}-tab-2`).classList.remove('active');
            document.getElementById(`room-${room_id}-tab-${tab_number}`).classList.add('active');

            if (tab_number == 2) {
                document.querySelectorAll('.cancel-class-button1').forEach(b => {b.style.display = 'none'})
                document.querySelectorAll('.cancel-class-button2').forEach(b => {b.style.display = 'block'})
            } else {
                document.querySelectorAll('.cancel-class-button2').forEach(b => {b.style.display = 'none'})
                document.querySelectorAll('.cancel-class-button1').forEach(b => {b.style.display = 'block'})
            }
        }
    

        function toggleReason(reasonSectionId, checkboxId, statusId, reasonId) {
            let reasonSection = document.getElementById(reasonSectionId);
            let checkbox = document.getElementById(checkboxId);
            let statusInput = document.getElementById(statusId);
            
            let reasonInput = document.getElementById(reasonId);
            
            if (checkbox.checked) {
                reasonSection.style.display = 'block';  // Show section
                statusInput.value = 'Unavailable';
            } else {
                reasonSection.style.display = 'none';   // Hide section
                statusInput.value = 'Available';
                reasonInput.value = '';
            }
        }

        let startDateInput = document.getElementById('class_start_date');
        let endDateInput = document.getElementById('class_end_date');

        // When start date changes, adjust end date if needed
        startDateInput.addEventListener('change', function() {
            let startDateValue = new Date(startDateInput.value);
            let endDateValue = new Date(endDateInput.value);

            // If end date is earlier than start date, adjust end date
            if (startDateValue && (!endDateInput.value || startDateValue > endDateValue)) {
                endDateInput.value = startDateInput.value;
            }
        });

        // When end date changes, adjust start date if needed
        endDateInput.addEventListener('change', function() {
            let startDateValue = new Date(startDateInput.value);
            let endDateValue = new Date(endDateInput.value);

            // If start date is later than end date, adjust start date
            if (endDateValue && (!startDateInput.value || endDateValue < startDateValue)) {
                startDateInput.value = endDateInput.value;
            }
        });

        <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            startDateInputEdit = document.getElementById('edit-class-<?php echo e($class->id); ?>-start-date');
            endDateInputEdit = document.getElementById('edit-class-<?php echo e($class->id); ?>-end-date');

            // When start date changes, adjust end date if needed
            startDateInputEdit.addEventListener('change', function() {
                startDateValueEdit = new Date(startDateInputEdit.value);
                endDateValueEdit = new Date(endDateInputEdit.value);

                // If end date is earlier than start date, adjust end date
                if (startDateValueEdit && (!endDateInputEdit.value || startDateValueEdit > endDateValueEdit)) {
                    endDateInputEdit.value = startDateInputEdit.value;
                }
            });

            // When end date changes, adjust start date if needed
            endDateInputEdit.addEventListener('change', function() {
                startDateValueEdit = new Date(startDateInputEdit.value);
                endDateValueEdit = new Date(endDateInputEdit.value);

                // If start date is later than end date, adjust start date
                if (endDateValueEdit && (!startDateInputEdit.value || endDateValueEdit < startDateValueEdit)) {
                    startDateInputEdit.value = endDateInputEdit.value;
                }
            });

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
        // to remove session on the last session page
        localStorage.removeItem('classroom-management-session');

        let current_date = new Date();
        let month = current_date.getMonth() + 1;
        let year = current_date.getFullYear();

        // return dates for month with day names based on given year and month
        function get_dates_for_month_with_day_names(year, month) {
            const dates = [];
            const startDate = new Date(year, month - 1, 1);
            const endDate = new Date(year, month, 0);
            let currentDate = startDate;
            let week = 1;
            let firstDay = true;
            while (currentDate <= endDate) {
                const day = currentDate.getDate();
                const dayName = currentDate.toLocaleDateString('en-US', { weekday: 'long' });
                if (!firstDay) { if(dayName == 'Sunday') {week += 1}; };
                if (firstDay) { if(dayName == 'Sunday') {week = 1}; firstDay = false};
                const dateObject = {
                    day: day,
                    month: month,
                    dayName: dayName,
                    year: year,
                    week: week,
                    date: currentDate.getDate(),
                }
                dates.push(dateObject);
                currentDate.setDate(currentDate.getDate() + 1)
            }
            return dates;
        }

        // for holiday in the calender
        const holidaysCalender = <?php echo json_encode(App\Models\Holidays::all(), 15, 512) ?>;

        // Setup calendar in room
        function setup_calendar(room_id, classes, room_name) {
            document.getElementById(`monthYearDisplay-${room_id}`).textContent = `${monthNames[month-1]} ${year}`;

            const datesForMonth = get_dates_for_month_with_day_names(year, month);
            cells = document.querySelectorAll(`#calendar-room-${room_id} .calendar-cell`);
            cells.forEach(cell => {
                cell.classList.remove('exist');
                // holiday
                cell.classList.remove('holiday-calender');
            });

            start_time_setting = <?php echo json_encode(App\Models\Settings::where('setting_key', 'start_time')->get()->first()->setting_value, 512) ?>;
            end_time_setting = <?php echo json_encode(App\Models\Settings::where('setting_key', 'end_time')->get()->first()->setting_value, 512) ?>;

            document.querySelectorAll(`#calendar-room-${room_id} .calendar-cell`).forEach(cell => {
                cell.onclick = null;
                cell.innerHTML = '';
            })

            datesForMonth.forEach(date => {
                let week = '';
                switch(date.week) {
                    case 1: week = 'first'; break;
                    case 2: week = 'second'; break;
                    case 3: week = 'third'; break;
                    case 4: week = 'fourth'; break;
                    case 5: week = 'fifth'; break;
                    case 6: week = 'sixth'; break;
                }
                const cell = document.querySelector(`#calendar-room-${room_id} .calendar-cell.${week}.${date.dayName.toLowerCase()}`);
                cell.classList.add('exist');
                cell.innerHTML = `
                    <div class="day-number">${date.day.toString().padStart(2, '0')}</div>
                `;

                // Check if the date is a holiday
                const dateStringHoliday = `${date.year}-${date.month.toString().padStart(2, '0')}-${date.day.toString().padStart(2, '0')}`;
                if (holidaysCalender.some(holiday => holiday.date == dateStringHoliday)) {
                    cell.classList.add('holiday');
                    const dayNumberHoliday = cell.querySelector('.day-number');
                    dayNumberHoliday.style.color = 'red';
                } 

                class_hours = 0;
                classes.forEach(clss => {
                    if((new Date(clss.start_date_time)).getDate() == date.date && (new Date(clss.start_date_time)).getMonth()+1 == date.month && (new Date(clss.start_date_time)).getFullYear() == date.year) {
                        const start_time = new Date(clss.start_date_time.replace(" ", "T"));
                        const end_time = new Date(clss.end_date_time.replace(" ", "T"));
                        const diffInMilliseconds = end_time - start_time;
                        const diffInHours = diffInMilliseconds / (1000 * 60 * 60);
                        class_hours += diffInHours;
                    }
                })
                const [startHours, startMinutes] = start_time_setting.split(':').map(Number)
                const [endHours, endMinutes] = end_time_setting.split(':').map(Number)
                startTime = new Date(year, month-1, date.date);
                startTime.setHours(startHours, startMinutes, 0, 0);
                endTime = new Date(year, month-1, date.date);
                endTime.setHours(endHours, endMinutes, 0, 0);

                const total_hours = (endTime.getTime() - startTime.getTime()) / (1000 * 60 * 60)
                const usage_percentage = Math.round(class_hours/total_hours * 10000) / 100;
                if (usage_percentage != 0) {
                    if (usage_percentage >= 100) {usage_percentage=100}
                    cell.innerHTML += `
                        <div class="day-percentage">${usage_percentage}%</div>
                    `
                } 

                cell.onclick = function () {
                    open_popup_click(`calendar-day-${room_id}-popup`);
                    popup = document.getElementById(`calendar-day-${room_id}-popup`)
                    time_slot = document.querySelector(`#calendar-day-${room_id}-popup .time-slot`);

                    time_slot_date = new Date(date.year, date.month - 1, date.day);
                    formatted_time_slot_date = time_slot_date.toLocaleDateString('en-GB', { day: '2-digit', month: 'long', year: 'numeric'});
                    popup.querySelector('.title span').textContent = `${formatted_time_slot_date}`;
                    
                    let timeSlotsHTML = '';
                    let classList = '';
                    div_description = '';
                    started = false;

                    startTime = new Date(year, month-1, date.date);
                    startTime.setHours(startHours, startMinutes, 0, 0);
                    endTime = new Date(year, month-1, date.date);
                    endTime.setHours(endHours, endMinutes, 0, 0);

                    sorted_classes = classes.sort((a, b) => { return new Date(a.start_date_time) - new Date(b.start_date_time); });
                    filtered_classes = sorted_classes.filter(item => {itemDate = new Date(item.start_date_time); return itemDate.getFullYear() == date.year && itemDate.getMonth()+1 == date.month && itemDate.getDate() == date.date;})
                    while (startTime <= endTime) {
                        let hours = startTime.getHours();
                        let minutes = startTime.getMinutes();
                        let period = hours >= 12 ? 'PM' : 'AM';
                        hours = hours % 12 || 12;
                        let formattedTime = `${hours}:${minutes.toString().padStart(2, '0')} ${period}`;
                        
                        div_description = '';
                        filtered_classes.forEach(clss => {
                            startDateTime = new Date(clss.start_date_time);
                            endDateTime = new Date(clss.end_date_time);
                            if (!started && (startDateTime <= startTime)) {
                                classList = 'bg-plt1-tr1';
                                total_row = Math.ceil((endDateTime - startDateTime)/1800000);
                                groups = <?php echo json_encode(App\Models\Groups::all(), 15, 512) ?>;
                                group = groups.filter(g => g.id === clss.group_id)[0];
                                class_start_time_string = `${startDateTime.getHours() % 12 || 12 }:${startDateTime.getMinutes().toString().padStart(2, '0')} ${startDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                                class_end_time_string = `${endDateTime.getHours()  % 12 || 12 }:${endDateTime.getMinutes().toString().padStart(2, '0')} ${endDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                                div_description = `
                                    <div class="bg-plt5" style="height:calc((100% + 1px) * ${total_row}); width:calc(100% - 110px); position:absolute; left:110px; z-index:2;">
                                        <div class="mg-l-10 cursor-pointer" onclick="open_popup_click('view-class-${clss.id}-popup')">
                                            <div class="fs-10 fw-bold clr-blue">${clss.title}</div>
                                            <div class="fs-10 clr-grey-2">${group.name}</div>
                                            <div class="fs-10">${class_start_time_string} - ${class_end_time_string}</div>
                                        </div>
                                    </div>
                                `;
                                total_row += 1;
                                started = true;
                                // if (filtered_classes[0]) {
                                //    if(new Date(filtered_classes[0].start_date_time) <= startTime)  {started=false}
                                // }
                            } else if(started && endDateTime <= startTime) {
                                classList = '';
                                started = false;
                                filtered_classes.shift();
                                if (filtered_classes[0]) {
                                   if(new Date(filtered_classes[0].start_date_time) <= startTime)  {
                                        clss_temp = filtered_classes[0];
                                        classList = 'bg-plt1-tr1';
                                        startDateTime = new Date(clss_temp.start_date_time);
                                        endDateTime = new Date(clss_temp.end_date_time);
                                        total_row = Math.ceil((endDateTime - startDateTime)/1800000);
                                        groups = <?php echo json_encode(App\Models\Groups::all(), 15, 512) ?>;
                                        group = groups.filter(g => g.id === clss_temp.group_id)[0];
                                        class_start_time_string = `${startDateTime.getHours() % 12 || 12 }:${startDateTime.getMinutes().toString().padStart(2, '0')} ${startDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                                        class_end_time_string = `${endDateTime.getHours() % 12 || 12 }:${endDateTime.getMinutes().toString().padStart(2, '0')} ${endDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                                        div_description = `
                                            <div class="bg-plt5 bs-bb" style="height:calc((100% + 1px) * ${total_row}); width:calc(100% - 110px); position:absolute; left:110px; z-index:2; border:1px solid #00000022;">
                                                <div class="mg-l-10 cursor-pointer" onclick="open_popup_click('view-class-${clss_temp.id}-popup')">
                                                    <div class="fs-10 fw-bold clr-blue">${clss_temp.title}</div>
                                                    <div class="fs-10 clr-grey-2">${group.name}</div>
                                                    <div class="fs-10">${class_start_time_string} - ${class_end_time_string}</div>
                                                </div>
                                            </div>
                                        `;
                                        total_row += 1;
                                        started = true;
                                   }
                                }
                            }
                        });

                        let start_phase = 'AM';
                        let start_hour = startTime.getHours();

                        start_phase = start_hour >= 12 ? 'PM' : 'AM';
                        start_hour_input = start_hour;
                        start_hour = start_hour % 12 || 12; // Convert to 12-hour format, handling midnight and noon
                        start_hour = start_hour.toString().padStart(2, '0');
                        start_hour_input = start_hour_input.toString().padStart(2, '0');
                        let start_minute = startTime.getMinutes().toString().padStart(2, '0');
                        
                        let startTime_temp = new Date(startTime.getTime()); 
                        startTime_temp.setMinutes(startTime_temp.getMinutes() + 30);
                        let end_phase = 'AM';
                        let end_hour = startTime_temp.getHours();
                        end_phase = end_hour >= 12 ? 'PM' : 'AM';
                        end_hour_input = end_hour;
                        end_hour = end_hour % 12 || 12; // Convert to 12-hour format
                        end_hour = end_hour.toString().padStart(2, '0');
                        end_hour_input = end_hour_input.toString().padStart(2, '0');
                        let end_minute = startTime_temp.getMinutes().toString().padStart(2, '0');

                        start_year = startTime.getFullYear().toString();
                        start_month = (startTime.getMonth() + 1).toString().padStart(2, '0');
                        start_date = startTime.getDate().toString().padStart(2, '0');

                        timeSlotsHTML += `
                        <div style="border-bottom: 1px solid #00000055; position:relative;" class="${classList} d-flex">
                            <div class="fs3 fw-bold clr-grey-2 w-100 f-shrink-0 pd-tb-10 pd-l-10">${formattedTime}</div>
                            <div class="time-slot-hv w-100p pd-tb-10 cursor-pointer fs3 fw-bold txt-c clr-white" onclick="
                            open_popup_click('add-class-popup');
                            document.getElementById('class-room-dropdown-button').textContent = '${room_name}';
                            document.getElementById('class-room-dropdown-input').value = '${room_id}';
                            document.getElementById('repeat-until-input').value = '${start_year}-${start_month}-${start_date}';
                            document.getElementById('class_start_date').value = '${start_year}-${start_month}-${start_date}';
                            document.getElementById('class_add_start_date').textContent = '${start_date}/${start_month}/${start_year}';
                            document.getElementById('start_time').value = '${start_hour_input}:${start_minute}:00';
                            document.getElementById('start-hour-dropdown-button').textContent = '${start_hour}';
                            document.getElementById('start-minute-dropdown-button').textContent = '${start_minute}';
                            document.getElementById('start-phase-dropdown-button').textContent = '${start_phase}';
                            document.getElementById('class_end_date').value = '${start_year}-${start_month}-${start_date}';
                            document.getElementById('class_add_end_date').textContent = '${start_date}/${start_month}/${start_year}';
                            document.getElementById('end_time').value = '${end_hour_input}:${end_minute}:00';
                            document.getElementById('end-hour-dropdown-button').textContent = '${end_hour}';
                            document.getElementById('end-minute-dropdown-button').textContent = '${end_minute}';
                            document.getElementById('end-phase-dropdown-button').textContent = '${end_phase}';
                            ">Add New Class</div>
                            ${div_description}
                        </div>
                        `;
                        startTime.setMinutes(startTime.getMinutes() + 30);
                    }
                    time_slot.innerHTML = timeSlotsHTML;
                }
            });
        }

        //next month, calender or list calender
        const monthNames = [
        "January", "February", "March", "April", "May", "June",
        "July", "August", "September", "October", "November", "December"
        ];

        let holidays = <?php echo json_encode($holidays->map(function($holiday) {
            return [
                'date' => \Carbon\Carbon::parse($holiday->date)->format('Y-m-d'), // Format date as string
                'description' => $holiday->description
            ];
        }), 512) ?>;

        function previousMonth(room_id, classes, room_name){
            month--;
            if (month < 1) {
                month = 12;
                year--;
            }
            // document.getElementById(`monthYearDisplay-${room_id}`).textContent = `${monthNames[month]} ${year}`;
            setup_calendar(room_id, classes, room_name);
            // sixth_row = document.querySelectorAll(`#calendar-room-${room_id} .sixth.exist`);
            // if (sixth_row.length == 0) {
            //     document.querySelector(`#calendar-room-${room_id}`).style.height = '600px';
            // } else {
            //     document.querySelector(`#calendar-room-${room_id}`).style.height = '700px';
            // }
            showHolidayForMonth(month, year, room_id);
        }
        function nextMonth(room_id, classes, room_name){
            month++;
            if (month > 12) {
                month = 1;
                year++;
            }
            // document.getElementById(`monthYearDisplay-${room_id}`).textContent = `${monthNames[month]} ${year}`;
            setup_calendar(room_id, classes, room_name)
            // sixth_row = document.querySelectorAll(`#calendar-room-${room_id} .sixth.exist`);
            // if (sixth_row.length == 0) {
            //     document.querySelector(`#calendar-room-${room_id}`).style.height = '600px';
            // } else {
            //     document.querySelector(`#calendar-room-${room_id}`).style.height = '700px';
            // }
            showHolidayForMonth(month, year, room_id);
        }

        // document.querySelectorAll('.calendar').forEach(calendar => {
        //     sixth_row = calendar.querySelectorAll(`.sixth.exist`);
        //     if (sixth_row.length == 0) {
        //         calendar.style.height = '600px';
        //     } else {
        //         calendar.style.height = '700px';
        //     }
        // })

        // document.addEventListener("DOMContentLoaded", function() {
        //     showHolidayForMonth(month, year);
        // });

    
        //     showHolidayForMonth(month, year, room_id) this is on
        // 

        function showHolidayForMonth(month, year, room_id){
            let holiday = holidays.filter(holiday =>{
                // console.log('Holiday date:', holiday.date); 
                let holidayDate = new Date(holiday.date);
                return holidayDate.getMonth() + 1 === month && holidayDate.getFullYear() === year;
            });

            let holidayDisplay = document.getElementById(`holidayDisplay-${room_id}`);

            // If there are holidays for the month, display them
            if (holiday.length > 0) {
                holidayDisplay.innerHTML = holiday.map(holiday => {
                    let formattedDate = new Date(holiday.date).toLocaleDateString('en-GB', { day: '2-digit', month: 'short' });
                    return `<div class="d-flex mg-5">
                            <div class="fs4 fw-bold txt-nowrap">${formattedDate}</div>
                            <div class="fs4 clr-grey-1 fw-bold txt-nowrap"> - ${holiday.description}</div>
                            </div>
                            `;
                }).join(""); // Join all holiday elements into one string
                holidayDisplay.style.display = 'flex';
            } else {
                holidayDisplay.style.display = 'none';
            }
        }

        //add room, faculty dropdown
        add_dropdown_event('add-room-faculty-dropdown-button','add-room-faculty-dropdown');
        add_search('add-room-faculty-search', 'add-room-faculty-dropdown');
        //add room, building dropdown
        add_dropdown_event('add-room-building-dropdown-button','add-room-building-dropdown');
        add_search('add-room-building-search', 'add-room-building-dropdown');
        //add room, level dropdown
        add_dropdown_event('add-room-level-dropdown-button','add-room-level-dropdown');
        add_search('add-room-level-search', 'add-room-level-dropdown');
        //add room, roomType dropdown
        add_dropdown_event('add-room-type-dropdown-button','add-room-type-dropdown');
        add_search('add-room-type-search', 'add-room-type-dropdown');

        add_dropdown_event('room-option-dropdown-button', 'room-option-dropdown');

        //edit room dropdown
        <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $classes = $room->classes; ?>
            classes = <?php echo json_encode($classes, 15, 512) ?>;
            setup_calendar(<?php echo e($room->id); ?>, classes, '<?php echo e($room->name); ?>');

            //edit room, faculty dropdown
            add_dropdown_event('edit-room-faculty-<?php echo e($room->id); ?>-dropdown-button','edit-room-faculty-<?php echo e($room->id); ?>-dropdown');
            add_search('edit-room-faculty-<?php echo e($room->id); ?>-search', 'edit-room-faculty-<?php echo e($room->id); ?>-dropdown');
            //edit room, building dropdown
            add_dropdown_event('edit-room-building-<?php echo e($room->id); ?>-dropdown-button','edit-room-building-<?php echo e($room->id); ?>-dropdown');
            add_search('edit-room-building-<?php echo e($room->id); ?>-search', 'edit-room-building-<?php echo e($room->id); ?>-dropdown');
            //edit room, level dropdown
            add_dropdown_event('edit-room-level-<?php echo e($room->id); ?>-dropdown-button','edit-room-level-<?php echo e($room->id); ?>-dropdown');
            add_search('edit-room-level-<?php echo e($room->id); ?>-search', 'edit-room-level-<?php echo e($room->id); ?>-dropdown');
            //edit room, roomType dropdown
            add_dropdown_event('edit-room-type-<?php echo e($room->id); ?>-dropdown-button','edit-room-type-<?php echo e($room->id); ?>-dropdown');
            add_search('edit-room-type-<?php echo e($room->id); ?>-search', 'edit-room-type-<?php echo e($room->id); ?>-dropdown');
            add_dropdown_event('edit-reason-<?php echo e($room->id); ?>-dropdown-button','edit-reason-<?php echo e($room->id); ?>-dropdown');
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        // from class index
        // add classes, room dropdown
        // add_dropdown_event('class-room-dropdown-button','class-room-dropdown');
        // add_search('class-room-search', 'class-room-dropdown');
        // add classes, group dropdown
        add_dropdown_event('class-group-dropdown-button','class-group-dropdown');
        add_search('class-group-search', 'class-group-dropdown');
        // add classes, repeat type dropdown
        add_dropdown_event('class-type-dropdown-button','class-type-option-dropdown');
        // add classes, start & end time dropdown
        add_dropdown_event('start-hour-dropdown-button','start-hour-dropdown');
        add_dropdown_event('start-minute-dropdown-button','start-minute-dropdown');
        add_dropdown_event('start-phase-dropdown-button','start-phase-dropdown');
        add_dropdown_event('end-hour-dropdown-button','end-hour-dropdown');
        add_dropdown_event('end-minute-dropdown-button','end-minute-dropdown');
        add_dropdown_event('end-phase-dropdown-button','end-phase-dropdown');
        <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            // edit classes, room dropdown
            add_dropdown_event('class-room-<?php echo e($class->id); ?>-dropdown-button','class-room-<?php echo e($class->id); ?>-dropdown');
            add_search('class-room-<?php echo e($class->id); ?>-search', 'class-room-<?php echo e($class->id); ?>-dropdown');
            // edit classes, group dropdown
            add_dropdown_event('class-group-<?php echo e($class->id); ?>-dropdown-button','class-group-<?php echo e($class->id); ?>-dropdown');
            add_search('class-group-<?php echo e($class->id); ?>-search', 'class-group-<?php echo e($class->id); ?>-dropdown');
            // edit classes, start & end time dropdown
            add_dropdown_event('start-hour-<?php echo e($class->id); ?>-dropdown-button','start-hour-<?php echo e($class->id); ?>-dropdown');
            add_dropdown_event('start-minute-<?php echo e($class->id); ?>-dropdown-button','start-minute-<?php echo e($class->id); ?>-dropdown');
            add_dropdown_event('start-phase-<?php echo e($class->id); ?>-dropdown-button','start-phase-<?php echo e($class->id); ?>-dropdown');
            add_dropdown_event('end-hour-<?php echo e($class->id); ?>-dropdown-button','end-hour-<?php echo e($class->id); ?>-dropdown');
            add_dropdown_event('end-minute-<?php echo e($class->id); ?>-dropdown-button','end-minute-<?php echo e($class->id); ?>-dropdown');
            add_dropdown_event('end-phase-<?php echo e($class->id); ?>-dropdown-button','end-phase-<?php echo e($class->id); ?>-dropdown');
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
        function add_faculty_dropdown_click(faculty_id) {
            dropdown = document.getElementById('add-room-building-dropdown');
            document.getElementById('add-room-building-dropdown-button').textContent = '';
            document.getElementById('add-room-building-dropdown-input').value = '';
            document.getElementById('add-room-level-dropdown-button').textContent = '';
            document.getElementById('add-room-level-dropdown-input').value = '';
            dropdown.innerHTML = `
            <div class="d-flex">
                <input type="text" name="" id="add-room-building-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
            </div>
            ` 
            buildings = <?php echo json_encode($buildings, 15, 512) ?>;
            buildings = buildings.filter(building => building.faculty_id == faculty_id);

            buildings.forEach(building => {
                dropdown.innerHTML += `
                    <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'add-room-building-dropdown-button', 'add-room-building-dropdown-input', ${building.id}, 'add-room-building-dropdown'); add_building_dropdown_click(${building.id});" style="border:none;">${building.name}</div>
                `
            })
        }

        function add_building_dropdown_click(building_id) {
            dropdown = document.getElementById('add-room-level-dropdown');
            document.getElementById('add-room-level-dropdown-button').textContent = '';
            document.getElementById('add-room-level-dropdown-input').value = '';
            dropdown.innerHTML = `
            <div class="d-flex">
                <input type="text" name="" id="add-room-level-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
            </div>
            ` 

            levels = <?php echo json_encode($levels, 15, 512) ?>;
            levels = levels.filter(level => level.building_id == building_id);

            // levels 
            levels.forEach(level => {
                dropdown.innerHTML += `
                    <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'add-room-level-dropdown-button', 'add-room-level-dropdown-input', ${level.id}, 'add-room-level-dropdown')" style="border:none;">${level.name}</div>
                `
            })
        }

        function edit_faculty_dropdown_click(room_id, faculty_id) {
            dropdown = document.getElementById(`edit-room-building-${room_id}-dropdown`);
            document.getElementById(`edit-room-building-${room_id}-dropdown-button`).textContent = '';
            document.getElementById(`edit-room-building-${room_id}-dropdown-input`).value = '';
            document.getElementById(`edit-room-level-${room_id}-dropdown-button`).textContent = '';
            document.getElementById(`edit-room-level-${room_id}-dropdown-input`).value = '';
            dropdown.innerHTML = `
            <div class="d-flex">
                <input type="text" name="" id="edit-room-building-${room_id}-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
            </div>
            ` 

            buildings = <?php echo json_encode($buildings, 15, 512) ?>;
            buildings = buildings.filter(building => building.faculty_id == faculty_id);

            buildings.forEach(building => {
                dropdown.innerHTML += `
                    <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'edit-room-building-${room_id}-dropdown-button', 'edit-room-building-${room_id}-dropdown-input', ${building.id}, 'edit-room-building-${room_id}-dropdown'); edit_building_dropdown_click(${room_id}, ${building.id});" style="border:none;">${building.name}</div>
                `
            })
        }

        function edit_building_dropdown_click(room_id, building_id) {
            dropdown = document.getElementById(`edit-room-level-${room_id}-dropdown`);
            document.getElementById(`edit-room-level-${room_id}-dropdown-button`).textContent = '';
            document.getElementById(`edit-room-level-${room_id}-dropdown-input`).value = '';
            dropdown.innerHTML = `
            <div class="d-flex">
                <input type="text" name="" id="edit-room-level-${room_id}-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
            </div>
            ` 

            levels = <?php echo json_encode($levels, 15, 512) ?>;
            levels = levels.filter(level => level.building_id == building_id);
            
            levels.forEach(level => {
                dropdown.innerHTML += `
                    <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'edit-room-level-${room_id}-dropdown-button', 'edit-room-level-${room_id}-dropdown-input', ${level.id}, 'edit-room-level-${room_id}-dropdown')" style="border:none;">${level.name}</div>
                `
            })
        }

        firstDay = new Date();
        secondDay = new Date();
        thirdDay = new Date();

        function previousDay(room_id, classes){
            firstDay.setDate(firstDay.getDate() - 1);
            secondDay.setDate(secondDay.getDate() - 1);
            thirdDay.setDate(thirdDay.getDate() - 1);

            document.querySelector(`#room-${room_id}-tab-2 .first-day-date`).textContent = firstDay.getDate().toString().padStart(2, '0');
            document.querySelector(`#room-${room_id}-tab-2 .second-day-date`).textContent = secondDay.getDate().toString().padStart(2, '0');
            document.querySelector(`#room-${room_id}-tab-2 .third-day-date`).textContent = thirdDay.getDate().toString().padStart(2, '0');

            document.querySelector(`#room-${room_id}-tab-2 .first-day-month`).textContent = firstDay.toLocaleString('en-US', { month: 'short' })
            document.querySelector(`#room-${room_id}-tab-2 .second-day-month`).textContent = secondDay.toLocaleString('en-US', { month: 'short' })
            document.querySelector(`#room-${room_id}-tab-2 .third-day-month`).textContent = thirdDay.toLocaleString('en-US', { month: 'short' })

            document.querySelector(`#room-${room_id}-tab-2 .first-day-name`).textContent = firstDay.toLocaleString('en-US', { weekday: 'short' })
            document.querySelector(`#room-${room_id}-tab-2 .second-day-name`).textContent = secondDay.toLocaleString('en-US', { weekday: 'short' })
            document.querySelector(`#room-${room_id}-tab-2 .third-day-name`).textContent = thirdDay.toLocaleString('en-US', { weekday: 'short' })
            
            set_time_slot_date_list(room_id, classes)
        }
        function nextDay(room_id, classes){
            firstDay.setDate(firstDay.getDate() + 1);
            secondDay.setDate(secondDay.getDate() + 1);
            thirdDay.setDate(thirdDay.getDate() + 1);

            document.querySelector(`#room-${room_id}-tab-2 .first-day-date`).textContent = firstDay.getDate().toString().padStart(2, '0');
            document.querySelector(`#room-${room_id}-tab-2 .second-day-date`).textContent = secondDay.getDate().toString().padStart(2, '0');
            document.querySelector(`#room-${room_id}-tab-2 .third-day-date`).textContent = thirdDay.getDate().toString().padStart(2, '0');

            document.querySelector(`#room-${room_id}-tab-2 .first-day-month`).textContent = firstDay.toLocaleString('en-US', { month: 'short' })
            document.querySelector(`#room-${room_id}-tab-2 .second-day-month`).textContent = secondDay.toLocaleString('en-US', { month: 'short' })
            document.querySelector(`#room-${room_id}-tab-2 .third-day-month`).textContent = thirdDay.toLocaleString('en-US', { month: 'short' })

            document.querySelector(`#room-${room_id}-tab-2 .first-day-name`).textContent = firstDay.toLocaleString('en-US', { weekday: 'short' })
            document.querySelector(`#room-${room_id}-tab-2 .second-day-name`).textContent = secondDay.toLocaleString('en-US', { weekday: 'short' })
            document.querySelector(`#room-${room_id}-tab-2 .third-day-name`).textContent = thirdDay.toLocaleString('en-US', { weekday: 'short' })

            set_time_slot_date_list(room_id, classes)
        }

        <?php $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            room_id = <?php echo json_encode($room->id, 15, 512) ?>;
            classes = <?php echo json_encode($room->classes, 15, 512) ?>;
            set_time_slot_date_list(room_id, classes);
            showHolidayForMonth(month, year, room_id); //for show the holiday each calender in the room, the function located at above
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        function set_time_slot_date_list(room_id, classes) {
            const start_time_setting = <?php echo json_encode(App\Models\Settings::where('setting_key', 'start_time')->get()->first()->setting_value, 512) ?>;
            const end_time_setting = <?php echo json_encode(App\Models\Settings::where('setting_key', 'end_time')->get()->first()->setting_value, 512) ?>;
            const [startHours, startMinutes] = start_time_setting.split(':').map(Number)
            const [endHours, endMinutes] = end_time_setting.split(':').map(Number)

            startTime = new Date(firstDay);
            startTime.setHours(startHours, startMinutes, 0, 0);
            endTime = new Date(firstDay);
            endTime.setHours(endHours, endMinutes, 0, 0);

            firstStartTime = new Date(firstDay);
            firstStartTime.setHours(startHours, startMinutes, 0, 0);
            firstEndTime = new Date(firstDay);
            firstEndTime.setHours(endHours, endMinutes, 0, 0);

            secondStartTime = new Date(secondDay);
            secondStartTime.setHours(startHours, startMinutes, 0, 0);
            secondEndTime = new Date(secondDay);
            secondEndTime.setHours(endHours, endMinutes, 0, 0);

            thirdStartTime = new Date(thirdDay);
            thirdStartTime.setHours(startHours, startMinutes, 0, 0);
            thirdEndTime = new Date(thirdDay);
            thirdEndTime.setHours(endHours, endMinutes, 0, 0);
            
            let firstClassList = '';
            let firstStarted = false;
            let first_div_description = ``;
            let secondClassList = '';
            let secondStarted = false;
            let second_div_description = ``;
            let thirdClassList = '';
            let thirdStarted = false;
            let third_div_description = ``;
            sorted_classes = classes.sort((a, b) => { return new Date(a.start_date_time) - new Date(b.start_date_time); });
            
            first_filtered_classes = sorted_classes.filter(clss => {classDate = new Date(clss.start_date_time); return classDate.getFullYear() == firstDay.getFullYear() && classDate.getMonth()+1 == firstDay.getMonth()+1 && classDate.getDate() == firstDay.getDate();})
            second_filtered_classes = sorted_classes.filter(clss => {classDate = new Date(clss.start_date_time); return classDate.getFullYear() == secondDay.getFullYear() && classDate.getMonth()+1 == secondDay.getMonth()+1 && classDate.getDate() == secondDay.getDate();})
            third_filtered_classes = sorted_classes.filter(clss => {classDate = new Date(clss.start_date_time); return classDate.getFullYear() == thirdDay.getFullYear() && classDate.getMonth()+1 == thirdDay.getMonth()+1 && classDate.getDate() == thirdDay.getDate();})

            timeSlotsHTML = ``
            while (startTime <= endTime) {
                let hours = startTime.getHours();
                let minutes = startTime.getMinutes();
                let period = hours >= 12 ? 'PM' : 'AM';
                hours = hours % 12 || 12;
                let formattedTime = `${hours}:${minutes.toString().padStart(2, '0')} ${period}`;

                first_div_description = ``
                first_filtered_classes.forEach(clss => {
                    startDateTime = new Date(clss.start_date_time);
                    endDateTime = new Date(clss.end_date_time);
                    if (!firstStarted && (startDateTime <= startTime)) {
                        // firstClassList = 'bg-plt1-tr1';
                        total_row = Math.ceil((endDateTime - startDateTime)/1800000);
                        groups = <?php echo json_encode(App\Models\Groups::all(), 15, 512) ?>;
                        group = groups.filter(g => g.id === clss.group_id)[0];
                        class_start_time_string = `${startDateTime.getHours() % 12 || 12 }:${startDateTime.getMinutes().toString().padStart(2, '0')} ${startDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                        class_end_time_string = `${endDateTime.getHours()  % 12 || 12 }:${endDateTime.getMinutes().toString().padStart(2, '0')} ${endDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                        first_div_description = `
                            <div class="bg-plt5" style="height:calc((100% + 1px) * ${total_row}); width:calc(100% - 10px); position:absolute; z-index:2;">
                                <div class="mg-l-10 cursor-pointer" onclick="open_popup_click('view-class-${clss.id}-popup')">
                                    <div class="fs-10 fw-bold clr-blue">${clss.title}</div>
                                    <div class="fs-10 clr-grey-2">${group.name}</div>
                                    <div class="fs-10">${class_start_time_string} - ${class_end_time_string}</div>
                                </div>
                            </div>
                        `
                        firstStarted = true;
                    } else if(firstStarted && endDateTime <= startTime){
                        // firstClassList = ''
                        firstStarted = false;
                        first_filtered_classes.shift();
                        if (first_filtered_classes[0]) {
                            if(new Date(first_filtered_classes[0].start_date_time) <= startTime)  {
                                clss_temp = first_filtered_classes[0];
                                // firstClassList = 'bg-plt1-tr1';
                                startDateTime = new Date(clss_temp.start_date_time);
                                endDateTime = new Date(clss_temp.end_date_time);
                                total_row = Math.ceil((endDateTime - startDateTime)/1800000);
                                groups = <?php echo json_encode(App\Models\Groups::all(), 15, 512) ?>;
                                group = groups.filter(g => g.id === clss_temp.group_id)[0];
                                class_start_time_string = `${startDateTime.getHours() % 12 || 12 }:${startDateTime.getMinutes().toString().padStart(2, '0')} ${startDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                                class_end_time_string = `${endDateTime.getHours() % 12 || 12 }:${endDateTime.getMinutes().toString().padStart(2, '0')} ${endDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                                first_div_description = `
                                    <div class="bg-plt5 bs-bb" style="height:calc((100% + 1px) * ${total_row}); width:calc(100% - 10px); position:absolute; z-index:2; border:1px solid #00000022;">
                                        <div class="mg-l-10 cursor-pointer" onclick="open_popup_click('view-class-${clss_temp.id}-popup')">
                                            <div class="fs-10 fw-bold clr-blue">${clss_temp.title}</div>
                                            <div class="fs-10 clr-grey-2">${group.name}</div>
                                            <div class="fs-10">${class_start_time_string} - ${class_end_time_string}</div>
                                        </div>
                                    </div>
                                `;
                                firstStarted = true;
                            }
                        }
                    }
                })

                second_div_description = ``;
                second_filtered_classes.forEach(clss => {
                    startDateTime = new Date(clss.start_date_time);
                    startDateTime.setDate(startDateTime.getDate() - 1);
                    endDateTime = new Date(clss.end_date_time);
                    endDateTime.setDate(endDateTime.getDate() - 1);
                    // console.log(startDateTime)
                    if (!secondStarted && (startDateTime <= startTime)) {
                        // secondClassList = 'bg-plt1-tr1';
                        total_row = Math.ceil((endDateTime - startDateTime)/1800000);
                        groups = <?php echo json_encode(App\Models\Groups::all(), 15, 512) ?>;
                        group = groups.filter(g => g.id === clss.group_id)[0];
                        class_start_time_string = `${startDateTime.getHours() % 12 || 12 }:${startDateTime.getMinutes().toString().padStart(2, '0')} ${startDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                        class_end_time_string = `${endDateTime.getHours()  % 12 || 12 }:${endDateTime.getMinutes().toString().padStart(2, '0')} ${endDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                        second_div_description = `
                            <div class="bg-plt5" style="height:calc((100% + 1px) * ${total_row}); width:calc(100% - 10px); position:absolute; z-index:2;">
                                <div class="mg-l-10 cursor-pointer" onclick="open_popup_click('view-class-${clss.id}-popup')">
                                    <div class="fs-10 fw-bold clr-blue">${clss.title}</div>
                                    <div class="fs-10 clr-grey-2">${group.name}</div>
                                    <div class="fs-10">${class_start_time_string} - ${class_end_time_string}</div>
                                </div>
                            </div>
                        `
                        secondStarted = true;
                    } else if(secondStarted && endDateTime <= startTime){
                        // secondClassList = ''
                        secondStarted = false;
                        second_filtered_classes.shift();
                        if (second_filtered_classes[0]) {
                            classDate = new Date(second_filtered_classes[0].start_date_time);
                            classDate.setDate(classDate.getDate() - 1);
                            if(classDate <= startTime)  {
                                clss_temp = second_filtered_classes[0];
                                // secondClassList = 'bg-plt1-tr1';
                                startDateTime = new Date(clss_temp.start_date_time);
                                endDateTime = new Date(clss_temp.end_date_time);
                                total_row = Math.ceil((endDateTime - startDateTime)/1800000);
                                groups = <?php echo json_encode(App\Models\Groups::all(), 15, 512) ?>;
                                group = groups.filter(g => g.id === clss_temp.group_id)[0];
                                class_start_time_string = `${startDateTime.getHours() % 12 || 12 }:${startDateTime.getMinutes().toString().padStart(2, '0')} ${startDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                                class_end_time_string = `${endDateTime.getHours() % 12 || 12 }:${endDateTime.getMinutes().toString().padStart(2, '0')} ${endDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                                second_div_description = `
                                    <div class="bg-plt5 bs-bb" style="height:calc((100% + 1px) * ${total_row}); width:calc(100% - 10px); position:absolute; z-index:2; border:1px solid #00000022;">
                                        <div class="mg-l-10 cursor-pointer" onclick="open_popup_click('view-class-${clss_temp.id}-popup')">
                                            <div class="fs-10 fw-bold clr-blue">${clss_temp.title}</div>
                                            <div class="fs-10 clr-grey-2">${group.name}</div>
                                            <div class="fs-10">${class_start_time_string} - ${class_end_time_string}</div>
                                        </div>
                                    </div>
                                `;
                                secondStarted = true;
                            }
                        }
                        
                    }
                })

                third_div_description = ``;
                third_filtered_classes.forEach(clss => {
                    startDateTime = new Date(clss.start_date_time);
                    startDateTime.setDate(startDateTime.getDate() - 2);
                    endDateTime = new Date(clss.end_date_time);
                    endDateTime.setDate(endDateTime.getDate() - 2);
                    if (!thirdStarted && (startDateTime <= startTime)) {
                        // thirdClassList = 'bg-plt1-tr1';
                        total_row = Math.ceil((endDateTime - startDateTime)/1800000);
                        groups = <?php echo json_encode(App\Models\Groups::all(), 15, 512) ?>;
                        group = groups.filter(g => g.id === clss.group_id)[0];
                        class_start_time_string = `${startDateTime.getHours() % 12 || 12 }:${startDateTime.getMinutes().toString().padStart(2, '0')} ${startDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                        class_end_time_string = `${endDateTime.getHours()  % 12 || 12 }:${endDateTime.getMinutes().toString().padStart(2, '0')} ${endDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                        third_div_description = `
                            <div class="bg-plt5" style="height:calc((100% + 1px) * ${total_row}); width:calc(100% - 10px); position:absolute; z-index:2;">
                                <div class="mg-l-10 cursor-pointer" onclick="open_popup_click('view-class-${clss.id}-popup')">
                                    <div class="fs-10 fw-bold clr-blue">${clss.title}</div>
                                    <div class="fs-10 clr-grey-2">${group.name}</div>
                                    <div class="fs-10">${class_start_time_string} - ${class_end_time_string}</div>
                                </div>
                            </div>
                        `
                        thirdStarted = true;
                    } else if(thirdStarted && endDateTime <= startTime){
                        // thirdClassList = ''
                        thirdStarted = false;
                        third_filtered_classes.shift();
                        if (third_filtered_classes[0]) {
                            classDate = new Date(third_filtered_classes[0].start_date_time);
                            classDate.setDate(classDate.getDate() - 2);
                            if(classDate <= startTime)  {
                                clss_temp = third_filtered_classes[0];
                                // thirdClassList = 'bg-plt1-tr1';
                                startDateTime = new Date(clss_temp.start_date_time);
                                endDateTime = new Date(clss_temp.end_date_time);
                                total_row = Math.ceil((endDateTime - startDateTime)/1800000);
                                groups = <?php echo json_encode(App\Models\Groups::all(), 15, 512) ?>;
                                group = groups.filter(g => g.id === clss_temp.group_id)[0];
                                class_start_time_string = `${startDateTime.getHours() % 12 || 12 }:${startDateTime.getMinutes().toString().padStart(2, '0')} ${startDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                                class_end_time_string = `${endDateTime.getHours() % 12 || 12 }:${endDateTime.getMinutes().toString().padStart(2, '0')} ${endDateTime.getHours() >= 12 ? 'PM' : 'AM'}`
                                third_div_description = `
                                    <div class="bg-plt5 bs-bb" style="height:calc((100% + 1px) * ${total_row}); width:calc(100% - 10px); position:absolute; z-index:2; border:1px solid #00000022;">
                                        <div class="mg-l-10 cursor-pointer" onclick="open_popup_click('view-class-${clss_temp.id}-popup')">
                                            <div class="fs-10 fw-bold clr-blue">${clss_temp.title}</div>
                                            <div class="fs-10 clr-grey-2">${group.name}</div>
                                            <div class="fs-10">${class_start_time_string} - ${class_end_time_string}</div>
                                        </div>
                                    </div>
                                `;
                                thirdStarted = true;
                            }
                        }
                    }
                })

                timeSlotsHTML += `
                <div class="d-flex w-100p" style="border-top:1px solid #00000011">
                    <div class="fs3 fw-bold clr-grey-2 w-80 h-40 f-shrink-0 pd-l-10 d-flex ai-center">${formattedTime}</div>
                    <div class="d-flex w-700 f-shrink-0 h-40">
                        <div class="w-100p h-100p ${firstClassList}" style="position:relative;">${first_div_description}</div>
                        <div class="w-100p h-100p ${secondClassList}" style="position:relative;">${second_div_description}</div>
                        <div class="w-100p h-100p ${thirdClassList}" style="position:relative;">${third_div_description}</div>
                    </div>
                    
                </div>`;
                startTime.setMinutes(startTime.getMinutes() + 30);
            }

            document.getElementById(`time-slot-date-list-${room_id}`).innerHTML = timeSlotsHTML;
        }
    


        // add_dropdown_event('add-room-access-level-dropdown-button','add-room-access-level-dropdown');
        // add_search('add-room-access-level-search', 'add-room-access-level-dropdown');
        
        // Promise.all([fetch_data(api='/artemis/api/acs/v1/privilege/group', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({})),])
        //     .then(([data_door]) => {
        //         data_door = {"code":"0","msg":"Success","data":{"total":27,"pageNo":1,"pageSize":100,"list":[{"privilegeGroupId":"27","privilegeGroupName":"BILIK KULIAH E10","description":"BILIK KULIAH E10","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":218,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH E10","AreaName":"BILIK KULIAH E10","AreaID":43}}}]},{"privilegeGroupId":"26","privilegeGroupName":"BILIK KULIAH E9","description":"BILIK KULIAH E9","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":213,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH E9","AreaName":"BILIK KULIAH E9","AreaID":42}}}]},{"privilegeGroupId":"25","privilegeGroupName":"BILIK KULIAH E8","description":"BILIK KULIAH E8","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":208,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH E8","AreaName":"BILIK KULIAH E8","AreaID":41}}}]},{"privilegeGroupId":"24","privilegeGroupName":"BILIK KULIAH E7","description":"BILIK KULIAH E7","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":203,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH E7","AreaName":"BILIK KULIAH E7","AreaID":40}}}]},{"privilegeGroupId":"23","privilegeGroupName":"BILIK KULIAH B10","description":"BILIK KULIAH B10","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":98,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH B10","AreaName":"BILIK KULIAH B10","AreaID":20}}}]},{"privilegeGroupId":"22","privilegeGroupName":"BILIK KULIAH B9","description":"BILIK KULIAH B9","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":133,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH B9","AreaName":"BILIK KULIAH B9","AreaID":26}}}]},{"privilegeGroupId":"21","privilegeGroupName":"BILIK KULIAH B8","description":"BILIK KULIAH B8","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":93,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH B8","AreaName":"BILIK KULIAH B8","AreaID":19}}}]},{"privilegeGroupId":"20","privilegeGroupName":"BILIK KULIAH B7","description":"BILIK KULIAH B7","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":88,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH B7","AreaName":"BILIK KULIAH B7","AreaID":18}}}]},{"privilegeGroupId":"19","privilegeGroupName":"BILIK KULIAH E6","description":"BILIK KULIAH E6","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":63,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH E6","AreaName":"BILIK KULIAH E6","AreaID":13}}}]},{"privilegeGroupId":"18","privilegeGroupName":"BILIK KULIAH E5","description":"BILIK KULIAH E5","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":58,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH E5","AreaName":"BILIK KULIAH E5","AreaID":12}}}]},{"privilegeGroupId":"17","privilegeGroupName":"BILIK KULIAH B6","description":"BILIK KULIAH B6","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":123,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH B6","AreaName":"BILIK KULIAH B6","AreaID":24}}}]},{"privilegeGroupId":"16","privilegeGroupName":"BILIK KULIAH B5","description":"BILIK KULIAH B5","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":33,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH B5","AreaName":"BILIK KULIAH B5","AreaID":7}}}]},{"privilegeGroupId":"15","privilegeGroupName":"BILIK KULIAH B4","description":"BILIK KULIAH B4","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":28,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH B4","AreaName":"BILIK KULIAH B4","AreaID":6}}}]},{"privilegeGroupId":"14","privilegeGroupName":"BILIK KULIAH B3","description":"BILIK KULIAH B3","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":23,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH B3","AreaName":"BILIK KULIAH B3","AreaID":5}}}]},{"privilegeGroupId":"13","privilegeGroupName":"BILIK KULIAH E4","description":"BILIK KULIAH E4","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":153,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH E4","AreaName":"BILIK KULIAH E4","AreaID":30}}}]},{"privilegeGroupId":"12","privilegeGroupName":"BILIK KULIAH E3","description":"BILIK KULIAH E3","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":148,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH E3","AreaName":"BILIK KULIAH E3","AreaID":29}}}]},{"privilegeGroupId":"11","privilegeGroupName":"BILIK KULIAH E2","description":"BILIK KULIAH E2","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":143,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH E2","AreaName":"BILIK KULIAH E2","AreaID":28}}}]},{"privilegeGroupId":"10","privilegeGroupName":"BILIK KULIAH E1","description":"BILIK KULIAH E1","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":138,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH E1","AreaName":"BILIK KULIAH E1","AreaID":27}}}]},{"privilegeGroupId":"9","privilegeGroupName":"BILIK PERBINCANGAN 2 (B)","description":"BILIK PERBINCANGAN 2 (B)","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":103,"BaseInfo":{"ElementType":1002,"Name":"BILIK PERBINCANGAN 2 (B)","AreaName":"BILIK PERBINCANGAN 2 (B)","AreaID":4}}}]},{"privilegeGroupId":"8","privilegeGroupName":"BILIK PERBINCANGAN 1 (B)","description":"BILIK PERBINCANGAN 1 (B)","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":13,"BaseInfo":{"ElementType":1002,"Name":"BILIK PERBINCANGAN 1 (B)","AreaName":"BILIK PERBINCANGAN 1 (B)","AreaID":3}}}]},{"privilegeGroupId":"7","privilegeGroupName":"BILIK KULIAH B2","description":"BILIK KULIAH B2","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":8,"BaseInfo":{"ElementType":1002,"Name":"BILIK KULIAH B2","AreaName":"BILIK KULIAH B2","AreaID":2}}}]},{"privilegeGroupId":"6","privilegeGroupName":"BILIK KULIAH B1","description":"BILIK KULIAH B1","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":3,"BaseInfo":{"ElementType":1002,"Name":" BILIK KULIAH B1","AreaName":"BILIK KULIAH B1","AreaID":1}}}]},{"privilegeGroupId":"5","privilegeGroupName":"Dewan Kuliah Blok F","description":"Dewan Kuliah Blok F","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":68,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK F - 1 -Aras 1","AreaName":"DEWAN KULIAH BLOK F - 1 - Aras 1","AreaID":14}}},{"Element":{"ID":73,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK F–2-Aras1","AreaName":"DEWAN KULIAH BLOK F – 2 - Aras 1","AreaID":15}}},{"Element":{"ID":158,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK F - 1 - Aras G","AreaName":"DEWAN KULIAH BLOK F - 1 - Aras G","AreaID":31}}},{"Element":{"ID":163,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK F–2-ArasG","AreaName":"DEWAN KULIAH BLOK F – 2 - Aras G","AreaID":32}}}]},{"privilegeGroupId":"4","privilegeGroupName":"Dewan Kuliah Blok G","description":"Dewan Kuliah Blok G","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":78,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK G–1-Aras1","AreaName":"DEWAN KULIAH BLOK G – 1 - Aras 1","AreaID":16}}},{"Element":{"ID":83,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK G - 2 - Aras 1","AreaName":"DEWAN KULIAH BLOK G - 2 - Aras 1","AreaID":17}}},{"Element":{"ID":168,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK G–1-ArasG","AreaName":"DEWAN KULIAH BLOK G – 1 - Aras G","AreaID":33}}},{"Element":{"ID":173,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK G - 2 - Aras G","AreaName":"DEWAN KULIAH BLOK G - 2 - Aras G","AreaID":34}}}]},{"privilegeGroupId":"3","privilegeGroupName":"Dewan Kuliah Blok D","description":"Dewan Kuliah Blok D","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":48,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK D - 1 -Aras 1","AreaName":"DEWAN KULIAH BLOK D - 1 - Aras 1","AreaID":10}}},{"Element":{"ID":53,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK D - 2 - Aras 1","AreaName":"DEWAN KULIAH BLOK D - 2 - Aras 1","AreaID":11}}},{"Element":{"ID":113,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK D - 1 - Aras G","AreaName":"DEWAN KULIAH BLOK D - 1 - Aras G","AreaID":22}}},{"Element":{"ID":118,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK D - 2 - Aras G","AreaName":"DEWAN KULIAH BLOK D - 2 - Aras G","AreaID":23}}}]},{"privilegeGroupId":"2","privilegeGroupName":"Dewan Kuliah Blok C","description":"Dewan Kuliah Blok C","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":38,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK C - 1-Aras 1","AreaName":"DEWAN KULIAH BLOK C - 1 - Aras 1","AreaID":8}}},{"Element":{"ID":43,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK C - 2-Aras 1","AreaName":"DEWAN KULIAH BLOK C - 2 - Aras 1","AreaID":9}}},{"Element":{"ID":108,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK C - 1- Aras G","AreaName":"DEWAN KULIAH BLOK C - 1- Aras G","AreaID":21}}},{"Element":{"ID":128,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK C - 2 - Aras G","AreaName":"DEWAN KULIAH BLOK C - 2 - Aras G","AreaID":25}}}]},{"privilegeGroupId":"1","privilegeGroupName":"Dewan kuliah Block A","description":"Dewan kuliah Block A","timeSchedule":{"indexCode":"1","name":""},"ElementList":[{"Element":{"ID":178,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK A - Aras G","AreaName":"DEWAN KULIAH BLOK A - Aras G","AreaID":35}}},{"Element":{"ID":183,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK A–1-Aras1","AreaName":"DEWAN KULIAH BLOK A – 1 - Aras 1","AreaID":36}}},{"Element":{"ID":188,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK A–2-Aras1","AreaName":"DEWAN KULIAH BLOK A – 2 - Aras 1","AreaID":37}}},{"Element":{"ID":193,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK A–3-Aras1","AreaName":"DEWAN KULIAH BLOK A – 3 - Aras 1","AreaID":38}}},{"Element":{"ID":198,"BaseInfo":{"ElementType":1002,"Name":"DEWAN KULIAH BLOK A–4-Aras1","AreaName":"DEWAN KULIAH BLOK A – 4 - Aras 1","AreaID":39}}}]}]}}
        //         if (data_door.code == 0) {
        //             count = 1;
        //             console.log(data_door)

        //             dropdown_innerHTML = ``;
        //             rooms = <?php echo json_encode($rooms, 15, 512) ?>;

        //             data_door.data.list.forEach(access_level => {
                        
        //                     dropdown_innerHTML += `
        //                         <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'add-room-access-level-dropdown-button', 'add-room-access-level-id-dropdown-input', ${access_level.privilegeGroupId}, 'add-room-access-level-dropdown'); document.getElementById('add-room-access-level-id-dropdown-input').textContent = ${access_level.privilegeGroupId}; document.getElementById('add-room-access-level-name-dropdown-input').value = '${access_level.privilegeGroupName}';" style="border:none;">${access_level.privilegeGroupName}</div>
        //                     `;
        //             })

        //             access_level_dropdown = document.getElementById('add-room-access-level-dropdown');
        //             access_level_dropdown.innerHTML += dropdown_innerHTML;
        //             // devices.forEach(device => {
        //             //     const dropdown = document.getElementById(`edit-device-${device.id}-dropdown`);
        //             //     dropdown.innerHTML += dropdown_innerHTML;
        //             // });
        //         }
        //     });
    
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Acer\Desktop\BIG PROJECTS\uthm_classroom_management_system\uthm_classroom_management_system\resources\views/room/index.blade.php ENDPATH**/ ?>