<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>

    
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,200,0,-25" />
    <link href="<?php echo e(asset('css/bootstrap-custom.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/main.css')); ?>" rel="stylesheet">

    <style>
        .login-input {
            border: 1px solid #007bff00;
            transition: 0.5s;
        }

        .login-input:focus {
            border: 1px solid #007bff;
        }

        .message {
            visibility: hidden;
            position:fixed; 
            left:50%; 
            top: -500px;
            transform:translateX(-50%);
            z-index: 99;
            border-radius: 10px;
            transition: 1s;
            box-shadow: 0px 10px 20px 5px #00000033;
        }

        .message.success { background-color: #91cd91}
        .message.error { background-color: #fc6d6d }


        .message.active {
            visibility: visible;
            top: 10px;
        }

        .laptop-view {display:none;}
        .mobile-view {display:none;}
        /* Mobile Phones (less than 425px) */
        @media only screen and (max-width: 425px) {
            .mobile-view {display:flex;}
        }
        /* Tablets (480px to 768px) */ 
        @media only screen and (min-width: 426px) and (max-width: 768px) {
            .mobile-view {display:flex;}
        }
        /* Desktops (768px to 1024px) */
        @media only screen and (min-width: 769px) and (max-width: 1024px) {
            .laptop-view {display:flex;}
        }
        /* Large Screens (more than 1024px) */
        @media only screen and (min-width: 1025px) {
            .laptop-view {display:flex;}
        }
    </style>
</head>
<body>

    <div class="message pd-20 bs-bb" style="position:fixed; width:calc(100% - 20px); max-width:500px">
        <div style="position:relative;">
            <div class="d-flex jc-end clr-white" style="position:absolute; right:0px;"><span class="material-symbols-outlined fs-15 cursor-pointer" onclick="document.querySelector('.message').classList.remove('active');">close</span></div>
        </div>
        <?php if($errors->any()): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="fs-12 clr-white mg-b-5" style="width:calc(100% - 20px)"><?php echo e($error); ?></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <?php if(session('success')): ?>
            <div class="fs-12 clr-white mg-b-5" style="width:calc(100% - 20px)"><?php echo e(session('success')); ?></div>
        <?php endif; ?>
    </div>

    <!-- Mobile View -->
    <div class="w-100p h-100p d-flex cursor-default mobile-view" style="position:fixed">
        <div class="w-100p h-100p d-flex jc-center">
            <div class="h-100p w-400 d-flex fd-column jc-center pd-lr-20" style="position:relative; max-width:400px;">

                <div class="w-100p">
                    <div class=" pd-t-10 d-flex fd-column ai-center cursor-default">
                        <div class="pd-5 h-80 mg-b-10"><img class="h-100p" src="storage/system/logo.png" alt="" style="object-fit:cover"></div>
                        <div class="fs1 fw-bold">
                            <?php echo e(App\Models\Settings::where('setting_key','system_name')->get()->first()->setting_value); ?>

                        </div>
                        <div class="fs3 fw-bold clr-grey-1">
                            <?php echo e(App\Models\Settings::where('setting_key','company_name')->get()->first()->setting_value); ?>

                        </div>
                    </div>
                </div>

                <div class="w-100p title-1 mg-t-30 mg-b-20 cursor-default">Sign In</div>
                <div class="w-100p">
                    <form  method="POST" action="<?php echo e(route('login')); ?>" class="w-100p h-100p">
                    <?php echo csrf_field(); ?>
                        <div class="fs-12 fw-bold">
                            <div class="clr-grey-1 mg-b-5">Email</div>
                            <input name="email" class="login-input w-100p pd-10 bs-bb pd-l-5 border-none bg-plt5 br-5 clr-grey-1" type="email" style="outline:none">
                            <div class="clr-grey-1 mg-t-10 mg-b-5">Password</div>
                            <input name="password" class="login-input w-100p pd-10 bs-bb pd-l-5 border-none bg-plt5 br-5 clr-grey-1" type="password" style="outline:none">
                        </div>
                        <div class="d-flex jc-end fs-10 mg-t-5 mg-b-5 clr-grey-1 cursor-pointer">
                            <div>Forgot your password?</div>
                        </div>
                        <div class="d-flex ai-center clr-grey-1">
                            <input class="cursor-pointer" id="remember_me" type="checkbox" name="remember">
                            <div class="fw-bold fs-10">Remember me</div>
                        </div>
                        <button type="submit" class="button-primary w-100p mg-t-20">Sign In</button>
                    </form>
                </div>

                <div class="h-100"></div>

                <div class="fs4 pd-15 cursor-default" style="position:absolute; bottom:5px;">
                    <!-- <span class="fw-bold">Language : </span><span class="cursor-pointer txt-u-hv clr-blue-hv clr-grey-1">Malay</span><span class="clr-grey-1"> | </span><span class="cursor-pointer txt-u-hv clr-blue-hv clr-grey-1">English</span>  -->
                </div>
                <div class="fs4 pd-15 clr-black txt-shadow-basic" style="position:fixed; bottom:5px; right:0px; ">
                    © 2024 Universiti Tun Hussein Onn Malaysia
                </div>
            </div>
        </div>
    </div>

    <!-- Laptop View -->
    <div class="w-100p h-100p d-flex cursor-default laptop-view" style="position:fixed">
        <div class="w-100p h-100p d-flex jc-center">
            <div class="h-100p w-350 bg-plt d-flex fd-column jc-center" style="position:relative;">

                <div class="w-100p h-100">
                    <a class="h-100p pd-t-10 d-flex cursor-default" style="height:60px; text-decoration:none;">
                        <div class="pd-5"><img class="h-100p" src="storage/system/logo.png" alt="" style="object-fit:cover"></div>
                        <div class="d-flex fd-column jc-center">
                            <div class="fs1 fw-bold">
                                <?php echo e(App\Models\Settings::where('setting_key','system_name')->get()->first()->setting_value); ?>

                            </div>
                            <div class="fs3 fw-bold clr-grey-1">
                                <?php echo e(App\Models\Settings::where('setting_key','company_name')->get()->first()->setting_value); ?>

                            </div>
                        </div>
                    </a>
                </div>

                <div class="w-100p title-1 mg-t-30 mg-b-20 cursor-default">Sign In</div>
                <div class="w-100p">
                    <form  method="POST" action="<?php echo e(route('login')); ?>" class="w-100p h-100p">
                    <?php echo csrf_field(); ?>
                        <div class="fs-12 fw-bold">
                            <div class="clr-grey-1 mg-b-5">Email</div>
                            <input name="email" class="login-input w-100p pd-10 bs-bb pd-l-5 border-none bg-plt5 br-5 clr-grey-1" type="email" style="outline:none">
                            <div class="clr-grey-1 mg-t-10 mg-b-5">Password</div>
                            <input name="password" class="login-input w-100p pd-10 bs-bb pd-l-5 border-none bg-plt5 br-5 clr-grey-1" type="password" style="outline:none">
                        </div>
                        <div class="d-flex jc-end fs-10 mg-t-5 mg-b-5 clr-grey-1 cursor-pointer">
                            <div>Forgot your password?</div>
                        </div>
                        <div class="d-flex ai-center clr-grey-1">
                            <input class="cursor-pointer" id="remember_me" type="checkbox" name="remember">
                            <div class="fw-bold fs-10">Remember me</div>
                        </div>
                        <div class="d-flex jc-end">
                            <button type="submit" class="button-primary">Sign In</button>
                        </div>
                    </form>
                </div>

                <div class="fs4 pd-15 cursor-default" style="position:absolute; bottom:5px;">
                    <!-- <span class="fw-bold">Language : </span><span class="cursor-pointer txt-u-hv clr-blue-hv clr-grey-1">Malay</span><span class="clr-grey-1"> | </span><span class="cursor-pointer txt-u-hv clr-blue-hv clr-grey-1">English</span>  -->
                </div>
                <div class="fs4 pd-15 clr-white txt-shadow-basic" style="position:fixed; bottom:5px; right:0px; ">
                    © 2024 Universiti Tun Hussein Onn Malaysia
                </div>
            </div>
        </div>
        <div class="w-100p h-100p bg-plt2">
            <img class="w-100p h-100p" src="storage/system/bg-login.jpg" alt="background image" style="object-fit:cover">
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", () => {
            setTimeout(() => {
                <?php if($errors->any()): ?>
                    document.querySelector('.message').classList.add('error');
                    document.querySelector('.message').classList.add('active');
                <?php elseif(session('success')): ?>
                    document.querySelector('.message').classList.add('success');
                    document.querySelector('.message').classList.add('active');
                <?php endif; ?>
            }, 50);
        });

    </script>
</body>
</html><?php /**PATH C:\Users\Acer\Desktop\BIG PROJECTS\uthm_classroom_management_system\uthm_classroom_management_system\resources\views/auth/login.blade.php ENDPATH**/ ?>