

<?php $__env->startPush('style'); ?>
    <style></style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('users-button', 'active'); ?>

<?php $__env->startSection('header'); ?>
    <div class="d-flex h-100p" id="nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs1 fw-bold cursor-default">Users</div>
        <div class="d-flex-center">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">filter_alt</span>
                <div>Filter</div>
            </div>
        </div>
        <div class="d-flex-center">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" onclick="open_popup_click('add-user-popup')">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">add</span>
                <div>Add</div>
            </div>
        </div>
        <div class="d-flex-center">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">database_upload</span>
                <div>Upload</div>
            </div>
        </div>
    </div>

    <div class="d-none" id="user-nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold clr-blue clr-blue-hv txt-u-hv cursor-pointer" onclick="back_click()">Back</div>
        <div class="d-flex-center">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" id="edit-user-button">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">edit</span>
                <div>Edit</div>
            </div>
        </div>
        <div class="h-100p" style="position:relative">
            <div class="d-flex-center h-100p">
                <div id="user-option-dropdown-button" class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;">
                    <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">list</span>
                    <div>Option</div>
                </div>
            </div>
            <div class="dropdown w-180 cursor-pointer" id="user-option-dropdown" style="position:absolute;">
                <div class="option" id="edit-user-password-button">
                    <div class="fs3 clr-black-2 fw-bold">Edit Password</div>
                    <div class="fs4 clr-grey-2 fw-bold">Update user account password</div>
                </div>
                <div class="option" id="disable-user-button">
                    
                    <div class="fs3 clr-black-2 fw-bold" id="disable-enable-button-text">Disable Account</div>
                    <div class="fs4 clr-grey-2 fw-bold">To enable or disable user account from this system</div>
                </div>
                <div class="option pd-b-10" id="delete-user-button">
                    <div class="fs3 clr-black-2 fw-bold">Delete Account</div>
                    <div class="fs4 clr-grey-2 fw-bold">Remove user account from this system</div>
                </div>
            </div>
        </div>
    </div>
    <!-- <div id="add-user-button" onclick="open_popup_click('add-user-popup')" class="h-10 bg-btn-primary d-flex ai-center fs-12 fw-bold pd-10 pd-l-5 br-5 clr-white cursor-pointer"><span class="material-symbols-outlined mg-r-5">add</span>Add</div> -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main-body'); ?>
    <?php
        $users = App\Models\User::all();
    ?> 

    <div id="main">
        <table class="table w-100p">
            <tr>
                <th></th>
                <th><div class="cursor-pointer clr-blue-hv">Name</div></th>
                <th><div class="cursor-pointer clr-blue-hv">User Type</div></th>
                <th><div class="cursor-pointer clr-blue-hv">Phone No</div></th>
                <th><div class="cursor-pointer clr-blue-hv">Gender</div></th>
                <th><div class="cursor-pointer clr-blue-hv">Last Login</div></th>
            </tr>

            <?php $count = 1; ?>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($user->type == "Administrator"): ?>
                    <?php continue; ?>
                <?php endif; ?>
                <tr>
                    <td style="width:0px">
                        <div class="d-flex-center">
                            <div class="bg-plt1-tr2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4"><?php echo e($count); ?></div>
                        </div>
                    </td>
                    <td>
                        <div class="d-flex">
                            <div class="d-flex-center">
                                <div class="d-flex-center br-50p w-40 h-40">
                                    <?php if($user['image_path']): ?>
                                        <img src="<?php echo e(asset('storage' . $user->image_path)); ?>" alt="" class="w-100p h-100p br-50p" style="object-fit:cover;border:none;">
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('storage/system/avatar.png')); ?>" alt="" class="w-100p h-100p br-50p" style="object-fit:cover;border:none;">
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="mg-l-15 fs-12 fw-bold">
                                <div class="cursor-pointer clr-blue-hv txt-u-hv" style="text-transform: uppercase;" onclick="user_click(<?php echo e($user->id); ?>)">
                                    <?php echo e($user->full_name); ?>

                                </div>
                                <div class="clr-grey-2 mg-t-5">
                                    <?php echo e($user->email); ?>

                                </div>
                            </div>
                        </div>
                    </td>
                    <td>
                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($user->type); ?></div>
                    </td>
                    <td>
                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($user->phone_no); ?></div>
                    </td>
                    <td>
                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($user->gender == 1 ? 'Male' : 'Female'); ?></div>
                    </td>
                    <td>
                        <?php if($user->last_login): ?>
                            <div class="fs-12 clr-grey-1 tw-nowrap"><?php echo e(Carbon\Carbon::parse($user->last_login, 'Asia/Kuala_Lumpur')->format('d M Y')); ?></div>
                            <div class="fs-12 clr-grey-1 tw-nowrap"><?php echo e(Carbon\Carbon::parse($user->last_login, 'Asia/Kuala_Lumpur')->format('h:i:s A')); ?></div>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php $count += 1; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>
    </div>

    
    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="w-100p h-500 pd-t-20 d-none" style="position:fixed;" id="user-<?php echo e($user->id); ?>">
            <div class="w-300 d-flex jc-center">
                <div class="h-100p w-100p d-flex-center ai-start">
                    <?php if(Auth::user()->image_path): ?>
                        <img src="<?php echo e(asset('storage' . Auth::user()->image_path)); ?>" alt="" class="w-150 h-150 br-50p" style="object-fit:cover;border:none;">
                    <?php else: ?>
                        <img src="<?php echo e(asset('storage/system/avatar.png')); ?>" alt="" class="w-150 h-150 br-50p" style="object-fit:cover;border:none;">
                    <?php endif; ?>
                </div>
            </div>

            <div class="w-450 d-flex jc-center">
                <div class="w-400 h-100p">
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p fs2 clr-grey-1 fw-bold">Details</div>
                    </div>
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p clr-grey-2">User-ID</div>
                        <div class=""><?php echo e($user->staff_id ? $user->staff_id : '-'); ?></div>
                    </div>
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p clr-grey-2 ">First Name</div>
                        <div class=""><?php echo e($user->first_name ? $user->first_name : '-'); ?></div>
                    </div>
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p clr-grey-2 ">Last Name</div>
                        <div class=""><?php echo e($user->last_name ? $user->last_name : '-'); ?></div>
                    </div>
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p clr-grey-2 ">Full Name</div>
                        <div class=""><?php echo e($user->full_name ? $user->full_name : '-'); ?></div>
                    </div>
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p clr-grey-2 ">Email</div>
                        <div class=""><?php echo e($user->email ? $user->email : '-'); ?></div>
                    </div>
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p clr-grey-2 ">Phone Number</div>
                        <div class=""><?php echo e($user->phone_no ? $user->phone_no : '-'); ?></div>
                    </div>
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p clr-grey-2 ">Gender</div>
                        <div class=""><?php echo e($user->gender == 1 ? 'Male' : 'Female'); ?></div>
                    </div>
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p clr-grey-2 ">User Type</div>
                        <div class=""><?php echo e($user->type ? $user->type : '-'); ?></div>
                    </div>
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p clr-grey-2 ">Address</div>
                        <div class=""><?php echo e($user->address ? $user->address : '-'); ?></div>
                    </div>
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p clr-grey-2 ">NRIC</div>
                        <div class=""><?php echo e($user->nric ? $user->nric : '-'); ?></div>
                    </div>
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p clr-grey-2 ">Status</div>
                        <div class=""><?php echo e($user->status ? $user->status : '-'); ?></div>
                    </div>
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p clr-grey-2 ">Last Login</div>
                        <div class=""><?php echo e(Carbon\Carbon::parse($user->last_login, 'Asia/Kuala_Lumpur')->format('D, d M Y h:i A')); ?></div>
                    </div>
                    <div class="mg-tb-15 fs3 fw-bold d-flex cursor-default">
                        <div class="w-150 h-100p clr-grey-2 ">Remark</div>
                        <div class=""><?php echo e($user->remark ? $user->remark : '-'); ?></div>
                    </div>
                </div>
            </div>

            
            <form id="disable-user-<?php echo e($user->id); ?>-form" class="d-none" action="<?php echo e(route('user.disable-user-by-id',['id' => $user->id])); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
            </form>
            <form id="enable-user-<?php echo e($user->id); ?>-form" class="d-none" action="<?php echo e(route('user.enable-user-by-id',['id' => $user->id])); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
            </form>
            <form id="delete-user-<?php echo e($user->id); ?>-form" class="d-none" action="<?php echo e(route('user.delete-user-by-id',['id' => $user->id])); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
            </form>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-box'); ?>
    <div id="add-user-popup" class="right-popup bg-white w-600 h-100p">
        <form action="<?php echo e(route('user.create-user')); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('POST'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">New User</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-30">Staff ID <span style="color:red;">*</span></div>
                    <input type="text" name="staff_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Email <span style="color:red;">*</span></div>
                    <input type="text" name="email" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">First Name <span style="color:red;">*</span></div>
                    <input type="text" name="first_name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Last Name <span style="color:red;">*</span></div>
                    <input type="text" name="last_name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Full Name <span style="color:red;">*</span></div>
                    <input type="text" name="full_name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Phone No.</div>
                    <input type="text" name="phone_no" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Address</div>
                    <input type="text" name="address" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">NRIC <span style="color:red;">*</span></div>
                    <input type="text" name="nric" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Remark</div>
                    <input type="text" name="remark" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
            
                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Gender</div>
                    <div class="fs-12 fw-bold clr-grey-1 d-flex">
                        <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                            <div class="checkbox">
                            <input type="checkbox" name="gender" value="1" checked="true">
                            <svg viewBox="0 0 35.6 35.6">
                                <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                            </svg>
                            </div>
                            <div class="checkbox-name active">Male</div>
                        </label>
                        <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                            <div class="checkbox">
                            <input type="checkbox" name="gender" value="0" />
                            <svg viewBox="0 0 35.6 35.6">
                                <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                            </svg>
                            </div>
                            <div class="checkbox-name">Female</div>
                        </label>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">User Type</div>
                    <div class="fs-12 fw-bold clr-grey-1 w-350">
                        <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                            <div class="checkbox">
                            <input type="checkbox" name="type" value="Administrator" checked="true">
                            <svg viewBox="0 0 35.6 35.6">
                                <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                            </svg>
                            </div>
                            <div>
                                <div class="checkbox-name active">Administrator</div>
                                <div class="fs-10 clr-grey-2 fw-normal">User who can fullt manage this system</div>
                            </div>
                        </label>
                        <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                            <div class="checkbox">
                            <input type="checkbox" name="type" value="Management" />
                            <svg viewBox="0 0 35.6 35.6">
                                <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                            </svg>
                            </div>
                            <div>
                                <div class="checkbox-name">Management</div>
                                <div class="fs-10 clr-grey-2 fw-normal">User who can manage all the booking records</div>
                            </div>
                        </label>
                        <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                            <div class="checkbox">
                            <input type="checkbox" name="type" value="Lecturer" />
                            <svg viewBox="0 0 35.6 35.6">
                                <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                            </svg>
                            </div>
                            <div>
                                <div class="checkbox-name">Lecturer</div>
                                <div class="fs-10 clr-grey-2 fw-normal">User who can manage their own booking records</div>
                            </div>
                        </label>
                        <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                            <div class="checkbox">
                            <input type="checkbox" name="type" value="Student Lead" />
                            <svg viewBox="0 0 35.6 35.6">
                                <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                            </svg>
                            </div>
                            <div>
                                <div class="checkbox-name">Student Lead</div>
                                <div class="fs-10 clr-grey-2 fw-normal">User who make and manage booking records</div>
                            </div>
                        </label>
                        <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                            <div class="checkbox">
                            <input type="checkbox" name="type" value="Student" />
                            <svg viewBox="0 0 35.6 35.6">
                                <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                            </svg>
                            </div>
                            <div>
                                <div class="checkbox-name">Student</div>
                                <div class="fs-10 clr-grey-2 fw-normal">User who can only attend to class</div>
                            </div>
                        </label>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-30 d-flex">
                        <div class="w-230">
                            <div>Set Password</div>
                            <div class="fs-10 clr-grey-2 fw-normal">Set password to this account and user no longer receive email</div>
                        </div>
                        <div class="switch mg-l-30">
                            <input type="checkbox" id="switch1" name="set_password"/>
                            <label for="switch1" class="toggle"><span></span></label>
                        </div>
                    </div>

                    <div id="set-password" class=""></div>

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                    <button type="button" onclick="close_popup_click('add-user-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>

    <div id="upload-user-popup" class="right-popup bg-white w-600 h-100p">
        <form action="<?php echo e(route('user.create-user')); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('POST'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">New User</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-30">Staff ID <span style="color:red;">*</span></div>
                    <input type="text" name="staff_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                    <button type="button" onclick="close_popup_click('add-user-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>

    
    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div id="edit-user-<?php echo e($user->id); ?>-popup" class="right-popup bg-white w-600 h-100p">
            <form action="<?php echo e(route('user.update-user-by-id', ['id' => $user->id])); ?>" method="POST" enctype="multipart/form-data" class="h-100p w-100p">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>

                <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                    <div class="h-100p pd-30 bs-bb">
                        <div class="fs-18 clr-grey-2 fw-bold">Edit User</div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-30">Staff ID <span style="color:red;">*</span></div>
                        <input type="text" name="staff_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 form-control" style="cursor:text;" value="<?php echo e($user->staff_id); ?>">
                        
                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Email <span style="color:red;">*</span></div>
                        <input type="text" name="email" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;" value="<?php echo e($user->email); ?>">

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">First Name <span style="color:red;">*</span></div>
                        <input type="text" name="first_name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;" value="<?php echo e($user->first_name); ?>">

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Last Name <span style="color:red;">*</span></div>
                        <input type="text" name="last_name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;" value="<?php echo e($user->last_name); ?>">

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Full Name <span style="color:red;">*</span></div>
                        <input type="text" name="full_name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;" value="<?php echo e($user->full_name); ?>">

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Phone No.</div>
                        <input type="text" name="phone_no" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;" value="<?php echo e($user->phone_no); ?>">

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Address</div>
                        <input type="text" name="address" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;" value="<?php echo e($user->address); ?>">

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">NRIC <span style="color:red;">*</span></div>
                        <input type="text" name="nric" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;" value="<?php echo e($user->nric); ?>">

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Remark</div>
                        <input type="text" name="remark" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;" value="<?php echo e($user->remark); ?>">
                
                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">Gender</div>
                        <div class="fs-12 fw-bold clr-grey-1 d-flex">
                            <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                                <div class="checkbox">
                                <?php if($user->gender == 1): ?> 
                                    <input type="checkbox" name="gender" value="1" checked="true">
                                <?php else: ?>
                                    <input type="checkbox" name="gender" value="1">
                                <?php endif; ?>
                                <svg viewBox="0 0 35.6 35.6">
                                    <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                    <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                    <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                                </svg>
                                </div>
                                <?php if($user->gender == 1): ?> 
                                    <div class="checkbox-name active">Male</div>
                                <?php else: ?>
                                    <div class="checkbox-name">Male</div>
                                <?php endif; ?>
                            </label>
                            <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                                <div class="checkbox">
                                <?php if($user->gender == 0): ?> 
                                    <input type="checkbox" name="gender" value="0" checked="true">
                                <?php else: ?>
                                    <input type="checkbox" name="gender" value="0">
                                <?php endif; ?>
                                <svg viewBox="0 0 35.6 35.6">
                                    <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                    <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                    <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                                </svg>
                                </div>
                                <?php if($user->gender == 0): ?>
                                    <div class="checkbox-name active">Female</div>
                                <?php else: ?>
                                    <div class="checkbox-name">Female</div>
                                <?php endif; ?>
                            </label>
                        </div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-20">User Type</div>
                        <div class="fs-12 fw-bold clr-grey-1 w-350">
                            <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                                <div class="checkbox">
                                <?php if($user->type == "Administrator"): ?>
                                    <input type="checkbox" name="type" value="Administrator" checked="true">
                                <?php else: ?>
                                    <input type="checkbox" name="type" value="Administrator">
                                <?php endif; ?>
                                <svg viewBox="0 0 35.6 35.6">
                                    <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                    <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                    <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                                </svg>
                                </div>
                                <div>
                                    <?php if($user->type == "Administrator"): ?> 
                                        <div class="checkbox-name active">Administrator</div>
                                    <?php else: ?>
                                        <div class="checkbox-name">Administrator</div>
                                    <?php endif; ?>
                                    <div class="fs-10 clr-grey-2 fw-normal">User who can fullt manage this system</div>
                                </div>
                            </label>
                            <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                                <div class="checkbox">
                                <?php if($user->type == "Management"): ?> 
                                    <input type="checkbox" name="type" value="Management" checked="true">
                                <?php else: ?>
                                    <input type="checkbox" name="type" value="Management">
                                <?php endif; ?>
                                <svg viewBox="0 0 35.6 35.6">
                                    <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                    <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                    <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                                </svg>
                                </div>
                                <div>
                                    <?php if($user->type == "Management"): ?> 
                                        <div class="checkbox-name active">Management</div>
                                    <?php else: ?>
                                        <div class="checkbox-name">Management</div>
                                    <?php endif; ?>
                                    <div class="fs-10 clr-grey-2 fw-normal">User who can manage all the booking records</div>
                                </div>
                            </label>
                            <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                                <div class="checkbox">
                                <?php if($user->type == "Lecturer"): ?> 
                                    <input type="checkbox" name="type" value="Lecturer" checked="true">
                                <?php else: ?>
                                    <input type="checkbox" name="type" value="Lecturer">
                                <?php endif; ?>
                                <svg viewBox="0 0 35.6 35.6">
                                    <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                    <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                    <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                                </svg>
                                </div>
                                <div>
                                    <?php if($user->type == "Lecturer"): ?> 
                                        <div class="checkbox-name active">Lecturer</div>
                                    <?php else: ?>
                                        <div class="checkbox-name">Lecturer</div>
                                    <?php endif; ?>
                                    <div class="fs-10 clr-grey-2 fw-normal">User who can manage their own booking records</div>
                                </div>
                            </label>
                            <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                                <div class="checkbox">
                                <?php if($user->type == "Student Lead"): ?> 
                                    <input type="checkbox" name="type" value="Student Lead" checked="true">
                                <?php else: ?>
                                    <input type="checkbox" name="type" value="Student Lead">
                                <?php endif; ?>
                                <svg viewBox="0 0 35.6 35.6">
                                    <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                    <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                    <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                                </svg>
                                </div>
                                <div>
                                    <?php if($user->type == "Student Lead"): ?> 
                                        <div class="checkbox-name active">Student Lead</div>
                                    <?php else: ?>
                                        <div class="checkbox-name">Student Lead</div>
                                    <?php endif; ?>
                                    <div class="fs-10 clr-grey-2 fw-normal">User who make and manage booking records</div>
                                </div>
                            </label>
                            <label class="d-flex ai-center mg-10 mg-t-15 cursor-pointer us-none">
                                <div class="checkbox">
                                <?php if($user->type == "Student"): ?>
                                    <input type="checkbox" name="type" value="Student" checked="true">
                                <?php else: ?>
                                    <input type="checkbox" name="type" value="Student">
                                <?php endif; ?>
                                <svg viewBox="0 0 35.6 35.6">
                                    <circle class="background" cx="17.8" cy="17.8" r="17.8"></circle>
                                    <circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle>
                                    <polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline>
                                </svg>
                                </div>
                                <div>
                                    <?php if($user->type == "Student"): ?> 
                                        <div class="checkbox-name active">Student</div>
                                    <?php else: ?>
                                        <div class="checkbox-name">Student</div>
                                    <?php endif; ?>
                                    <div class="fs-10 clr-grey-2 fw-normal">User who can only attend to class</div>
                                </div>
                            </label>
                        </div>

                        <div class="h-150"></div>
                    </div>
                </div>

                <div class="submit-section h-80 w-100p">
                    <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                        <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Update</button>
                        <button type="button" onclick="close_popup_click('edit-user-<?php echo e($user->id); ?>-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    
    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div id="edit-user-password-<?php echo e($user->id); ?>-popup" class="right-popup bg-white w-600 h-100p">
            <form action="<?php echo e(route('user.update-password-by-id', ['id' => $user->id])); ?>" method="POST" enctype="multipart/form-data" class="h-100p w-100p">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            
                <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                    <div class="h-100p pd-30 bs-bb cursor-default">
                        <div class="fs-18 clr-grey-2 fw-bold">Edit Password</div>

                        <div class="fs-13 clr-black-1 fw-bold mg-t-30">New Password <span style="color:red;">*</span></div>
                        <input type="password" name="password" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                        
                        <div class="fs-13 clr-black-1 fw-bold mg-t-30">Confirm Password <span style="color:red;">*</span></div>
                        <input type="password" name="password_confirmation" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">        
                        
                        <div class="fs4 clr-grey-2 fw-bold w-300 mg-t-30">Set new password for selected user. Simple password is allow but please remind user to reset password after this.</div>
                        <div class="h-150"></div>
                    </div>
                </div>

                <div class="submit-section h-80 w-100p">
                    <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                        <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Save Changes</button>
                        <button type="button" onclick="close_popup_click('edit-user-password-<?php echo e($user->id); ?>-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        let user_id_opened;
       <?php if(session('updated_user_id')): ?>
            user_click(<?php echo e(session('updated_user_id')); ?>);
        <?php endif; ?>

        
        add_dropdown_event('user-option-dropdown-button', 'user-option-dropdown');

        document.querySelectorAll('input[name="gender"]').forEach((checkbox) => {
            checkbox.addEventListener('click', function () {
            if (this.checked) {
                document.querySelectorAll('input[name="gender"]').forEach((cb) => {
                    if (cb !== this) {
                        cb.checked = false
                        const label = cb.closest('label');
                        label.querySelector('.checkbox-name').classList.remove('active');
                    };
                });
                const label = this.closest('label');
                label.querySelector('.checkbox-name').classList.add('active');
            } else {
                this.checked = true;
            }
            });
        });

        document.querySelectorAll('input[name="type"]').forEach((checkbox) => {
            checkbox.addEventListener('click', function () {
            if (this.checked) {
                
                document.querySelectorAll('input[name="type"]').forEach((cb) => {
                    if (cb !== this) {
                        cb.checked = false
                        const label = cb.closest('label');
                        label.querySelector('.checkbox-name').classList.remove('active');
                    };
                });
                const label = this.closest('label');
                label.querySelector('.checkbox-name').classList.add('active');
            } else {
                this.checked = true;
            }
            });
        });
    
        document.getElementById('switch1').addEventListener('input', e => {
            if (e.target.checked) {
                document.getElementById('set-password').style.display = 'block';
                document.getElementById('set-password').innerHTML = `
                    <div class="h-30"></div>

                    <input type="text" name="fakeUsername" style="display:none;">
                    <input type="password" name="fakePassword" style="display:none;">
                
                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">New Password</div>
                    <input type="password" value="" id="new-password" required minlength="8" name="password" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text" autocomplete="off">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Confirm Password</div>
                    <input type="password" value="" id="password_confirmation" required minlength="8" name="password_confirmation" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text" autocomplete="off">
                    
                    <div class="fs-10 w-300 clr-grey-2 fw-normal mg-t-20">Set new password for selected user. Once the password is updated, please ensure that the user is notified of the new credentials to prevent any login issues.</div>`;

            } else {
                 document.getElementById('set-password').innerHTML = ``;
            }
        })
 
        function user_click(user_id) {
            document.getElementById(`user-${user_id}`).style.display = 'flex';
            document.getElementById('main').style.display = 'none';
            document.getElementById('nav-button').style.display = 'none';
            document.getElementById('user-nav-button').style.display = 'flex';
            user_id_opened = user_id;

            document.getElementById('edit-user-button').onclick = function () { open_popup_click(`edit-user-${user_id}-popup`) }
            document.getElementById('edit-user-password-button').onclick = function () { 
                open_popup_click(`edit-user-password-${user_id}-popup`);
                document.getElementById('user-password-option-dropdown-button').classList.remove('active');
                document.getElementById('user-password-option-dropdown').classList.remove('active');
            }

            users = <?php echo json_encode(App\Models\User::all(), 15, 512) ?>;
            user = users.find(user => user.id === user_id);
            if (user.status == 'Active') {
                document.getElementById('disable-enable-button-text').textContent = 'Disable Account';
            } else {
                document.getElementById('disable-enable-button-text').textContent = 'Enable Account';
            }

            document.getElementById('disable-user-button').onclick = function () {                 
                if (user.status === 'Active'){
                    if (confirm('Are you sure you want to disable this user account?')) {
                    document.getElementById(`disable-user-${user_id}-form`).submit();
                }
                } else{
                    if (confirm('Are you sure you want to enable this user account?')) {
                    document.getElementById(`enable-user-${user_id}-form`).submit();
                }
                }
            }
            document.getElementById('delete-user-button').onclick = function () {
                if (confirm('Are you sure you want to delete this user account?')) {
                    document.getElementById(`delete-user-${user_id}-form`).submit();
                }
            }
        }

        function back_click() {
            document.getElementById(`user-${user_id_opened}`).style.display = 'none';
            document.getElementById('main').style.display = 'block';
            document.getElementById('nav-button').style.display = 'flex';
            document.getElementById('user-nav-button').style.display = 'none';
        }

        // to remove session on the last session page
        localStorage.removeItem('classroom-management-session');
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Acer\Desktop\BIG PROJECTS\uthm_classroom_management_system\uthm_classroom_management_system\resources\views/user/index.blade.php ENDPATH**/ ?>