

<?php $__env->startPush('style'); ?>
    <style>
    .setting-button {
        box-shadow: 0px 0px 0px 0px #00000022;
        transition: box-shadow 0.3s;
    }

    .building-level-button.active,
    .setting-button:hover {
        box-shadow: 0px 0px 10px 5px #00000022;
        background-color:#00000009;
    }

    

    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('settings-button', 'active'); ?>

<?php $__env->startSection('header'); ?>
    <div class="d-flex h-100p" id="main-nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs1 fw-bold cursor-default">Settings</div>
    </div>
    <div class="d-none" id="general-nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold clr-blue clr-blue-hv txt-u-hv cursor-pointer" onclick="back_click('general-nav-button', 'setting-general')">Back</div>
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold cursor-default">General Settings</div>
        <div class="d-flex-center">
            <div id="save-setting-general-button" class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" onclick="submit_form('save-setting-general-button-form')">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">save</span>
                <div>Save</div>
            </div>
        </div>
    </div>
    <div class="d-none" id="announcement-nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold clr-blue clr-blue-hv txt-u-hv cursor-pointer" onclick="back_click('announcement-nav-button', 'setting-announcement')">Back</div>
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold cursor-default">Announcement</div>
        <div class="d-flex-center">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" onclick="open_popup_click('add-announcement-popup')">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">add</span>
                <div>Add</div>
            </div>
        </div>
    </div>
    <div class="d-none" id="building-level-nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold clr-blue clr-blue-hv txt-u-hv cursor-pointer" onclick="back_click('building-level-nav-button', 'setting-building-level')">Back</div>
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold cursor-default">Building & Level</div>
        <div class="d-flex-center">
            <div id="add-faculty-btn" class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" onclick="open_popup_click('add-faculty-popup')">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">add</span>
                <div>Add</div>
            </div>
            <div id="add-building-btn" class="button-primary d-flex-center mg-l-2 mg-r-2 d-none" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" onclick="open_popup_click('add-building-popup')">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">add</span>
                <div>Add</div>
            </div>
            <div id="add-level-btn" class="button-primary d-flex-center mg-l-2 mg-r-2 d-none" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" onclick="open_popup_click('add-level-popup')">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">add</span>
                <div>Add</div>
            </div>
        </div>
    </div>
    <div class="d-none" id="public-holiday-nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold clr-blue clr-blue-hv txt-u-hv cursor-pointer" onclick="back_click('public-holiday-nav-button', 'setting-public-holiday')">Back</div>
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold cursor-default">Holiday</div>
        <div class="d-flex-center">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" onclick="open_popup_click('add-holiday-popup')">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">add</span>
                <div>Add</div>
            </div>
        </div>
    </div>
    <div class="d-none" id="smtp-relay-nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold clr-blue clr-blue-hv txt-u-hv cursor-pointer" onclick="back_click('smtp-relay-nav-button', 'setting-smtp-relay')">Back</div>
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold cursor-default">SMTP Relay</div>
        <div class="d-flex-center">
            <div id="save-setting-smtp-button" class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" onclick="submit_form('save-setting-smtp-button-form')">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">save</span>
                <div>Save</div>
            </div>
        </div>
    </div>
    <div class="d-none" id="devices-nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold clr-blue clr-blue-hv txt-u-hv cursor-pointer" onclick="back_click('devices-nav-button', 'setting-devices')">Back</div>
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold cursor-default">Devices</div>
        <div class="d-flex-center">
            <div class="button-primary d-flex-center mg-l-2 mg-r-2" style="padding-top:5px; padding-bottom:5px; padding-left:10px;" onclick="open_popup_click('add-device-popup')">
                <span class="material-symbols-outlined b fs-20 mg-r-5 fw-bold">Add</span>
                <div>Add</div>
            </div>
        </div>
    </div>
    <div class="d-none" id="integration-nav-button">
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold clr-blue clr-blue-hv txt-u-hv cursor-pointer" onclick="back_click('integration-nav-button', 'setting-integration')">Back</div>
        <div class="h-100p d-flex-center mg-t-2 pd-lr-20 fs2 fw-bold cursor-default">Integration</div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main-body'); ?>
    <?php
        $settings = App\Models\Settings::all();
        $buildings = App\Models\Buildings::all();
        $levels = App\Models\Levels::all();
        $devices = App\Models\Devices::all();
        $faculties = App\Models\Faculties::all();
    ?>

    <div id="setting-main">
        <div class="fw-wrap">
            <div class="">
                <div class="fs2 mg-t-10 pd-tb-20 fw-bold clr-grey-2 cursor-default">Application</div>
                <div class="w-100p h-100p d-flex fd-row fw-wrap">
                    <div onclick="setting_click('general-nav-button', 'setting-general'); localStorage.setItem('classroom-management-session', 'general');" class="setting-button d-flex-center jc-start w-280 h-50 pd-lr-20 pd-tb-5 mg-r-20 mg-tb-15 bs-bb br-5 of-hidden cursor-pointer f-shrink-0">
                        <span class="material-symbols-outlined clr-blue mg-r-10 fw-bold">web_asset</span>
                        <div>
                            <div class="fs3 clr-black-2 fw-bold">General</div>
                            <div class="fs3 clr-grey-2">General settings for application</div>
                        </div>
                    </div>
                    <!-- For pagination, to get the last session page -->
                    <div onclick="setting_click('announcement-nav-button', 'setting-announcement'); localStorage.setItem('classroom-management-session', 'announcement');" class="setting-button d-flex-center jc-start w-280 h-50 pd-lr-20 pd-tb-5 mg-r-20 mg-tb-15 bs-bb br-5 of-hidden cursor-pointer f-shrink-0">
                        <span class="material-symbols-outlined clr-blue mg-r-10 fw-bold">chat</span>
                        <div>
                            <div class="fs3 clr-black-2 fw-bold">Announcement</div>
                            <div class="fs3 clr-grey-2">Announcement for system user</div>
                        </div>
                    </div>
                    <div onclick="setting_click('building-level-nav-button', 'setting-building-level'); localStorage.setItem('classroom-management-session', 'building-level');" class="setting-button d-flex-center jc-start w-280 h-50 pd-lr-20 pd-tb-5 mg-r-20 mg-tb-15 bs-bb br-5 of-hidden cursor-pointer f-shrink-0">
                        <span class="material-symbols-outlined clr-blue mg-r-10 fw-bold">apartment</span>
                        <div>
                            <div class="fs3 clr-black-2 fw-bold">Building & Level</div>
                            <div class="fs3 clr-grey-2">Building & level for room</div>
                        </div>
                    </div>
                    <div onclick="setting_click('public-holiday-nav-button', 'setting-public-holiday'); localStorage.setItem('classroom-management-session', 'public-holiday');" class="setting-button d-flex-center jc-start w-280 h-50 pd-lr-20 pd-tb-5 mg-r-20 mg-tb-15 bs-bb br-5 of-hidden cursor-pointer f-shrink-0">
                        <span class="material-symbols-outlined clr-blue mg-r-10 fw-bold">calendar_today</span>
                        <div>
                            <div class="fs3 clr-black-2 fw-bold">Public Holiday</div>
                            <div class="fs3 clr-grey-2">Public Holiday for class</div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="">
                <div class="fs2 mg-t-20 pd-tb-20 fw-bold clr-grey-2 cursor-default">System</div>
                <div class="w-100p h-100p d-flex fd-row fw-wrap">
                    <div onclick="setting_click('smtp-relay-nav-button', 'setting-smtp-relay'); localStorage.setItem('classroom-management-session', 'smtp-relay');" class="setting-button d-flex-center jc-start w-280 h-50 pd-lr-20 pd-tb-5 mg-r-20 mg-tb-15 bs-bb br-5 of-hidden cursor-pointer f-shrink-0">
                        <span class="material-symbols-outlined clr-blue mg-r-10 fw-bold">mail</span>
                        <div>
                            <div class="fs3 clr-black-2 fw-bold">SMTP Relay</div>
                            <div class="fs3 clr-grey-2">SMTP relay settings for outgoing email</div>
                        </div>
                    </div>
                    <div onclick="setting_click('devices-nav-button', 'setting-devices'); localStorage.setItem('classroom-management-session', 'devices');" class="setting-button d-flex-center jc-start w-280 h-50 pd-lr-20 pd-tb-5 mg-r-20 mg-tb-15 bs-bb br-5 of-hidden cursor-pointer f-shrink-0">
                        <span class="material-symbols-outlined clr-blue mg-r-10 fw-bold">camera_video</span>
                        <div>
                            <div class="fs3 clr-black-2 fw-bold">Devices</div>
                            <div class="fs3 clr-grey-2">Devices for room</div>
                        </div>
                    </div>
                    <div onclick="setting_click('integration-nav-button', 'setting-integration'); localStorage.setItem('classroom-management-session', 'integration');" class="setting-button d-flex-center jc-start w-280 h-50 pd-lr-20 pd-tb-5 mg-r-20 mg-tb-15 bs-bb br-5 of-hidden cursor-pointer f-shrink-0">
                        <span class="material-symbols-outlined clr-blue mg-r-10 fw-bold">data_table</span>
                        <div>
                            <div class="fs3 clr-black-2 fw-bold">Integration</div>
                            <div class="fs3 clr-grey-2">Integration settings for system</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="setting-general" class="d-none">
        <div class="fw-wrap">
            <form id="save-setting-general-button-form" action="<?php echo e(route('setting.update-general')); ?>" method="POST" class="h-100p w-100p cursor-default">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>

                <div class="general-system">
                    <div class="fs2 mg-t-20 pd-tb-20 fw-bold clr-grey-2 cursor-default">System</div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">System Version</div>
                            <div class="fs3 clr-grey-2">Current system version</div>
                        </div>
                        <div class="d-flex ai-center fs3 clr-grey-2 w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0"><?php echo e(App\Models\Settings::where('setting_key', 'system_version')->get()->first()->setting_value); ?></div>
                        <input type="hidden" name="system_version" value="<?php echo e(App\Models\Settings::where('setting_key', 'system_version')->get()->first()->setting_value); ?>">
                    </div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">System Updated</div>
                            <div class="fs3 clr-grey-2">Date of system updated</div>
                        </div>
                        <div class="d-flex ai-center fs3 clr-grey-2 w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <?php echo e(Carbon\Carbon::parse(App\Models\Settings::where('setting_key', 'system_updated')->get()->first()->setting_value, 'Asia/Kuala_Lumpur')->format('d F Y')); ?>

                        </div>
                        <input type="hidden" name="system_updated" value="<?php echo e(App\Models\Settings::where('setting_key', 'system_updated')->get()->first()->setting_value); ?>">
                    </div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">Company Name</div>
                            <div class="fs3 clr-grey-2">Define your company name to display</div>
                        </div>
                        <input class="dropdown-button fs3 clr-grey-2 w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0" style="cursor:text;" name="company_name" value='<?php echo e(App\Models\Settings::where('setting_key', 'company_name')->get()->first()->setting_value); ?>'>
                    </div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">Short Name</div>
                            <div class="fs3 clr-grey-2">Define your company short name to display</div>
                        </div>
                        <input class="dropdown-button fs3 clr-grey-2 w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0" style="cursor:text;" name="short_name" value='<?php echo e(App\Models\Settings::where('setting_key', 'short_name')->get()->first()->setting_value); ?>'>
                    </div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">System Name</div>
                            <div class="fs3 clr-grey-2">Define your system name to display</div>
                        </div>
                        <input class="dropdown-button fs3 clr-grey-2 w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0" style="cursor:text;" name="system_name" value='<?php echo e(App\Models\Settings::where('setting_key', 'system_name')->get()->first()->setting_value); ?>'>
                    </div>
                </div>
                <div class="general-time-slot">
                    <div class="fs2 mg-t-20 pd-tb-20 fw-bold clr-grey-2 cursor-default">Time Slot</div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">Custom Range</div>
                            <div class="fs3 clr-grey-2">Enable for custom time range</div>
                        </div>
                        <div class="switch d-flex ai-center">
                            <?php if(App\Models\Settings::where('setting_key', 'custom_range')->get()->first()->setting_value): ?>
                                <input type="checkbox" id="switchCustomRange" onclick="toggleStartEndTimeSection();" name="custom_range" checked=""/>
                            <?php else: ?> 
                                <input type="checkbox" id="switchCustomRange" onclick="toggleStartEndTimeSection();" name="custom_range"/>
                            <?php endif; ?>
                            <label for="switchCustomRange" class="toggle"><span></span></label>
                        </div>
                    </div>
                    <?php
                        $startEndTimeDisplay = 'd-none';
                        if ((App\Models\Settings::where('setting_key', 'custom_range')->get()->first()->setting_value) == 1){
                            $startEndTimeDisplay = '';
                        } else{
                            $startEndTimeDisplay = 'd-none';
                        }
                    ?>

                    <div id="start-end-time-section" class="<?php echo e($startEndTimeDisplay); ?>">
                        <div class="w-100p h-100p d-flex fd-row fw-wrap">
                            <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                                <div class="fs3 clr-black-2 fw-bold">Start Time</div>
                                <div class="fs3 clr-grey-2">Start time for room booking</div>
                            </div>
                            <div>
                                <div id="setting-option-dropdown-start-time-button" class="dropdown-button w-300 fs4 clr-grey-2 bs-bb" style="padding-top:12px; padding-bottom:12px;"><?php echo e(Carbon\Carbon::parse(App\Models\Settings::where('setting_key', 'start_time')->get()->first()->setting_value, 'Asia/Kuala_Lumpur')->format('h:i:s A')); ?></div>
                                <input id="setting-option-dropdown-start-time-input" type="hidden" name="start_time" value="<?php echo e(App\Models\Settings::where('setting_key', 'start_time')->get()->first()->setting_value); ?>">
                                <div class="dropdown w-300 h-150 cursor-pointer" id="setting-option-start-time-dropdown" style="position:absolute;">
                                    <?php
                                        $startTime = new DateTime('00:00:00');
                                        $endTime = new DateTime('23:30:00');
                                        $currentTime = clone $startTime;
                                    ?>
                                    <?php while($currentTime <= $endTime): ?>
                                        <div class="option" id="start-time-option">
                                            <div class="fs3 clr-grey-1" onclick="dropdown_option_input_click(this, 'setting-option-dropdown-start-time-button', 'setting-option-dropdown-start-time-input', '<?php echo e(Carbon\Carbon::parse($currentTime)->format('H:i:s')); ?>', 'setting-option-start-time-dropdown')"><?php echo e(Carbon\Carbon::parse($currentTime)->format('h:i:s A')); ?></div>
                                            <?php $currentTime->modify('+30 minutes') ?>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            </div>
                        </div>
                        <div class="w-100p h-100p d-flex fd-row fw-wrap">
                            <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                                <div class="fs3 clr-black-2 fw-bold">End time</div>
                                <div class="fs3 clr-grey-2">End time for room booking</div>
                            </div>
                            <div>
                                <div id="setting-option-dropdown-end-time-button" class="dropdown-button w-300 fs4 clr-grey-2 bs-bb" style="padding-top:12px; padding-bottom:12px;"><?php echo e(Carbon\Carbon::parse(App\Models\Settings::where('setting_key', 'end_time')->get()->first()->setting_value)->format('h:i:s A')); ?></div>
                                <input id="setting-option-dropdown-end-time-input" type="hidden" name="end_time" value="<?php echo e(App\Models\Settings::where('setting_key', 'end_time')->get()->first()->setting_value); ?>">
                                <div class="dropdown w-300 h-150 cursor-pointer" id="setting-option-end-time-dropdown" style="position:absolute;">
                                    <?php
                                        $startTime = new DateTime('00:00:00');
                                        $endTime = new DateTime('23:30:00');
                                        $currentTime = clone $startTime;
                                    ?>
                                    <?php while($currentTime <= $endTime): ?>
                                        <div class="option" id="end-time-option">
                                            <div class="fs3 clr-grey-1" onclick="dropdown_option_input_click(this, 'setting-option-dropdown-end-time-button', 'setting-option-dropdown-end-time-input', '<?php echo e(Carbon\Carbon::parse($currentTime)->format('H:i:s')); ?>', 'setting-option-end-time-dropdown')"><?php echo e(Carbon\Carbon::parse($currentTime)->format('h:i:s A')); ?></div>
                                            <?php $currentTime->modify('+30 minutes') ?>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="general-attendance">
                    <div class="fs2 mg-t-20 pd-tb-20 fw-bold clr-grey-2 cursor-default">Attendance</div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">Attendance Type</div>
                            <div class="fs3 clr-grey-2">Attendance type for student check in</div>
                        </div>
                        <div>
                            <div id="setting-option-dropdown-button" class="dropdown-button w-300 fs4 clr-grey-2 bs-bb" style="padding-top:12px; padding-bottom:12px;"><?php echo e(App\Models\Settings::where('setting_key', 'attendance_type')->get()->first()->setting_value); ?></div>
                            <input id="setting-option-dropdown-input" type="hidden" name="attendance_type" value="<?php echo e(App\Models\Settings::where('setting_key', 'attendance_type')->get()->first()->setting_value); ?>">
                            <div class="dropdown w-300 cursor-pointer" id="setting-option-dropdown" style="position:absolute;">
                                <div class="option" id="check-in-option">
                                    <div class="fs3 clr-grey-1" onclick="dropdown_option_input_click(this, 'setting-option-dropdown-button', 'setting-option-dropdown-input', this.textContent, 'setting-option-dropdown')">Check in</div>
                                </div>
                                <div class="option pd-b-10" id="check-in-out-option">
                                    <div class="fs3 clr-grey-1" onclick="dropdown_option_input_click(this, 'setting-option-dropdown-button', 'setting-option-dropdown-input', this.textContent, 'setting-option-dropdown')">Check in and check out</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="general-email">
                    <div class="fs2 mg-t-20 pd-tb-20 fw-bold clr-grey-2 cursor-default">Email</div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">Send Email</div>
                            <div class="fs3 clr-grey-2">Enable process to send email</div>
                        </div>
                        <div class="switch d-flex ai-center">
                            <?php if(App\Models\Settings::where('setting_key', 'send_email')->get()->first()->setting_value): ?>
                                <input type="checkbox" id="switch2" name="send_email" checked=""/>
                            <?php else: ?> 
                                <input type="checkbox" id="switch2" name="send_email"/>
                            <?php endif; ?>
                                <label for="switch2" class="toggle"><span></span></label>
                        </div>
                    </div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">Security Team</div>
                            <div class="fs3 clr-grey-2">Security team email for notification</div>
                        </div>
                        <input class="dropdown-button fs3 clr-grey-2 w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0" style="cursor:text;" name="security_team" value='<?php echo e(App\Models\Settings::where('setting_key', 'security_team')->get()->first()->setting_value); ?>'>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div id="setting-announcement" class="w-100p h-100p d-none">
        <div class="fw-wrap w-100p h-100p pd-t-20">
            <?php if($announcements->isEmpty()): ?>
                <div class="d-flex fd-column ai-center">
                    <span class="material-symbols-outlined clr-grey-2 fs-200">chat</span>
                    <div class="clr-grey-2 fs2">Currently you have no announcement to show.</div>
                </div>
            <?php else: ?>
                <div class="w-100p d-flex cursor-default">
                    <div class="d-flex w-100p of-auto">
                        
                        <table class="table w-100p">
                            <tr>
                                <th></th>
                                <th>Title</th>
                                <th>Message</th>
                                <th>Date Publish</th>
                                <th>Date Expiry</th>
                                <th></th>
                            </tr>
                            <?php $count = 1; ?>
                            <?php $__currentLoopData = $announcements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $announcement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="width:0px">
                                        <div class="d-flex-center">
                                            <div class="bg-plt1-tr2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4"><?php echo e($count); ?></div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($announcement->title); ?></div>
                                    </td>
                                    <td>
                                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($announcement->message); ?></div>
                                    </td>
                                    <td>
                                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($announcement->date_publish); ?></div>
                                    </td>
                                    <td>
                                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($announcement->date_expiry); ?></div>
                                    </td>
                                    <td>
                                        <div class="tw-nowrap fs-12 clr-grey-1"></div>
                                        <div class="d-flex jc-start ai-end">
                                            <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="open_popup_click('edit-announcement-<?php echo e($announcement->id); ?>-popup')">
                                                <span class="material-symbols-outlined">edit</span>
                                            </div>
                                            <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="if(confirm('Are you sure you want to delete <?php echo e($announcement->title); ?>?')) {submit_form('delete-announcement-<?php echo e($announcement->id); ?>-form')}">
                                                <span class="material-symbols-outlined">delete</span>
                                                <form id="delete-announcement-<?php echo e($announcement->id); ?>-form" class="d-none" action="<?php echo e(route('setting.delete-announcement-by-id',['id' => $announcement->id])); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>       
                                                </form>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php $count += 1; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                    <div class=""><?php echo e($announcements->links('vendor.pagination.tailwind')); ?></div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div id="setting-building-level" class="w-100p h-100p d-none">
        <div class="d-flex w-100p h-100p pd-t-20">
            <div class="d-flex fd-column w-200 h-100p">
                <div onclick="setting_building_level_click('setting-faculty-part', this)" class="setting-button active building-level-button d-flex-center jc-start bg-plt5 w-180 h-50 pd-lr-20 pd-tb-5 mg-r-20 mg-tb-5 bs-bb br-5 of-hidden cursor-pointer f-shrink-0">
                    <div>
                        <div class="fs3 clr-black-2 fw-bold">Faculty</div>
                    </div>
                </div>
                <div onclick="setting_building_level_click('setting-building-part', this)" class="setting-button building-level-button d-flex-center jc-start bg-plt5 w-180 h-50 pd-lr-20 pd-tb-5 mg-r-20 mg-tb-5 bs-bb br-5 of-hidden cursor-pointer f-shrink-0">
                    <div>
                        <div class="fs3 clr-black-2 fw-bold">Building</div>
                    </div>
                </div>
                <div onclick="setting_building_level_click('setting-level-part', this)" class="setting-button building-level-button d-flex-center jc-start bg-plt5 w-180 h-50 pd-lr-20 pd-tb-5 mg-r-20 mg-tb-5 bs-bb br-5 of-hidden cursor-pointer f-shrink-0">
                    <div>
                        <div class="fs3 clr-black-2 fw-bold">Level</div>
                    </div>
                </div>
            </div>
            <div class="d-flex w-1 h-100p mg-lr-30" style="background-color:#00000022"></div>

            <div class="d-flex w-700 h-100p cursor-default">
                <div id="setting-faculty-part" class="building-level-part w-100p h-100p">
                    <div class="fs3 clr-black-2 fw-bold">Faculty</div>
                    <div class="w-100p h-100p">
                        <table class="table w-100p mg-tb-20">
                            <tr>
                                <th><div class="fs3">Faculty Name</div></th>
                                <th></th>
                            </tr>
                
                            <?php $__currentLoopData = $faculties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faculty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($faculty->name); ?></div>
                                    </td>
                                    <td class="h-100p">
                                        <div class="d-flex jc-end h-100p">
                                            <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="open_popup_click('edit-faculty-<?php echo e($faculty->id); ?>-popup')">
                                                <span class="material-symbols-outlined">edit</span>
                                            </div>
                                            <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="if(confirm('Are you sure you want to delete <?php echo e($faculty->name); ?>?')) {submit_form('delete-faculty-<?php echo e($faculty->id); ?>-form')}">
                                                <span class="material-symbols-outlined">delete</span>
                                                <form id="delete-faculty-<?php echo e($faculty->id); ?>-form" class="d-none" action="<?php echo e(route('setting.delete-faculty-by-id',['id' => $faculty->id])); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>       
                                                </form>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                </div>
                <div id="setting-building-part" class="building-level-part w-100p h-100p d-none">
                    <div class="fs3 clr-black-2 fw-bold">Building</div>
                    <div class="w-100p h-100p">
                        <table class="table w-100p mg-tb-20">
                            <tr>
                                <th><div class="fs3">Building Name</div></th>
                                <th><div class="fs3">Faculty Name</div></th>
                                <th></th>
                            </tr>
                
                            <?php $__currentLoopData = $buildings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $building): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($building->faculty->name); ?></div>
                                    </td>
                                    <td>
                                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($building->name); ?></div>
                                    </td>
                                    <td class="h-100p">
                                        <div class="d-flex jc-end h-100p">
                                            <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="open_popup_click('edit-building-<?php echo e($building->id); ?>-popup')">
                                                <span class="material-symbols-outlined">edit</span>
                                            </div>
                                            <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="if(confirm('Are you sure you want to delete <?php echo e($building->name); ?>?')) {submit_form('delete-building-<?php echo e($building->id); ?>-form')}">
                                                <span class="material-symbols-outlined">delete</span>
                                                <form id="delete-building-<?php echo e($building->id); ?>-form" class="d-none" action="<?php echo e(route('setting.delete-building-by-id',['id' => $building->id])); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>       
                                                </form>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                </div>
                <div id="setting-level-part" class="building-level-part w-100p h-100p d-none">
                    <div class="fs3 clr-black-2 fw-bold">Level</div>
                    <div class="w-100p h-100p">
                        <table class="table w-100p mg-tb-20">
                            <tr>
                                <th><div class="fs3">Faculty Name</div></th>
                                <th><div class="fs3">Building Name</div></th>
                                <th><div class="fs3">Level Name</div></th>
                                <th></th>
                            </tr>
                
                            <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($level->faculty->name); ?></div>
                                    </td>
                                    <td>
                                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($level->building->name); ?></div>
                                    </td>
                                    <td>
                                        <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($level->name); ?></div>
                                    </td>
                                    <td class="h-100p">
                                        <div class="d-flex jc-end h-100p">
                                            <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="open_popup_click('edit-level-<?php echo e($level->id); ?>-popup')">
                                                <span class="material-symbols-outlined">edit</span>
                                            </div>
                                            <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="if(confirm('Are you sure you want to delete <?php echo e($level->name); ?>?')) {submit_form('delete-level-<?php echo e($level->id); ?>-form')}">
                                                <span class="material-symbols-outlined">delete</span>
                                                <form id="delete-level-<?php echo e($level->id); ?>-form" class="d-none" action="<?php echo e(route('setting.delete-level-by-id',['id' => $level->id])); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>       
                                                </form>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="setting-public-holiday" class="w-100p h-100p d-none">
        <div class="fw-wrap w-100p h-100p pd-t-20">
            <?php if($holidays->isEmpty()): ?>
                <div class="d-flex fd-column ai-center">
                    <span class="material-symbols-outlined clr-grey-2 fs-200">calendar_today</span>
                    <div class="clr-grey-2 fs2">Currently you have no public holiday to show.</div>
                </div>
            <?php else: ?>
                <table class="table w-100p">
                    <tr>
                        <th></th>
                        <th>Description</th>
                        <th>Date</th>
                        <th></th>
                    </tr>
        
                    <?php $count = 1; ?>
                    <?php $__currentLoopData = $holidays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $holiday): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td style="width:0px">
                                <div class="d-flex-center">
                                    <div class="bg-plt1-tr2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4"><?php echo e($count); ?></div>
                                </div>
                            </td>
                            <td>
                                <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($holiday->description); ?></div>
                            </td>
                            <td>
                                <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e(Carbon\Carbon::parse($holiday->date, 'Asia/Kuala_Lumpur')->format('l, d F Y')); ?></div>
                            </td>
                            <td class="h-100p">
                                <div class="d-flex h-100p">
                                    <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="open_popup_click('edit-holiday-<?php echo e($holiday->id); ?>-popup')">
                                        <span class="material-symbols-outlined">edit</span>
                                    </div>
                                    <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="if(confirm('Are you sure you want to delete <?php echo e($holiday->name); ?>?')) {submit_form('delete-holiday-<?php echo e($holiday->id); ?>-form')}">
                                        <span class="material-symbols-outlined">delete</span>
                                        <form id="delete-holiday-<?php echo e($holiday->id); ?>-form" class="d-none" action="<?php echo e(route('setting.delete-holiday-by-id',['id' => $holiday->id])); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>       
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php $count += 1; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>
                <div class=""><?php echo e($holidays->links('vendor.pagination.tailwind')); ?></div>
            <?php endif; ?>
        </div>
    </div>

    <div id="setting-smtp-relay" class="d-none">
        <div class="fw-wrap">
            <form id="save-setting-smtp-button-form" action="<?php echo e(route('setting.update-smtp')); ?>" method="POST" class="h-100p w-100p cursor-default">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>

                <div class="smtp-relay">
                    <div class="fs2 mg-t-20 pd-tb-20 fw-bold clr-grey-2 cursor-default">SMTP</div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">SMTP server</div>
                            <div class="fs3 clr-grey-2">Server name for your SMTP relay</div>
                        </div>
                        <input class="dropdown-button fs3 clr-grey-2 w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0" style="cursor:text;" name="smtp_server" value='<?php echo e(App\Models\Settings::where('setting_key', 'smtp_server')->get()->first()->setting_value); ?>'>
                    </div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">SMTP sender name</div>
                            <div class="fs3 clr-grey-2">Sender name to display in email</div>
                        </div>
                        <input class="dropdown-button fs3 clr-grey-2 w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0" style="cursor:text;" name="smtp_sender_name" value='<?php echo e(App\Models\Settings::where('setting_key', 'smtp_sender_name')->get()->first()->setting_value); ?>'>
                    </div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">SMTP username</div>
                            <div class="fs3 clr-grey-2">Username to access SMTP relay</div>
                        </div>
                        <input class="dropdown-button fs3 clr-grey-2 w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0" style="cursor:text;" name="smtp_username" value='<?php echo e(App\Models\Settings::where('setting_key', 'smtp_username')->get()->first()->setting_value); ?>'>
                    </div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">SMTP password</div>
                            <div class="fs3 clr-grey-2">Password for SMTP username</div>
                        </div>
                        <input class="dropdown-button fs3 clr-grey-2 w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0" style="cursor:text;" name="smtp_password" value='<?php echo e(App\Models\Settings::where('setting_key', 'smtp_password')->get()->first()->setting_value); ?>'>
                    </div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">SMTP port</div>
                            <div class="fs3 clr-grey-2">Port number for SMTP relay</div>
                        </div>
                        <input class="dropdown-button fs3 clr-grey-2 w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0" style="cursor:text;" name="smtp_port" value='<?php echo e(App\Models\Settings::where('setting_key', 'smtp_port')->get()->first()->setting_value); ?>'>
                    </div>
                    <div class="w-100p h-100p d-flex fd-row fw-wrap">
                        <div class="w-300 pd-r-10 pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0">
                            <div class="fs3 clr-black-2 fw-bold">Enable SSL</div>
                            <div class="fs3 clr-grey-2">Enable SSL for SMTP relay</div>
                        </div>
                        <div class="switch d-flex ai-center">
                            <?php if(App\Models\Settings::where('setting_key', 'enable_ssl')->get()->first()->setting_value): ?>
                                <input type="checkbox" id="switch3" name="enable_ssl" checked=""/>
                            <?php else: ?> 
                                <input type="checkbox" id="switch3" name="enable_ssl"/>
                            <?php endif; ?>
                                <label for="switch3" class="toggle"><span></span></label>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div id="setting-devices" class="d-none">
        <div class="fw-wrap">
            <div class="clr-grey-1 fs-30 fw-bold txt-c mg-b-20 mg-t-20">#Under Maintenance</div>
            <table class="table w-700 cursor-default">
                <tr>
                    <th></th>
                    <th>Device Name</th>
                    <th>Index Code</th>
                    <th>Room</th>
                    <th></th>
                </tr>
    
                <?php $count = 1; ?>
                <?php $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td style="width:0px">
                            <div class="d-flex-center">
                                <div class="bg-plt1-tr2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4"><?php echo e($count); ?></div>
                            </div>
                        </td>
                        <td>
                            <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($device->name); ?></div>
                        </td>
                        <td>
                            <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($device->index_code); ?></div>
                        </td>
                        <td>
                            <div class="tw-nowrap fs-12 clr-grey-1"><?php echo e($device->room->name); ?></div>
                        </td>
                        <td class="h-100p">
                            <div class="d-flex h-100p">
                                <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="open_popup_click('edit-device-<?php echo e($device->id); ?>-popup')">
                                    <span class="material-symbols-outlined">edit</span>
                                </div>
                                <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="if(confirm('Are you sure you want to delete <?php echo e($device->name); ?>?')) {submit_form('delete-device-<?php echo e($device->id); ?>-form')}">
                                    <span class="material-symbols-outlined">delete</span>
                                    <form id="delete-device-<?php echo e($device->id); ?>-form" class="d-none" action="<?php echo e(route('setting.delete-device-by-id',['id' => $device->id])); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>       
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <?php $count += 1; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </table>
        </div>
    </div>

    <div id="setting-integration" class="d-none">
        <div class="fw-wrap">
            <div class="w-100p h-100p mg-t-20 cursor-default">
                <div class="h-200 w-800 d-flex-center">
                    <div class="mg-10 pd-10">
                        <div class="">
                            <img src="<?php echo e(asset('storage/system/hik_central.png')); ?>" alt="hikcentral-img">
                        </div>
                        <div class="fs2 fw-bold mg-tb-20">Hikcentral</div>
                    </div>
                    <div class="h-100p d-flex-center">
                        <?php
                            $database_connection = 'Disconnected';
                            try { DB::connection()->getPdo(); $database_connection = 'Connected';
                            } catch (\Exception $e) { $database_connection = 'Disconnected'; }
                        ?>
                        <div class="d-flex-center fw-bold fs2 clr-red w-200">Disconnected</div>
                    </div>
                    <div class="mg-10 pd-10">
                        <div>
                            <img src="<?php echo e(asset('storage/system/middleware.png')); ?>" alt="hikcentral-img">
                        </div>
                        <div class="fs2 fw-bold mg-tb-20">Middleware</div>
                    </div>
                    <div class="h-100p d-flex-center">
                        <?php
                            $database_connection = 'Disconnected';
                            try { DB::connection()->getPdo(); $database_connection = 'Connected';
                            } catch (\Exception $e) { $database_connection = 'Disconnected'; }
                        ?>
                        <div class="fw-bold d-flex-center fs2 clr-green w-200"><?php echo e($database_connection); ?></div>
                    </div>
                    <div class="mg-10 pd-10">
                        <div>
                            <img src="<?php echo e(asset('storage/system/database.png')); ?>" alt="hikcentral-img">
                        </div>
                        <div class="fs2 fw-bold mg-tb-20">Database</div>
                    </div>
                </div>
                <div class="mg-tb-20 d-flex">
                    <div class="w-500 d-flex">
                        <?php
                        $hik_central = [
                            'url' => env('HIKCENTRAL_API_BASE_URL'),
                            'app_key' => env('HIKCENTRAL_APP_KEY'),
                            'app_secret' => env('HIKCENTRAL_APP_SECRET'),
                        ];
                        ?>
                        <div>
                            <div class="fs2 clr-grey-2 fw-bold mg-tb-10">HikCentral</div>
                            <div class="d-flex bs-bb fw-shrink-0">
                                <div class="d-flex w-100 fs3 clr-grey-2 mg-tb-10 bs-bb">Server</div>
                                <div class="d-flex w-300 fs3 clr-black-1 fw-bold pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0"><?php echo e($hik_central['url']); ?></div>
                            </div>
                            <div class="d-flex bs-bb fw-shrink-0">
                                <div class="d-flex w-100 fs3 clr-grey-2 mg-tb-10 bs-bb">App Key</div>
                                <div class="d-flex w-300 fs3 clr-black-1 fw-bold pd-tb-5 mg-r-10 mg-tb-5 bs-bb"><?php echo e($hik_central['app_key']); ?></div>
                            </div>
                            <div class="d-flex bs-bb fw-shrink-0">
                                <div class="d-flex w-100 fs3 clr-grey-2 mg-tb-10 bs-bb">Secret</div>
                                <div class="d-flex w-300 fs3 clr-black-1 fw-bold pd-tb-5 mg-r-10 mg-tb-5 bs-bb"><?php echo e(str_repeat('*', strlen($hik_central['app_secret']))); ?></div>
                                
                            </div>
                            <div class="d-flex">
                                <div class="button-primary d-flex-center mg-tb-20" onclick="open_popup_click('update-hcp-configuration-popup')">
                                    <div>Configure</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="w-500 d-flex">
                        <?php
                        $database = [
                            'host' => env('DB_HOST'),
                            'database' => env('DB_DATABASE'),
                            'username' => env('DB_USERNAME'),
                        ];
                        ?>
                        <div>
                            <div class="fs2 clr-grey-2 fw-bold mg-tb-10">Database</div>
                            <div class="d-flex bs-bb fw-shrink-0">
                                <div class="d-flex w-100 fs3 clr-grey-2 mg-tb-10 bs-bb">Server</div>
                                <div class="d-flex w-300 fs3 clr-black-1 fw-bold pd-tb-5 mg-r-10 mg-tb-5 bs-bb fw-shrink-0"><?php echo e($database['host']); ?></div>
                            </div>
                            <div class="d-flex bs-bb fw-shrink-0">
                                <div class="d-flex w-100 fs3 clr-grey-2 mg-tb-10 bs-bb">Database</div>
                                <div class="d-flex w-300 fs3 clr-black-1 fw-bold pd-tb-5 mg-r-10 mg-tb-5 bs-bb"><?php echo e($database['database']); ?></div>
                            </div>
                            <div class="d-flex bs-bb fw-shrink-0">
                                <div class="d-flex w-100 fs3 clr-grey-2 mg-tb-10 bs-bb">Username</div>
                                <div class="d-flex w-300 fs3 clr-black-1 fw-bold pd-tb-5 mg-r-10 mg-tb-5 bs-bb"><?php echo e($database['username']); ?></div>
                            </div>
                            <div class="d-flex">
                                <div class="button-primary d-flex-center mg-tb-20" onclick="open_popup_click('update-db-configuration-popup')">
                                    <div>Configure</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>  
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-box'); ?>
    <div id="add-announcement-popup" class="right-popup bg-white w-600 h-100p cursor-default">
        <form action="<?php echo e(route('setting.create-announcement')); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('POST'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Add Announcement</div>
                    
                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Title <span style="color:red;">*</span></div>
                    <input type="text" name="title" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Message <span style="color:red;">*</span></div>
                    <textarea class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text; font-family:Arial, Helvetica, sans-serif; max-width:300px; min-width:300px;" name="message" rows="4"></textarea>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Date Publish <span style="color:red;">*</span></div>
                    <input type="date" name="date_publish" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Date Expiry <span style="color:red;">*</span></div>
                    <input type="date" name="date_expiry" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                    <button type="button" onclick="close_popup_click('add-announcement-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>

    <?php $__currentLoopData = $announcements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $announcement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div id="edit-announcement-<?php echo e($announcement->id); ?>-popup" class="right-popup bg-white w-600 h-100p cursor-default">
        <form action="<?php echo e(route('setting.update-announcement-by-id', ['id' => $announcement->id])); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PATCH'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Edit Announcement</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Title <span style="color:red;">*</span></div>
                    <input type="text" value="<?php echo e($announcement->title); ?>" name="title" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Message <span style="color:red;">*</span></div>
                    <textarea class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text; font-family:Arial, Helvetica, sans-serif; max-width:300px; min-width:300px;" name="message" rows="4"><?php echo e($announcement->message); ?></textarea>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Date Publish <span style="color:red;">*</span></div>
                    <input type="date" value="<?php echo e($announcement->date_publish); ?>" name="date_publish" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Date Expiry <span style="color:red;">*</span></div>
                    <input type="date" value="<?php echo e($announcement->date_expiry); ?>" name="date_expiry" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Update</button>
                    <button type="button" onclick="close_popup_click('edit-announcement-<?php echo e($announcement->id); ?>-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div id="add-faculty-popup" class="right-popup bg-white w-600 h-100p cursor-default">
        <form action="<?php echo e(route('setting.create-faculty')); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('POST'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Add faculty</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">faculty Name <span style="color:red;">*</span></div>
                    <input type="text" name="name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text">

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                    <button type="button" onclick="close_popup_click('add-faculty-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>

    <?php $__currentLoopData = $faculties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faculty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div id="edit-faculty-<?php echo e($faculty->id); ?>-popup" class="right-popup bg-white w-600 h-100p cursor-default">
        <form action="<?php echo e(route('setting.update-faculty-by-id', ['id' => $faculty->id])); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PATCH'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Edit faculty</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">faculty Name <span style="color:red;">*</span></div>
                    <input type="text" name="name" value="<?php echo e($faculty->name); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Update</button>
                    <button type="button" onclick="close_popup_click('edit-faculty-<?php echo e($faculty->id); ?>-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div id="add-building-popup" class="right-popup bg-white w-600 h-100p cursor-default">
        <form action="<?php echo e(route('setting.create-building')); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('POST'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Add Building</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Faculty Name <span style="color:red;">*</span></div>
                    <input id="building-faculty-dropdown-input" type="hidden" name="faculty_id" value="<?php echo e($faculties->first()->id); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                    <div id="building-faculty-dropdown-button" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-pointer"><?php echo e($faculties->first()->name); ?></div>
                    <div id="building-faculty-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                        <div class="d-flex">
                            <input type="text" name="" id="building-faculty-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                        <?php $__currentLoopData = $faculties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faculty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'building-faculty-dropdown-button', 'building-faculty-dropdown-input', <?php echo e($faculty->id); ?>, 'building-faculty-dropdown')" style="border:none;"><?php echo e($faculty->name); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Building Name <span style="color:red;">*</span></div>
                    <input type="text" name="name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text">

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                    <button type="button" onclick="close_popup_click('add-building-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>

    <?php $__currentLoopData = $buildings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $building): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div id="edit-building-<?php echo e($building->id); ?>-popup" class="right-popup bg-white w-600 h-100p cursor-default">
        <form action="<?php echo e(route('setting.update-building-by-id', ['id' => $building->id])); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PATCH'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Edit Building</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Faculty Name <span style="color:red;">*</span></div>
                    <input id="edit-building-faculty-<?php echo e($building->id); ?>-dropdown-input" type="hidden" name="faculty_id" value="<?php echo e($building->faculty->id); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">
                    <div id="edit-building-faculty-<?php echo e($building->id); ?>-dropdown-button" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-pointer"><?php echo e($building->faculty->name); ?></div>
                    <div id="edit-building-faculty-<?php echo e($building->id); ?>-dropdown" name="faculty-id" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                        <div class="d-flex">
                            <input type="text" name="" id="edit-building-faculty-<?php echo e($building->id); ?>-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                        <?php $__currentLoopData = $faculties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faculty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'edit-building-faculty-<?php echo e($building->id); ?>-dropdown-button', 'edit-building-faculty-<?php echo e($building->id); ?>-dropdown-input', <?php echo e($faculty->id); ?>, 'edit-building-faculty-<?php echo e($building->id); ?>-dropdown')" style="border:none;"><?php echo e($faculty->name); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Building Name <span style="color:red;">*</span></div>
                    <input type="text" name="name" value="<?php echo e($building->name); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Update</button>
                    <button type="button" onclick="close_popup_click('edit-building-<?php echo e($building->id); ?>-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div id="add-level-popup" class="right-popup bg-white w-600 h-100p cursor-default">
        <form action="<?php echo e(route('setting.create-level')); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('POST'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Add Level</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Faculty Name <span style="color:red;">*</span></div>
                    <input id="level-faculty-dropdown-input" type="hidden" name="faculty_id" value="<?php echo e($faculties->first()->id); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                    <div id="level-faculty-dropdown-button" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-pointer"><?php echo e($faculties->first()->name); ?></div>
                    <div id="level-faculty-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                        <div class="d-flex">
                            <input type="text" name="" id="level-faculty-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                        <?php $__currentLoopData = $faculties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faculty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'level-faculty-dropdown-button', 'level-faculty-dropdown-input', <?php echo e($faculty->id); ?>, 'level-faculty-dropdown')" style="border:none;"><?php echo e($faculty->name); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Building Name <span style="color:red;">*</span></div>
                    <input id="building-dropdown-input" type="hidden" name="building_id" value="<?php echo e($buildings->first()->id); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">
                    <div id="building-dropdown-button" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-pointer"><?php echo e($buildings->first()->name); ?></div>
                    <div id="building-dropdown" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                        <div class="d-flex">
                            <input type="text" name="" id="building-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                        <?php $__currentLoopData = $buildings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $building): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'building-dropdown-button', 'building-dropdown-input', <?php echo e($building->id); ?>, 'building-dropdown')" style="border:none;"><?php echo e($building->name); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Level Name <span style="color:red;">*</span></div>
                    <input type="text" name="name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                    <button type="button" onclick="close_popup_click('add-level-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>

    <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div id="edit-level-<?php echo e($level->id); ?>-popup" class="right-popup bg-white w-600 h-100p cursor-default">
        <form action="<?php echo e(route('setting.update-level-by-id', ['id' => $level->id])); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PATCH'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Edit Level</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Faculty Name <span style="color:red;">*</span></div>
                    <input id="edit-level-faculty-<?php echo e($level->id); ?>-dropdown-input" type="hidden" name="faculty_id" value="<?php echo e($level->faculty->id); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">
                    <div id="edit-level-faculty-<?php echo e($level->id); ?>-dropdown-button" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-pointer"><?php echo e($level->faculty->name); ?></div>
                    <div id="edit-level-faculty-<?php echo e($level->id); ?>-dropdown" name="faculty-id" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                        <div class="d-flex">
                            <input type="text" name="" id="edit-level-faculty-<?php echo e($level->id); ?>-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                        <?php $__currentLoopData = $faculties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faculty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'edit-level-faculty-<?php echo e($level->id); ?>-dropdown-button', 'edit-level-faculty-<?php echo e($level->id); ?>-dropdown-input', <?php echo e($faculty->id); ?>, 'edit-level-faculty-<?php echo e($level->id); ?>-dropdown')" style="border:none;"><?php echo e($faculty->name); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Building Name <span style="color:red;">*</span></div>
                    <input id="edit-building-<?php echo e($level->id); ?>-dropdown-input" type="hidden" name="building_id" value="<?php echo e($level->building->id); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0">
                    <div id="edit-building-<?php echo e($level->id); ?>-dropdown-button" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-pointer"><?php echo e($level->building->name); ?></div>
                    <div id="edit-building-<?php echo e($level->id); ?>-dropdown" name="building-id" class="dropdown w-300 pd-b-10" style="max-height:100px;">
                        <div class="d-flex">
                            <input type="text" name="" id="edit-building-<?php echo e($level->id); ?>-search" class="dropdown-search w-250 h-20 mg-5 pd-l-5 fs-12">
                            <div class="w-25 h-25 mg-t-5 d-flex-center"><span class="material-symbols-outlined fw-bold">search</span></div>
                        </div>
                        <?php $__currentLoopData = $buildings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $building): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="option w-100p txt-l fs-12 clr-grey-1 bs-bb cursor-pointer" onclick="dropdown_option_input_click(this, 'edit-building-<?php echo e($level->id); ?>-dropdown-button', 'edit-building-<?php echo e($level->id); ?>-dropdown-input', <?php echo e($building->id); ?>, 'edit-building-<?php echo e($level->id); ?>-dropdown')" style="border:none;"><?php echo e($building->name); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Level Name <span style="color:red;">*</span></div>
                    <input type="text" name="name" value="<?php echo e($level->name); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Update</button>
                    <button type="button" onclick="close_popup_click('edit-level-<?php echo e($level->id); ?>-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div id="add-holiday-popup" class="right-popup bg-white w-600 h-100p">
        <form action="<?php echo e(route('setting.create-holiday')); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('POST'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">New Public Holiday</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Description </div>
                    <textarea class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" name="description" rows="3" style="cursor:text; font-family:Arial, Helvetica, sans-serif; max-width:300px; min-width:300px;"></textarea>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Date <span style="color:red;">*</span></div>
                    <input type="date" name="date" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                    <button type="button" onclick="close_popup_click('add-holiday-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>
    
    <?php $__currentLoopData = $holidays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $holiday): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div id="edit-holiday-<?php echo e($holiday->id); ?>-popup" class="right-popup bg-white w-600 h-100p cursor-default">
        <form action="<?php echo e(route('setting.update-holiday-by-id', ['id' => $holiday->id])); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PATCH'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Edit Public Holiday</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Description </div>
                    <textarea class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" name="description" rows="3" style="cursor:text; font-family:Arial, Helvetica, sans-serif; max-width:300px; min-width:300px;"><?php echo e($holiday->description); ?></textarea>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Date <span style="color:red;">*</span></div>
                    <input type="date" value="<?php echo e($holiday->date); ?>" name="date" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Update</button>
                    <button type="button" onclick="close_popup_click('edit-holiday-<?php echo e($holiday->id); ?>-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div id="add-device-popup" class="right-popup bg-white w-600 h-100p cursor-default">
        <form action="<?php echo e(route('setting.create-device')); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('POST'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Add Device</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Device <span style="color:red;">*</span></div>
                    <input type="text" name="name" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Index Code <span style="color:red;">*</span></div>
                    <div class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text"></div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Room (serching ni)</div>
                    <input type="text" name="room_id" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0 cursor-text">

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Create</button>
                    <button type="button" onclick="close_popup_click('add-device-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>

    <div id="update-hcp-configuration-popup" class="right-popup bg-white w-600 h-100p cursor-default">
        <form action="<?php echo e(route('setting.update-hcp')); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PATCH'); ?>
        <?php
        $hik_central = [
            'url' => env('HIKCENTRAL_API_BASE_URL'),
            'app_key' => env('HIKCENTRAL_APP_KEY'),
            'app_secret' => env('HIKCENTRAL_APP_SECRET'),
        ];
        ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Configure HikCentral Connection</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Server <span style="color:red;">*</span></div>
                    <input type="text" name="url" value="<?php echo e($hik_central['url']); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">App Key <span style="color:red;">*</span></div>
                    <input type="text" name="app_key" value="<?php echo e($hik_central['app_key']); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">App Secret <span style="color:red;">*</span></div>
                    <input type="text" name="app_secret" value="<?php echo e($hik_central['app_secret']); ?>" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <!-- <div class="fs-13 clr-black-1 fw-bold mg-t-20">Event Type <span style="color:red;">*</span></div>
                    <input type="text" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Lecturer Organization <span style="color:red;">*</span></div>
                    <input type="text" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Student Organization <span style="color:red;">*</span></div>
                    <input type="text" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;"> -->

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Save Changes</button>
                    <button type="button" onclick="close_popup_click('update-hcp-configuration-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>

    <div id="update-db-configuration-popup" class="right-popup bg-white w-600 h-100p cursor-default">
        <form action="<?php echo e(route('setting.update-db')); ?>" method="POST" class="h-100p w-100p">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PATCH'); ?>
            <div class="content w-100p of-auto" style="height: calc(100% - 80px);position:relative;">
                <div class="h-100p pd-30 bs-bb">
                    <div class="fs-18 clr-grey-2 fw-bold">Configure Database Connection</div>

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Server <span style="color:red;">*</span></div>
                    <input type="text" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Database <span style="color:red;">*</span></div>
                    <input type="text" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Username <span style="color:red;">*</span></div>
                    <input type="text" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Password <span style="color:red;">*</span></div>
                    <input type="text" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="fs-13 clr-black-1 fw-bold mg-t-20">Post <span style="color:red;">*</span></div>
                    <input type="text" name="" class="dropdown-button w-300 clr-grey-1 pd-tb-8 mg-t-5 pd-lr-0" style="cursor:text;">

                    <div class="h-150"></div>
                </div>
            </div>

            <div class="submit-section h-80 w-100p">
                <div class="d-flex mg-t-20 mg-l-40" style="gap:10px">
                    <button type="submit" class="button-primary fw-bold fs-12 clr-white pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Save Changes</button>
                    <button type="button" onclick="close_popup_click('update-db-configuration-popup')" class="bg-btn-secondary fw-bold fs-12 clr-black pd-tb-8 pd-lr-10 br-4 cursor-pointer" style="border:none">Cancel</button>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        //for pagination, to save the last session page that you went
        // localStorage.setItem("classroom-management-session", "announcement");
        // localStorage.removeItem("");
        if (localStorage.getItem('classroom-management-session') && localStorage.getItem('classroom-management-session') != 'main') {
            session = localStorage.getItem('classroom-management-session');
            setting_click(`${session}-nav-button`, `setting-${session}`);
        }

        //to handle custome range, 0 = 24 hour, 1 = custom time based on start-end time
        // customRange = <?php echo json_encode(App\Models\Settings::where('setting_key', 'custom_range')->get()->first()->setting_value, 512) ?>;
        // startTime = <?php echo json_encode(Carbon\Carbon::parse(App\Models\Settings::where('setting_key', 'start_time')->first()->setting_value), 512) ?>;
        // endTime = <?php echo json_encode(Carbon\Carbon::parse(App\Models\Settings::where('setting_key', 'end_time')->first()->setting_value), 512) ?>;
        function toggleStartEndTimeSection(){
            let startEndTimeSection = document.getElementById('start-end-time-section');
            let checkbox = document.getElementById('switchCustomRange');

            if (checkbox.checked) {
                startEndTimeSection.style.display = 'block';
            } else {
                startEndTimeSection.style.display = 'none';
            }
        }

        function setting_building_level_click(building_level_part, button){
            document.getElementById('add-building-btn').classList.add('d-none');
            document.getElementById('add-level-btn').classList.add('d-none');
            document.getElementById('add-faculty-btn').classList.add('d-none');
            document.querySelectorAll('.building-level-part').forEach(section =>{ section.classList.add('d-none');})

            document.querySelectorAll('.building-level-button').forEach(button => { button.classList.remove('active'); });
            button.classList.add('active');

            document.getElementById(building_level_part).classList.remove('d-none');

            if (building_level_part === 'setting-building-part'){
                document.getElementById('add-building-btn').classList.remove('d-none');
            } else if (building_level_part === 'setting-level-part'){
                document.getElementById('add-level-btn').classList.remove('d-none');
            } else if (building_level_part === 'setting-faculty-part'){
                document.getElementById('add-faculty-btn').classList.remove('d-none');
            }
        }

        add_dropdown_event('setting-option-dropdown-button', 'setting-option-dropdown');
        add_dropdown_event('setting-option-dropdown-start-time-button', 'setting-option-start-time-dropdown');
        add_dropdown_event('setting-option-dropdown-end-time-button', 'setting-option-end-time-dropdown');

        // add building
        add_dropdown_event('building-faculty-dropdown-button','building-faculty-dropdown');
        add_search('building-faculty-search', 'building-faculty-dropdown');

        // edit building
        <?php $__currentLoopData = $buildings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $building): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            add_dropdown_event('edit-building-faculty-<?php echo e($building->id); ?>-dropdown-button','edit-building-faculty-<?php echo e($building->id); ?>-dropdown');
            add_search('edit-building-faculty-<?php echo e($building->id); ?>-search', 'edit-building-faculty-<?php echo e($building->id); ?>-dropdown');
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        // add level
        add_dropdown_event('building-dropdown-button','building-dropdown');
        add_search('building-search', 'building-dropdown');
        add_dropdown_event('level-faculty-dropdown-button','level-faculty-dropdown');
        add_search('level-faculty-search', 'level-faculty-dropdown');

        // edit level
        <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            add_dropdown_event('edit-building-<?php echo e($level->id); ?>-dropdown-button','edit-building-<?php echo e($level->id); ?>-dropdown');
            add_search('edit-building-<?php echo e($level->id); ?>-search', 'edit-building-<?php echo e($level->id); ?>-dropdown');
            add_dropdown_event('edit-level-faculty-<?php echo e($level->id); ?>-dropdown-button','edit-level-faculty-<?php echo e($level->id); ?>-dropdown');
            add_search('edit-level-faculty-<?php echo e($level->id); ?>-search', 'edit-level-faculty-<?php echo e($level->id); ?>-dropdown');
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        function setting_click(header_id, content_id) {
            document.getElementById(content_id).style.display = 'flex';
            document.getElementById('setting-main').style.display = 'none';
            document.getElementById('main-nav-button').style.display = 'none';
            document.getElementById(header_id).style.display = 'flex';
        }

        function back_click(header_id, content_id) {
            document.getElementById(content_id).style.display = 'none';
            document.getElementById('setting-main').style.display = 'block';
            document.getElementById('main-nav-button').style.display = 'flex';
            document.getElementById(header_id).style.display = 'none';

            localStorage.setItem('classroom-management-session', 'main');
        }

        // Promise.all([fetch_data(api='<?php echo e(route('hcp.get_person_list')); ?>', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({})),])
        //     .then(([data_users]) => {
        //         console.log(data_users.data.list[2]);
        //     })
        //     .catch(error => {
        //     });

        Promise.all([fetch_data(api='<?php echo e(route('hcp.get_door_event')); ?>', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({'startTime':'2024-10-01T12:00:00+08:00', 'endTime':'2024-10-30T12:00:00+08:00', 'eventType': 196893, 'personName':'', 'doorIndexCodes':['3']})),])
            .then(([door_events]) => {
                door_events.data.list.forEach(data => {

                    // console.log(data);
                    
                });
            })
            .catch(error => {
            });

        Promise.all([fetch_data(api='/artemis/api/resource/v1/acsDoor/acsDoorList', method='POST', headers={'Content-Type': 'application/json','X-CSRF-TOKEN': csrfToken,}, body=JSON.stringify({})),])
            .then(([data_door]) => {
                if (data_door.code == 0) {
                    count = 1;
                    console.log(data_door.data.list);
                    data_door.data.list.forEach(door => {
                        document.querySelector('#setting-devices .table').innerHTML += `
                            <tr>
                            <td style="width:0px">
                                <div class="d-flex-center">
                                    <div class="bg-plt1-tr2 pd-3 fs-12 fw-bold pd-tb-3 pd-lr-5 br-4">${count}</div>
                                </div>
                            </td>
                            <td>
                                <div class="tw-nowrap fs-12 clr-grey-1">${door.doorName}</div>
                            </td>
                            <td>
                                <div class="tw-nowrap fs-12 clr-grey-1">${door.acsDevIndexCode}</div>
                            </td>
                            <td>
                                <div class="tw-nowrap fs-12 clr-grey-1"></div>
                            </td>
                            <td class="h-100p">
                                <div class="d-flex h-100p">
                                    <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="open_popup_click('edit-device-{$device->id}-popup')">
                                        <span class="material-symbols-outlined">edit</span>
                                    </div>
                                    <div class="d-flex tw-nowrap fs-12 clr-grey-1 clr-white-hv bg-blue-1-hv pd-5 br-5 cursor-pointer" onclick="if(confirm('Are you sure you want to delete {$device->name}?')) {submit_form('delete-device-{$device->id}-form')}">
                                        <span class="material-symbols-outlined">delete</span>
                                        <form id="delete-device-device->id-form" class="d-none" action="<?php echo e(route('setting.delete-device-by-id',['id' => 1])); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>       
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        `;
                        count ++;
                    })
                    
                }
                
            });

        // to remove session on the last session page
        // localStorage.removeItem('classroom-management-session');

    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Predator\OneDrive - ums.edu.my\Documents\Work\Khaleef Net Sdn Bhd\uthm_classroom_management_system\resources\views/setting/index.blade.php ENDPATH**/ ?>